/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.container.thirdparty;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jpa.AbstractJPAProviderIntegration;
import com.ibm.ws.jpa.JPAAccessor;
import com.ibm.ws.jpa.JPAProviderIntegration;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.persistence.spi.PersistenceProvider;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={JPAProviderIntegration.class}, property={"service.ranking:Integer=10"})
public class ThirdPartyJPAProvider
extends AbstractJPAProviderIntegration {
    private static final TraceComponent tc = Tr.register(ThirdPartyJPAProvider.class, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");
    private final ConcurrentSkipListSet<String> providersFoundByBells = new ConcurrentSkipListSet();
    private volatile String computedProvider;
    private volatile String inUseProvider;
    private final AtomicBoolean activated = new AtomicBoolean();
    static final long serialVersionUID = -7710476057311905034L;

    @ManualTrace
    @Activate
    protected void activate(ComponentContext context) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"activate", (Object[])new Object[0]);
        }
        String p = this.computeProvider();
        this.activated.set(true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"activate", (Object)p);
        }
    }

    public String getProviderClassName() {
        String curComputedProvider = this.computedProvider;
        if (curComputedProvider == null) {
            throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"NO_JPA_PROVIDER_FOUND_CWWJP0051E", (Object[])new Object[0]));
        }
        this.inUseProvider = curComputedProvider;
        return curComputedProvider;
    }

    @Reference(service=PersistenceProvider.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(implementation.class=*)")
    protected void setPersistenceProvider(ServiceReference<PersistenceProvider> ref) {
        this.providersFoundByBells.add((String)ref.getProperty("implementation.class"));
        this.computeProvider();
    }

    protected void unsetPersistenceProvider(ServiceReference<PersistenceProvider> ref) {
        String removedProvider = (String)ref.getProperty("implementation.class");
        this.providersFoundByBells.remove(removedProvider);
        if (removedProvider != null && removedProvider.equals(this.inUseProvider)) {
            this.computeProvider();
        }
    }

    private String computeProvider() {
        boolean providerChanged;
        String curProvider;
        String originalProvider = this.computedProvider;
        if (this.providersFoundByBells.isEmpty()) {
            curProvider = null;
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Choose first of providers found by the bells feature", (Object[])new Object[]{this.providersFoundByBells});
            }
            curProvider = this.providersFoundByBells.first();
            if (tc.isInfoEnabled()) {
                Tr.info((TraceComponent)tc, (String)"DEFAULT_PERSISTENCE_PROVIDER_LOADED_CWWJP0006I", (Object[])new Object[]{curProvider});
            }
        }
        boolean bl = providerChanged = this.activated.get() && (originalProvider != null && !originalProvider.equals(curProvider) || curProvider != null && !curProvider.equals(originalProvider));
        if (providerChanged) {
            this.inUseProvider = null;
        }
        this.computedProvider = curProvider;
        if (providerChanged) {
            JPAAccessor.getJPAComponent().recycleJPAApplications();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("compute provider " + originalProvider + " -> " + curProvider), (Object[])new Object[0]);
        }
        return curProvider;
    }
}

