/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jaspi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.security.PasswordCheckFailedException;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.principals.WSPrincipal;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.webcontainer.security.JaspiService;
import com.ibm.wsspi.security.registry.RegistryHelper;
import jakarta.security.auth.message.callback.CallerPrincipalCallback;
import jakarta.security.auth.message.callback.GroupPrincipalCallback;
import jakarta.security.auth.message.callback.PasswordValidationCallback;
import java.io.IOException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JaspiCallbackHandler
implements CallbackHandler {
    private static final TraceComponent tc = Tr.register(JaspiCallbackHandler.class, (String)"Security", null);
    private static final String DEFAULT_REALM = "defaultRealm";
    private JaspiService jaspiService;
    static final long serialVersionUID = 2172923547513246042L;

    JaspiCallbackHandler() {
    }

    public JaspiCallbackHandler(JaspiService jaspiService) {
        this();
        this.jaspiService = jaspiService;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks == null || callbacks.length == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"handle", (Object[])new Object[]{"No Callbacks received, do nothing."});
            }
            return;
        }
        try {
            String realm = DEFAULT_REALM;
            for (Callback callback : callbacks) {
                if (callback instanceof CallerPrincipalCallback) {
                    this.handleCallerPrincipalCallback((CallerPrincipalCallback)callback, realm);
                    continue;
                }
                if (callback instanceof GroupPrincipalCallback) {
                    this.handleGroupPrincipalCallback((GroupPrincipalCallback)callback);
                    continue;
                }
                if (callback instanceof PasswordValidationCallback) {
                    this.handlePasswordValidationCallback((PasswordValidationCallback)callback);
                    continue;
                }
                if (callback instanceof NameCallback) {
                    realm = this.handleNameCallback((NameCallback)callback);
                    continue;
                }
                throw new UnsupportedCallbackException(callback);
            }
        }
        catch (UnsupportedCallbackException realm) {
            void e;
            FFDCFilter.processException((Throwable)realm, (String)"com.ibm.ws.security.jaspi.JaspiCallbackHandler", (String)"100", (Object)this, (Object[])new Object[]{callbacks});
            throw e;
        }
        catch (Exception e) {
            void t;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.jaspi.JaspiCallbackHandler", (String)"102", (Object)this, (Object[])new Object[]{callbacks});
            throw new IOException((Throwable)t);
        }
    }

    private String handleNameCallback(NameCallback nameCallback) throws UnsupportedCallbackException {
        String realm = DEFAULT_REALM;
        if (!"com.ibm.wsspi.security.cred.realm".equals(nameCallback.getPrompt())) {
            throw new UnsupportedCallbackException(nameCallback);
        }
        realm = this.getRealm(nameCallback.getName());
        return realm;
    }

    private String getRealm(String realm) {
        return realm != null && !realm.trim().isEmpty() ? realm : DEFAULT_REALM;
    }

    protected void handleCallerPrincipalCallback(CallerPrincipalCallback callback, String realm) throws WSSecurityException {
        Subject clientSubject = callback.getSubject();
        String userName = callback.getName();
        Principal userPrincipal = callback.getPrincipal();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"handleCallerPrincipalCallback", (Object[])new Object[]{"user=" + userName, "principal=" + userPrincipal});
        }
        Hashtable<String, Object> credData = null;
        if (clientSubject != null) {
            credData = this.getSubjectCustomData(clientSubject);
            String securityName = null;
            if (userName == null && userPrincipal == null) {
                securityName = "UNAUTHENTICATED";
                credData.put("com.ibm.wsspi.security.cred.securityName", securityName);
            } else if (userPrincipal != null) {
                securityName = userPrincipal.getName();
                this.addCommonAttributes(realm, securityName, credData);
                credData.put("com.ibm.wsspi.security.cred.jaspi.principal", userPrincipal);
                if (!(callback.getPrincipal() instanceof WSPrincipal)) {
                    AccessController.doPrivileged(new AddPrincipalPrivAction(callback));
                }
            } else {
                securityName = userName;
                this.addCommonAttributes(realm, securityName, credData);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Added securityName: " + securityName), (Object[])new Object[0]);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"handleCallerPrincipalCallback", (Object[])new Object[]{credData});
        }
    }

    protected void addCommonAttributes(String realm, String securityName, Hashtable<String, Object> credData) {
        try {
            UserRegistry registry = this.getUserRegistry();
            if (registry != null && registry.isValidUser(securityName)) {
                credData.put("com.ibm.wsspi.security.cred.userId", securityName);
                credData.put("com.ibm.ws.authentication.internal.assertion", Boolean.TRUE);
                List groups = registry.getUniqueGroupIds(securityName);
                credData.put("com.ibm.wsspi.security.cred.groups", groups);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Added userid: " + securityName + "  and groups: " + groups), (Object[])new Object[0]);
                }
            } else {
                if (registry == null) {
                    credData.put("com.ibm.wsspi.security.cred.uniqueId", "user:" + realm + "/" + securityName);
                } else {
                    credData.put("com.ibm.wsspi.security.cred.uniqueId", registry.getRealm() + "/" + securityName);
                }
                credData.put("com.ibm.wsspi.security.cred.securityName", securityName);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.jaspi.JaspiCallbackHandler", (String)"202", (Object)this, (Object[])new Object[]{realm, securityName, credData});
        }
    }

    protected void handleGroupPrincipalCallback(GroupPrincipalCallback callback) throws CustomRegistryException, EntryNotFoundException, RemoteException {
        Subject clientSubject = callback.getSubject();
        Hashtable<String, Object> credData = null;
        if (clientSubject != null) {
            String[] groupsFromCallback = callback.getGroups();
            if (groupsFromCallback != null && groupsFromCallback.length > 0) {
                ArrayList<String> groupsFromSubject;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Group names in Callback: ", (Object[])new Object[]{Arrays.asList(groupsFromCallback)});
                }
                if ((groupsFromSubject = (ArrayList<String>)(credData = this.getSubjectCustomData(clientSubject)).get("com.ibm.wsspi.security.cred.groups")) == null) {
                    groupsFromSubject = new ArrayList<String>();
                    credData.put("com.ibm.wsspi.security.cred.groups", groupsFromSubject);
                }
                for (int i = 0; i < groupsFromCallback.length; ++i) {
                    String groupFromCallback = groupsFromCallback[i];
                    if (groupFromCallback == null || groupFromCallback.isEmpty()) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"Group is null or an empty string, it has been ignored.", (Object[])new Object[0]);
                        continue;
                    }
                    String group = this.mapGroup(groupFromCallback);
                    if (!groupsFromSubject.contains(group)) {
                        groupsFromSubject.add(group);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Added groupId: " + group), (Object[])new Object[0]);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)(group + " already exists in custom credential data, avoid duplicates."), (Object[])new Object[0]);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Callback has no groups.", (Object[])new Object[0]);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"handleGroupPrincipalCallback", (Object[])new Object[]{credData});
        }
    }

    protected String mapGroup(String groupFromCallback) throws CustomRegistryException, EntryNotFoundException, RemoteException {
        String group = null;
        UserRegistry registry = this.getUserRegistry();
        group = registry != null && registry.isValidGroup(groupFromCallback) ? registry.getUniqueGroupId(groupFromCallback) : groupFromCallback;
        return group;
    }

    protected void handlePasswordValidationCallback(PasswordValidationCallback callback) throws RemoteException, EntryNotFoundException, CustomRegistryException {
        UserRegistry registry;
        Subject clientSubject = callback.getSubject();
        String userName = callback.getUsername();
        String password = new String(callback.getPassword());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"handlePasswordValidationCallback", (Object[])new Object[]{callback, userName});
        }
        if (clientSubject != null && (registry = this.getUserRegistry()) != null) {
            if (this.checkUserPassword(userName, password, registry, registry.getRealm(), clientSubject)) {
                callback.setResult(true);
            } else {
                callback.setResult(false);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"handlePasswordValidationCallback", (Object[])new Object[]{"valid password? " + callback.getResult()});
        }
    }

    @FFDCIgnore(value={PasswordCheckFailedException.class})
    protected boolean checkUserPassword(String user, @Sensitive String password, UserRegistry registry, String realmName, Subject clientSubject) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        try {
            String userSecurityName = registry.checkPassword(user, password);
            List groupNames = registry.getGroupsForUser(userSecurityName);
            ArrayList<String> uniqueGroups = new ArrayList<String>();
            if (groupNames != null) {
                for (String group : groupNames) {
                    uniqueGroups.add(registry.getUniqueGroupId(group));
                }
            }
            this.newCustomCredential(clientSubject, realmName, userSecurityName, uniqueGroups);
        }
        catch (PasswordCheckFailedException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"checkUserPassword - password is not valid.", (Object[])new Object[0]);
            }
            return false;
        }
        catch (Exception e) {
            Object[] objectArray = new Object[5];
            objectArray[0] = user;
            objectArray[1] = "<sensitive java.lang.String>";
            objectArray[2] = registry;
            objectArray[3] = realmName;
            objectArray[4] = clientSubject;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.jaspi.JaspiCallbackHandler", (String)"325", (Object)this, (Object[])objectArray);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("checkUserPassword - registry exception: " + e), (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }

    protected Hashtable<String, Object> newCustomCredential(Subject clientSubject, String realmName, String securityName, List<?> groupList) {
        Hashtable<String, Object> credData = this.getSubjectCustomData(clientSubject);
        credData.put("com.ibm.wsspi.security.cred.realm", realmName);
        credData.put("com.ibm.wsspi.security.cred.userId", securityName);
        credData.put("com.ibm.ws.authentication.internal.assertion", Boolean.TRUE);
        if (groupList != null && !groupList.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Adding groups found in registry", (Object[])new Object[]{groupList});
            }
            credData.put("com.ibm.wsspi.security.cred.groups", groupList);
        } else {
            credData.put("com.ibm.wsspi.security.cred.groups", new ArrayList());
        }
        return credData;
    }

    protected Hashtable<String, Object> getSubjectCustomData(@Sensitive Subject clientSubject) {
        Hashtable cred = this.jaspiService.getCustomCredentials(clientSubject);
        if (cred == null) {
            SubjectHelper subjectHelper = new SubjectHelper();
            cred = subjectHelper.createNewHashtableInSubject(clientSubject);
        }
        return cred;
    }

    /*
     * WARNING - void declaration
     */
    UserRegistry getUserRegistry() {
        UserRegistry registry;
        block2: {
            registry = null;
            try {
                registry = RegistryHelper.getUserRegistry(null);
            }
            catch (WSSecurityException wSSecurityException) {
                void e;
                FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.security.jaspi.JaspiCallbackHandler", (String)"363", (Object)this, (Object[])new Object[0]);
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"Internal error getting the user registry", (Object[])new Object[]{e});
            }
        }
        return registry;
    }

    @Trivial
    private class AddPrincipalPrivAction
    implements PrivilegedAction<Void> {
        CallerPrincipalCallback callback;

        AddPrincipalPrivAction(CallerPrincipalCallback callback) {
            this.callback = callback;
        }

        @Override
        public Void run() {
            this.callback.getSubject().getPrincipals().add(this.callback.getPrincipal());
            return null;
        }
    }
}

