/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.hpel.impl;

import com.ibm.ws.logging.hpel.LogRepositoryBrowser;
import com.ibm.ws.logging.hpel.MainLogRepositoryBrowser;
import com.ibm.ws.logging.object.hpel.RepositoryPointerImpl;
import java.io.File;
import java.util.Map;

public class OneInstanceBrowserImpl
implements MainLogRepositoryBrowser {
    private final LogRepositoryBrowser browser;
    protected final File repositoryLocation;

    public OneInstanceBrowserImpl(LogRepositoryBrowser browser, File location) {
        this.repositoryLocation = location;
        this.browser = browser;
    }

    public File getLocation() {
        return this.repositoryLocation;
    }

    @Override
    public LogRepositoryBrowser find(RepositoryPointerImpl location, boolean ignoreTimestamp) {
        String[] instanceIds = location.getInstanceIds();
        if (instanceIds.length == 0) {
            return null;
        }
        LogRepositoryBrowser result = this.browser;
        for (int i = 1; i < instanceIds.length && result != null; ++i) {
            Map<String, LogRepositoryBrowser> map = result.getSubProcesses();
            result = map.get(instanceIds[i]);
        }
        return result;
    }

    @Override
    public LogRepositoryBrowser findByMillis(long timestamp) {
        return timestamp < 0L || this.browser.getTimestamp() <= timestamp ? this.browser : null;
    }

    @Override
    public LogRepositoryBrowser findNext(LogRepositoryBrowser current, long timelimit) {
        if (current == null) {
            return this.browser;
        }
        return null;
    }

    @Override
    public LogRepositoryBrowser findNext(RepositoryPointerImpl location, long timelimit) {
        return null;
    }
}

