/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.Configuration;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.LogFileHeaderReadCallback;
import com.ibm.ws.recoverylog.spi.LogIncompatibleException;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LogFileHeader {
    private static final TraceComponent tc;
    static final byte[] MAGIC_NUMBER;
    static final byte[] VARIABLE_FIELD_HEADER;
    public static final int STATUS_INACTIVE = 2;
    public static final int STATUS_ACTIVE = 4;
    public static final int STATUS_KEYPOINTING = 8;
    public static final int STATUS_INVALID = 16;
    private int _status = 2;
    private int _creatorRLSVersionNumber = 0;
    private long _date;
    private long _firstRecordSequenceNumber;
    private String _serverName;
    private final byte[] _serverNameBytes;
    private String _serviceName;
    private int _serviceVersion;
    private final byte[] _serviceNameBytes;
    private String _logName;
    private final byte[] _logNameBytes;
    private byte[] _variableFieldData;
    private byte[] _serviceData;
    private boolean _compatible;
    private static boolean _useVariableFieldHeader;
    private boolean _shutDownWasClean;
    private static LogFileHeaderReadCallback _logFileHeaderReadCallback;
    static final long serialVersionUID = -8275895793054056813L;

    @ManualTrace
    public LogFileHeader(String serverName, String serviceName, int serviceVersion, String logName) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"LogFileHeader", (Object[])new Object[]{serverName, serviceName, serviceVersion, logName});
        }
        this._status = 2;
        this._creatorRLSVersionNumber = 3;
        GregorianCalendar currentCal = new GregorianCalendar();
        Date currentDate = currentCal.getTime();
        this._date = currentDate.getTime();
        this._firstRecordSequenceNumber = 0L;
        this._serverName = new String(serverName);
        this._serverNameBytes = this._serverName.getBytes();
        this._serviceName = new String(serviceName);
        this._serviceNameBytes = this._serviceName.getBytes();
        this._serviceVersion = serviceVersion;
        this._logName = new String(logName);
        this._logNameBytes = this._logName.getBytes();
        this._variableFieldData = this.initVariableFieldData();
        this._serviceData = null;
        this._compatible = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"LogFileHeader", (Object)this);
        }
    }

    @Trivial
    public static final int headerSize() {
        int headerSize = MAGIC_NUMBER.length + 4 + 4 + 8 + 8 + 4 + 4 + 4 + 4 + 4 + (_useVariableFieldHeader ? VARIABLE_FIELD_HEADER.length + 4 : 0) + 8 + 8;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"headerSize {0}", (Object[])new Object[]{headerSize});
        }
        return headerSize;
    }

    @ManualTrace
    public int length() throws InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"length", (Object[])new Object[0]);
        }
        if (!this._compatible) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"length", (Object)"LogIncompatibleException");
            }
            throw new LogIncompatibleException();
        }
        if (this._status == 16) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"length", (Object)"LogHeaderInvalid - throwing InternalLogException");
            }
            throw new InternalLogException("LogFileHeader status is invalid");
        }
        int length = 4 + LogFileHeader.headerSize() + this._serverNameBytes.length + this._serviceNameBytes.length + this._logNameBytes.length + (this._variableFieldData != null ? this._variableFieldData.length : 0) + (this._serviceData != null ? this._serviceData.length : 0);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"length", (Object)length);
        }
        return length;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public void write(ByteBuffer fileBuffer, boolean maintainPosition) throws InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"write", (Object[])new Object[]{fileBuffer, maintainPosition, this});
        }
        if (!this._compatible) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"write", (Object)"LogIncompatibleException");
            }
            throw new LogIncompatibleException();
        }
        if (this._status == 16) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"write", (Object)"LogHeaderInvalid - throwing InternalLogException");
            }
            throw new InternalLogException("LogFileHeader status is invalid");
        }
        try {
            int startPosition = 0;
            if (maintainPosition) {
                startPosition = fileBuffer.position();
            }
            fileBuffer.position(0);
            fileBuffer.putInt(LogFileHeader.headerSize() + this._serverNameBytes.length + this._serviceNameBytes.length + this._logNameBytes.length);
            fileBuffer.put(MAGIC_NUMBER);
            fileBuffer.putInt(3);
            fileBuffer.putInt(this._status);
            fileBuffer.putLong(this._date);
            fileBuffer.putLong(this._firstRecordSequenceNumber);
            fileBuffer.putInt(this._serverNameBytes.length);
            fileBuffer.put(this._serverNameBytes);
            fileBuffer.putInt(this._serviceNameBytes.length);
            fileBuffer.put(this._serviceNameBytes);
            fileBuffer.putInt(this._serviceVersion);
            fileBuffer.putInt(this._logNameBytes.length);
            fileBuffer.put(this._logNameBytes);
            int varLength = 0;
            if (this._variableFieldData != null && _useVariableFieldHeader) {
                varLength += VARIABLE_FIELD_HEADER.length;
                varLength += 4;
                varLength += this._variableFieldData.length;
            }
            if (this._serviceData != null) {
                varLength += this._serviceData.length;
            }
            fileBuffer.putInt(varLength);
            if (this._variableFieldData != null && _useVariableFieldHeader) {
                fileBuffer.put(VARIABLE_FIELD_HEADER);
                fileBuffer.putInt(this._variableFieldData.length);
                fileBuffer.put(this._variableFieldData);
            }
            if (this._serviceData != null) {
                fileBuffer.put(this._serviceData);
            }
            fileBuffer.putLong(this._date);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Writing FRSN " + this._firstRecordSequenceNumber + " at position " + fileBuffer.position() + " in log file " + this._logName), (Object[])new Object[0]);
            }
            fileBuffer.putLong(this._firstRecordSequenceNumber);
            if (maintainPosition) {
                fileBuffer.position(startPosition);
            }
        }
        catch (BufferUnderflowException startPosition) {
            void exc;
            FFDCFilter.processException((Throwable)startPosition, (String)"com.ibm.ws.recoverylog.spi.LogFileHeader", (String)"550", (Object)this, (Object[])new Object[]{fileBuffer, maintainPosition});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHeader.write", (String)"449", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"write", (Object)"InternalLogException");
            }
            throw new InternalLogException((Throwable)exc);
        }
        catch (Throwable exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHeader", (String)"555", (Object)this, (Object[])new Object[]{fileBuffer, maintainPosition});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHeader.write", (String)"455", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"write", (Object)"InternalLogException");
            }
            throw new InternalLogException(exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"write");
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public boolean read(ByteBuffer fileBuffer) {
        boolean readOK;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"read", (Object[])new Object[]{fileBuffer, this});
        }
        long checkDate = -1L;
        long checkFirstRecordSequenceNumber = -1L;
        int dataLength = -1;
        boolean valid = false;
        this._status = 16;
        this._compatible = false;
        try {
            int headerLength = fileBuffer.getInt();
            if (headerLength > 0 && headerLength <= fileBuffer.capacity() - fileBuffer.position()) {
                byte[] magicNumberBuffer = new byte[MAGIC_NUMBER.length];
                fileBuffer.get(magicNumberBuffer);
                if (this.validMagicNumber(magicNumberBuffer)) {
                    this._creatorRLSVersionNumber = fileBuffer.getInt();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Recovery log creator version is " + this._creatorRLSVersionNumber), (Object[])new Object[0]);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Current recovery log version is 3", (Object[])new Object[0]);
                    }
                    for (int i = 0; !this._compatible && i < Configuration.COMPATIBLE_RLS_VERSIONS.length; ++i) {
                        if (this._creatorRLSVersionNumber != Configuration.COMPATIBLE_RLS_VERSIONS[i]) continue;
                        this._compatible = true;
                    }
                    if (this._compatible) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"This version of recovery log file can be parsed by this level of the RLS", (Object[])new Object[0]);
                        }
                        this._status = fileBuffer.getInt();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Recovery log file state is " + LogFileHeader.statusToString(this._status)), (Object[])new Object[0]);
                        }
                        this._date = fileBuffer.getLong();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Recovery log file date (long) is " + this._date), (Object[])new Object[0]);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Recovery log file date (date) is " + new Date(this._date).toString()), (Object[])new Object[0]);
                        }
                        this._firstRecordSequenceNumber = fileBuffer.getLong();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Recovery log file first record sequence number is " + this._firstRecordSequenceNumber), (Object[])new Object[0]);
                        }
                        int stringLength = fileBuffer.getInt();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Reading String of length " + stringLength), (Object[])new Object[0]);
                        }
                        byte[] serverNameBytes = new byte[stringLength];
                        fileBuffer.get(serverNameBytes);
                        this._serverName = new String(serverNameBytes);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Recovery log file created on server " + this._serverName), (Object[])new Object[0]);
                        }
                        stringLength = fileBuffer.getInt();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Reading String of length " + stringLength), (Object[])new Object[0]);
                        }
                        byte[] serviceNameBytes = new byte[stringLength];
                        fileBuffer.get(serviceNameBytes);
                        this._serviceName = new String(serviceNameBytes);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Recovery log file created by service " + this._serviceName), (Object[])new Object[0]);
                        }
                        this._serviceVersion = fileBuffer.getInt();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Recovery log file created by service version" + this._serviceVersion), (Object[])new Object[0]);
                        }
                        stringLength = fileBuffer.getInt();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Reading String of length " + stringLength), (Object[])new Object[0]);
                        }
                        byte[] logNameBytes = new byte[stringLength];
                        fileBuffer.get(logNameBytes);
                        this._logName = new String(logNameBytes);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Recovery log name was " + this._logName), (Object[])new Object[0]);
                        }
                        dataLength = fileBuffer.getInt();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Recovery log file contains " + dataLength + " bytes of service specific information"), (Object[])new Object[0]);
                        }
                        if (dataLength > 0) {
                            byte[] varHeaderTest = new byte[VARIABLE_FIELD_HEADER.length];
                            int currPosition = fileBuffer.position();
                            fileBuffer.get(varHeaderTest);
                            if (_useVariableFieldHeader && Arrays.equals(varHeaderTest, VARIABLE_FIELD_HEADER)) {
                                int rlsVarFieldLength = fileBuffer.getInt();
                                if (rlsVarFieldLength > 0) {
                                    this._variableFieldData = new byte[rlsVarFieldLength];
                                    fileBuffer.get(this._variableFieldData);
                                    this.parseVariableFieldData();
                                }
                                if (dataLength - rlsVarFieldLength - VARIABLE_FIELD_HEADER.length - 4 > 0) {
                                    this._serviceData = new byte[dataLength - rlsVarFieldLength];
                                    fileBuffer.get(this._serviceData);
                                }
                            } else {
                                this._variableFieldData = null;
                                fileBuffer.position(currPosition);
                                this._serviceData = new byte[dataLength];
                                fileBuffer.get(this._serviceData);
                            }
                        } else {
                            this._variableFieldData = null;
                            this._serviceData = null;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("RLS var data Information is [" + RLSUtils.toHexString(this._variableFieldData, 32) + "]"), (Object[])new Object[0]);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Service Specific Information is [" + RLSUtils.toHexString(this._serviceData, 32) + "]"), (Object[])new Object[0]);
                        }
                        checkDate = fileBuffer.getLong();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Recovery log file check date (long) is " + checkDate), (Object[])new Object[0]);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Recovery log file check date (date) is " + new Date(checkDate).toString()), (Object[])new Object[0]);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Reading FRSN from position " + fileBuffer.position()), (Object[])new Object[0]);
                        }
                        checkFirstRecordSequenceNumber = fileBuffer.getLong();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Recovery log file check first record sequence number is " + checkFirstRecordSequenceNumber), (Object[])new Object[0]);
                        }
                        if (this._date == checkDate && this._firstRecordSequenceNumber == checkFirstRecordSequenceNumber && this._date > 0L) {
                            valid = true;
                        } else {
                            this.changeStatus(16);
                            if (tc.isEventEnabled()) {
                                Tr.event((TraceComponent)tc, (String)"Error processing recovery log file header - integrity check failed", (Object[])new Object[0]);
                            }
                        }
                    } else {
                        this.reset();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"This version of recovery log file can not be parsed by this level of the RLS", (Object[])new Object[0]);
                        }
                    }
                }
            }
        }
        catch (BufferUnderflowException headerLength) {
            void exc;
            FFDCFilter.processException((Throwable)headerLength, (String)"com.ibm.ws.recoverylog.spi.LogFileHeader", (String)"773", (Object)this, (Object[])new Object[]{fileBuffer});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHeader.read", (String)"603", (Object)this);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Error processing recovery log file header", (Object[])new Object[]{exc.toString()});
            }
            this.changeStatus(16);
        }
        catch (Throwable exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHeader", (String)"778", (Object)this, (Object[])new Object[]{fileBuffer});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHeader.read", (String)"609", (Object)this);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Error processing recovery log file header", (Object[])new Object[]{exc.toString()});
            }
            this.changeStatus(16);
        }
        boolean bl = readOK = this._compatible && valid;
        if (_logFileHeaderReadCallback != null) {
            _logFileHeaderReadCallback.readComplete(this, readOK);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"read", (Object)readOK);
        }
        return readOK;
    }

    @ManualTrace
    private boolean validMagicNumber(byte[] magicNumberBuffer) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validMagicNumber", (Object[])new Object[]{RLSUtils.toHexString(magicNumberBuffer, 32), this});
        }
        boolean incorrectByteDetected = false;
        for (int currentByte = 0; !incorrectByteDetected && currentByte < MAGIC_NUMBER.length; ++currentByte) {
            if (magicNumberBuffer[currentByte] == MAGIC_NUMBER[currentByte]) continue;
            incorrectByteDetected = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validMagicNumber", (Object)(!incorrectByteDetected ? 1 : 0));
        }
        return !incorrectByteDetected;
    }

    @Trivial
    public long date() {
        return this._date;
    }

    @Trivial
    public long firstRecordSequenceNumber() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"firstRecordSequenceNumber {0} {1}", (Object[])new Object[]{this, this._firstRecordSequenceNumber});
        }
        return this._firstRecordSequenceNumber;
    }

    @ManualTrace
    public String serverName() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"serverName", (Object[])new Object[]{this});
            Tr.exit((TraceComponent)tc, (String)"serverName", (Object)this._serverName);
        }
        return this._serverName;
    }

    @Trivial
    public String serviceName() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"serviceName {0} {1}", (Object[])new Object[]{this._serviceName, this});
        }
        return this._serviceName;
    }

    @Trivial
    public int serviceVersion() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"serviceVersion {0} {1}", (Object[])new Object[]{this._serviceVersion, this});
        }
        return this._serviceVersion;
    }

    @Trivial
    public String logName() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"logName {0} {1}", (Object[])new Object[]{this._logName, this});
        }
        return this._logName;
    }

    @Trivial
    public byte[] getServiceData() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getServiceData {0} {1}", (Object[])new Object[]{this, RLSUtils.toHexString(this._serviceData, 32)});
        }
        return this._serviceData;
    }

    @Trivial
    public void setServiceData(byte[] serviceData) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setServiceData {0} {1}", (Object[])new Object[]{this, RLSUtils.toHexString(serviceData, 32)});
        }
        this._serviceData = serviceData;
    }

    @Trivial
    public boolean compatible() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"compatible {0} {1}", (Object[])new Object[]{this._compatible, this});
        }
        return this._compatible;
    }

    @Trivial
    public boolean valid() {
        boolean valid = true;
        if (this._status == 16) {
            valid = false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"valid {0} {1}", (Object[])new Object[]{valid, this});
        }
        return valid;
    }

    @Trivial
    public int status() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"status {0} {1}", (Object[])new Object[]{this, this._status});
        }
        return this._status;
    }

    @ManualTrace
    public void reset() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reset", (Object[])new Object[]{this});
        }
        this._status = 4;
        this._date = 0L;
        this._firstRecordSequenceNumber = 0L;
        this._serverName = null;
        this._serviceName = null;
        this._serviceVersion = 0;
        this._logName = null;
        this._variableFieldData = this.initVariableFieldData();
        this._serviceData = null;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"reset");
        }
    }

    @ManualTrace
    public void resetHeader(LogFileHeader validHeader) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resetHeader", (Object[])new Object[]{this});
        }
        this._date = 0L;
        this._firstRecordSequenceNumber = 0L;
        this._serverName = validHeader.serverName();
        this._serviceName = validHeader.serviceName();
        this._logName = validHeader.logName();
        this._variableFieldData = this.initVariableFieldData();
        this._serviceData = null;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resetHeader", (Object[])new Object[0]);
        }
    }

    @Trivial
    public void changeStatus(int newStatus) {
        this._status = newStatus;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"changeStatus {0} {1}", (Object[])new Object[]{this, newStatus});
        }
    }

    @ManualTrace
    public void keypointStarting(long nextRecordSequenceNumber) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"keypointStarting", (Object[])new Object[]{this, nextRecordSequenceNumber});
        }
        GregorianCalendar currentCal = new GregorianCalendar();
        Date currentDate = currentCal.getTime();
        this._date = currentDate.getTime();
        this._firstRecordSequenceNumber = nextRecordSequenceNumber;
        this._status = 8;
        this._variableFieldData = this.initVariableFieldData();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"keypointStarting");
        }
    }

    @ManualTrace
    public void keypointComplete() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"keypointComplete", (Object[])new Object[]{this});
        }
        this._status = 4;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"keypointComplete");
        }
    }

    @ManualTrace
    public void setCleanShutdown() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setCleanShutdown", (Object[])new Object[]{this});
        }
        if (this._variableFieldData != null && this._variableFieldData.length > 0) {
            this._variableFieldData[0] = 1;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setCleanShutdown");
        }
    }

    @Trivial
    public boolean wasShutdownClean() {
        boolean clean = true;
        if (_useVariableFieldHeader) {
            clean = this._shutDownWasClean;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"wasShutdownClean {0} {1}", (Object[])new Object[]{this, clean});
        }
        return clean;
    }

    @Trivial
    private byte[] initVariableFieldData() {
        if (_useVariableFieldHeader) {
            return new byte[1];
        }
        return null;
    }

    private void parseVariableFieldData() {
        if (this._variableFieldData != null && this._variableFieldData.length > 0 && this._variableFieldData[0] == 1) {
            this._shutDownWasClean = true;
            this._variableFieldData[0] = 0;
        }
    }

    public static void setUseVariableFieldHeader(boolean b) {
        _useVariableFieldHeader = b;
    }

    static String statusToString(int status) {
        String result = null;
        result = status == 2 ? "INACTIVE" : (status == 4 ? "ACTIVE" : (status == 8 ? "KEYPOINTING" : (status == 16 ? "INVALID" : "UNKNOWN")));
        return result;
    }

    public static void registerReadCallback(LogFileHeaderReadCallback callback) {
        _logFileHeaderReadCallback = callback;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        Boolean b;
        block2: {
            tc = Tr.register(LogFileHeader.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
            MAGIC_NUMBER = new byte[]{87, 65, 83, 76, 79, 71};
            VARIABLE_FIELD_HEADER = new byte[]{86, 65, 82, 70, 73, 69, 76, 68};
            b = Boolean.TRUE;
            try {
                b = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){
                    static final long serialVersionUID = 7458608347782191068L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public Boolean run() throws Exception {
                        Boolean bb = Boolean.valueOf(System.getProperty("com.ibm.ws.recoverylog.UseVariableHeader", "true"));
                        return bb;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.recoverylog.spi.LogFileHeader$1", 1.class, null, null);
                    }
                });
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.recoverylog.spi.LogFileHeader", (String)"271", null, (Object[])new Object[0]);
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"<clinit>", (Object[])new Object[]{"Exception reading custom property", e});
            }
        }
        _useVariableFieldHeader = b;
    }
}

