/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.tx.util.Utils;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class PeerLeaseData {
    private static final TraceComponent tc = Tr.register(PeerLeaseData.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    private final String _recoveryIdentity;
    private final long _leaseTime;
    private final int _leaseTimeout;
    static final long serialVersionUID = 6465566093042642773L;

    @ManualTrace
    public PeerLeaseData(String recoveryIdentity, long leaseTime, int leaseTimeout) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"PeerLeaseData", (Object[])new Object[]{recoveryIdentity, Utils.traceTime((long)leaseTime), leaseTimeout});
        }
        this._recoveryIdentity = recoveryIdentity;
        this._leaseTime = leaseTime;
        this._leaseTimeout = leaseTimeout;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"PeerLeaseData");
        }
    }

    @Trivial
    public String getRecoveryIdentity() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getRecoveryIdentity", (Object[])new Object[]{this._recoveryIdentity});
        }
        return this._recoveryIdentity;
    }

    @Trivial
    public long getLeaseTime() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getLeaseTime", (Object[])new Object[]{Utils.traceTime((long)this._leaseTime)});
        }
        return this._leaseTime;
    }

    @Trivial
    public boolean isExpired() {
        boolean expired = false;
        long curTime = System.currentTimeMillis();
        if (curTime - this._leaseTime > (long)(this._leaseTimeout * 1000)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Lease has EXPIRED for " + this._recoveryIdentity + ", currenttime: " + Utils.traceTime((long)curTime) + ", storedTime: " + Utils.traceTime((long)this._leaseTime) + " (" + (curTime - this._leaseTime) / 1000L + "s)"), (Object[])new Object[0]);
            }
            expired = true;
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Lease has not expired for " + this._recoveryIdentity + ", currenttime: " + Utils.traceTime((long)curTime) + ", storedTime: " + Utils.traceTime((long)this._leaseTime) + " (" + (curTime - this._leaseTime) / 1000L + "s)"), (Object[])new Object[0]);
        }
        return expired;
    }
}

