/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.LogRecord;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import java.nio.ByteBuffer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WriteableLogRecord
extends LogRecord {
    private static final TraceComponent tc = Tr.register(WriteableLogRecord.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    private final long _sequenceNumber;
    static final long serialVersionUID = -1243372223489304644L;

    @Trivial
    protected WriteableLogRecord(ByteBuffer buffer, long sequenceNumber, int length, int absolutePosition) {
        super(buffer, absolutePosition);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"WriteableLogRecord {0} {1} {2} {3} {4}", (Object[])new Object[]{this, buffer, sequenceNumber, length, absolutePosition});
        }
        this._buffer.put(RECORD_MAGIC_NUMBER);
        this._buffer.putLong(sequenceNumber);
        this._buffer.putInt(length);
        this._sequenceNumber = sequenceNumber;
    }

    @Trivial
    protected void put(byte[] bytes) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"put {0} {1} {2}", (Object[])new Object[]{RLSUtils.toHexString(bytes, 32), this._buffer.position(), this});
        }
        this._buffer.put(bytes);
    }

    @Trivial
    protected void putInt(int data) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Writing at position {0} {1} {2}", (Object[])new Object[]{this._buffer.position(), data, this});
        }
        this._buffer.putInt(data);
    }

    @Trivial
    protected void putLong(long data) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Writing at position {0} {1} {2}", (Object[])new Object[]{this._buffer.position(), data, this});
        }
        this._buffer.putLong(data);
    }

    @Trivial
    protected void putShort(short data) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Writing at position {0} {1} {2}", (Object[])new Object[]{this._buffer.position(), data, this});
        }
        this._buffer.putShort(data);
    }

    @Trivial
    protected void putBoolean(boolean data) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Writing at position {0} {1} {2}", (Object[])new Object[]{this._buffer.position(), data, this});
        }
        this._buffer.put(data ? (byte)1 : 0);
    }

    protected void close() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"close {0}", (Object[])new Object[]{this});
        }
        this._buffer.putLong(this._sequenceNumber);
    }
}

