/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.url.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.artifact.url.WSJarURLConnection;
import com.ibm.ws.artifact.url.internal.Utils;
import com.ibm.ws.artifact.zip.cache.ZipCachingService;
import com.ibm.ws.artifact.zip.cache.ZipFileHandle;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.security.thread.ThreadIdentityManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.ParserUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.osgi.service.url.AbstractURLStreamHandlerService;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WSJarURLStreamHandler
extends AbstractURLStreamHandlerService {
    ZipCachingService zipCache = null;
    static final long serialVersionUID = 3715397959201388195L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected void setZipCachingService(ZipCachingService zcs) {
        this.zipCache = zcs;
    }

    protected void parseURL(URL url, String spec, int start, int limit) {
        boolean hasScheme = start != 0 && spec.charAt(start - 1) == ':';
        spec = spec.substring(start, limit);
        String path = hasScheme ? spec : WSJarURLStreamHandler.parseRelativeURL(url, spec);
        this.setURL(url, "wsjar", url.getHost(), url.getPort(), url.getAuthority(), url.getUserInfo(), path, url.getQuery(), url.getRef());
    }

    /*
     * WARNING - void declaration
     */
    private static String parseRelativeURL(URL url, String spec) {
        String result;
        String path = url.getPath();
        int index = path.indexOf("!/");
        if (index == -1) {
            try {
                url = Utils.newURL(Utils.newURL(path), spec);
            }
            catch (MalformedURLException malformedURLException) {
                void ex;
                FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.artifact.url.internal.WSJarURLStreamHandler", (String)"92", null, (Object[])new Object[]{url, spec});
                throw new RuntimeException("Malformed URL [ " + path + " ] [ " + spec + " ]", (Throwable)ex);
            }
            result = url.toString();
        } else {
            String entry;
            entry = spec.startsWith("/") ? WSJarURLStreamHandler.canonicalize(spec) : ((entry = path.substring(index + 1)).endsWith("/") ? WSJarURLStreamHandler.canonicalize(entry + spec) : (entry.endsWith("/.") ? WSJarURLStreamHandler.canonicalize(entry + '/' + spec) : WSJarURLStreamHandler.canonicalize(entry + "/../" + spec)));
            result = path.substring(0, index) + '!' + entry;
        }
        return result;
    }

    private static String canonicalize(String s) {
        int length = s.length();
        StringBuffer result = new StringBuffer(length);
        result.append('/');
        for (int i = 1; i < length; ++i) {
            char ch = s.charAt(i);
            if (ch != '.' || result.charAt(result.length() - 1) != '/') {
                result.append(ch);
                continue;
            }
            if (i + 1 == length || s.charAt(i + 1) == '/') {
                ++i;
                continue;
            }
            if (s.charAt(i + 1) == '.' && (i + 2 == length || s.charAt(i + 2) == '/')) {
                i += 2;
                int j = result.length();
                if (--j <= 0) continue;
                while (result.charAt(j - 1) != '/' && --j > 0) {
                }
                result.setLength(j);
                continue;
            }
            result.append('.');
        }
        return result.toString();
    }

    public URLConnection openConnection(URL url) throws IOException {
        URLConnection conn;
        String path = url.getPath();
        int resourceDelimiterIndex = path.indexOf("!/");
        if (resourceDelimiterIndex == -1) {
            conn = Utils.newURL(path).openConnection();
        } else {
            String urlString = ParserUtils.decode((String)path.substring(0, resourceDelimiterIndex));
            String entry = ParserUtils.decode((String)path.substring(resourceDelimiterIndex + 2));
            URL jarURL = WSJarURLStreamHandler.constructUNCTolerantURL("file", urlString);
            conn = new WSJarURLConnectionImpl(url, jarURL.getPath(), entry, this.zipCache);
        }
        return conn;
    }

    protected static URL constructUNCTolerantURL(String protocolPrefix, String urlString) throws IOException {
        String urlProtocol;
        int protocolDelimiterIndex = urlString.indexOf(58);
        if (protocolDelimiterIndex < 0 || !(urlProtocol = urlString.substring(0, protocolDelimiterIndex)).equalsIgnoreCase(protocolPrefix)) {
            throw new IOException("URL [ " + urlString + " ] does not have protocol [ " + protocolPrefix + " ]");
        }
        String urlPath = urlString.substring(protocolDelimiterIndex + 1);
        URL jarURL = Utils.newURL(urlProtocol, "", -1, urlPath);
        return jarURL;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.url.internal.WSJarURLStreamHandler", WSJarURLStreamHandler.class, null, null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class WSJarURLConnectionImpl
    extends URLConnection
    implements WSJarURLConnection {
        private final String path;
        private final String entry;
        private boolean connected;
        private String contentType;
        private final ZipCachingService zipCache;
        static final long serialVersionUID = 3502292679685135950L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        WSJarURLConnectionImpl(URL url, String path, String entry, ZipCachingService zcs) {
            super(url);
            this.path = path;
            this.entry = entry;
            this.zipCache = zcs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void connect() throws IOException {
            if (!this.connected) {
                boolean exists;
                ZipFileHandle zipFileHandle = this.zipCache.openZipFile(this.path);
                ZipFile zipFile = zipFileHandle.open();
                try {
                    exists = zipFile.getEntry(this.entry) != null;
                }
                finally {
                    zipFileHandle.close();
                }
                if (!exists) {
                    throw new FileNotFoundException("JAR entry " + this.entry + " not found in " + this.path);
                }
                this.connected = true;
            }
        }

        @Override
        public long getLastModified() {
            long result = Utils.getLastModified(new File(this.path));
            return result;
        }

        @Override
        public synchronized InputStream getInputStream() throws IOException {
            Object token = ThreadIdentityManager.runAsServer();
            try {
                InputStream inputStream = this.getInputStreamInternal();
                return inputStream;
            }
            finally {
                ThreadIdentityManager.reset((Object)token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized InputStream getInputStreamInternal() throws IOException {
            ZipEntryInputStream result;
            ZipFileHandle zipFileHandle = this.zipCache.openZipFile(this.path);
            ZipFile zipFile = zipFileHandle.open();
            try {
                ZipEntry zipEntry = zipFile.getEntry(this.entry);
                if (zipEntry == null) {
                    throw new FileNotFoundException("JAR entry " + this.entry + " not found in " + this.path);
                }
                this.connected = true;
                InputStream input = zipFileHandle.getInputStream(zipFile, zipEntry);
                result = new ZipEntryInputStream(zipFileHandle, input);
                zipFileHandle = null;
            }
            finally {
                if (zipFileHandle != null) {
                    zipFileHandle.close();
                }
            }
            return result;
        }

        @Override
        public Permission getPermission() throws IOException {
            String permissionPath = File.separatorChar != '/' ? this.path.replace('/', File.separatorChar) : this.path;
            return new FilePermission(permissionPath, "read");
        }

        @Override
        public String getContentType() {
            if (this.contentType == null) {
                try (InputStream input = this.getInputStream();){
                    this.contentType = WSJarURLConnectionImpl.guessContentTypeFromStream(new BufferedInputStream(input));
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.artifact.url.internal.WSJarURLStreamHandler$WSJarURLConnectionImpl", (String)"314", (Object)this, (Object[])new Object[0]);
                }
                if (this.contentType == null) {
                    this.contentType = WSJarURLConnectionImpl.guessContentTypeFromName(this.entry);
                    if (this.contentType == null) {
                        this.contentType = "content/unknown";
                    }
                }
            }
            return this.contentType;
        }

        @Override
        public File getFile() {
            return new File(this.path);
        }

        @Override
        public String getEntry() {
            return this.entry == null ? "" : this.entry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getContentLengthLong() {
            long length;
            try (ZipFileHandle zipFileHandle = null;){
                zipFileHandle = this.zipCache.openZipFile(this.path);
                ZipFile zipFile = zipFileHandle.open();
                ZipEntry zipEntry = zipFile.getEntry(this.entry);
                if (zipEntry == null) {
                    length = -1L;
                } else {
                    length = zipEntry.getSize();
                    if (length < 0L) {
                        length = Utils.getStreamLength(zipFileHandle.getInputStream(zipFile, zipEntry));
                    }
                }
            }
            return length;
        }

        @Override
        public int getContentLength() {
            long l = this.getContentLengthLong();
            return l > Integer.MAX_VALUE ? -1 : (int)l;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.url.internal.WSJarURLStreamHandler$WSJarURLConnectionImpl", WSJarURLConnectionImpl.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ZipEntryInputStream
    extends FilterInputStream {
        private ZipFileHandle zipFileHandle;
        static final long serialVersionUID = 4143901672072577282L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ZipEntryInputStream(ZipFileHandle zipFileHandle, InputStream in) {
            super(in);
            this.zipFileHandle = zipFileHandle;
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.zipFileHandle != null) {
                try {
                    super.close();
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.artifact.url.internal.WSJarURLStreamHandler$ZipEntryInputStream", (String)"391", (Object)this, (Object[])new Object[0]);
                }
                this.zipFileHandle.close();
                this.zipFileHandle = null;
            }
        }

        protected void finalize() {
            try {
                this.close();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.artifact.url.internal.WSJarURLStreamHandler$ZipEntryInputStream", (String)"409", (Object)this, (Object[])new Object[0]);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.url.internal.WSJarURLStreamHandler$ZipEntryInputStream", ZipEntryInputStream.class, null, null);
        }
    }
}

