/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.classloading.internal.AppClassLoader;
import com.ibm.ws.classloading.internal.ContainerClassLoader;
import com.ibm.ws.classloading.internal.LibertyLoader;
import com.ibm.ws.classloading.internal.Util;
import com.ibm.ws.classloading.internal.util.Keyed;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.boot.classloader.NameBasedClassLoaderLock;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.classloading.ApiType;
import com.ibm.wsspi.classloading.ClassLoaderIdentity;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import org.osgi.framework.Bundle;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class ShadowClassLoader
extends LibertyLoader
implements Keyed<ClassLoaderIdentity> {
    static final TraceComponent tc;
    private static final Enumeration<URL> EMPTY_ENUMERATION;
    private final AppClassLoader shadowedLoader;
    private final Iterable<LibertyLoader> delegateLoaders;
    static final long serialVersionUID = 8447511525005112824L;

    ShadowClassLoader(AppClassLoader shadowed) {
        super(ShadowClassLoader.getShadow(shadowed.parent));
        this.shadowedLoader = shadowed;
        this.delegateLoaders = ShadowClassLoader.getShadows(shadowed.getDelegateLoaders());
    }

    private static ClassLoader getShadow(ClassLoader loader) {
        return loader instanceof AppClassLoader ? new ShadowClassLoader((AppClassLoader)loader) : loader;
    }

    private static LibertyLoader getShadow(LibertyLoader loader) {
        return loader instanceof AppClassLoader ? new ShadowClassLoader((AppClassLoader)loader) : loader;
    }

    private static List<LibertyLoader> getShadows(Iterable<? extends LibertyLoader> loaders) {
        ArrayList<LibertyLoader> result = new ArrayList<LibertyLoader>();
        for (LibertyLoader libertyLoader : loaders) {
            result.add(ShadowClassLoader.getShadow(libertyLoader));
        }
        return result;
    }

    @Override
    protected final Class<?> loadClass(String className, boolean resolveClass) throws ClassNotFoundException {
        return this.loadClass(className, resolveClass, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @FFDCIgnore(value={ClassNotFoundException.class})
    protected Class<?> loadClass(String className, boolean resolveClass, boolean onlySearchSelf, boolean returnNull) throws ClassNotFoundException {
        ClassNotFoundException lastException = null;
        NameBasedClassLoaderLock nameBasedClassLoaderLock = this.getClassLoadingLock(className);
        synchronized (nameBasedClassLoaderLock) {
            Class<?> result = this.findLoadedClass(className);
            if (result != null) {
                return result;
            }
            if (onlySearchSelf) {
                return this.findClass(className, returnNull);
            }
            block12: for (AppClassLoader.SearchLocation what : this.shadowedLoader.getSearchOrder()) {
                try {
                    switch (what) {
                        case PARENT: {
                            if (this.parent instanceof LibertyLoader) {
                                result = ((LibertyLoader)this.parent).loadClass(className, false, false, returnNull);
                                if (result != null) {
                                    return result;
                                }
                            } else {
                                return this.parent.loadClass(className);
                            }
                        }
                        case SELF: {
                            result = this.findClass(className, returnNull);
                            if (result != null) {
                                return result;
                            }
                        }
                        case DELEGATES: {
                            for (LibertyLoader delegate : this.delegateLoaders) {
                                try {
                                    result = delegate.loadClass(className, false, false, returnNull);
                                    if (result == null) continue;
                                    return result;
                                }
                                catch (ClassNotFoundException e) {
                                    lastException = e;
                                }
                            }
                            continue block12;
                        }
                        default: {
                            throw new IllegalStateException("Unknown class loader search ordering element: " + (Object)((Object)what));
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    lastException = e;
                }
            }
        }
        if (returnNull) {
            return null;
        }
        if (lastException == null) {
            lastException = new ClassNotFoundException(className);
        }
        throw lastException;
    }

    @Override
    protected Class<?> findClass(String name, boolean returnNull) throws ClassNotFoundException {
        String packageName;
        String resourceName = Util.convertClassNameToResourceName(name);
        ContainerClassLoader.ByteResourceInformation classBytesResourceInformation = this.shadowedLoader.findClassBytes(name, resourceName);
        if (classBytesResourceInformation == null) {
            if (returnNull) {
                return null;
            }
            throw new ClassNotFoundException(name);
        }
        int lastDotIndex = name.lastIndexOf(46);
        if (lastDotIndex != -1 && this.getPackage(packageName = name.substring(0, lastDotIndex)) == null) {
            classBytesResourceInformation.definePackage(packageName, this);
        }
        byte[] bytes = classBytesResourceInformation.getBytes();
        return this.defineClass(name, bytes, 0, bytes.length);
    }

    @Override
    public URL getResource(String name) {
        return name == null ? null : this.shadowedLoader.getResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return name == null ? null : this.shadowedLoader.getResourceAsStream(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return name == null ? EMPTY_ENUMERATION : this.shadowedLoader.getResources(name);
    }

    @Override
    public EnumSet<ApiType> getApiTypeVisibility() {
        return this.shadowedLoader.getApiTypeVisibility();
    }

    @Override
    public ClassLoaderIdentity getKey() {
        return this.shadowedLoader.getKey();
    }

    @Override
    public Bundle getBundle() {
        return this.shadowedLoader.getBundle();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        ClassLoader.registerAsParallelCapable();
        tc = Tr.register(ShadowClassLoader.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
        EMPTY_ENUMERATION = new Enumeration<URL>(){
            static final long serialVersionUID = 6781143533374470504L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public URL nextElement() {
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ShadowClassLoader$1", 1.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
            }
        };
    }
}

