/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrent.internal.ManagedThreadFactoryService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.enterprise.concurrent.ManageableThread;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class ManagedForkJoinWorkerThread
extends ForkJoinWorkerThread
implements ManageableThread {
    private static final TraceComponent tc = Tr.register(ManagedForkJoinWorkerThread.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.resources.CWWKCMessages");
    static final ConcurrentHashMap<ManagedForkJoinWorkerThread, ThreadGroup> ACTIVE_THREADS = new ConcurrentHashMap();
    private final ManagedThreadFactoryService.ManagedThreadFactoryImpl threadFactory;
    static final long serialVersionUID = -2409337283736940121L;

    @Trivial
    ManagedForkJoinWorkerThread(ManagedThreadFactoryService.ManagedThreadFactoryImpl threadFactory, ForkJoinPool pool) {
        super(pool);
        this.threadFactory = threadFactory;
        if (threadFactory.service.createDaemonThreads != this.isDaemon() || threadFactory.service.defaultPriority != null && threadFactory.service.defaultPriority.intValue() != this.getPriority()) {
            AccessController.doPrivileged(new InitAction(), threadFactory.serverAccessControlContext);
        }
    }

    @Override
    public void interrupt() {
        if (this.threadFactory.sameMetaDataIdentity()) {
            AccessController.doPrivileged(new InterruptAction(), this.threadFactory.serverAccessControlContext);
        } else {
            super.interrupt();
        }
    }

    @Trivial
    private final void interruptSuper() {
        super.interrupt();
    }

    public final boolean isShutdown() {
        return this.threadFactory.service.isShutdown.get() || this.getState() == Thread.State.TERMINATED;
    }

    @Override
    protected void onStart() {
        if (this.threadFactory.service.isShutdown.get()) {
            this.interrupt();
        } else {
            ACTIVE_THREADS.put(this, this.threadFactory.threadGroup);
        }
        super.onStart();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Trivial
    @ManualTrace
    public void run() {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"run", (Object[])new Object[0]);
        }
        try {
            ArrayList contextAppliedToThread = this.threadFactory.threadContextDescriptor.taskStarting();
            try {
                super.run();
            }
            finally {
                this.threadFactory.threadContextDescriptor.taskStopping(contextAppliedToThread);
            }
        }
        catch (Error contextAppliedToThread) {
            void x;
            FFDCFilter.processException((Throwable)contextAppliedToThread, (String)"com.ibm.ws.concurrent.internal.ManagedForkJoinWorkerThread", (String)"122", (Object)this, (Object[])new Object[0]);
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"run", (Object)x);
            }
            throw x;
        }
        catch (RuntimeException x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.internal.ManagedForkJoinWorkerThread", (String)"126", (Object)this, (Object[])new Object[0]);
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"run", (Object)x);
            }
            throw x;
        }
        finally {
            ACTIVE_THREADS.remove(this);
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"run");
        }
    }

    @Override
    @Trivial
    public String toString() {
        return this.getClass().getSimpleName() + '@' + Integer.toHexString(this.hashCode()) + ':' + super.toString();
    }

    @Trivial
    private class InitAction
    implements PrivilegedAction<Void> {
        private InitAction() {
        }

        @Override
        public Void run() {
            if (((ManagedForkJoinWorkerThread)ManagedForkJoinWorkerThread.this).threadFactory.service.createDaemonThreads != ManagedForkJoinWorkerThread.this.isDaemon()) {
                ManagedForkJoinWorkerThread.this.setDaemon(((ManagedForkJoinWorkerThread)ManagedForkJoinWorkerThread.this).threadFactory.service.createDaemonThreads);
            }
            if (((ManagedForkJoinWorkerThread)ManagedForkJoinWorkerThread.this).threadFactory.service.defaultPriority != null && ((ManagedForkJoinWorkerThread)ManagedForkJoinWorkerThread.this).threadFactory.service.defaultPriority.intValue() != ManagedForkJoinWorkerThread.this.getPriority()) {
                ManagedForkJoinWorkerThread.this.setPriority(((ManagedForkJoinWorkerThread)ManagedForkJoinWorkerThread.this).threadFactory.service.defaultPriority);
            }
            return null;
        }
    }

    @Trivial
    private class InterruptAction
    implements PrivilegedAction<Void> {
        private InterruptAction() {
        }

        @Override
        public Void run() {
            ManagedForkJoinWorkerThread.this.interruptSuper();
            return null;
        }
    }
}

