/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi.internal.common;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi.internal.common.WABConfigManager;
import io.openliberty.microprofile.openapi.internal.common.services.OpenAPIEndpointProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Pattern;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true, configurationPid={"io.openliberty.microprofile.openapi"})
public class OpenAPIEndpointManager
implements OpenAPIEndpointProvider {
    private static final TraceComponent tc = Tr.register(OpenAPIEndpointManager.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    private static final String OPEN_API_DOC_VAR_NAME = "openAPIDOCPATH";
    private static final String OPEN_API_DOC_ENDPOINT_CONFIG_NAME = "docPath";
    private static final String OPEN_API_DOC_ENDPOINT_PATH = "/openapi";
    private static final String OPEN_API_UI_VAR_NAME = "openAPIUIPATH";
    private static final String OPEN_API_UI_CONFIG_NAME = "uiPath";
    private static final String OPEN_API_UI_PATH = "/ui";
    private static final Pattern PATH_PATTERN = Pattern.compile("^(/[\\w./_-]*)?$");
    private String uiPath = null;
    private String docPath = null;
    private WABConfigManager uiWabConfigManager;
    private WABConfigManager docWabConfigManager;
    static final long serialVersionUID = -4320874416230069158L;

    @Override
    public String getOpenAPIUIUrl() {
        return this.uiPath;
    }

    @Override
    public String getOpenAPIDocUrl() {
        return this.docPath;
    }

    @Activate
    protected void activate(BundleContext context, Map<String, Object> properties) {
        this.docPath = OPEN_API_DOC_ENDPOINT_PATH;
        this.uiPath = this.docPath + OPEN_API_UI_PATH;
        this.getPathsFromProperties(properties);
        this.uiWabConfigManager = new WABConfigManager(context, OPEN_API_UI_VAR_NAME, "OpenAPI UI");
        this.docWabConfigManager = new WABConfigManager(context, OPEN_API_DOC_VAR_NAME, "OpenAPI Doc");
        this.uiWabConfigManager.setPath(this.uiPath);
        this.docWabConfigManager.setPath(this.docPath);
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        this.getPathsFromProperties(properties);
        this.uiWabConfigManager.setPath(this.uiPath);
        this.docWabConfigManager.setPath(this.docPath);
    }

    @Deactivate
    protected void deactivate() {
        this.uiWabConfigManager.close();
        this.docWabConfigManager.close();
    }

    private void getPathsFromProperties(Map<String, Object> properties) {
        this.docPath = (String)properties.get(OPEN_API_DOC_ENDPOINT_CONFIG_NAME);
        this.docPath = OpenAPIEndpointManager.normalizePath(this.docPath);
        if (!OpenAPIEndpointManager.validatePath(this.docPath, EndpointId.DOCUMENT)) {
            Tr.error((TraceComponent)tc, (String)"OPEN_API_DOC_PATH_UPDATE_FAILED_CWWKO1671E", (Object[])new Object[0]);
            this.docPath = OPEN_API_DOC_ENDPOINT_PATH;
        }
        if (!this.docPath.equals(OPEN_API_DOC_ENDPOINT_PATH)) {
            Tr.info((TraceComponent)tc, (String)"OPEN_API_DOC_PATH_UPDATE_CWWKO1669I", (Object[])new Object[]{this.docPath});
        }
        if (properties.containsKey(OPEN_API_UI_CONFIG_NAME)) {
            this.uiPath = (String)properties.get(OPEN_API_UI_CONFIG_NAME);
            this.uiPath = OpenAPIEndpointManager.normalizePath(this.uiPath);
            if (this.uiPath.equals(this.docPath)) {
                Tr.error((TraceComponent)tc, (String)"OPEN_API_UI_PATH_CONFLICT_CWWKO1672E", (Object[])new Object[]{this.uiPath});
                this.uiPath = this.docPath + OPEN_API_UI_PATH;
            } else if (!OpenAPIEndpointManager.validatePath(this.uiPath, EndpointId.UI)) {
                Tr.error((TraceComponent)tc, (String)"OPEN_API_UI_PATH_UPDATE_FAILED_CWWKO1670E", (Object[])new Object[0]);
                this.uiPath = this.docPath + OPEN_API_UI_PATH;
            }
        } else {
            this.uiPath = this.docPath + OPEN_API_UI_PATH;
        }
        if (!this.uiPath.equals("/openapi/ui")) {
            Tr.info((TraceComponent)tc, (String)"OPEN_API_UI_PATH_UPDATE_CWWKO1668I", (Object[])new Object[]{this.uiPath});
        }
    }

    public static boolean validatePath(String path, EndpointId id) {
        ArrayList<String> segments;
        boolean valid = true;
        if (!PATH_PATTERN.matcher(path).matches()) {
            if (id.equals((Object)EndpointId.UI)) {
                Tr.error((TraceComponent)tc, (String)"OPEN_API_UI_PATH_INVALID_CWWKO1675E", (Object[])new Object[]{path});
            } else {
                Tr.error((TraceComponent)tc, (String)"OPEN_API_DOC_PATH_INVALID_CWWKO1676E", (Object[])new Object[]{path});
            }
            valid = false;
        }
        if ((segments = new ArrayList<String>(Arrays.asList(path.split("/")))).contains(".") || segments.contains("..")) {
            Tr.error((TraceComponent)tc, (String)"OPEN_API_PATH_SEGMENT_INVALID_CWWKO1677E", (Object[])new Object[0]);
            valid = false;
        }
        return valid;
    }

    public static String normalizePath(String path) {
        if (!path.startsWith("/")) {
            path = '/' + path;
        }
        while (path.contains("//")) {
            path = path.replace("//", "/");
        }
        if (path.endsWith("/") && !path.equals("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static enum EndpointId {
        UI,
        DOCUMENT;

    }
}

