/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import com.ibm.ws.cache.servlet.ResponseSideEffect;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;

public class AddCookieSideEffect
implements ResponseSideEffect {
    private static final long serialVersionUID = 3572236512314101134L;
    private String name = null;
    private String value = null;
    private String comment = null;
    private String domain = null;
    private String path = null;
    private boolean secure = false;
    private int maxAge = -1;
    private int version = 0;
    private transient Cookie cookie = null;

    public String toString() {
        StringBuffer sb = new StringBuffer("Add cookie side effect:\n\t");
        sb.append("name: ").append(this.name).append("\n\t");
        sb.append("value: ").append(this.value).append("\n");
        return sb.toString();
    }

    public AddCookieSideEffect(Cookie cookie) {
        this.cookie = cookie;
        this.name = cookie.getName();
        this.value = cookie.getValue();
        this.comment = cookie.getComment();
        this.domain = cookie.getDomain();
        this.path = cookie.getPath();
        this.secure = cookie.getSecure();
        this.maxAge = cookie.getMaxAge();
        this.version = cookie.getVersion();
    }

    @Override
    public void performSideEffect(HttpServletResponse response) {
        if (this.cookie == null) {
            this.cookie = new Cookie(this.name, this.value);
            if (this.comment != null) {
                this.cookie.setComment(this.comment);
            }
            if (this.domain != null) {
                this.cookie.setDomain(this.domain);
            }
            if (this.path != null) {
                this.cookie.setPath(this.path);
            }
            this.cookie.setMaxAge(this.maxAge);
            this.cookie.setSecure(this.secure);
            this.cookie.setVersion(this.version);
        }
        response.addCookie(this.cookie);
    }
}

