/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.servlet.cache.DynamicContentProvider;
import com.ibm.ws.cache.ValueSet;
import com.ibm.ws.cache.servlet.AddCookieSideEffect;
import com.ibm.ws.cache.servlet.CacheProxyOutputStream;
import com.ibm.ws.cache.servlet.CacheProxyRequest;
import com.ibm.ws.cache.servlet.CacheProxyResponse;
import com.ibm.ws.cache.servlet.CacheProxyWriter;
import com.ibm.ws.cache.servlet.CharacterEncodingSideEffect;
import com.ibm.ws.cache.servlet.ContentLengthSideEffect;
import com.ibm.ws.cache.servlet.DateHeaderSideEffect;
import com.ibm.ws.cache.servlet.DefaultStatusSideEffect;
import com.ibm.ws.cache.servlet.ESISupport;
import com.ibm.ws.cache.servlet.FragmentComposerMemento;
import com.ibm.ws.cache.servlet.FragmentInfo;
import com.ibm.ws.cache.servlet.HeaderSideEffect;
import com.ibm.ws.cache.servlet.IntHeaderSideEffect;
import com.ibm.ws.cache.servlet.LocaleSideEffect;
import com.ibm.ws.cache.servlet.MementoEntry;
import com.ibm.ws.cache.servlet.ResponseSideEffect;
import com.ibm.ws.cache.servlet.SendRedirectSideEffect;
import com.ibm.ws.cache.servlet.StatusSideEffect;
import com.ibm.ws.cache.servlet.UnexternalizablePageException;
import com.ibm.ws.cache.util.SerializationUtility;
import com.ibm.ws.ffdc.FFDCFilter;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;

public class FragmentComposer {
    private static TraceComponent tc = Tr.register(FragmentComposer.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    public static final int NOT_CACHED = 0;
    public static final int WAS_CACHED = 1;
    public static final int POPULATED_CACHE = 2;
    public static final int SERVLET_REQUEST = 1;
    public static final int PORTLET_CACHE_REQUEST = 2;
    private int cacheType = -1;
    private boolean externalPage = false;
    protected static final int BYTE = 1;
    protected static final int CHAR = 2;
    protected static final int NONE = 3;
    protected int outputStyle = 3;
    protected String contentType = null;
    protected String characterEncoding = null;
    FragmentComposer parent = null;
    protected FragmentComposer currentChild = null;
    protected ArrayList contentVector = new ArrayList();
    private int bufferSize = 8192;
    private CacheProxyOutputStream cacheProxyOutputStream;
    private CacheProxyWriter cacheProxyWriter;
    protected FragmentInfo fragmentInfo = null;
    protected boolean isSendRedirect = false;
    private boolean isJSTLImport = false;
    private boolean discardJSPContent = false;
    private String uri = null;
    private String servletClassName = null;
    private boolean doNotConsume = false;
    private boolean consumeSubfragments = false;
    private boolean hasCacheableConsumingParent = false;
    public CacheProxyRequest.Attribute[] saveAttributeList = null;
    private CacheProxyRequest.Attribute[] attributeTable = null;
    private byte[] attributeTableBytes = null;
    private boolean include = false;
    private boolean namedDispatch = false;
    private long expirationTime = Long.MAX_VALUE;
    private long timeStamp = -1L;
    private boolean parentExternallyCacheable = false;
    private CacheProxyResponse response = null;
    private CacheProxyRequest request = null;
    private String contextPath = null;
    private int esiVersion = ESISupport.NO_ESI;
    private ValueSet externalDataIds = new ValueSet(5);
    private ValueSet externalTemplates = new ValueSet(3);
    private boolean asyncDispatch = false;
    private boolean asyncDoubleDip = false;

    public FragmentComposer(CacheProxyRequest request, CacheProxyResponse response) {
        this.response = response;
        this.request = request;
        this.contextPath = request._getContextPath();
    }

    public FragmentComposer() {
    }

    public void resetRequestAndResponseOnly(CacheProxyRequest request, CacheProxyResponse response) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            if (null == this.uri) {
                Tr.debug((TraceComponent)tc, (String)("PARTIAL RESET called on " + this), (Object[])new Object[0]);
            } else {
                Tr.debug((TraceComponent)tc, (String)("PARTIAL RESET called on " + this.uri), (Object[])new Object[0]);
            }
        }
        this.response = response;
        this.request = request;
    }

    public void reset(CacheProxyRequest request, CacheProxyResponse response) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            if (null == this.uri) {
                Tr.debug((TraceComponent)tc, (String)("FULL RESET called on " + this), (Object[])new Object[0]);
            } else {
                Tr.debug((TraceComponent)tc, (String)("FULL RESET called on " + this.uri), (Object[])new Object[0]);
            }
        }
        this.response = response;
        this.request = request;
        this.contentVector.clear();
        this.cacheType = -1;
        this.fragmentInfo = null;
        this.uri = null;
        this.servletClassName = null;
        this.externalPage = false;
        this.outputStyle = 3;
        this.contentType = null;
        this.characterEncoding = null;
        this.attributeTable = null;
        this.include = false;
        this.namedDispatch = false;
        this.expirationTime = Long.MAX_VALUE;
        this.timeStamp = -1L;
        this.parentExternallyCacheable = false;
        this.parent = null;
        this.currentChild = null;
        this.attributeTableBytes = null;
        this.esiVersion = ESISupport.NO_ESI;
        if (this.cacheProxyOutputStream != null) {
            this.cacheProxyOutputStream.reset();
        }
        if (this.cacheProxyWriter != null) {
            this.cacheProxyWriter.reset();
        }
        if (request != null) {
            this.contextPath = request._getContextPath();
        }
        this.isSendRedirect = false;
        this.isJSTLImport = false;
        this.discardJSPContent = false;
        this.hasCacheableConsumingParent = false;
        this.saveAttributeList = null;
        this.externalDataIds.clear();
        this.externalTemplates.clear();
        this.asyncDispatch = false;
        this.asyncDoubleDip = false;
    }

    public void addContents(Object[] contents) {
        for (int i = 0; i < contents.length; ++i) {
            this.contentVector.add(contents[i]);
        }
    }

    public void setDoNotConsume(boolean dnc) {
        String s;
        this.doNotConsume = dnc;
        if (this.doNotConsume && (s = ESISupport.getHeaderDirect(this.request, "Surrogate-Capability")) != null) {
            if (this.getFragmentInfo().isEdgeable()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"fragment is EdgeCacheable, setting doNotConsume=false", (Object[])new Object[0]);
                }
                this.doNotConsume = false;
                this.fragmentInfo.setConsumeExcludeList(null);
            } else {
                for (FragmentComposer curFC = this.getParent(); curFC != null; curFC = curFC.getParent()) {
                    if (!curFC.getFragmentInfo().isEdgeable()) continue;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"EdgeCacheable parent found, setting doNotConsume=false", (Object[])new Object[0]);
                    }
                    this.doNotConsume = false;
                    this.fragmentInfo.setConsumeExcludeList(null);
                    break;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setDoNotConsume: " + this.uri + " doNotConsume=" + this.doNotConsume), (Object[])new Object[0]);
        }
    }

    public boolean getDoNotConsume() {
        return this.doNotConsume;
    }

    public void setConsumeSubfragments(boolean csf) {
        String s;
        this.consumeSubfragments = csf;
        if (this.isExternalPage() && !this.consumeSubfragments && (s = ESISupport.getHeaderDirect(this.request, "Surrogate-Capability")) != null && this.getFragmentInfo().isEdgeable()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"fragment is EdgeCacheable, setting consumeSubfragments=true", (Object[])new Object[0]);
            }
            this.consumeSubfragments = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setConsumeSubfragments: " + this.uri + " consumeSubfragments=" + this.consumeSubfragments), (Object[])new Object[0]);
        }
    }

    public boolean getConsumeSubfragments() {
        return this.consumeSubfragments;
    }

    public boolean getHasCacheableConsumingParent() {
        return this.hasCacheableConsumingParent;
    }

    public void setHasCacheableConsumingParent(boolean hccp) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this + " hasCacheableConsumingParent set to " + hccp), (Object[])new Object[0]);
        }
        this.hasCacheableConsumingParent = hccp;
    }

    public void setBufferSize(int size) {
        if (size > this.bufferSize) {
            this.bufferSize = size;
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void resetBuffer() {
        if (this.cacheProxyWriter != null) {
            this.cacheProxyWriter.resetBuffer();
        }
        if (this.cacheProxyOutputStream != null) {
            this.cacheProxyOutputStream.resetBuffer();
        }
    }

    public void requestFinished() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"requestFinished", (Object[])new Object[]{this});
            Tr.debug((TraceComponent)tc, (String)("Flushing: " + this.uri), (Object[])new Object[0]);
        }
        if (this.cacheProxyWriter != null) {
            this.cacheProxyWriter.flush();
        }
        if (this.cacheProxyOutputStream != null) {
            try {
                this.cacheProxyOutputStream.flush();
            }
            catch (IOException ex) {
                FFDCFilter.processException((Throwable)ex, (String)(this.getClass().getName() + ".requestFinished()"), (String)"413");
            }
        }
        this.saveCachedData();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"requestFinished");
        }
    }

    public boolean shouldCacheOutput() {
        if (this.cacheType == 2) {
            return true;
        }
        if (this.cacheType == 1) {
            return this.parentExternallyCacheable || this.isExternallyCached();
        }
        return false;
    }

    public boolean isExternallyCached() {
        if (this.isExternalPage() && this.fragmentInfo != null) {
            String externalCacheId = this.fragmentInfo.getExternalCacheGroupId();
            return externalCacheId != null && !externalCacheId.equals("");
        }
        return false;
    }

    public void setParentExternallyCacheable(boolean parentExternal) {
        this.parentExternallyCacheable = parentExternal;
    }

    public boolean shouldExternalCacheOutput() {
        if (this.isExternallyCached()) {
            return true;
        }
        FragmentComposer externalFC = this.getExternalFragmentComposer();
        if (externalFC.isExternallyCached()) {
            if (externalFC.consumeSubfragments) {
                return true;
            }
            if (this.cacheType == 1 || this.cacheType == 2) {
                return true;
            }
            FragmentComposer currentFC = this.parent;
            while (currentFC != null && !currentFC.consumeSubfragments) {
                currentFC = currentFC.parent;
            }
            if (currentFC != null && currentFC.consumeSubfragments) {
                return true;
            }
        }
        return false;
    }

    protected void saveExternalInvalidationIds() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("saveExternalInvalidationIds uri=" + this.uri), (Object[])new Object[0]);
        }
        if (this.shouldExternalCacheOutput() && this.fragmentInfo.getId() != null) {
            FragmentComposer externalFC = this.getExternalFragmentComposer();
            externalFC.externalDataIds.union(this.fragmentInfo.getDataIds());
            externalFC.externalDataIds.add((Object)this.fragmentInfo.getId());
            externalFC.externalTemplates.union(this.fragmentInfo.getTemplates());
        }
    }

    public void startChildFragmentComposer(FragmentComposer fragmentComposer) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("starting fragment composer for " + fragmentComposer.uri + " parent=" + this.uri), (Object[])new Object[0]);
        }
        this.saveCachedData();
        this.contentVector.add(fragmentComposer);
        if (this.cacheProxyWriter != null) {
            this.cacheProxyWriter.setCaching(false);
        }
        if (this.cacheProxyOutputStream != null) {
            this.cacheProxyOutputStream.setCaching(false);
        }
        if (fragmentComposer.getRequest().getCaching() || fragmentComposer.getHasCacheableConsumingParent()) {
            if (fragmentComposer.cacheProxyWriter != null) {
                fragmentComposer.cacheProxyWriter.setCaching(true);
            }
            if (fragmentComposer.cacheProxyOutputStream != null) {
                fragmentComposer.cacheProxyOutputStream.setCaching(true);
            }
        }
        fragmentComposer.setParentExternallyCacheable(this.isExternallyCached());
        this.currentChild = fragmentComposer;
    }

    public void endChildFragmentComposer(FragmentComposer child) throws IOException {
        boolean cacheable;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ending fragment composer for " + this.currentChild.uri + " parent=" + this.uri), (Object[])new Object[0]);
        }
        child.saveCachedData();
        this.childComposerEnded(child);
        boolean bl = cacheable = this.request.getCaching() || this.getHasCacheableConsumingParent();
        if (this.cacheProxyWriter != null) {
            if (this.isJSTLImport) {
                this.cacheProxyWriter.setDelayWrite(true, cacheable);
                this.setJSTLImport(false);
            } else {
                this.cacheProxyWriter.setCaching(cacheable);
            }
        }
        if (this.cacheProxyOutputStream != null) {
            if (this.isJSTLImport) {
                this.cacheProxyOutputStream.setDelayWrite(true, cacheable);
                this.setJSTLImport(false);
            } else {
                this.cacheProxyOutputStream.setCaching(cacheable);
            }
        }
        if (!this.isAsyncDispatch()) {
            this.currentChild = null;
        }
    }

    protected void childComposerEnded(FragmentComposer childComposer) {
        if (this.getConsumeSubfragments() && childComposer.fragmentInfo != null && !childComposer.fragmentInfo.getBuildEsiInclude() && !childComposer.getDoNotConsume()) {
            Enumeration templates = childComposer.fragmentInfo.getTemplates();
            while (templates.hasMoreElements()) {
                this.fragmentInfo.templates.add(templates.nextElement());
            }
            Enumeration dataIds = childComposer.fragmentInfo.getDataIds();
            while (dataIds.hasMoreElements()) {
                this.fragmentInfo.dataIds.add(dataIds.nextElement());
            }
            String tmp = childComposer.fragmentInfo.getId();
            if (tmp != null) {
                this.fragmentInfo.dataIds.add((Object)tmp);
            }
        }
        if (this.parent != null && !childComposer.getDoNotConsume() && !this.getDoNotConsume()) {
            this.parent.childComposerEnded(childComposer);
        }
    }

    public void saveCachedData() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && null != this.cacheProxyWriter) {
            Tr.debug((TraceComponent)tc, (String)("saveCachedData uri=" + this.uri + " cacheProxyWriter: " + this.cacheProxyWriter + " caching=" + this.cacheProxyWriter.isCaching()), (Object[])new Object[0]);
        }
        if (null != this.cacheProxyWriter && this.outputStyle == 2 && this.cacheProxyWriter.isCaching()) {
            char[] c = this.cacheProxyWriter.getCachedData();
            if (c.length > 0) {
                this.contentVector.add(c);
            }
            this.cacheProxyWriter.resetBuffer();
        } else if (null != this.cacheProxyOutputStream && this.outputStyle == 1 && this.cacheProxyOutputStream.isCaching()) {
            byte[] b = this.cacheProxyOutputStream.getCachedData();
            if (b.length > 0) {
                this.contentVector.add(b);
            }
            this.cacheProxyOutputStream.resetBuffer();
        }
    }

    private OutputStream obtainOutputStream() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getting OutputStream from " + this.response.getResponse() + ", buffering output = " + this.response.isBufferingOutput() + ", hasParent == " + (this.parent != null)), (Object[])new Object[0]);
        }
        ServletOutputStream responseOutputStream = this.response.isBufferingOutput() ? this.response.getBufferedOutputStream() : ((HttpServletResponse)this.response.getResponse()).getOutputStream();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("got OutputStream: " + responseOutputStream), (Object[])new Object[0]);
        }
        return responseOutputStream;
    }

    private Writer obtainWriter() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getting Writer from " + this.response.getResponse() + ", buffering output = " + this.response.isBufferingOutput() + ", hasParent == " + (this.parent != null)), (Object[])new Object[0]);
        }
        PrintWriter responsePrintWriter = this.response.isBufferingOutput() ? this.response.getBufferedWriter() : ((HttpServletResponse)this.response.getResponse()).getWriter();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("got Writer: " + responsePrintWriter), (Object[])new Object[0]);
        }
        return responsePrintWriter;
    }

    private FragmentComposer getExternalFragmentComposer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getExternalFragmentComposer", (Object[])new Object[0]);
        }
        FragmentComposer current = this;
        while (null != current && !current.isExternalPage()) {
            current = current.parent;
        }
        return current;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getOutputStream: " + this.uri), (Object[])new Object[0]);
        }
        this.outputStyle = 1;
        if (this.cacheProxyOutputStream == null) {
            this.cacheProxyOutputStream = new CacheProxyOutputStream();
        }
        this.cacheProxyOutputStream.setOutputStream(this.obtainOutputStream());
        this.cacheProxyOutputStream.setCaching(this.currentChild == null && (this.request.getCaching() || this.getHasCacheableConsumingParent()));
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("returning " + (Object)((Object)this.cacheProxyOutputStream) + ", pointing to " + this.cacheProxyOutputStream.getOutputStream()), (Object[])new Object[0]);
        }
        return this.cacheProxyOutputStream;
    }

    public PrintWriter getPrintWriter() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getPrintWriter: " + this.uri), (Object[])new Object[0]);
        }
        this.outputStyle = 2;
        if (this.cacheProxyWriter == null) {
            this.cacheProxyWriter = new CacheProxyWriter();
        }
        this.cacheProxyWriter.setWriter(this.obtainWriter());
        this.cacheProxyWriter.setCaching(this.currentChild == null && (this.request.getCaching() || this.getHasCacheableConsumingParent()));
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this + " returning " + this.cacheProxyWriter + ", pointing to " + this.cacheProxyWriter.getWriter() + " caching=" + this.cacheProxyWriter.isCaching()), (Object[])new Object[0]);
        }
        return this.cacheProxyWriter;
    }

    private Object[] excludeChildFragments(Object[] contents, ArrayList excludes) {
        if (contents == null) {
            return contents;
        }
        for (int i = 0; i < contents.length; ++i) {
            if (!(contents[i] instanceof MementoEntry)) continue;
            MementoEntry me = (MementoEntry)contents[i];
            String name = me.getTemplate();
            int j = name.indexOf(63);
            if (j != -1) {
                name = name.substring(0, j);
            }
            if (excludes.contains(name) || excludes.contains(me.getServletClassName())) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Fragment: " + name + " excluded from CacheEntry: " + this.getURI()), (Object[])new Object[0]);
                }
                me.contents = null;
                me.setDoNotConsume(true);
                continue;
            }
            this.excludeChildFragments(me.contents, excludes);
        }
        return contents;
    }

    public FragmentComposerMemento getMemento(CacheProxyRequest request) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getMemento: ", (Object[])new Object[]{this.uri, this});
        }
        if (!this.shouldCacheOutput()) {
            throw new IllegalStateException("Cannot obtain cache memento since caching was not enabled for this fragment");
        }
        this.saveCachedData();
        FragmentComposerMemento memento = new FragmentComposerMemento();
        String externalCacheGroupId = this.fragmentInfo.getExternalCacheGroupId();
        memento.setExternalCacheGroupId(externalCacheGroupId);
        memento.setConsumeSubfragments(this.getConsumeSubfragments());
        memento.setOutputStyle(this.outputStyle);
        memento.setContentType(this.contentType);
        memento.setCharacterEncoding(this.characterEncoding);
        Object[] contents = this.contentVector.toArray();
        for (int i = 0; i < contents.length; ++i) {
            boolean ignore;
            if (!(contents[i] instanceof FragmentComposer)) continue;
            FragmentComposer fragmentComposer = (FragmentComposer)contents[i];
            String cp1 = this.getContextPath();
            String cp2 = fragmentComposer.getContextPath();
            boolean bl = ignore = cp1 != null && cp2 != null && cp1.equals(cp2);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ignore context paths? " + ignore), (Object[])new Object[0]);
            }
            MementoEntry mementoEntry = fragmentComposer.getMementoEntry(ignore);
            mementoEntry.setOutputStyle(fragmentComposer.outputStyle);
            mementoEntry.setExternallyCacheable(fragmentComposer.shouldExternalCacheOutput());
            mementoEntry.setAsync(this.isAsyncDispatch());
            if (this.getConsumeSubfragments() && !fragmentComposer.getDoNotConsume() && !fragmentComposer.isDiscardJSPContent()) {
                mementoEntry.addContents(fragmentComposer.contentVector.toArray());
            } else if (fragmentComposer.isDiscardJSPContent()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Creating an empty mementoEntry for fragmentComposer -->" + this.uri), (Object[])new Object[0]);
                }
                mementoEntry.addContents(new ArrayList(0).toArray());
            }
            mementoEntry.setServletClassName(fragmentComposer.getServletClassName());
            mementoEntry.setDoNotConsume(fragmentComposer.getDoNotConsume());
            contents[i] = mementoEntry;
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("Created MementoEntry for " + fragmentComposer.getURI()), (Object[])new Object[0]);
        }
        String[] excludeList = this.fragmentInfo.getConsumeExcludeList();
        if (excludeList != null) {
            ArrayList<String> excludes = new ArrayList<String>();
            for (int i = 0; i < excludeList.length; ++i) {
                excludes.add(excludeList[i]);
            }
            contents = this.excludeChildFragments(contents, excludes);
        }
        memento.addContents(contents);
        CacheProxyRequest.Attribute[] saveList = this.getSaveAttributeList(request);
        if (saveList != null && saveList.length > 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setting changed attrs on memento " + this.uri + ": " + saveList), (Object[])new Object[0]);
            }
            boolean isShared = false;
            if (this.fragmentInfo != null) {
                boolean bl = isShared = !this.fragmentInfo.isNotShared();
            }
            if (isShared) {
                String exceptionMessage = null;
                byte[] array = null;
                try {
                    array = SerializationUtility.serialize((Serializable)saveList);
                }
                catch (Exception e) {
                    exceptionMessage = e.toString();
                }
                if (array != null) {
                    memento.addAttributeBytes(array);
                } else {
                    memento.addAttributes(saveList);
                    Tr.error((TraceComponent)tc, (String)"dynacache.error", (Object[])new Object[]{"NON_SERIALIZABLE_ATTRIBUTES_FOUND. SET_SHARE_POLICY_TO_NOT_SHARED.  uri=" + this.uri + "  exception=" + exceptionMessage});
                }
            } else {
                memento.addAttributes(saveList);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getMemento: ", (Object)Arrays.deepToString(contents));
        }
        return memento;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final MementoEntry getMementoEntry(boolean ignoreContextPath) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getMementoEntry: " + ignoreContextPath), (Object[])new Object[0]);
        }
        try {
            CacheProxyRequest.Attribute[] saveList;
            if (this.uri == null) {
                throw new IllegalStateException("fragmentComposer.uri is null for " + this);
            }
            CacheProxyRequest.Attribute[] endAttributeTable = null;
            byte[] endAttributeTableBytes = null;
            if (this.getHasCacheableConsumingParent() && !this.getDoNotConsume() && (saveList = this.saveAttributeList) != null && saveList.length > 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("setting changed attrs on mementoEntry " + this.uri + ": "), (Object[])new Object[]{saveList});
                }
                boolean isShared = false;
                if (this.fragmentInfo != null) {
                    boolean bl = isShared = !this.fragmentInfo.isNotShared();
                }
                if (isShared) {
                    String exceptionMessage = null;
                    byte[] array = null;
                    try {
                        array = SerializationUtility.serialize((Serializable)saveList);
                    }
                    catch (Exception e) {
                        exceptionMessage = e.toString();
                    }
                    if (array != null) {
                        endAttributeTableBytes = array;
                    } else {
                        endAttributeTable = saveList;
                        Tr.error((TraceComponent)tc, (String)"dynacache.error", (Object[])new Object[]{"NON_SERIALIZABLE_ATTRIBUTES_FOUND. SET_SHARE_POLICY_TO_NOT_SHARED.  uri=" + this.uri + "  exception=" + exceptionMessage});
                    }
                } else {
                    this.attributeTable = saveList;
                }
            }
            MementoEntry me = null;
            String cacheName = this.getFragmentInfo().getInstanceName();
            me = this.attributeTableBytes == null ? (ignoreContextPath ? new MementoEntry(cacheName, this.uri, this.attributeTable, endAttributeTable, this.include, this.namedDispatch, null) : new MementoEntry(cacheName, this.uri, this.attributeTable, endAttributeTable, this.include, this.namedDispatch, this.getContextPath())) : (ignoreContextPath ? new MementoEntry(cacheName, this.uri, this.attributeTableBytes, endAttributeTableBytes, this.include, this.namedDispatch, null) : new MementoEntry(cacheName, this.uri, this.attributeTableBytes, endAttributeTableBytes, this.include, this.namedDispatch, this.getContextPath()));
            MementoEntry mementoEntry = me;
            return mementoEntry;
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getMementoEntry");
            }
        }
    }

    public void copyContentForParents() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("copyContentForParents:" + this.uri), (Object[])new Object[0]);
        }
        Object[] contents = this.contentVector.toArray();
        for (int i = 0; i < contents.length; ++i) {
            if (!(contents[i] instanceof FragmentComposer)) continue;
            FragmentComposer fragmentComposer = (FragmentComposer)contents[i];
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("copyContentForParents: examining " + fragmentComposer), (Object[])new Object[0]);
            }
            String cp1 = this.getContextPath();
            String cp2 = fragmentComposer.getContextPath();
            boolean ignore = cp1 != null && cp2 != null && cp1.equals(cp2);
            MementoEntry contentME = fragmentComposer.getMementoEntry(ignore);
            contentME.setOutputStyle(fragmentComposer.outputStyle);
            contentME.setExternallyCacheable(fragmentComposer.shouldExternalCacheOutput());
            if (!fragmentComposer.getDoNotConsume() && !fragmentComposer.isDiscardJSPContent()) {
                contentME.addContents(fragmentComposer.contentVector.toArray());
            } else if (fragmentComposer.isDiscardJSPContent()) {
                contentME.addContents(new ArrayList(0).toArray());
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Creating an EMPTY MementoEntry for fragmentComposer -->" + this.uri + " fragmentComposer.isDiscardJSPContent()-->" + fragmentComposer.isDiscardJSPContent()), (Object[])new Object[0]);
                }
            }
            contentME.setDoNotConsume(fragmentComposer.getDoNotConsume());
            this.contentVector.set(i, contentME);
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("Created MementoEntry for " + fragmentComposer.getURI() + " with " + this.contentVector), (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"copyContentForParents", (Object)this.contentVector);
        }
    }

    public String getContextPath() {
        return this.contextPath;
    }

    protected CacheProxyRequest.Attribute[] getSaveAttributeList(CacheProxyRequest request) {
        FragmentInfo fi = (FragmentInfo)request.getFragmentInfo();
        CacheProxyRequest.Attribute[] h = request.getChangedAttributes();
        String[] excludeList = fi.getAttributeExcludeList();
        CacheProxyRequest.Attribute[] saveList = null;
        if (!fi.getStoreAttributes() && excludeList == null) {
            return null;
        }
        if (fi.getStoreAttributes() && excludeList == null) {
            return h;
        }
        if (!fi.getStoreAttributes() && excludeList != null) {
            ArrayList<CacheProxyRequest.Attribute> tmpList = null;
            for (int i = 0; i < excludeList.length; ++i) {
                for (int j = 0; h != null && j < h.length; ++j) {
                    if (!excludeList[i].equals(h[j].key)) continue;
                    if (tmpList == null) {
                        tmpList = new ArrayList<CacheProxyRequest.Attribute>();
                    }
                    tmpList.add(h[j]);
                }
            }
            if (tmpList != null) {
                saveList = tmpList.toArray(new CacheProxyRequest.Attribute[0]);
            }
        } else if (fi.getStoreAttributes() && excludeList != null) {
            ArrayList<CacheProxyRequest.Attribute> tmpList = null;
            for (int i = 0; h != null && i < h.length; ++i) {
                boolean exclude = false;
                for (int j = 0; j < excludeList.length; ++j) {
                    if (!excludeList[j].equals(h[i].key)) continue;
                    exclude = true;
                    break;
                }
                if (exclude) continue;
                if (tmpList == null) {
                    tmpList = new ArrayList<CacheProxyRequest.Attribute>();
                }
                tmpList.add(h[i]);
            }
            if (tmpList != null) {
                saveList = tmpList.toArray(new CacheProxyRequest.Attribute[0]);
            }
        }
        return saveList;
    }

    public byte[] toByteArray(String charEnc) throws IOException {
        if (!this.shouldExternalCacheOutput()) {
            throw new IllegalStateException("Cannot obtain byteArray since caching was not enabled for this fragment");
        }
        this.saveCachedData();
        byte[] array = null;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        OutputStreamWriter osw = null;
        int len = this.contentVector.size();
        for (int i = 0; i < len; ++i) {
            Object object = this.contentVector.get(i);
            if (object instanceof byte[]) {
                if (this.outputStyle != 1) {
                    throw new IllegalStateException("FragmentComposer " + this + " with outputStyle " + this.outputStyle + " cannot contain byte arrays");
                }
                outputStream.write((byte[])object, 0, ((byte[])object).length);
                outputStream.flush();
                continue;
            }
            if (object instanceof char[]) {
                if (this.outputStyle != 2) {
                    throw new IllegalStateException("FragmentComposer " + this + " with outputStyle " + this.outputStyle + " cannot contain char arrays");
                }
                if (osw == null) {
                    try {
                        osw = new OutputStreamWriter((OutputStream)outputStream, charEnc);
                    }
                    catch (UnsupportedEncodingException uex) {
                        FFDCFilter.processException((Throwable)uex, (String)"com.ibm.ws.cache.servlet.FragmentComposer.toByteArray", (String)"671", (Object)this);
                        osw = new OutputStreamWriter(outputStream);
                    }
                }
                osw.write((char[])object, 0, ((char[])object).length);
                osw.flush();
                continue;
            }
            if (object instanceof ResponseSideEffect || object instanceof String) continue;
            if (object instanceof MementoEntry) {
                MementoEntry mementoEntry = (MementoEntry)object;
                byte[] meContents = mementoEntry.toByteArray(charEnc);
                outputStream.write(meContents, 0, meContents.length);
                continue;
            }
            if (!(object instanceof FragmentComposer)) {
                throw new IllegalStateException("FragmentComposer should only contain other FragmentComposers, Byte Arrays, Char Arrays, and ResponseSideEffects");
            }
            FragmentComposer fragmentComposer = (FragmentComposer)object;
            array = fragmentComposer.toByteArray(charEnc);
            outputStream.write(array, 0, array.length);
        }
        return outputStream.toByteArray();
    }

    public int getCacheType() {
        return this.cacheType;
    }

    public void setCacheType(int cacheType) {
        this.cacheType = cacheType;
    }

    public FragmentComposer getParent() {
        return this.parent;
    }

    public void setParent(FragmentComposer fc) {
        this.parent = fc;
    }

    protected void setJSTLImport(boolean flag) {
        this.isJSTLImport = flag;
    }

    public boolean isExternalPage() {
        return this.externalPage;
    }

    public void setExternalPage(boolean externalPage) {
        this.externalPage = externalPage;
    }

    public void setAttributeTableBytes(byte[] attributeTableBytes) {
        this.attributeTableBytes = attributeTableBytes;
    }

    public byte[] getAttributeTableBytes() {
        return this.attributeTableBytes;
    }

    public void setAttributeTable(CacheProxyRequest.Attribute[] attributeTable) {
        this.attributeTable = attributeTable;
    }

    public CacheProxyRequest.Attribute[] getAttributeTable() {
        return this.attributeTable;
    }

    public FragmentInfo getFragmentInfo() {
        return this.fragmentInfo;
    }

    public void setFragmentInfo(FragmentInfo fragmentInfo) {
        this.fragmentInfo = fragmentInfo;
    }

    public String getURI() {
        return this.uri;
    }

    public void setURI(String uri) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this + " URI set to :" + uri), (Object[])new Object[0]);
        }
        this.uri = uri;
    }

    public String getServletClassName() {
        return this.servletClassName;
    }

    public void setServletClassName(String servletClassName) {
        this.servletClassName = servletClassName;
    }

    protected CacheProxyRequest getRequest() {
        return this.request;
    }

    protected CacheProxyResponse getResponse() {
        return this.response;
    }

    public boolean getInclude() {
        return this.include;
    }

    public void setInclude(boolean include) {
        this.include = include;
    }

    public boolean getNamedDispatch() {
        return this.namedDispatch;
    }

    public void setNamedDispatch(boolean namedDispatch) {
        this.namedDispatch = namedDispatch;
    }

    public void setExpirationTime(long expirationTime) {
        if (expirationTime >= 0L && expirationTime < this.expirationTime) {
            this.expirationTime = expirationTime;
        }
    }

    public long getExpirationTime() {
        long expirationTime = this.expirationTime;
        long temp = this.fragmentInfo.getExpirationTime();
        if (temp >= 0L && temp < expirationTime) {
            expirationTime = temp;
        }
        int len = this.contentVector.size();
        for (int i = 0; i < len; ++i) {
            FragmentComposer fragmentComposer;
            Object object = this.contentVector.get(i);
            if (!(object instanceof FragmentComposer) || (temp = (fragmentComposer = (FragmentComposer)object).getExpirationTime()) < 0L || temp >= expirationTime) continue;
            expirationTime = temp;
        }
        if (expirationTime == Long.MAX_VALUE) {
            return -1L;
        }
        return expirationTime;
    }

    public long getTimeStamp() {
        long timeStamp = this.timeStamp;
        int len = this.contentVector.size();
        for (int i = 0; i < len; ++i) {
            FragmentComposer fragmentComposer;
            long temp;
            Object object = this.contentVector.get(i);
            if (!(object instanceof FragmentComposer) || (temp = (fragmentComposer = (FragmentComposer)object).getTimeStamp()) <= timeStamp) continue;
            timeStamp = temp;
        }
        return timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        if (timeStamp <= this.timeStamp) {
            return;
        }
        this.timeStamp = timeStamp;
    }

    public ValueSet getAllInvalidationIds() throws UnexternalizablePageException {
        if (this.cacheType == 0) {
            throw new UnexternalizablePageException("FragmentComposer is NOT_CACHED, therefore, you cannot externalize a top level page which includes it.");
        }
        if (this.fragmentInfo == null) {
            throw new UnexternalizablePageException("FragmentInfo should not be null, or FragmentComposer should be marked NOT_CACHED");
        }
        ValueSet dataIds = new ValueSet(23);
        dataIds.add((Object)this.fragmentInfo.getId());
        dataIds.union(this.fragmentInfo.dataIds);
        dataIds.union(this.externalDataIds);
        return dataIds;
    }

    public ValueSet getAllTemplates() throws UnexternalizablePageException {
        if (this.cacheType == 0) {
            throw new UnexternalizablePageException("FragmentComposer is NOT_CACHED, therefore, you cannot externalize a top level page which includes it.");
        }
        if (this.fragmentInfo == null) {
            throw new UnexternalizablePageException("FragmentInfo should not be null, or FragmentComposer should be marked NOT_CACHED");
        }
        ValueSet templates = new ValueSet(11);
        Iterator it = this.fragmentInfo.templates.iterator();
        while (it.hasNext()) {
            templates.add(it.next());
        }
        templates.union(this.externalTemplates);
        return templates;
    }

    public void setHeader(String key, String value, boolean isSet) {
        if (this.getConsumeSubfragments() || this.currentChild == null) {
            if (key == null) {
                throw new IllegalArgumentException("setHeader key parameter must be non-null");
            }
            HeaderSideEffect headerSideEffect = new HeaderSideEffect(key, value, isSet);
            this.contentVector.add(headerSideEffect);
        }
    }

    public void sendRedirect(String location) {
        this.isSendRedirect = true;
        if (this.getConsumeSubfragments() || this.currentChild == null) {
            SendRedirectSideEffect srse = new SendRedirectSideEffect(location);
            this.contentVector.add(srse);
        }
    }

    public void addDynamicContentProvider(DynamicContentProvider dynamicContentProvider) throws IOException {
        if (dynamicContentProvider == null) {
            throw new IllegalArgumentException("Dynamic Content Provider must be non-null");
        }
        this.saveCachedData();
        this.contentVector.add(dynamicContentProvider);
        if (this.outputStyle == 2) {
            boolean caching = this.cacheProxyWriter.isCaching();
            this.cacheProxyWriter.setCaching(false);
            dynamicContentProvider.provideDynamicContent((HttpServletRequest)this.request, this.cacheProxyWriter.getWriter());
            this.cacheProxyWriter.setCaching(true);
        } else if (this.outputStyle == 1) {
            boolean caching = this.cacheProxyOutputStream.isCaching();
            this.cacheProxyOutputStream.setCaching(false);
            dynamicContentProvider.provideDynamicContent((HttpServletRequest)this.request, this.cacheProxyOutputStream.getOutputStream());
            this.cacheProxyOutputStream.setCaching(true);
        }
    }

    public void addCookie(Cookie cookie) {
        if (this.getConsumeSubfragments() || this.currentChild == null) {
            String[] cookieExclude;
            boolean addCookie;
            if (cookie == null) {
                throw new IllegalArgumentException("cookie must be non-null");
            }
            if (this.fragmentInfo.getStoreCookies()) {
                addCookie = true;
                cookieExclude = this.fragmentInfo.getCookieExcludeList();
                if (cookieExclude != null) {
                    for (int i = 0; i < cookieExclude.length; ++i) {
                        if (!cookie.getName().equals(cookieExclude[i])) continue;
                        addCookie = false;
                    }
                }
            } else {
                addCookie = false;
                cookieExclude = this.fragmentInfo.getCookieExcludeList();
                if (cookieExclude != null) {
                    for (int i = 0; i < cookieExclude.length; ++i) {
                        if (!cookie.getName().equals(cookieExclude[i])) continue;
                        addCookie = true;
                    }
                }
            }
            if (addCookie) {
                AddCookieSideEffect addCookieSideEffect = new AddCookieSideEffect(cookie);
                this.contentVector.add(addCookieSideEffect);
            }
        }
    }

    public void setDateHeader(String name, long value, boolean isSet) {
        if (this.getConsumeSubfragments() || this.currentChild == null) {
            if (name == null) {
                throw new IllegalArgumentException("name must be non-null");
            }
            DateHeaderSideEffect dateHeaderSideEffect = new DateHeaderSideEffect(name, value, isSet);
            this.contentVector.add(dateHeaderSideEffect);
        }
    }

    public void setIntHeader(String name, int value, boolean isSet) {
        if (this.getConsumeSubfragments() || this.currentChild == null) {
            if (name == null) {
                throw new IllegalArgumentException("name must be non-null");
            }
            IntHeaderSideEffect intHeaderSideEffect = new IntHeaderSideEffect(name, value, isSet);
            this.contentVector.add(intHeaderSideEffect);
        }
    }

    public void setStatus(int statusCode) {
        if (this.getConsumeSubfragments() || this.currentChild == null) {
            DefaultStatusSideEffect defaultStatusSideEffect = new DefaultStatusSideEffect(statusCode);
            this.contentVector.add(defaultStatusSideEffect);
        }
    }

    public void setStatus(int statusCode, String comment) {
        if (this.getConsumeSubfragments() || this.currentChild == null) {
            if (comment == null) {
                throw new IllegalArgumentException("comment must be non-null");
            }
            StatusSideEffect statusSideEffect = new StatusSideEffect(statusCode, comment);
            this.contentVector.add(statusSideEffect);
        }
    }

    public void setContentLength(int contentLength) {
        if (this.getConsumeSubfragments() || this.currentChild == null) {
            ContentLengthSideEffect contentLengthSideEffect = new ContentLengthSideEffect(contentLength);
            this.contentVector.add(contentLengthSideEffect);
        }
    }

    public void setContentType(String contentType) {
        if (!this.response._gotWriter && !this.response._gotOutputStream) {
            this.contentType = contentType;
        }
        if (this.getConsumeSubfragments() || this.currentChild == null) {
            this.contentVector.add(contentType);
        }
    }

    public void setCharacterEncoding(String charEnc) {
        if (!this.response._gotWriter && !this.response._gotOutputStream) {
            this.characterEncoding = charEnc;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setting self CharacterEncoding " + charEnc), (Object[])new Object[0]);
            }
        }
        if (this.getConsumeSubfragments() || this.currentChild == null) {
            CharacterEncodingSideEffect charEncSideEffect = new CharacterEncodingSideEffect(charEnc);
            this.contentVector.add(charEncSideEffect);
        }
    }

    public void setLocale(Locale locale) {
        if (this.getConsumeSubfragments() || this.currentChild == null) {
            LocaleSideEffect localeSideEffect = new LocaleSideEffect(locale);
            this.contentVector.add(localeSideEffect);
        }
    }

    public void setESIVersion(int esiVersion) {
        this.esiVersion = esiVersion;
    }

    public int getESIVersion() {
        return this.esiVersion;
    }

    public boolean isDiscardJSPContent() {
        return this.discardJSPContent;
    }

    public void setDiscardJSPContent(boolean discardJSPContent) {
        this.discardJSPContent = discardJSPContent;
    }

    public boolean isAsyncDispatch() {
        return this.asyncDispatch;
    }

    public void setAsyncDispatch(boolean async) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this + " setAsyncDispatch " + async), (Object[])new Object[0]);
        }
        this.asyncDispatch = async;
        if (this.asyncDispatch) {
            this.consumeSubfragments = true;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(this + " Servlet 3.0 Scenario: FORCING consumeSubfragments to true"), (Object[])new Object[0]);
            }
        }
    }

    public boolean isAsyncDoubleDip() {
        return this.asyncDoubleDip;
    }

    public void setAsyncDoubleDip(boolean b) {
        this.asyncDoubleDip = b;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this + " Servlet 3.0 Scenario: AsyncDoubleDip " + b), (Object[])new Object[0]);
        }
    }
}

