/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ras.instrument.internal.bci;

import com.ibm.ws.ras.instrument.internal.bci.AbstractTracingRasClassAdapter;
import com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter;
import com.ibm.ws.ras.instrument.internal.bci.RasMethodAdapter;
import com.ibm.ws.ras.instrument.internal.main.LibertyTracePreprocessInstrumentation;
import com.ibm.ws.ras.instrument.internal.model.ClassInfo;
import com.ibm.ws.ras.instrument.internal.model.FieldInfo;
import java.util.logging.Logger;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class JSR47TracingClassAdapter
extends AbstractTracingRasClassAdapter
implements Opcodes {
    public static final Type LOGGER_TYPE = Type.getType(Logger.class);
    private static final String DEFAULT_LOGGER_FIELD_NAME = "$$$logger$$$";
    private FieldInfo declaredLoggerField;
    private FieldInfo loggerField;
    private boolean loggerAlreadyDefined;

    public JSR47TracingClassAdapter(ClassVisitor visitor, ClassInfo classInfo) {
        super(visitor, classInfo);
        if (classInfo != null) {
            this.declaredLoggerField = classInfo.getDeclaredLoggerField();
            if (this.declaredLoggerField != null && this.declaredLoggerField.getFieldDescriptor().equals("")) {
                this.loggerField = this.declaredLoggerField;
                this.loggerAlreadyDefined = true;
            }
        }
        if (this.loggerField == null) {
            this.loggerField = new FieldInfo(DEFAULT_LOGGER_FIELD_NAME, LOGGER_TYPE.getDescriptor());
        }
    }

    public JSR47TracingClassAdapter(ClassVisitor visitor, ClassInfo classInfo, LibertyTracePreprocessInstrumentation.ClassTraceInfo info) {
        super(visitor, classInfo, info);
    }

    @Override
    public RasMethodAdapter createRasMethodAdapter(MethodVisitor delegate, int access, String name, String descriptor, String signature, String[] exceptions) {
        return new JSR47TracingMethodAdapter(this, delegate, access, name, descriptor, signature, exceptions);
    }

    @Override
    public String getTraceObjectFieldName() {
        return this.loggerField.getFieldName();
    }

    @Override
    public Type getTraceObjectFieldType() {
        return LOGGER_TYPE;
    }

    @Override
    public boolean isTraceObjectFieldDefinitionRequired() {
        System.out.println("!!MJS: JSR47 tracing class adatper isTraceObjectFieldDefinitionRequired called");
        System.out.println("!!MJS loggerAlreadyDefined = " + this.loggerAlreadyDefined);
        return !this.loggerAlreadyDefined;
    }

    @Override
    public boolean isTraceObjectFieldInitializationRequired() {
        return this.isTraceObjectFieldDefinitionRequired();
    }
}

