/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.Configuration;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.LeaseInfo;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class FileFailureScope
implements FailureScope {
    private static final TraceComponent tc = Tr.register(FileFailureScope.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    protected String _serverName;
    private final int _hashCode;
    private final String _stringForm;
    private LeaseInfo _leaseInfo = null;
    static final long serialVersionUID = -7176437965763176854L;

    @Trivial
    public LeaseInfo getLeaseInfo() {
        return this._leaseInfo;
    }

    @Trivial
    public FileFailureScope() {
        this(Configuration.fqServerName());
    }

    @Trivial
    public FileFailureScope(String serverName) {
        this._serverName = serverName;
        this._hashCode = this._serverName.hashCode();
        this._stringForm = "FileFailureScope: " + this._serverName + " [" + this._hashCode + "]";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"FileFailureScope {0}", (Object[])new Object[]{this._stringForm});
        }
    }

    @ManualTrace
    public FileFailureScope(String serverName, LeaseInfo leaseInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"FileFailureScope", (Object[])new Object[]{serverName, leaseInfo});
        }
        this._serverName = serverName;
        this._leaseInfo = leaseInfo;
        this._hashCode = this._serverName.hashCode();
        this._stringForm = "FileFailureScope: " + this._serverName + " [" + this._hashCode + "]";
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"FileFailureScope", (Object)this);
        }
    }

    @Override
    @ManualTrace
    public boolean isContainedBy(FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isContainedBy", (Object[])new Object[]{failureScope, this});
        }
        boolean contains = this.equals(failureScope);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isContainedBy", (Object)contains);
        }
        return contains;
    }

    @ManualTrace
    public boolean equals(Object anotherScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"equals", (Object[])new Object[]{anotherScope, this});
        }
        boolean result = false;
        if (anotherScope == this) {
            result = true;
        } else if (anotherScope instanceof FileFailureScope && ((FileFailureScope)anotherScope)._serverName.equals(this._serverName)) {
            result = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"equals", (Object)result);
        }
        return result;
    }

    public int hashCode() {
        return this._hashCode;
    }

    public String toString() {
        return this._stringForm;
    }

    @Override
    @Trivial
    public String serverName() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"serverName: {0}", (Object[])new Object[]{this._serverName});
        }
        return this._serverName;
    }

    @Override
    @ManualTrace
    public boolean isSameExecutionZone(FailureScope anotherScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isSameExecutionZone", (Object[])new Object[]{anotherScope});
        }
        boolean isSameZone = this.equals(anotherScope);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isSameExecutionZone", (Object)isSameZone);
        }
        return isSameZone;
    }
}

