/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.RLSController;
import com.ibm.ws.recoverylog.spi.RLSControllerFactory;
import com.ibm.ws.recoverylog.spi.RLSInvalidSuspendTokenException;
import com.ibm.ws.recoverylog.spi.RLSSuspendToken;
import com.ibm.ws.recoverylog.spi.RLSTimeoutRangeException;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import com.ibm.ws.recoverylog.spi.RecoveryLogServiceException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class RecoveryLogService {
    private static final TraceComponent tc = Tr.register(RecoveryLogService.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    private static RLSController _rlsController;
    static final long serialVersionUID = 6624937576433842555L;

    private RecoveryLogService() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"RecoveryLogService", (Object[])new Object[]{this});
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public static RLSSuspendToken suspend(int timeout) throws RLSTimeoutRangeException, RecoveryLogServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"suspend", (Object[])new Object[]{timeout});
        }
        RLSSuspendToken token = null;
        try {
            token = RecoveryLogService.getRLSController().suspend(timeout);
        }
        catch (RLSTimeoutRangeException rLSTimeoutRangeException) {
            void exc;
            FFDCFilter.processException((Throwable)rLSTimeoutRangeException, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogService", (String)"80", null, (Object[])new Object[]{timeout});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogService.suspend", (String)"53");
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Rethrow RLSTimeoutRangeException", (Object[])new Object[0]);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"suspend");
            }
            throw exc;
        }
        catch (RecoveryLogServiceException exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogService", (String)"87", null, (Object[])new Object[]{timeout});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogService.suspend", (String)"63");
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"RecoveryLogServiceException caught trying to suspend RLS - rethrowing", (Object[])new Object[0]);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"suspend");
            }
            throw exc;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"suspend", (Object)token);
        }
        return token;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public static void resume(RLSSuspendToken token) throws RLSInvalidSuspendTokenException, RecoveryLogServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resume", (Object[])new Object[]{token});
        }
        try {
            RecoveryLogService.getRLSController().resume(token);
        }
        catch (RLSInvalidSuspendTokenException rLSInvalidSuspendTokenException) {
            void exc;
            FFDCFilter.processException((Throwable)rLSInvalidSuspendTokenException, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogService", (String)"122", null, (Object[])new Object[]{token});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogService.resume", (String)"81");
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Rethrow RLSInvalidSuspendTokenException", (Object[])new Object[0]);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"resume");
            }
            throw exc;
        }
        catch (RecoveryLogServiceException exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogService", (String)"129", null, (Object[])new Object[]{token});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogService.suspend", (String)"91");
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"RecoveryLogServiceException caught trying to resume RLS - rethrowing", (Object[])new Object[0]);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"resume");
            }
            throw exc;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resume");
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public static void resume(byte[] tokenBytes) throws RLSInvalidSuspendTokenException, RecoveryLogServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resume", (Object[])new Object[]{RLSUtils.toHexString(tokenBytes)});
        }
        try {
            RecoveryLogService.getRLSController().resume(tokenBytes);
        }
        catch (RLSInvalidSuspendTokenException rLSInvalidSuspendTokenException) {
            void exc;
            FFDCFilter.processException((Throwable)rLSInvalidSuspendTokenException, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogService", (String)"163", null, (Object[])new Object[]{tokenBytes});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogService.resume", (String)"81");
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Rethrow RLSInvalidSuspendTokenException", (Object[])new Object[0]);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"resume");
            }
            throw exc;
        }
        catch (RecoveryLogServiceException exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogService", (String)"170", null, (Object[])new Object[]{tokenBytes});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogService.suspend", (String)"91");
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"RecoveryLogServiceException caught trying to resume RLS - rethrowing", (Object[])new Object[0]);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"resume");
            }
            throw exc;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resume");
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    private static RLSController getRLSController() throws RecoveryLogServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRLSController", (Object[])new Object[0]);
        }
        RLSController retVal = null;
        if (_rlsController == null) {
            try {
                retVal = RLSControllerFactory.getRLSController();
            }
            catch (Exception exception) {
                void exc;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogService", (String)"197", null, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogService.getRLSController", (String)"115");
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Rethrow as RecoveryLogServiceException", (Object[])new Object[0]);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getRLSController");
                }
                throw new RecoveryLogServiceException((Throwable)exc);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRLSController", (Object)retVal);
        }
        return retVal;
    }
}

