/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.internal.ValidationUtil;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.sdk.metrics.AbstractInstrument;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.InstrumentValueType;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.state.CallbackRegistration;
import io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import io.opentelemetry.sdk.metrics.internal.state.SdkObservableMeasurement;
import io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.Collections;
import java.util.function.BiFunction;
import java.util.function.Consumer;

abstract class AbstractInstrumentBuilder<BuilderT extends AbstractInstrumentBuilder<?>> {
    static final String DEFAULT_UNIT = "";
    private final MeterProviderSharedState meterProviderSharedState;
    private String description;
    private String unit;
    protected final MeterSharedState meterSharedState;
    protected final String instrumentName;

    AbstractInstrumentBuilder(MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, String name, String description, String unit) {
        this.instrumentName = name;
        this.description = description;
        this.unit = unit;
        this.meterProviderSharedState = meterProviderSharedState;
        this.meterSharedState = meterSharedState;
    }

    protected abstract BuilderT getThis();

    public BuilderT setUnit(String unit) {
        this.unit = !ValidationUtil.checkValidInstrumentUnit(unit, " Using \"\" for instrument " + this.instrumentName + " instead.") ? DEFAULT_UNIT : unit;
        return this.getThis();
    }

    public BuilderT setDescription(String description) {
        this.description = description;
        return this.getThis();
    }

    private InstrumentDescriptor makeDescriptor(InstrumentType type, InstrumentValueType valueType) {
        return InstrumentDescriptor.create(this.instrumentName, this.description, this.unit, type, valueType);
    }

    protected <T> T swapBuilder(SwapBuilder<T> swapper) {
        return swapper.newBuilder(this.meterProviderSharedState, this.meterSharedState, this.instrumentName, this.description, this.unit);
    }

    final <I extends AbstractInstrument> I buildSynchronousInstrument(InstrumentType type, InstrumentValueType valueType, BiFunction<InstrumentDescriptor, WriteableMetricStorage, I> instrumentFactory) {
        InstrumentDescriptor descriptor = this.makeDescriptor(type, valueType);
        WriteableMetricStorage storage = this.meterSharedState.registerSynchronousMetricStorage(descriptor, this.meterProviderSharedState);
        return (I)((AbstractInstrument)instrumentFactory.apply(descriptor, storage));
    }

    final CallbackRegistration registerDoubleAsynchronousInstrument(InstrumentType type, Consumer<ObservableDoubleMeasurement> updater) {
        SdkObservableMeasurement sdkObservableMeasurement = this.buildObservableMeasurement(type, InstrumentValueType.DOUBLE);
        Runnable runnable = () -> updater.accept(sdkObservableMeasurement);
        CallbackRegistration callbackRegistration = CallbackRegistration.create(Collections.singletonList(sdkObservableMeasurement), runnable);
        this.meterSharedState.registerCallback(callbackRegistration);
        return callbackRegistration;
    }

    final CallbackRegistration registerLongAsynchronousInstrument(InstrumentType type, Consumer<ObservableLongMeasurement> updater) {
        SdkObservableMeasurement sdkObservableMeasurement = this.buildObservableMeasurement(type, InstrumentValueType.LONG);
        Runnable runnable = () -> updater.accept(sdkObservableMeasurement);
        CallbackRegistration callbackRegistration = CallbackRegistration.create(Collections.singletonList(sdkObservableMeasurement), runnable);
        this.meterSharedState.registerCallback(callbackRegistration);
        return callbackRegistration;
    }

    final SdkObservableMeasurement buildObservableMeasurement(InstrumentType type, InstrumentValueType valueType) {
        return this.meterSharedState.registerObservableMeasurement(this.makeDescriptor(type, valueType));
    }

    @FunctionalInterface
    protected static interface SwapBuilder<T> {
        public T newBuilder(MeterProviderSharedState var1, MeterSharedState var2, String var3, String var4, String var5);
    }
}

