/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.interception.jaxrs;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.jboss.resteasy.core.PostResourceMethodInvoker;
import org.jboss.resteasy.core.PostResourceMethodInvokers;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.core.interception.jaxrs.SuspendableContainerRequestContext;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.specimpl.ResteasyHttpHeaders;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.tracing.RESTEasyTracingLogger;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class PreMatchContainerRequestContext
implements SuspendableContainerRequestContext {
    private static final Logger LOG;
    protected final HttpRequest httpRequest;
    protected Response response;
    private ContainerRequestFilter[] requestFilters;
    private int currentFilter;
    private boolean suspended;
    private boolean filterReturnIsMeaningful = true;
    private Supplier<BuiltResponse> continuation;
    private Map<Class<?>, Object> contextDataMap;
    private boolean inFilter;
    private Throwable throwable;
    private boolean startedContinuation;
    private final Lock lock = new ReentrantLock();
    static final long serialVersionUID = 6745633414340201329L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Deprecated
    public PreMatchContainerRequestContext(HttpRequest request) {
        this(request, new ContainerRequestFilter[0], null);
    }

    public PreMatchContainerRequestContext(HttpRequest request, ContainerRequestFilter[] requestFilters, Supplier<BuiltResponse> continuation) {
        this.httpRequest = request;
        this.requestFilters = requestFilters;
        this.continuation = continuation;
        this.contextDataMap = ResteasyContext.getContextDataMap();
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public Response getResponseAbortedWith() {
        return this.response;
    }

    public Object getProperty(String name) {
        return this.httpRequest.getAttribute(name);
    }

    public Collection<String> getPropertyNames() {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration<String> enames = this.httpRequest.getAttributeNames();
        while (enames.hasMoreElements()) {
            names.add(enames.nextElement());
        }
        return names;
    }

    public void setProperty(String name, Object object) {
        this.httpRequest.setAttribute(name, object);
    }

    public void removeProperty(String name) {
        this.httpRequest.removeAttribute(name);
    }

    public UriInfo getUriInfo() {
        return this.httpRequest.getUri();
    }

    public void setRequestUri(URI requestUri) throws IllegalStateException {
        this.httpRequest.setRequestUri(requestUri);
    }

    public void setRequestUri(URI baseUri, URI requestUri) throws IllegalStateException {
        this.httpRequest.setRequestUri(baseUri, requestUri);
    }

    public String getMethod() {
        return this.httpRequest.getHttpMethod();
    }

    public void setMethod(String method) {
        this.httpRequest.setHttpMethod(method);
    }

    public MultivaluedMap<String, String> getHeaders() {
        return ((ResteasyHttpHeaders)this.httpRequest.getHttpHeaders()).getMutableHeaders();
    }

    public Date getDate() {
        return this.httpRequest.getHttpHeaders().getDate();
    }

    public Locale getLanguage() {
        return this.httpRequest.getHttpHeaders().getLanguage();
    }

    public int getLength() {
        return this.httpRequest.getHttpHeaders().getLength();
    }

    public MediaType getMediaType() {
        return this.httpRequest.getHttpHeaders().getMediaType();
    }

    public List<MediaType> getAcceptableMediaTypes() {
        return this.httpRequest.getHttpHeaders().getAcceptableMediaTypes();
    }

    public List<Locale> getAcceptableLanguages() {
        return this.httpRequest.getHttpHeaders().getAcceptableLanguages();
    }

    public Map<String, Cookie> getCookies() {
        return this.httpRequest.getHttpHeaders().getCookies();
    }

    public boolean hasEntity() {
        return this.getMediaType() != null;
    }

    public InputStream getEntityStream() {
        return this.httpRequest.getInputStream();
    }

    public void setEntityStream(InputStream entityStream) {
        this.httpRequest.setInputStream(entityStream);
    }

    public SecurityContext getSecurityContext() {
        return ResteasyContext.getContextData(SecurityContext.class);
    }

    public void setSecurityContext(SecurityContext context) {
        ResteasyContext.pushContext(SecurityContext.class, context);
    }

    public Request getRequest() {
        return ResteasyContext.getContextData(Request.class);
    }

    public String getHeaderString(String name) {
        return this.httpRequest.getHttpHeaders().getHeaderString(name);
    }

    @Override
    public void suspend() {
        this.lock.lock();
        try {
            if (this.continuation == null) {
                throw new RuntimeException("Suspend not supported yet");
            }
            this.suspended = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortWith(Response response) {
        block10: {
            this.lock.lock();
            try {
                if (this.suspended && !this.inFilter) {
                    try (ResteasyContext.CloseableContext c = ResteasyContext.addCloseableContextDataLevel(this.contextDataMap);){
                        this.httpRequest.getAsyncContext().getAsyncResponse().resume(response);
                        break block10;
                    }
                }
                this.response = response;
                this.suspended = false;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        this.lock.lock();
        try {
            if (!this.suspended) {
                throw new RuntimeException("Cannot resume: not suspended");
            }
            if (this.inFilter) {
                this.suspended = false;
                return;
            }
            try (ResteasyContext.CloseableContext c = ResteasyContext.addCloseableContextDataLevel(this.contextDataMap);){
                this.filter();
            }
            catch (Throwable t) {
                this.writeException(t);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume(Throwable t) {
        block11: {
            this.lock.lock();
            try {
                if (!this.suspended) {
                    throw new RuntimeException("Cannot resume: not suspended");
                }
                if (this.inFilter) {
                    this.throwable = t;
                    this.suspended = false;
                    break block11;
                }
                try (ResteasyContext.CloseableContext c = ResteasyContext.addCloseableContextDataLevel(this.contextDataMap);){
                    this.writeException(t);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void writeException(Throwable t) {
        this.httpRequest.getAsyncContext().getAsyncResponse().resume(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuiltResponse filter() {
        this.lock.lock();
        try {
            BuiltResponse builtResponse;
            RESTEasyTracingLogger tracingLogger = RESTEasyTracingLogger.getInstance(this.httpRequest);
            long totalTimestamp = tracingLogger.timestamp("REQUEST_FILTER_SUMMARY");
            while (this.requestFilters != null && this.currentFilter < this.requestFilters.length) {
                ContainerRequestFilter filter = this.requestFilters[this.currentFilter++];
                try {
                    this.suspended = false;
                    this.response = null;
                    this.throwable = null;
                    this.inFilter = true;
                    long timestamp = tracingLogger.timestamp("REQUEST_FILTER");
                    filter.filter((ContainerRequestContext)this);
                    tracingLogger.logDuration("REQUEST_FILTER", timestamp, filter);
                }
                catch (IOException e) {
                    this.cleanupPostResourceMethodInvokers();
                    throw new ApplicationException(e);
                }
                finally {
                    this.inFilter = false;
                }
                if (this.suspended) {
                    if (!this.httpRequest.getAsyncContext().isSuspended()) {
                        this.httpRequest.getAsyncContext().suspend();
                    }
                    this.filterReturnIsMeaningful = false;
                    this.response = null;
                    BuiltResponse e = null;
                    return e;
                }
                BuiltResponse serverResponse = (BuiltResponse)this.getResponseAbortedWith();
                if (serverResponse != null) {
                    if (this.filterReturnIsMeaningful) {
                        BuiltResponse builtResponse2 = serverResponse;
                        return builtResponse2;
                    }
                    this.httpRequest.getAsyncContext().getAsyncResponse().resume((Object)serverResponse);
                    BuiltResponse builtResponse3 = null;
                    return builtResponse3;
                }
                if (this.throwable == null) continue;
                if (this.filterReturnIsMeaningful) {
                    SynchronousDispatcher.rethrow(this.throwable);
                    continue;
                }
                this.writeException(this.throwable);
                BuiltResponse builtResponse4 = null;
                return builtResponse4;
            }
            tracingLogger.logDuration("REQUEST_FILTER_SUMMARY", totalTimestamp, this.requestFilters == null ? 0 : this.requestFilters.length);
            this.startedContinuation = true;
            if (this.continuation == null) {
                builtResponse = null;
                return builtResponse;
            }
            builtResponse = this.continuation.get();
            return builtResponse;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean startedContinuation() {
        return this.startedContinuation;
    }

    private void cleanupPostResourceMethodInvokers() {
        PostResourceMethodInvokers postResourceMethodInvokers = ResteasyContext.getContextData(PostResourceMethodInvokers.class);
        if (postResourceMethodInvokers != null) {
            for (PostResourceMethodInvoker p : postResourceMethodInvokers.getInvokers()) {
                try {
                    p.close();
                }
                catch (Exception e) {
                    LOG.warn((Object)e.getMessage());
                }
            }
            postResourceMethodInvokers.clear();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.core.interception.jaxrs.PreMatchContainerRequestContext", PreMatchContainerRequestContext.class, null, null);
        LOG = Logger.getLogger(PreMatchContainerRequestContext.class);
    }
}

