/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.utils.OpenAPIModelWalker;
import io.openliberty.microprofile.openapi20.internal.validation.OASValidationResult;
import io.openliberty.microprofile.openapi20.internal.validation.TypeValidator;
import io.openliberty.microprofile.openapi20.internal.validation.ValidationHelper;
import io.openliberty.microprofile.openapi20.internal.validation.ValidatorUtils;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.links.Link;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LinkValidator
extends TypeValidator<Link> {
    private static final TraceComponent tc = Tr.register(LinkValidator.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.validation.ValidationMessages");
    private static final LinkValidator INSTANCE = new LinkValidator();
    static final long serialVersionUID = -1095848508686954111L;

    public static LinkValidator getInstance() {
        return INSTANCE;
    }

    private LinkValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, Link t) {
        block32: {
            boolean isValid;
            block35: {
                block36: {
                    String op;
                    String[] operationRef;
                    block34: {
                        boolean operationIdDefined;
                        boolean operationRefDefined;
                        block33: {
                            String message;
                            if (t == null) break block32;
                            String reference = t.getRef();
                            if (reference != null && !reference.isEmpty()) {
                                ValidatorUtils.referenceValidatorHelper(reference, t, helper, context, key);
                                return;
                            }
                            operationRefDefined = t.getOperationRef() != null && !t.getOperationRef().isEmpty();
                            boolean bl = operationIdDefined = t.getOperationId() != null && !t.getOperationId().isEmpty();
                            if (operationRefDefined && operationIdDefined) {
                                message = Tr.formatMessage((TraceComponent)tc, (String)"linkOperationRefAndId", (Object[])new Object[]{key});
                                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, context.getLocation(), message));
                            }
                            if (operationRefDefined || operationIdDefined) break block33;
                            message = Tr.formatMessage((TraceComponent)tc, (String)"linkMustSpecifyOperationRefOrId", (Object[])new Object[]{key});
                            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
                            break block32;
                        }
                        if (operationIdDefined) {
                            helper.addLinkOperationId(t.getOperationId(), context.getLocation());
                        }
                        if (!operationRefDefined || !t.getOperationRef().startsWith("#")) break block32;
                        isValid = true;
                        if (t.getOperationRef().startsWith("#/paths/") && (operationRef = t.getOperationRef().split("/")).length == 4) break block34;
                        isValid = false;
                        break block35;
                    }
                    String pathKey = operationRef[2].replace("~1", "/").replace("~0", "~");
                    Paths paths = context.getModel().getPaths();
                    if (paths == null || paths.getPathItem(pathKey) == null) break block36;
                    switch (op = operationRef[3].toUpperCase()) {
                        case "GET": {
                            if (paths.getPathItem(pathKey).getGET() == null) {
                                isValid = false;
                                break;
                            }
                            break block35;
                        }
                        case "PUT": {
                            if (paths.getPathItem(pathKey).getPUT() == null) {
                                isValid = false;
                                break;
                            }
                            break block35;
                        }
                        case "POST": {
                            if (paths.getPathItem(pathKey).getPOST() == null) {
                                isValid = false;
                                break;
                            }
                            break block35;
                        }
                        case "DELETE": {
                            if (paths.getPathItem(pathKey).getDELETE() == null) {
                                isValid = false;
                                break;
                            }
                            break block35;
                        }
                        case "OPTIONS": {
                            if (paths.getPathItem(pathKey).getOPTIONS() == null) {
                                isValid = false;
                                break;
                            }
                            break block35;
                        }
                        case "HEAD": {
                            if (paths.getPathItem(pathKey).getHEAD() == null) {
                                isValid = false;
                                break;
                            }
                            break block35;
                        }
                        case "PATCH": {
                            if (paths.getPathItem(pathKey).getPATCH() == null) {
                                isValid = false;
                                break;
                            }
                            break block35;
                        }
                        case "TRACE": {
                            if (paths.getPathItem(pathKey).getTRACE() == null) {
                                isValid = false;
                                break;
                            }
                            break block35;
                        }
                        default: {
                            isValid = false;
                            break;
                        }
                    }
                    break block35;
                }
                isValid = false;
            }
            if (!isValid) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"linkOperationRefInvalidOrMissing", (Object[])new Object[]{key, t.getOperationRef()});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            }
        }
    }
}

