/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.javaeesec.identitystore;

import com.ibm.websphere.ras.ProtectedString;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.javaeesec.CDIHelper;
import com.ibm.ws.security.javaeesec.identitystore.DatabaseIdentityStoreDefinitionWrapper;
import com.ibm.ws.security.javaeesec.identitystore.IdentityStoreRuntimeException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.security.enterprise.credential.CallerOnlyCredential;
import jakarta.security.enterprise.credential.Credential;
import jakarta.security.enterprise.credential.UsernamePasswordCredential;
import jakarta.security.enterprise.identitystore.CredentialValidationResult;
import jakarta.security.enterprise.identitystore.DatabaseIdentityStoreDefinition;
import jakarta.security.enterprise.identitystore.IdentityStore;
import jakarta.security.enterprise.identitystore.IdentityStorePermission;
import jakarta.security.enterprise.identitystore.PasswordHash;
import java.lang.annotation.Annotation;
import java.security.Permission;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

@Default
@ApplicationScoped
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class DatabaseIdentityStore
implements IdentityStore {
    private static final TraceComponent tc = Tr.register(DatabaseIdentityStore.class, (String)"security", (String)"com.ibm.ws.security.javaeesec.internal.resources.JavaEESecMessages");
    private final DatabaseIdentityStoreDefinitionWrapper idStoreDefinition;
    private final PasswordHash passwordHash;
    private InitialContext initialContext;
    private DataSource dataSource;
    private boolean evaluateAlways;
    static final long serialVersionUID = 6014569462181766753L;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DatabaseIdentityStore(DatabaseIdentityStoreDefinition idStoreDefinition) {
        block18: {
            this.initialContext = null;
            this.dataSource = null;
            this.evaluateAlways = false;
            this.idStoreDefinition = new DatabaseIdentityStoreDefinitionWrapper(idStoreDefinition);
            Class<? extends PasswordHash> hashAlgorithm = this.idStoreDefinition.getHashAlgorithm();
            Instance p2phi = null;
            CDI cdi = CDIHelper.getCDI();
            if (cdi != null) {
                p2phi = cdi.select(hashAlgorithm, new Annotation[0]);
            }
            if (p2phi == null) {
                Tr.error((TraceComponent)tc, (String)"JAVAEESEC_ERROR_HASH_NOTFOUND", (Object[])new Object[]{hashAlgorithm});
                throw new IdentityStoreRuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"JAVAEESEC_ERROR_HASH_NOTFOUND", (Object[])new Object[]{hashAlgorithm}));
            }
            if (!p2phi.isUnsatisfied() && !p2phi.isAmbiguous()) {
                this.passwordHash = (PasswordHash)p2phi.get();
            } else {
                Set<? extends PasswordHash> hashes;
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Try alternate bean lookup. isUnsatisfied() is " + p2phi.isUnsatisfied() + ", isAmbiguous() is " + p2phi.isAmbiguous()), (Object[])new Object[0]);
                }
                if ((hashes = CDIHelper.getBeansFromCurrentModule(hashAlgorithm)).size() == 1) {
                    this.passwordHash = hashes.iterator().next();
                } else {
                    if (hashes.size() == 0) {
                        Tr.error((TraceComponent)tc, (String)"JAVAEESEC_ERROR_HASH_NOTFOUND", (Object[])new Object[]{hashAlgorithm});
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)("the CDI bean was not found for: " + hashAlgorithm), (Object[])new Object[0]);
                        }
                        throw new IdentityStoreRuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"JAVAEESEC_ERROR_HASH_NOTFOUND", (Object[])new Object[]{hashAlgorithm}));
                    }
                    Tr.error((TraceComponent)tc, (String)"JAVAEESEC_ERROR_HASH_NOTFOUND", (Object[])new Object[]{hashAlgorithm});
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Too many CDI beans were found for " + hashAlgorithm + ". Found " + hashes.size()), (Object[])new Object[0]);
                    }
                    throw new IdentityStoreRuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"JAVAEESEC_ERROR_HASH_NOTFOUND", (Object[])new Object[]{hashAlgorithm}));
                }
            }
            List<String> params = this.idStoreDefinition.getHashAlgorithmParameters();
            if (params != null && !params.isEmpty()) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Processing HashAlgorithmParameters.", (Object[])new Object[0]);
                }
                HashMap<String, String> prepped = new HashMap<String, String>(params.size());
                for (String param : params) {
                    String[] split = param.split("=");
                    if (split.length != 2) {
                        Tr.error((TraceComponent)tc, (String)"JAVAEESEC_ERROR_BAD_HASH_PARAM", (Object[])new Object[]{hashAlgorithm, param});
                        throw new IdentityStoreRuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"JAVAEESEC_ERROR_BAD_HASH_PARAM", (Object[])new Object[]{hashAlgorithm, param}));
                    }
                    prepped.put(split[0], split[1]);
                }
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Processed HashAlgorithmParameters: " + prepped), (Object[])new Object[0]);
                }
                this.passwordHash.initialize(prepped);
            }
            try {
                this.initialContext = new InitialContext();
            }
            catch (NamingException prepped) {
                void e;
                FFDCFilter.processException((Throwable)prepped, (String)"com.ibm.ws.security.javaeesec.identitystore.DatabaseIdentityStore", (String)"146", (Object)this, (Object[])new Object[]{idStoreDefinition});
                if (!tc.isEventEnabled()) break block18;
                Tr.event((TraceComponent)tc, (String)"Setting up InitializeContext failed, will try later.", (Object[])new Object[]{e});
            }
        }
        boolean bl = this.evaluateAlways = !this.idStoreDefinition.isDataSourceEvaluated();
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Always evaluate Datasource: " + this.evaluateAlways), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public Set<String> getCallerGroups(CredentialValidationResult validationResult) {
        String caller;
        HashSet<String> groups = new HashSet<String>();
        if (!this.validationTypes().contains(IdentityStore.ValidationType.PROVIDE_GROUPS)) {
            return groups;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission((Permission)new IdentityStorePermission("getGroups"));
        }
        if ((caller = validationResult.getCallerPrincipal().getName()) == null) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("A null caller was passed into getCallerGroups. No groups returned. " + validationResult), (Object[])new Object[0]);
            }
            return groups;
        }
        PreparedStatement prep = null;
        String groupsQuery = "not_resolved";
        try {
            groupsQuery = this.idStoreDefinition.getGroupsQuery();
            Connection conn = this.getConnection();
            ResultSet result = null;
            try {
                prep = conn.prepareStatement(groupsQuery);
                prep.setString(1, caller);
                result = this.runQuery(prep, caller);
                if (result == null) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("The result query was null looking for groups for caller " + caller + " with query " + groupsQuery), (Object[])new Object[0]);
                    }
                } else {
                    while (result.next()) {
                        String aGroup = result.getString(1);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("For caller " + caller + " found " + aGroup), (Object[])new Object[0]);
                        }
                        if (aGroup == null) continue;
                        groups.add(aGroup);
                    }
                }
            }
            finally {
                if (result != null) {
                    result.close();
                }
                if (prep != null) {
                    prep.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (IllegalArgumentException | SQLException | NamingException conn) {
            void e;
            FFDCFilter.processException((Throwable)conn, (String)"com.ibm.ws.security.javaeesec.identitystore.DatabaseIdentityStore", (String)"218", (Object)this, (Object[])new Object[]{validationResult});
            Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_EXCEPTION_ON_GROUPS", (Object[])new Object[]{caller, groupsQuery, groups, e});
            throw new IdentityStoreRuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"JAVAEESEC_WARNING_EXCEPTION_ON_GROUPS", (Object[])new Object[]{caller, groupsQuery, groups, e.toString()}), (Throwable)e);
        }
        return groups;
    }

    public int priority() {
        return this.idStoreDefinition.getPriority();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Sensitive
    public CredentialValidationResult validate(Credential credential) {
        String caller;
        if (!this.validationTypes().contains(IdentityStore.ValidationType.VALIDATE)) {
            return CredentialValidationResult.NOT_VALIDATED_RESULT;
        }
        boolean callerOnly = false;
        ProtectedString password = null;
        if (credential instanceof UsernamePasswordCredential) {
            caller = ((UsernamePasswordCredential)credential).getCaller();
            password = new ProtectedString(((UsernamePasswordCredential)credential).getPassword().getValue());
        } else {
            if (!(credential instanceof CallerOnlyCredential)) {
                Tr.error((TraceComponent)tc, (String)"JAVAEESEC_ERROR_WRONG_CRED", (Object[])new Object[0]);
                return CredentialValidationResult.NOT_VALIDATED_RESULT;
            }
            callerOnly = true;
            caller = ((CallerOnlyCredential)credential).getCaller();
        }
        if (caller == null) {
            if (!tc.isEventEnabled()) return CredentialValidationResult.INVALID_RESULT;
            Tr.event((TraceComponent)tc, (String)"A null caller was passed in", (Object[])new Object[0]);
            return CredentialValidationResult.INVALID_RESULT;
        }
        if (!callerOnly && password == null && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("A null password was passed in for caller " + caller), (Object[])new Object[0]);
        }
        ProtectedString dbPassword = null;
        PreparedStatement prep = null;
        String callerQuery = "not_resolved";
        try {
            callerQuery = this.idStoreDefinition.getCallerQuery();
            if (callerQuery == null || callerQuery.isEmpty()) {
                if (!tc.isEventEnabled()) return CredentialValidationResult.INVALID_RESULT;
                Tr.event((TraceComponent)tc, (String)("The 'callerQuery' parameter can not be " + callerQuery == null ? "null." : "empty."), (Object[])new Object[0]);
                return CredentialValidationResult.INVALID_RESULT;
            }
            Connection conn = this.getConnection();
            ResultSet result = null;
            try {
                prep = conn.prepareStatement(callerQuery);
                prep.setString(1, caller);
                prep.setMaxRows(2);
                result = this.runQuery(prep, caller);
                if (result == null) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("The result query was null looking for caller " + caller + " with query " + callerQuery), (Object[])new Object[0]);
                    }
                    CredentialValidationResult credentialValidationResult = CredentialValidationResult.INVALID_RESULT;
                    return credentialValidationResult;
                }
                if (!result.next()) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("The result query was empty looking for caller " + caller + " with query " + callerQuery), (Object[])new Object[0]);
                    }
                    CredentialValidationResult credentialValidationResult = CredentialValidationResult.INVALID_RESULT;
                    return credentialValidationResult;
                }
                if (!callerOnly) {
                    String dbreturn = result.getString(1);
                    if (dbreturn == null) {
                        Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_NO_PWD", (Object[])new Object[]{caller, callerQuery});
                        CredentialValidationResult credentialValidationResult = CredentialValidationResult.INVALID_RESULT;
                        return credentialValidationResult;
                    }
                    dbPassword = new ProtectedString(dbreturn.toCharArray());
                }
                if (result.next()) {
                    Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_MULTI_CALLER", (Object[])new Object[]{caller, callerQuery});
                    CredentialValidationResult credentialValidationResult = CredentialValidationResult.INVALID_RESULT;
                    return credentialValidationResult;
                }
            }
            finally {
                if (result != null) {
                    result.close();
                }
                if (prep != null) {
                    prep.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (IllegalArgumentException | SQLException | NamingException conn) {
            void e;
            FFDCFilter.processException((Throwable)conn, (String)"com.ibm.ws.security.javaeesec.identitystore.DatabaseIdentityStore", (String)"329", (Object)this, (Object[])new Object[]{credential});
            Tr.error((TraceComponent)tc, (String)"JAVAEESEC_ERROR_GEN_DB", (Object[])new Object[]{caller, callerQuery, e});
            throw new IdentityStoreRuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"JAVAEESEC_ERROR_GEN_DB", (Object[])new Object[]{caller, callerQuery, e.toString()}), (Throwable)e);
        }
        if (!callerOnly && !this.passwordHash.verify(password.getChars(), String.valueOf(dbPassword.getChars()))) {
            if (!tc.isEventEnabled()) return CredentialValidationResult.INVALID_RESULT;
            Tr.event((TraceComponent)tc, (String)("PasswordHash verify check returned false for caller: " + caller), (Object[])new Object[0]);
            return CredentialValidationResult.INVALID_RESULT;
        }
        Set<String> groups = this.getCallerGroups(new CredentialValidationResult(null, caller, null, caller, null));
        return new CredentialValidationResult(this.idStoreDefinition.getDataSourceLookup(), caller, null, caller, groups);
    }

    public Set<IdentityStore.ValidationType> validationTypes() {
        return this.idStoreDefinition.getUseFor();
    }

    /*
     * WARNING - void declaration
     */
    private ResultSet runQuery(PreparedStatement prep, String caller) throws SQLException {
        long startTime = -1L;
        ResultSet result = null;
        try {
            if (tc.isDebugEnabled()) {
                startTime = System.currentTimeMillis();
            }
            result = prep.executeQuery();
        }
        catch (Exception endTime) {
            void e;
            FFDCFilter.processException((Throwable)endTime, (String)"com.ibm.ws.security.javaeesec.identitystore.DatabaseIdentityStore", (String)"360", (Object)this, (Object[])new Object[]{prep, caller});
            throw e;
        }
        finally {
            if (tc.isDebugEnabled()) {
                long endTime = System.currentTimeMillis();
                Tr.debug((TraceComponent)tc, (String)("Time to run query on caller " + caller + ". Start time: " + startTime + ". End time: " + endTime + ". Total time in ms: " + (endTime - startTime)), (Object[])new Object[0]);
            }
        }
        return result;
    }

    private Connection getConnection() throws NamingException, SQLException {
        DataSource localDataSource;
        if (this.initialContext == null) {
            this.initialContext = new InitialContext();
        }
        if (this.evaluateAlways || this.dataSource == null) {
            String dataSourceLookup = this.idStoreDefinition.getDataSourceLookup();
            if (dataSourceLookup == null || dataSourceLookup.isEmpty()) {
                throw new IllegalArgumentException("The 'dataSourceLookup' configuration cannot be " + (dataSourceLookup == null ? "null." : "empty."));
            }
            localDataSource = (DataSource)this.initialContext.lookup(dataSourceLookup);
            if (!this.evaluateAlways) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("DataSource is stored for " + dataSourceLookup), (Object[])new Object[0]);
                }
                this.dataSource = localDataSource;
            }
        } else {
            localDataSource = this.dataSource;
        }
        Connection conn = localDataSource.getConnection();
        return conn;
    }
}

