/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.telemetry.internal.common.info;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.telemetry.internal.common.info.OpenTelemetryInfo;
import io.opentelemetry.api.OpenTelemetry;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class DisposedOpenTelemetryInfo
implements OpenTelemetryInfo {
    private static final TraceComponent tc = Tr.register(DisposedOpenTelemetryInfo.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
    private String appName = "Unkown";
    static final long serialVersionUID = 3253499758608663323L;

    public DisposedOpenTelemetryInfo() {
    }

    public DisposedOpenTelemetryInfo(String appName) {
        this.appName = appName;
    }

    @Override
    public boolean getEnabled() {
        return false;
    }

    @Override
    public OpenTelemetry getOpenTelemetry() {
        this.logWarning();
        return OpenTelemetry.noop();
    }

    @Override
    public void dispose() {
    }

    private void logWarning() {
        Tr.warning((TraceComponent)tc, (String)Tr.formatMessage((TraceComponent)tc, (String)"CWMOT5003.factory.used.after.shutdown", (Object[])new Object[]{this.appName}), (Object[])new Object[0]);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Exception e = new Exception();
            ByteArrayOutputStream stackStream = new ByteArrayOutputStream();
            PrintStream stackPrintStream = new PrintStream(stackStream);
            e.printStackTrace(stackPrintStream);
            Tr.event((TraceComponent)tc, (String)"OpenTelemetryInfoFactory", (Object[])new Object[]{"The stack that led to OpenTelemetryInfoFactory being called after " + this.appName + " has shutdown is:.", stackStream.toString()});
        }
    }
}

