/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.jakartasec.tokens;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.security.jakartasec.tokens.CloneClaimsAction;
import io.openliberty.security.jakartasec.tokens.JwtClaimsImpl;
import jakarta.security.enterprise.identitystore.openid.AccessToken;
import jakarta.security.enterprise.identitystore.openid.JwtClaims;
import jakarta.security.enterprise.identitystore.openid.Scope;
import java.io.Serializable;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AccessTokenImpl
implements AccessToken,
Serializable {
    public static final TraceComponent tc = Tr.register(AccessTokenImpl.class, (String)"OpenIdConnect", (String)"io.openliberty.security.jakartasec.internal.resources.JakartaSecurity30Messages");
    private static final long serialVersionUID = 1L;
    private final String tokenString;
    private final Long expirationTimeInSeconds;
    private final Instant responseGenerationTime;
    private final Long tokenMinValidityInMillis;
    private Map<String, Object> accessTokenClaimsMap;
    private JwtClaims jwtClaims;
    private AccessToken.Type type;

    public AccessTokenImpl(String tokenString, Instant responseGenerationTime, Long expirationTimeInSeconds, Long tokenMinValidityInMillis) {
        this.tokenString = tokenString;
        this.expirationTimeInSeconds = expirationTimeInSeconds;
        this.responseGenerationTime = responseGenerationTime;
        this.tokenMinValidityInMillis = tokenMinValidityInMillis;
        this.accessTokenClaimsMap = Collections.emptyMap();
        this.jwtClaims = JwtClaims.NONE;
        this.type = AccessToken.Type.MAC;
    }

    public AccessTokenImpl(String tokenString, Map<String, Object> accessTokenClaimsMap, Instant responseGenerationTime, Long expirationTimeInSeconds, Long tokenMinValidityInMillis) {
        this(tokenString, responseGenerationTime, expirationTimeInSeconds, tokenMinValidityInMillis);
        this.accessTokenClaimsMap = accessTokenClaimsMap == null ? Collections.emptyMap() : accessTokenClaimsMap;
        this.jwtClaims = accessTokenClaimsMap == null ? JwtClaims.NONE : new JwtClaimsImpl(accessTokenClaimsMap);
        this.type = AccessToken.Type.BEARER;
    }

    public String getToken() {
        return this.tokenString;
    }

    public boolean isJWT() {
        return AccessToken.Type.BEARER.equals((Object)this.type);
    }

    public JwtClaims getJwtClaims() {
        return this.jwtClaims;
    }

    public Map<String, Object> getClaims() {
        if (AccessToken.Type.BEARER.equals((Object)this.type)) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            CloneClaimsAction action = new CloneClaimsAction(result);
            this.accessTokenClaimsMap.forEach(action);
            return result;
        }
        return Collections.emptyMap();
    }

    public Object getClaim(String key) {
        return this.accessTokenClaimsMap.get(key);
    }

    public Long getExpirationTime() {
        return this.expirationTimeInSeconds;
    }

    public boolean isExpired() {
        Instant expirationInstant = this.getExpirationInstant();
        Instant nowInstant = Instant.now();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Current time: " + nowInstant + ", expirationInstant: " + expirationInstant + " = when the token response was generated (" + this.responseGenerationTime + ") + expiration time (" + this.expirationTimeInSeconds + "), tokenMinValidityInMillis: " + this.tokenMinValidityInMillis), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)"Token is considered expired if the current time is after expiration instant, or if the current time + tokenMinValidityInMillis is after the expiration instant", (Object[])new Object[0]);
        }
        return nowInstant.isAfter(expirationInstant) || nowInstant.plusMillis(this.tokenMinValidityInMillis).isAfter(expirationInstant);
    }

    private Instant getExpirationInstant() {
        Instant expirationInstant = Instant.MIN;
        if (this.expirationTimeInSeconds != null && this.expirationTimeInSeconds >= 0L) {
            expirationInstant = this.responseGenerationTime.plusMillis(this.expirationTimeInSeconds * 1000L);
        } else if (AccessToken.Type.BEARER.equals((Object)this.type)) {
            Optional expirationOptionalInstant;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Access token is a bearer token", (Object[])new Object[0]);
            }
            if ((expirationOptionalInstant = this.jwtClaims.getExpirationTime()).isPresent()) {
                expirationInstant = (Instant)expirationOptionalInstant.get();
            }
        }
        return expirationInstant;
    }

    public Scope getScope() {
        Optional optionalScope;
        if (AccessToken.Type.BEARER.equals((Object)this.type) && (optionalScope = this.jwtClaims.getStringClaim("scope")).isPresent()) {
            return Scope.parse((String)((String)optionalScope.get()));
        }
        return null;
    }

    public AccessToken.Type getType() {
        return this.type;
    }
}

