/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.concurrent.internal.processor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.resource.ResourceFactoryBuilder;
import com.ibm.ws.resource.ResourceRefInfo;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import com.ibm.wsspi.resource.ResourceFactory;
import com.ibm.wsspi.resource.ResourceInfo;
import io.openliberty.concurrent.internal.processor.ContextServiceDefinitionProvider;
import io.openliberty.concurrent.internal.processor.QualifierProxy;
import io.openliberty.concurrent.internal.qualified.QualifiedResourceFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AppDefinedResourceFactory
implements QualifiedResourceFactory {
    private static final TraceComponent tc = Tr.register(AppDefinedResourceFactory.class, (String)"concurrent", (String)"io.openliberty.concurrent.internal.resources.CWWKCMessages");
    private final String appName;
    private final ResourceFactoryBuilder builder;
    private final String contextSvcFilter;
    private final String contextSvcJndiName;
    private final ClassLoader declaringClassLoader;
    private final MetaData declaringMetadata;
    private final String id;
    private final String jndiName;
    private final Set<Annotation> qualifiers;
    private final ServiceTracker<ResourceFactory, ResourceFactory> tracker;
    static final long serialVersionUID = 2649103506682204803L;

    AppDefinedResourceFactory(ResourceFactoryBuilder builder, BundleContext bundleContext, String appName, String id, String jndiName, String filter, String contextSvcJndiName, String contextSvcFilter, MetaData declaringMetadata, ClassLoader declaringClassLoader, List<String> qualifierNames) throws ClassNotFoundException, InvalidSyntaxException {
        this.appName = appName;
        this.builder = builder;
        this.id = id;
        this.jndiName = jndiName;
        this.contextSvcFilter = contextSvcFilter;
        this.contextSvcJndiName = contextSvcJndiName;
        this.declaringClassLoader = declaringClassLoader;
        this.declaringMetadata = declaringMetadata;
        if (qualifierNames == null) {
            this.qualifiers = Collections.emptySet();
        } else {
            this.qualifiers = new LinkedHashSet<Annotation>();
            for (String qualifierClassName : qualifierNames) {
                Class<?> qualifierClass = declaringClassLoader.loadClass(qualifierClassName);
                if (!qualifierClass.isInterface()) {
                    throw new IllegalArgumentException("The " + qualifierClassName + " class is not a valid qualifier class because it is not an annotation.");
                }
                this.qualifiers.add((Annotation)Annotation.class.cast(Proxy.newProxyInstance(declaringClassLoader, new Class[]{Annotation.class, qualifierClass}, (InvocationHandler)new QualifierProxy(qualifierClass))));
            }
        }
        this.tracker = new ServiceTracker(bundleContext, bundleContext.createFilter(filter), null);
        this.tracker.open();
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public Object createResource(ResourceInfo info) throws Exception {
        Object resource;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"createResource", (Object[])new Object[]{info});
        }
        try {
            ResourceFactory factory = (ResourceFactory)this.tracker.waitForService(TimeUnit.MINUTES.toMillis(1L));
            if (factory == null) {
                Bundle bundle;
                BundleContext bundleContext;
                Collection refs;
                int start = this.id.lastIndexOf("]/managed") + 3;
                String type = "M" + this.id.substring(start, this.id.indexOf(91, start));
                if (this.contextSvcFilter != null && (refs = ContextServiceDefinitionProvider.priv.getServiceReferences(bundleContext = ContextServiceDefinitionProvider.priv.getBundleContext(bundle = FrameworkUtil.getBundle(this.getClass())), ResourceFactory.class, this.contextSvcFilter)).isEmpty()) {
                    throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1201.contextsvc.inaccessible", (Object[])new Object[]{type + " " + this.jndiName, this.appName, this.contextSvcJndiName}));
                }
                throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1200.resource.unavailable", (Object[])new Object[]{type + " " + this.jndiName, this.appName}));
            }
            resource = factory.createResource(info);
        }
        catch (Exception factory) {
            void x;
            FFDCFilter.processException((Throwable)factory, (String)"io.openliberty.concurrent.internal.processor.AppDefinedResourceFactory", (String)"199", (Object)this, (Object[])new Object[]{info});
            FFDCFilter.processException((Throwable)x, (String)this.getClass().getName(), (String)"129", (Object)this);
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"createResource", (Object)x);
            }
            throw x;
        }
        catch (Error x) {
            FFDCFilter.processException((Throwable)x, (String)"io.openliberty.concurrent.internal.processor.AppDefinedResourceFactory", (String)"204", (Object)this, (Object[])new Object[]{info});
            FFDCFilter.processException((Throwable)x, (String)this.getClass().getName(), (String)"134", (Object)this);
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"createResource", (Object)x);
            }
            throw x;
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"createResource", (Object)resource);
        }
        return resource;
    }

    @Trivial
    public Object createResource(ResourceRefInfo ref) throws Exception {
        return this.createResource((ResourceInfo)ref);
    }

    @ManualTrace
    public void destroy() throws Exception {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"destroy", (Object[])new Object[]{this.id});
        }
        this.tracker.close();
        StringBuilder filter = new StringBuilder(FilterUtils.createPropertyFilter((String)"id", (String)this.id));
        filter.insert(filter.length() - 1, '*');
        this.builder.removeExistingConfigurations(filter.toString());
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"destroy");
        }
    }

    @Override
    public ClassLoader getDeclaringClassLoader() {
        return this.declaringClassLoader;
    }

    @Override
    public MetaData getDeclaringMetadata() {
        return this.declaringMetadata;
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public void modify(Map<String, Object> props) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Trivial
    public String toString() {
        return "AppDefinedResourceFactory@" + Integer.toHexString(this.hashCode()) + ':' + this.id;
    }
}

