/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.concurrent.internal.processor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.javaee.dd.common.ContextService;
import com.ibm.ws.javaee.dd.common.JNDIEnvironmentRef;
import com.ibm.ws.javaee.version.JavaEEVersion;
import com.ibm.ws.kernel.service.util.SecureAction;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionProcessor;
import com.ibm.wsspi.injectionengine.InjectionProcessorProvider;
import io.openliberty.concurrent.internal.processor.ContextServiceDefinitionBinding;
import jakarta.enterprise.concurrent.ContextServiceDefinition;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.security.AccessController;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={InjectionProcessorProvider.class})
public class ContextServiceDefinitionProvider
extends InjectionProcessorProvider<ContextServiceDefinition, ContextServiceDefinition.List> {
    static final SecureAction priv = (SecureAction)AccessController.doPrivileged(SecureAction.get());
    private static final TraceComponent tc = Tr.register(ContextServiceDefinitionProvider.class, (String)"concurrent", (String)"io.openliberty.concurrent.internal.resources.CWWKCMessages");
    private static final List<Class<? extends JNDIEnvironmentRef>> REF_CLASSES = Collections.singletonList(ContextService.class);
    private int eeVersion;
    static final long serialVersionUID = 832350615739613300L;

    @Trivial
    public Class<ContextServiceDefinition> getAnnotationClass() {
        return ContextServiceDefinition.class;
    }

    @Trivial
    public Class<ContextServiceDefinition.List> getAnnotationsClass() {
        return ContextServiceDefinition.List.class;
    }

    @Trivial
    public List<Class<? extends JNDIEnvironmentRef>> getJNDIEnvironmentRefClasses() {
        return REF_CLASSES;
    }

    public InjectionProcessor<ContextServiceDefinition, ContextServiceDefinition.List> createInjectionProcessor() {
        return new Processor();
    }

    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    protected void setEEVersion(ServiceReference<JavaEEVersion> ref) {
        String version = (String)ref.getProperty("version");
        this.eeVersion = Integer.parseInt(version.substring(0, version.indexOf(46)));
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    class Processor
    extends InjectionProcessor<ContextServiceDefinition, ContextServiceDefinition.List> {
        static final long serialVersionUID = 8817739454129956599L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        public Processor() {
            super(ContextServiceDefinition.class, ContextServiceDefinition.List.class);
        }

        @ManualTrace
        public InjectionBinding<ContextServiceDefinition> createInjectionBinding(ContextServiceDefinition annotation, Class<?> instanceClass, Member member, String jndiName) throws InjectionException {
            boolean trace;
            boolean bl = trace = TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled();
            if (trace) {
                Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"createInjectionBinding", (Object[])new Object[]{ContextServiceDefinitionBinding.toString(annotation, ContextServiceDefinitionProvider.this.eeVersion), instanceClass, member, jndiName});
            }
            ContextServiceDefinitionBinding injectionBinding = new ContextServiceDefinitionBinding(jndiName, this.ivNameSpaceConfig, ContextServiceDefinitionProvider.this.eeVersion);
            injectionBinding.merge((Annotation)annotation, instanceClass, null);
            if (trace) {
                Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"createInjectionBinding", (Object)((Object)injectionBinding));
            }
            return injectionBinding;
        }

        @Trivial
        public ContextServiceDefinition[] getAnnotations(ContextServiceDefinition.List pluralAnnotation) {
            ContextServiceDefinition[] annos = pluralAnnotation.value();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Object[] a = new String[annos.length];
                for (int i = 0; i < annos.length; ++i) {
                    a[i] = "ContextServiceDefinition@" + Integer.toHexString(annos[i].hashCode()) + ' ' + annos[i].name();
                }
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"getAnnotations", (Object[])a);
            }
            return annos;
        }

        @Trivial
        public String getJndiName(ContextServiceDefinition annotation) {
            return annotation.name();
        }

        public void processXML() throws InjectionException {
            List contextServiceDefinitions = this.ivNameSpaceConfig.getJNDIEnvironmentRefs(ContextService.class);
            if (contextServiceDefinitions != null) {
                for (ContextService contextService : contextServiceDefinitions) {
                    ContextServiceDefinitionBinding binding;
                    String jndiName = contextService.getName();
                    InjectionBinding injectionBinding = (InjectionBinding)this.ivAllAnnotationsCollection.get(jndiName);
                    if (injectionBinding == null) {
                        binding = new ContextServiceDefinitionBinding(jndiName, this.ivNameSpaceConfig, ContextServiceDefinitionProvider.this.eeVersion);
                        this.addInjectionBinding(binding);
                    } else {
                        binding = (ContextServiceDefinitionBinding)injectionBinding;
                    }
                    binding.mergeXML(contextService);
                }
            }
        }

        public void resolve(InjectionBinding<ContextServiceDefinition> injectionBinding) throws InjectionException {
            ((ContextServiceDefinitionBinding)injectionBinding).resolve();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.concurrent.internal.processor.ContextServiceDefinitionProvider$Processor", Processor.class, (String)"concurrent", (String)"io.openliberty.concurrent.internal.resources.CWWKCMessages");
        }
    }
}

