/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.concurrent.internal.processor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrent.WSManagedExecutorService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.resource.ResourceFactory;
import com.ibm.ws.resource.ResourceFactoryBuilder;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.kernel.service.location.VariableRegistry;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import io.openliberty.concurrent.internal.processor.AppDefinedResourceFactory;
import io.openliberty.concurrent.internal.processor.ContextServiceDefinitionProvider;
import io.openliberty.concurrent.internal.qualified.QualifiedResourceFactories;
import io.openliberty.concurrent.internal.qualified.QualifiedResourceFactory;
import jakarta.enterprise.concurrent.ContextServiceDefinition;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={ResourceFactoryBuilder.class}, property={"creates.objectClass=jakarta.enterprise.concurrent.ContextService"})
public class ContextServiceResourceFactoryBuilder
implements ResourceFactoryBuilder {
    private static final TraceComponent tc = Tr.register(ContextServiceResourceFactoryBuilder.class, (String)"concurrent", (String)"io.openliberty.concurrent.internal.resources.CWWKCMessages");
    private static final String CONTEXT_PID_ZOS_WLM = "com.ibm.ws.zos.wlm.context";
    public static final Map<String, String[]> BUILT_IN_CONTEXT_PIDS = new HashMap<String, String[]>();
    private static final String CONFIG_DISPLAY_ID = "config.displayId";
    private static final String CONFIG_SOURCE = "config.source";
    static final String DECLARING_APPLICATION = "declaringApplication";
    static final String DECLARING_CLASS_LOADER = "declaringClassLoader";
    static final String DECLARING_METADATA = "declaringMetadata";
    private static final String FILE = "file";
    private static final String ID = "id";
    static final String UNIQUE_JNDI_NAME = "jndiName.unique";
    private final AtomicServiceReference<ConfigurationAdmin> configAdminRef = new AtomicServiceReference("ConfigAdmin");
    private final AtomicServiceReference<VariableRegistry> variableRegistryRef = new AtomicServiceReference("VariableRegistry");
    static final long serialVersionUID = -3386463477411989749L;

    protected void activate(ComponentContext context) {
        this.configAdminRef.activate(context);
        this.variableRegistryRef.activate(context);
    }

    @Trivial
    private int addPropagated(String[] pids, int propagateCount, String[] properties, Hashtable<String, Object> contextSvcProps) {
        for (String pid : pids) {
            String prefix = "threadContextConfigRef." + propagateCount++;
            if (CONTEXT_PID_ZOS_WLM.equals(pid)) {
                String defaultTransactionClass = "ASYNCBN";
                String daemonTransactionClass = "ASYNCDMN";
                if (properties != null) {
                    for (String prop : properties) {
                        if (prop.startsWith("defaultTransactionClass=")) {
                            defaultTransactionClass = prop.substring(24);
                            continue;
                        }
                        if (!prop.startsWith("daemonTransactionClass=")) continue;
                        daemonTransactionClass = prop.substring(23);
                    }
                }
                contextSvcProps.put(prefix + ".wlm", "Propagate");
                contextSvcProps.put(prefix + ".defaultTransactionClass", defaultTransactionClass);
                contextSvcProps.put(prefix + ".daemonTransactionClass", daemonTransactionClass);
            }
            contextSvcProps.put(prefix + ".config.referenceType", pid);
        }
        return propagateCount;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public ResourceFactory createResourceFactory(Map<String, Object> props) throws Exception {
        void var28_36;
        int n;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createResourceFactory", (Object[])new Object[]{ContextServiceResourceFactoryBuilder.toString(props)});
        }
        Hashtable<String, Object> contextSvcProps = new Hashtable<String, Object>();
        contextSvcProps.put("onError", "WARN");
        VariableRegistry variableRegistry = (VariableRegistry)this.variableRegistryRef.getServiceWithException();
        for (Map.Entry<String, Object> prop : props.entrySet()) {
            Object value = prop.getValue();
            if (value instanceof String) {
                value = variableRegistry.resolveRawString((String)value);
            } else if (value instanceof String[]) {
                String[] v = (String[])value;
                String[] s = new String[v.length];
                for (int i = 0; i < v.length; ++i) {
                    s[i] = variableRegistry.resolveRawString(v[i]);
                }
            }
            contextSvcProps.put(prop.getKey(), value);
        }
        ClassLoader declaringClassLoader = (ClassLoader)contextSvcProps.remove(DECLARING_CLASS_LOADER);
        MetaData declaringMetadata = (MetaData)contextSvcProps.remove(DECLARING_METADATA);
        String declaringApplication = (String)contextSvcProps.remove(DECLARING_APPLICATION);
        String application = (String)contextSvcProps.get("application");
        String module = (String)contextSvcProps.get("module");
        String component = (String)contextSvcProps.get("component");
        String jndiName = (String)contextSvcProps.get("jndiName");
        String contextServiceID = ContextServiceResourceFactoryBuilder.getContextServiceID(application, module, component, jndiName);
        StringBuilder filter = new StringBuilder(FilterUtils.createPropertyFilter((String)ID, (String)contextServiceID));
        filter.insert(filter.length() - 1, '*');
        if (!this.removeExistingConfigurations(filter.toString())) {
            throw new IllegalArgumentException(contextServiceID);
        }
        contextSvcProps.put(ID, contextServiceID);
        contextSvcProps.put(CONFIG_DISPLAY_ID, contextServiceID);
        contextSvcProps.put(UNIQUE_JNDI_NAME, contextServiceID);
        contextSvcProps.put("baseInstance.target", "(service.pid=unbound)");
        contextSvcProps.put("baseInstance.cardinality.minimum", 0);
        Object[] cleared = (String[])contextSvcProps.remove("cleared");
        Object[] propagated = (String[])contextSvcProps.remove("propagated");
        Object[] unchanged = (String[])contextSvcProps.remove("unchanged");
        String[] properties = (String[])contextSvcProps.remove("properties");
        String[] qualifiers = (String[])contextSvcProps.remove("qualifiers");
        List<String> qualifierNames = null;
        if (qualifiers != null && qualifiers.length > 0) {
            qualifierNames = Arrays.asList(qualifiers);
            contextSvcProps.put("qualifiers", qualifierNames);
        }
        if (cleared == null) {
            cleared = new String[]{};
        }
        if (propagated == null) {
            propagated = new String[]{};
        }
        if (unchanged == null) {
            unchanged = new String[]{};
        }
        String transaction = null;
        String remaining = null;
        TreeSet<String> dups = new TreeSet<String>();
        HashSet<String> used = new HashSet<String>();
        TreeSet<String> cleared3PCtx = new TreeSet<String>();
        for (String string : cleared) {
            if (used.add(string)) {
                if ("Remaining".equals(string)) {
                    remaining = "cleared";
                    continue;
                }
                if ("Transaction".equals(string)) {
                    transaction = "cleared";
                    continue;
                }
                String[] pids2 = BUILT_IN_CONTEXT_PIDS.get(string);
                if (pids2 != null) continue;
                cleared3PCtx.add(string);
                continue;
            }
            dups.add(string);
        }
        TreeSet<String> unchanged3PCtx = new TreeSet<String>();
        StringBuilder skip = new StringBuilder();
        for (String string : unchanged) {
            if (used.add(string)) {
                if ("Remaining".equals(string)) {
                    remaining = "unchanged";
                    continue;
                }
                if ("Transaction".equals(string)) {
                    transaction = "unchanged";
                    continue;
                }
                String[] pids3 = BUILT_IN_CONTEXT_PIDS.get(string);
                if (pids3 == null) {
                    unchanged3PCtx.add(string);
                    skip.append(skip.length() == 0 ? "" : ",").append(string);
                    continue;
                }
                for (String pid : pids3) {
                    skip.append(skip.length() == 0 ? "" : ",").append(pid).append(".provider");
                }
                continue;
            }
            dups.add(string);
        }
        TreeSet<String> propagated3PCtx = new TreeSet<String>();
        boolean bl = false;
        used.add("EmptyHandleList");
        for (String string : propagated) {
            if (used.add(string)) {
                int n2;
                if ("Remaining".equals(string)) {
                    remaining = "propagated";
                    continue;
                }
                if ("Transaction".equals(string)) {
                    transaction = "propagated";
                    continue;
                }
                String[] pids4 = BUILT_IN_CONTEXT_PIDS.get(string);
                if (pids4 == null) {
                    propagated3PCtx.add(string);
                    continue;
                }
                n2 = this.addPropagated(pids4, n2, properties, contextSvcProps);
                continue;
            }
            dups.add(string);
        }
        if (remaining == null) {
            remaining = "cleared";
        } else if ("propagated".equals(remaining)) {
            for (Map.Entry entry : BUILT_IN_CONTEXT_PIDS.entrySet()) {
                String type = (String)entry.getKey();
                if (used.contains(type)) continue;
                used.add(type);
                String[] stringArray = (String[])entry.getValue();
                n = this.addPropagated(stringArray, n, properties, contextSvcProps);
            }
        } else if ("unchanged".equals(remaining)) {
            for (Map.Entry entry : BUILT_IN_CONTEXT_PIDS.entrySet()) {
                String[] stringArray;
                String type = (String)entry.getKey();
                if (used.contains(type)) continue;
                used.add(type);
                for (String pid : stringArray = (String[])entry.getValue()) {
                    skip.append(skip.length() == 0 ? "" : ",").append(pid).append(".provider");
                }
            }
        }
        if (skip.length() > 0) {
            contextSvcProps.put("context.unchanged", skip.toString());
        }
        if (!dups.isEmpty()) {
            throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1202.context.lists.overlap", (Object[])new Object[]{dups, jndiName, Arrays.toString(cleared), Arrays.toString(propagated), Arrays.toString(unchanged)}));
        }
        if (transaction == null) {
            transaction = remaining;
        }
        ++var28_36;
        String prefix = "threadContextConfigRef." + n;
        contextSvcProps.put(prefix + ".config.referenceType", "com.ibm.ws.transaction.context");
        contextSvcProps.put(prefix + ".transaction", transaction);
        if (remaining.equals("propagated") || remaining.equals("unchanged") || !propagated3PCtx.isEmpty() || !unchanged3PCtx.isEmpty()) {
            void var28_37;
            ++var28_37;
            prefix = "threadContextConfigRef." + (int)var28_36;
            contextSvcProps.put(prefix + ".config.referenceType", "io.openliberty.thirdparty.context");
            contextSvcProps.put(prefix + ".cleared", new Vector(cleared3PCtx));
            contextSvcProps.put(prefix + ".propagated", new Vector(propagated3PCtx));
            contextSvcProps.put(prefix + ".unchanged", new Vector(unchanged3PCtx));
            contextSvcProps.put(prefix + ".remaining", remaining);
        }
        BundleContext bundleContext = ContextServiceDefinitionProvider.priv.getBundleContext(FrameworkUtil.getBundle(WSManagedExecutorService.class));
        StringBuilder contextServiceFilter = new StringBuilder(200);
        contextServiceFilter.append("(&").append(FilterUtils.createPropertyFilter((String)ID, (String)contextServiceID));
        contextServiceFilter.append("(component.name=com.ibm.ws.context.service)(jndiName=*))");
        AppDefinedResourceFactory appDefinedResourceFactory = new AppDefinedResourceFactory(this, bundleContext, declaringApplication, contextServiceID, jndiName, contextServiceFilter.toString(), null, null, declaringMetadata, declaringClassLoader, qualifierNames);
        try {
            String bundleLocation = bundleContext.getBundle().getLocation();
            ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.configAdminRef.getService();
            Configuration contextServiceConfig = configAdmin.createFactoryConfiguration("com.ibm.ws.context.service", bundleLocation);
            contextServiceConfig.update(contextSvcProps);
            if (qualifierNames != null) {
                String jeeName;
                if (module == null) {
                    jeeName = application;
                } else {
                    ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
                    jeeName = cmd.getJ2EEName().toString();
                }
                ServiceReference ref = bundleContext.getServiceReference(QualifiedResourceFactories.class);
                if (ref == null) {
                    throw new UnsupportedOperationException("The " + jeeName + " application artifact cannot specify the " + qualifierNames + " qualifiers on the " + jndiName + " " + ContextServiceDefinition.class.getSimpleName() + " because the CDI feature is not enabled.");
                }
                QualifiedResourceFactories qrf = (QualifiedResourceFactories)bundleContext.getService(ref);
                qrf.add(jeeName, QualifiedResourceFactory.Type.ContextService, qualifierNames, appDefinedResourceFactory);
            }
        }
        catch (Exception bundleLocation) {
            void x;
            FFDCFilter.processException((Throwable)bundleLocation, (String)"io.openliberty.concurrent.internal.processor.ContextServiceResourceFactoryBuilder", (String)"410", (Object)this, (Object[])new Object[]{props});
            appDefinedResourceFactory.destroy();
            throw x;
        }
        catch (Error x) {
            FFDCFilter.processException((Throwable)x, (String)"io.openliberty.concurrent.internal.processor.ContextServiceResourceFactoryBuilder", (String)"413", (Object)this, (Object[])new Object[]{props});
            appDefinedResourceFactory.destroy();
            throw x;
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createResourceFactory", (Object)appDefinedResourceFactory);
        }
        return appDefinedResourceFactory;
    }

    protected void deactivate(ComponentContext context) {
        this.configAdminRef.deactivate(context);
        this.variableRegistryRef.deactivate(context);
    }

    static final String getContextServiceID(String application, String module, String component, String jndiName) {
        StringBuilder sb = new StringBuilder(jndiName.length() + 80);
        if (application != null && !jndiName.startsWith("java:global")) {
            sb.append("application[").append(application).append("]/");
            if (module != null && !jndiName.startsWith("java:app")) {
                sb.append("module[").append(module).append("]/");
                if (component != null && !jndiName.startsWith("java:module")) {
                    sb.append("component[").append(component).append("]/");
                }
            }
        }
        return sb.append("contextService").append('[').append(jndiName).append(']').toString();
    }

    public final boolean removeExistingConfigurations(String filter) throws Exception {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.configAdminRef.getService();
        Configuration[] existingConfigurations = configAdmin.listConfigurations(filter);
        if (existingConfigurations != null) {
            for (Configuration config : existingConfigurations) {
                Dictionary cfgProps = config.getProperties();
                if (cfgProps != null && FILE.equals(cfgProps.get(CONFIG_SOURCE))) {
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"configuration found in server.xml: ", (Object[])new Object[]{config.getPid()});
                    }
                    return false;
                }
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"removing", (Object[])new Object[]{config.getPid()});
                }
                config.delete();
            }
        }
        return true;
    }

    @Reference(service=ConfigurationAdmin.class)
    protected void setConfigAdmin(ServiceReference<ConfigurationAdmin> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setConfigAdmin", (Object[])new Object[]{ref});
        }
        this.configAdminRef.setReference(ref);
    }

    protected void unsetConfigAdmin(ServiceReference<ConfigurationAdmin> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"unsetConfigAdmin", (Object[])new Object[]{ref});
        }
        this.configAdminRef.unsetReference(ref);
    }

    @Reference(service=VariableRegistry.class)
    protected void setVariableRegistry(ServiceReference<VariableRegistry> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setVariableRegistry", (Object[])new Object[]{ref});
        }
        this.variableRegistryRef.setReference(ref);
    }

    protected void unsetVariableRegistry(ServiceReference<VariableRegistry> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"unsetVariableRegistry", (Object[])new Object[]{ref});
        }
        this.variableRegistryRef.unsetReference(ref);
    }

    @Trivial
    private static final String toString(Map<String, Object> map) {
        boolean first = true;
        StringBuilder b = new StringBuilder(200).append('{');
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    b.append(", ");
                }
                b.append(entry.getKey()).append('=');
                Object val = entry.getValue();
                if (val instanceof String[]) {
                    b.append(Arrays.toString((String[])val));
                    continue;
                }
                b.append(val);
            }
        }
        return b.append('}').toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        BUILT_IN_CONTEXT_PIDS.put("Application", new String[]{"com.ibm.ws.classloader.context", "com.ibm.ws.javaee.metadata.context"});
        BUILT_IN_CONTEXT_PIDS.put("Classification", new String[]{CONTEXT_PID_ZOS_WLM});
        BUILT_IN_CONTEXT_PIDS.put("Security", new String[]{"com.ibm.ws.security.context"});
        BUILT_IN_CONTEXT_PIDS.put("SyncToOSThread", new String[]{"com.ibm.ws.security.thread.zos.context"});
    }
}

