/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.internal.classloader;

import com.ibm.ws.kernel.boot.classloader.ClassLoaderHook;
import com.ibm.ws.kernel.boot.classloader.ClassLoaderHookFactory;
import com.ibm.ws.kernel.boot.classloader.NameBasedClassLoaderLock;
import com.ibm.ws.kernel.boot.utils.KeyBasedLockStore;
import com.ibm.ws.kernel.internal.classloader.DirectoryResourceHandler;
import com.ibm.ws.kernel.internal.classloader.JarResourceHandler;
import com.ibm.ws.kernel.internal.classloader.ResourceEntry;
import com.ibm.ws.kernel.internal.classloader.ResourceHandler;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class JarFileClassLoader
extends SecureClassLoader
implements Closeable {
    private final KeyBasedLockStore<String, NameBasedClassLoaderLock> classNameLockStore = new KeyBasedLockStore(NameBasedClassLoaderLock.LOCK_SUPPLIER);
    private final CopyOnWriteArrayList<URL> urls;
    private final CopyOnWriteArrayList<ResourceHandler> resourceHandlers;
    private final boolean verify;
    private final ClassLoaderHook hook;

    public JarFileClassLoader(URL[] urls, boolean verify, ClassLoader parent) {
        super(parent);
        if (System.getSecurityManager() != null) {
            throw new IllegalStateException("This ClassLoader does not work with SecurityManager");
        }
        this.verify = verify;
        this.hook = ClassLoaderHookFactory.getClassLoaderHook(this);
        if (urls == null) {
            this.urls = new CopyOnWriteArrayList();
            this.resourceHandlers = new CopyOnWriteArrayList();
        } else {
            this.urls = new CopyOnWriteArrayList<URL>(Arrays.asList(urls));
            ArrayList<ResourceHandler> tempResourceHandlers = new ArrayList<ResourceHandler>(urls.length);
            for (URL url : urls) {
                tempResourceHandlers.add(this.createResoureHandler(url, verify));
            }
            this.resourceHandlers = new CopyOnWriteArrayList(tempResourceHandlers);
        }
    }

    @Override
    protected final NameBasedClassLoaderLock getClassLoadingLock(String className) {
        return this.classNameLockStore.getLock(className);
    }

    private ResourceHandler createResoureHandler(URL url, boolean verify) {
        String urlFile = url.getFile();
        try {
            if (urlFile != null && urlFile.endsWith("/")) {
                if ("file".equals(url.getProtocol())) {
                    File file = new File(url.toURI().getPath());
                    return new DirectoryResourceHandler(file);
                }
                throw new IllegalArgumentException("URL is not supported: " + url);
            }
            return new JarResourceHandler(url, verify);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URL: " + url);
        }
    }

    @Override
    public void close() {
        for (ResourceHandler handler : this.resourceHandlers) {
            JarFileClassLoader.close(handler);
        }
        this.resourceHandlers.clear();
    }

    protected void addURL(URL url) {
        this.urls.add(url);
        this.resourceHandlers.add(this.createResoureHandler(url, this.verify));
    }

    public URL[] getURLs() {
        return this.urls.toArray(new URL[0]);
    }

    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        return this.findClass(className, false);
    }

    protected Class<?> findClass(String className, boolean returnNull) throws ClassNotFoundException {
        String resourceName = className.replace('.', '/') + ".class";
        ResourceEntry entry = this.findResourceEntry(resourceName);
        if (entry == null) {
            if (returnNull) {
                return null;
            }
            throw new ClassNotFoundException(className);
        }
        ResourceHandler resourceHandler = entry.getResourceHandler();
        URL jarURL = resourceHandler.toURL();
        byte[] classBytes = null;
        boolean foundInClassCache = false;
        if (this.hook != null) {
            classBytes = this.hook.loadClass(jarURL, className);
            foundInClassCache = classBytes != null;
        }
        Manifest manifest = null;
        try {
            if (!foundInClassCache) {
                classBytes = entry.getBytes();
            }
            manifest = resourceHandler.getManifest();
        }
        catch (IOException e) {
            if (returnNull) {
                return null;
            }
            throw new ClassNotFoundException(className, e);
        }
        int packageEnd = className.lastIndexOf(46);
        if (packageEnd >= 0) {
            String packageName = className.substring(0, packageEnd);
            String packagePath = resourceName.substring(0, packageEnd + 1);
            this.definePackage(packageName, packagePath, jarURL, manifest);
        }
        CodeSource source = new CodeSource(jarURL, entry.getCertificates());
        Class<?> clazz = this.defineClass(className, classBytes, 0, classBytes.length, source);
        if (this.hook != null && !foundInClassCache) {
            this.hook.storeClass(jarURL, clazz);
        }
        return clazz;
    }

    private void definePackage(String packageName, String packagePath, URL jarURL, Manifest manifest) {
        Package pkg = this.getPackage(packageName);
        if (pkg != null) {
            Attributes mainAttributes;
            Attributes packageAttributes;
            if (pkg.isSealed()) {
                if (!pkg.isSealed(jarURL)) {
                    throw new SecurityException("Seal violation: Package " + packageName + " is sealed with another URL.");
                }
            } else if (manifest != null && this.isSealed(packageAttributes = manifest.getAttributes(packagePath), mainAttributes = manifest.getMainAttributes())) {
                throw new SecurityException("Seal violation: Cannot seal already loaded package " + packageName);
            }
        } else {
            String specTitle = null;
            String specVendor = null;
            String specVersion = null;
            String implTitle = null;
            String implVendor = null;
            String implVersion = null;
            URL sealBase = null;
            if (manifest != null) {
                Attributes packageAttributes = manifest.getAttributes(packagePath);
                Attributes mainAttributes = manifest.getMainAttributes();
                specTitle = JarFileClassLoader.getAttribute(Attributes.Name.SPECIFICATION_TITLE, packageAttributes, mainAttributes);
                specVendor = JarFileClassLoader.getAttribute(Attributes.Name.SPECIFICATION_VENDOR, packageAttributes, mainAttributes);
                specVersion = JarFileClassLoader.getAttribute(Attributes.Name.SPECIFICATION_VERSION, packageAttributes, mainAttributes);
                implTitle = JarFileClassLoader.getAttribute(Attributes.Name.IMPLEMENTATION_TITLE, packageAttributes, mainAttributes);
                implVendor = JarFileClassLoader.getAttribute(Attributes.Name.IMPLEMENTATION_VENDOR, packageAttributes, mainAttributes);
                implVersion = JarFileClassLoader.getAttribute(Attributes.Name.IMPLEMENTATION_VERSION, packageAttributes, mainAttributes);
                if (this.isSealed(packageAttributes, mainAttributes)) {
                    sealBase = jarURL;
                }
            }
            try {
                this.definePackage(packageName, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private static String getAttribute(Attributes.Name name, Attributes packageAttributes, Attributes mainAttributes) {
        String value;
        if (packageAttributes != null && (value = packageAttributes.getValue(name)) != null) {
            return value;
        }
        return mainAttributes != null ? mainAttributes.getValue(name) : null;
    }

    private boolean isSealed(Attributes packageAttributes, Attributes mainAttributes) {
        String sealed = JarFileClassLoader.getAttribute(Attributes.Name.SEALED, packageAttributes, mainAttributes);
        return sealed == null ? false : "true".equalsIgnoreCase(sealed);
    }

    @Override
    public URL findResource(String resourceName) {
        ResourceEntry entry = this.findResourceEntry(resourceName);
        return entry == null ? null : entry.toURL();
    }

    @Override
    public Enumeration<URL> findResources(String resourceName) throws IOException {
        return new ResourceEntryEnumeration(this.resourceHandlers, resourceName);
    }

    private ResourceEntry findResourceEntry(String resourceName) {
        for (ResourceHandler handler : this.resourceHandlers) {
            ResourceEntry entry = handler.getEntry(resourceName);
            if (entry == null) continue;
            return entry;
        }
        return null;
    }

    static URL toURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new Error(e);
        }
    }

    static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static byte[] getBytes(InputStream in, long inLength) throws IOException {
        int read;
        int offset = 0;
        int len = (int)inLength;
        byte[] buf = new byte[len];
        while (len > 0 && 0 < (read = in.read(buf, offset, len))) {
            len -= read;
            offset += read;
        }
        return buf;
    }

    static void copy(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] bytes = new byte[1024];
        while (0 <= (read = in.read(bytes))) {
            out.write(bytes, 0, read);
        }
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }

    private static class ResourceEntryEnumeration
    implements Enumeration<URL> {
        private final String resourceName;
        private final Iterator<ResourceHandler> handlerIterator;
        private ResourceEntry entry;

        public ResourceEntryEnumeration(List<ResourceHandler> resourceHandlers, String resourceName) {
            this.resourceName = resourceName;
            this.handlerIterator = resourceHandlers.iterator();
            this.entry = null;
        }

        @Override
        public boolean hasMoreElements() {
            return this.next();
        }

        @Override
        public URL nextElement() {
            if (!this.next()) {
                throw new NoSuchElementException();
            }
            ResourceEntry resourceEntry = this.entry;
            this.entry = null;
            return resourceEntry.toURL();
        }

        private boolean next() {
            if (this.entry == null) {
                while (this.handlerIterator.hasNext()) {
                    ResourceEntry resourceEntry = this.handlerIterator.next().getEntry(this.resourceName);
                    if (resourceEntry == null) continue;
                    this.entry = resourceEntry;
                    return true;
                }
                return false;
            }
            return true;
        }
    }
}

