/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.component.validate;

import jakarta.el.ELContext;
import jakarta.el.ValueExpression;
import jakarta.el.ValueReference;
import jakarta.faces.FacesException;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.visit.VisitCallback;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.component.visit.VisitResult;
import jakarta.faces.context.FacesContext;
import jakarta.faces.validator.ValidatorException;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.groups.Default;
import jakarta.validation.metadata.BeanDescriptor;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.component.validate.CopyBeanInterceptorELResolver;
import org.apache.myfaces.component.validate.ValidateWholeBeanComponent;
import org.apache.myfaces.core.api.shared.ELContextDecorator;
import org.apache.myfaces.core.api.shared.FacesMessageInterpolator;
import org.apache.myfaces.core.api.shared.ValueReferenceResolver;
import org.apache.myfaces.core.api.shared.lang.Assert;
import org.apache.myfaces.util.ExternalSpecifications;
import org.apache.myfaces.util.MessageUtils;
import org.apache.myfaces.util.MyFacesObjectInputStream;
import org.apache.myfaces.util.lang.ClassUtils;
import org.apache.myfaces.util.lang.FastByteArrayOutputStream;

public class WholeBeanValidator
implements jakarta.faces.validator.Validator {
    private static final Logger log = Logger.getLogger(WholeBeanValidator.class.getName());
    private static final Class<?>[] DEFAULT_VALIDATION_GROUPS_ARRAY = new Class[]{Default.class};
    private static final String CANDIDATE_COMPONENT_VALUES_MAP = "oam.WBV.candidatesMap";
    private static final String BEAN_VALIDATION_FAILED = "oam.WBV.validationFailed";
    private Class<?>[] validationGroupsArray;

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        Assert.notNull(context, "context");
        Assert.notNull(component, "component");
        ValueExpression valueExpression = component.getValueExpression("value");
        if (valueExpression == null) {
            log.warning("cannot validate component with empty value: " + component.getClientId(context));
            return;
        }
        Object base = valueExpression.getValue(context.getELContext());
        Class<?> valueBaseClass = base.getClass();
        if (valueBaseClass == null) {
            return;
        }
        ValidatorFactory validatorFactory = this.createValidatorFactory(context);
        Validator validator = this.createValidator(validatorFactory, context, (ValidateWholeBeanComponent)component);
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(valueBaseClass);
        if (!beanDescriptor.isBeanConstrained()) {
            return;
        }
        Class[] validationGroupsArray = this.validationGroupsArray;
        Boolean beanValidationFailed = (Boolean)context.getViewRoot().getTransientStateHelper().getTransient((Object)BEAN_VALIDATION_FAILED);
        if (Boolean.TRUE.equals(beanValidationFailed)) {
            return;
        }
        Map candidatesMap = (Map)context.getViewRoot().getTransientStateHelper().getTransient((Object)CANDIDATE_COMPONENT_VALUES_MAP);
        if (candidatesMap != null) {
            Object copy = this.createBeanCopy(base);
            UpdateBeanCopyCallback callback = new UpdateBeanCopyCallback(this, base, copy, candidatesMap);
            context.getViewRoot().visitTree(VisitContext.createVisitContext((FacesContext)context, candidatesMap.keySet(), null), (VisitCallback)callback);
            Set constraintViolations = validator.validate(copy, validationGroupsArray);
            if (!constraintViolations.isEmpty()) {
                LinkedHashSet<FacesMessage> messages = new LinkedHashSet<FacesMessage>(constraintViolations.size());
                for (ConstraintViolation constraintViolation : constraintViolations) {
                    String message = constraintViolation.getMessage();
                    Object[] args = new Object[]{message, MessageUtils.getLabel(context, component)};
                    FacesMessage msg = MessageUtils.getMessage(FacesMessage.SEVERITY_ERROR, "jakarta.faces.validator.BeanValidator.MESSAGE", args, context);
                    messages.add(msg);
                }
                throw new ValidatorException(messages);
            }
        }
    }

    private Object createBeanCopy(Object base) {
        Object copy = null;
        try {
            copy = base.getClass().newInstance();
        }
        catch (Exception ex) {
            log.log(Level.FINEST, null, ex);
        }
        if (base instanceof Serializable) {
            copy = this.copySerializableObject(base);
        } else if (base instanceof Cloneable) {
            try {
                Method cloneMethod = base.getClass().getMethod("clone", new Class[0]);
                copy = cloneMethod.invoke(base, new Object[0]);
            }
            catch (Exception ex) {
                log.log(Level.FINEST, null, ex);
            }
        } else {
            Class<?> clazz = base.getClass();
            try {
                Constructor<?> copyConstructor = clazz.getConstructor(clazz);
                if (copyConstructor != null) {
                    copy = copyConstructor.newInstance(base);
                }
            }
            catch (Exception ex) {
                log.log(Level.FINEST, null, ex);
            }
        }
        if (copy == null) {
            throw new FacesException("Cannot create copy for wholeBeanValidator: " + base.getClass().getName());
        }
        return copy;
    }

    private Object copySerializableObject(Object base) {
        try {
            FastByteArrayOutputStream baos = new FastByteArrayOutputStream(256);
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(base);
                oos.flush();
            }
            MyFacesObjectInputStream ois = new MyFacesObjectInputStream(baos.getInputStream());
            try {
                return ois.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private Validator createValidator(ValidatorFactory validatorFactory, FacesContext context, ValidateWholeBeanComponent component) {
        if (this.validationGroupsArray == null) {
            this.postSetValidationGroups(component);
        }
        return validatorFactory.usingContext().messageInterpolator((MessageInterpolator)new FacesMessageInterpolator(validatorFactory.getMessageInterpolator(), context)).getValidator();
    }

    private ValidatorFactory createValidatorFactory(FacesContext context) {
        Map applicationMap = context.getExternalContext().getApplicationMap();
        Object attr = applicationMap.get("jakarta.faces.validator.beanValidator.ValidatorFactory");
        if (attr instanceof ValidatorFactory) {
            return (ValidatorFactory)attr;
        }
        WholeBeanValidator wholeBeanValidator = this;
        synchronized (wholeBeanValidator) {
            if (ExternalSpecifications.isBeanValidationAvailable()) {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                applicationMap.put("jakarta.faces.validator.beanValidator.ValidatorFactory", factory);
                return factory;
            }
            throw new FacesException("Bean Validation is not present");
        }
    }

    private void postSetValidationGroups(ValidateWholeBeanComponent component) {
        String validationGroups = this.getValidationGroups(component);
        if (validationGroups == null || validationGroups.matches("^[\\W,]*$")) {
            this.validationGroupsArray = DEFAULT_VALIDATION_GROUPS_ARRAY;
        } else {
            String[] classes = validationGroups.split(",");
            ArrayList validationGroupsList = new ArrayList(classes.length);
            for (String clazz : classes) {
                if ((clazz = clazz.trim()).isEmpty()) continue;
                try {
                    Class theClass = ClassUtils.classForName(clazz);
                    validationGroupsList.add(theClass);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Could not load validation group", e);
                }
            }
            this.validationGroupsArray = validationGroupsList.toArray(new Class[validationGroupsList.size()]);
        }
    }

    public String getValidationGroups(ValidateWholeBeanComponent component) {
        return component.getValidationGroups();
    }

    public void setValidationGroups(ValidateWholeBeanComponent component, String validationGroups) {
        component.setValidationGroups(validationGroups);
    }

    private static class UpdateBeanCopyCallback
    implements VisitCallback {
        private WholeBeanValidator validator;
        private Object wholeBeanBase;
        private Object wholeBeanBaseCopy;
        private Map<String, Object> candidateValuesMap;

        public UpdateBeanCopyCallback(WholeBeanValidator validator, Object wholeBeanBase, Object wholeBeanBaseCopy, Map<String, Object> candidateValuesMap) {
            this.validator = validator;
            this.wholeBeanBase = wholeBeanBase;
            this.wholeBeanBaseCopy = wholeBeanBaseCopy;
            this.candidateValuesMap = candidateValuesMap;
        }

        public VisitResult visit(VisitContext context, UIComponent target) {
            ValueExpression valueExpression = target.getValueExpression("value");
            if (valueExpression == null) {
                log.warning("cannot validate component with empty value: " + target.getClientId(context.getFacesContext()));
                return VisitResult.ACCEPT;
            }
            ValueReference reference = ValueReferenceResolver.resolve(valueExpression, context.getFacesContext());
            if (reference == null) {
                return VisitResult.ACCEPT;
            }
            Object base = reference.getBase();
            if (base == null) {
                return VisitResult.ACCEPT;
            }
            Object referenceProperty = reference.getProperty();
            if (!(referenceProperty instanceof String)) {
                return VisitResult.ACCEPT;
            }
            if (base == this.wholeBeanBase || base.equals(this.wholeBeanBase)) {
                ELContextDecorator elCtxDecorator = new ELContextDecorator(context.getFacesContext().getELContext(), new CopyBeanInterceptorELResolver(context.getFacesContext().getApplication().getELResolver(), this.wholeBeanBase, this.wholeBeanBaseCopy));
                valueExpression.setValue((ELContext)elCtxDecorator, this.candidateValuesMap.get(target.getClientId(context.getFacesContext())));
            }
            return VisitResult.ACCEPT;
        }
    }
}

