/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.context.servlet;

import jakarta.faces.FacesException;
import jakarta.faces.FactoryFinder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.Flash;
import jakarta.faces.context.FlashFactory;
import jakarta.faces.context.PartialResponseWriter;
import jakarta.faces.context.PartialViewContext;
import jakarta.faces.lifecycle.ClientWindow;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.PushBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.myfaces.config.webparameters.MyfacesConfig;
import org.apache.myfaces.context.flash.FlashImpl;
import org.apache.myfaces.context.servlet.CookieMap;
import org.apache.myfaces.context.servlet.RequestHeaderMap;
import org.apache.myfaces.context.servlet.RequestHeaderValuesMap;
import org.apache.myfaces.context.servlet.RequestMap;
import org.apache.myfaces.context.servlet.RequestParameterMap;
import org.apache.myfaces.context.servlet.RequestParameterValuesMap;
import org.apache.myfaces.context.servlet.ServletExternalContextImplBase;
import org.apache.myfaces.context.servlet.SessionMap;
import org.apache.myfaces.core.api.shared.lang.Assert;
import org.apache.myfaces.core.api.shared.lang.SharedStringBuilder;
import org.apache.myfaces.util.lang.EnumerationIterator;
import org.apache.myfaces.util.lang.StringUtils;

public final class ServletExternalContextImpl
extends ServletExternalContextImplBase {
    private static final Logger log = Logger.getLogger(ServletExternalContextImpl.class.getName());
    private static final String URL_PARAM_SEPERATOR = "&";
    private static final char URL_QUERY_SEPERATOR = '?';
    private static final char URL_FRAGMENT_SEPERATOR = '#';
    private static final String URL_NAME_VALUE_PAIR_SEPERATOR = "=";
    private static final String PUSHED_RESOURCE_URLS = "oam.PUSHED_RESOURCE_URLS";
    private static final String PUSH_SUPPORTED = "oam.PUSH_SUPPORTED";
    private static final String SB_ENCODE_URL = ServletExternalContextImpl.class.getName() + "#encodeURL";
    private ServletRequest _servletRequest;
    private ServletResponse _servletResponse;
    private Map<String, Object> _sessionMap;
    private Map<String, Object> _requestMap;
    private Map<String, String> _requestParameterMap;
    private Map<String, String[]> _requestParameterValuesMap;
    private Map<String, String> _requestHeaderMap;
    private Map<String, String[]> _requestHeaderValuesMap;
    private Map<String, Object> _requestCookieMap;
    private HttpServletRequest _httpServletRequest;
    private HttpServletResponse _httpServletResponse;
    private String _requestServletPath;
    private String _requestPathInfo;
    private FlashFactory _flashFactory;
    private Flash _flash;
    private FacesContext _currentFacesContext;

    public ServletExternalContextImpl(ServletContext servletContext, ServletRequest servletRequest, ServletResponse servletResponse) {
        super(servletContext);
        this._servletRequest = servletRequest;
        this._servletResponse = servletResponse;
        this._sessionMap = null;
        this._requestMap = null;
        this._requestParameterMap = null;
        this._requestParameterValuesMap = null;
        this._requestHeaderMap = null;
        this._requestHeaderValuesMap = null;
        this._requestCookieMap = null;
        this._httpServletRequest = this.isHttpServletRequest(servletRequest) ? (HttpServletRequest)servletRequest : null;
        HttpServletResponse httpServletResponse = this._httpServletResponse = this.isHttpServletResponse(servletResponse) ? (HttpServletResponse)servletResponse : null;
        if (this._httpServletRequest != null) {
            this._requestServletPath = this._httpServletRequest.getServletPath();
            this._requestPathInfo = this._httpServletRequest.getPathInfo();
        }
    }

    public ServletExternalContextImpl(ServletContext servletContext, ServletRequest servletRequest, ServletResponse servletResponse, FlashFactory flashFactory) {
        this(servletContext, servletRequest, servletResponse);
        this._flashFactory = flashFactory;
    }

    @Override
    public void release() {
        super.release();
        this._currentFacesContext = null;
        this._servletRequest = null;
        this._servletResponse = null;
        this._sessionMap = null;
        this._requestMap = null;
        this._requestParameterMap = null;
        this._requestParameterValuesMap = null;
        this._requestHeaderMap = null;
        this._requestHeaderValuesMap = null;
        this._requestCookieMap = null;
        this._httpServletRequest = null;
        this._httpServletResponse = null;
    }

    public Object getSession(boolean create) {
        this.checkHttpServletRequest();
        return ((HttpServletRequest)this._servletRequest).getSession(create);
    }

    public String getSessionId(boolean create) {
        this.checkHttpServletRequest();
        HttpSession session = ((HttpServletRequest)this._servletRequest).getSession(create);
        if (session != null) {
            return session.getId();
        }
        return "";
    }

    public Object getRequest() {
        return this._servletRequest;
    }

    public int getRequestContentLength() {
        return this._servletRequest.getContentLength();
    }

    public Object getResponse() {
        return this._servletResponse;
    }

    public int getResponseBufferSize() {
        return this._servletResponse.getBufferSize();
    }

    public String getResponseContentType() {
        return this._servletResponse.getContentType();
    }

    public OutputStream getResponseOutputStream() throws IOException {
        return this._servletResponse.getOutputStream();
    }

    public Writer getResponseOutputWriter() throws IOException {
        return this._servletResponse.getWriter();
    }

    public Map<String, Object> getSessionMap() {
        if (this._sessionMap == null) {
            this.checkHttpServletRequest();
            this._sessionMap = new SessionMap(this._httpServletRequest);
        }
        return this._sessionMap;
    }

    public Map<String, Object> getRequestMap() {
        if (this._requestMap == null) {
            this._requestMap = new RequestMap(this._servletRequest);
        }
        return this._requestMap;
    }

    public Map<String, String> getRequestParameterMap() {
        if (this._requestParameterMap == null) {
            this._requestParameterMap = new RequestParameterMap(this._servletRequest);
        }
        return this._requestParameterMap;
    }

    public Map<String, String[]> getRequestParameterValuesMap() {
        if (this._requestParameterValuesMap == null) {
            this._requestParameterValuesMap = new RequestParameterValuesMap(this._servletRequest);
        }
        return this._requestParameterValuesMap;
    }

    public int getRequestServerPort() {
        return this._servletRequest.getServerPort();
    }

    public Iterator<String> getRequestParameterNames() {
        return new EnumerationIterator<String>(this._servletRequest.getParameterNames());
    }

    public Map<String, String> getRequestHeaderMap() {
        if (this._requestHeaderMap == null) {
            this.checkHttpServletRequest();
            this._requestHeaderMap = new RequestHeaderMap(this._httpServletRequest);
        }
        return this._requestHeaderMap;
    }

    public Map<String, String[]> getRequestHeaderValuesMap() {
        if (this._requestHeaderValuesMap == null) {
            this.checkHttpServletRequest();
            this._requestHeaderValuesMap = new RequestHeaderValuesMap(this._httpServletRequest);
        }
        return this._requestHeaderValuesMap;
    }

    public Map<String, Object> getRequestCookieMap() {
        if (this._requestCookieMap == null) {
            this.checkHttpServletRequest();
            this._requestCookieMap = new CookieMap(this._httpServletRequest);
        }
        return this._requestCookieMap;
    }

    public Locale getRequestLocale() {
        return this._servletRequest.getLocale();
    }

    public String getRequestPathInfo() {
        this.checkHttpServletRequest();
        return this._requestPathInfo;
    }

    public String getRequestContentType() {
        return this._servletRequest.getContentType();
    }

    public String getRequestContextPath() {
        this.checkHttpServletRequest();
        return this._httpServletRequest.getContextPath();
    }

    public String getRequestScheme() {
        return this._servletRequest.getScheme();
    }

    public String encodeActionURL(String url) {
        Assert.notNull(url, "url");
        this.checkHttpServletRequest();
        String encodedUrl = ((HttpServletResponse)this._servletResponse).encodeURL(url);
        encodedUrl = this.encodeURL(encodedUrl, null);
        return encodedUrl;
    }

    public String encodeBookmarkableURL(String baseUrl, Map<String, List<String>> parameters) {
        return this.encodeURL(baseUrl, parameters);
    }

    public String encodeResourceURL(String url) {
        Assert.notNull(url, "url");
        this.checkHttpServletRequest();
        String encodedUrl = ((HttpServletResponse)this._servletResponse).encodeURL(url);
        this.pushResource(encodedUrl);
        return encodedUrl;
    }

    protected void pushResource(String resourceUrl) {
        boolean pushSupported;
        HttpServletRequest servletRequest;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map attributes = facesContext.getAttributes();
        PushBuilder pushBuilder = null;
        if (!attributes.containsKey(PUSH_SUPPORTED)) {
            Object request = this.getRequest();
            boolean pushSupported2 = false;
            if (request instanceof HttpServletRequest) {
                servletRequest = (HttpServletRequest)request;
                pushBuilder = servletRequest.newPushBuilder();
                pushSupported2 = pushBuilder != null;
            }
            attributes.put(PUSH_SUPPORTED, pushSupported2);
        }
        if (!(pushSupported = ((Boolean)attributes.get(PUSH_SUPPORTED)).booleanValue())) {
            return;
        }
        Set pushedResourceUrls = (Set)facesContext.getAttributes().computeIfAbsent(PUSHED_RESOURCE_URLS, a -> new HashSet());
        if (pushedResourceUrls.contains(resourceUrl)) {
            return;
        }
        if (pushBuilder == null) {
            servletRequest = (HttpServletRequest)this.getRequest();
            pushBuilder = servletRequest.newPushBuilder();
        }
        if (pushBuilder != null) {
            pushBuilder.path(resourceUrl).push();
        }
    }

    public String encodeNamespace(String s) {
        return s;
    }

    public String encodePartialActionURL(String url) {
        Assert.notNull(url, "url");
        this.checkHttpServletRequest();
        return this.encodeURL(((HttpServletResponse)this._servletResponse).encodeURL(url), null);
    }

    public String encodeRedirectURL(String baseUrl, Map<String, List<String>> parameters) {
        return this._httpServletResponse.encodeRedirectURL(this.encodeURL(baseUrl, parameters));
    }

    public String encodeWebsocketURL(String url) {
        Assert.notNull(url, "url");
        FacesContext facesContext = this.getCurrentFacesContext();
        Integer port = MyfacesConfig.getCurrentInstance((FacesContext)facesContext).getWebsocketEndpointPort();
        Integer n = port = port == null || port == 0 ? null : port;
        if (port != null && !port.equals(facesContext.getExternalContext().getRequestServerPort())) {
            String scheme = facesContext.getExternalContext().getRequestScheme();
            String serverName = facesContext.getExternalContext().getRequestServerName();
            try {
                String webSocketUrl = new URL(scheme, serverName, port, url).toExternalForm();
                webSocketUrl = webSocketUrl.replaceFirst("http", "ws");
                return ((HttpServletResponse)this._servletResponse).encodeURL(webSocketUrl);
            }
            catch (MalformedURLException ex) {
                return url;
            }
        }
        return url;
    }

    public void dispatch(String requestURI) throws IOException, FacesException {
        RequestDispatcher requestDispatcher = this._servletRequest.getRequestDispatcher(requestURI);
        if (requestDispatcher == null) {
            ((HttpServletResponse)this._servletResponse).sendError(404);
            return;
        }
        try {
            requestDispatcher.forward(this._servletRequest, this._servletResponse);
        }
        catch (ServletException e) {
            if (e.getMessage() != null) {
                throw new FacesException(e.getMessage(), (Throwable)e);
            }
            throw new FacesException((Throwable)e);
        }
    }

    public String getRequestServerName() {
        return this._servletRequest.getServerName();
    }

    public String getRequestServletPath() {
        this.checkHttpServletRequest();
        return this._requestServletPath;
    }

    public String getAuthType() {
        this.checkHttpServletRequest();
        return this._httpServletRequest.getAuthType();
    }

    public String getRemoteUser() {
        this.checkHttpServletRequest();
        return this._httpServletRequest.getRemoteUser();
    }

    public boolean isUserInRole(String role) {
        Assert.notNull(role, "role");
        this.checkHttpServletRequest();
        return this._httpServletRequest.isUserInRole(role);
    }

    public Principal getUserPrincipal() {
        this.checkHttpServletRequest();
        return this._httpServletRequest.getUserPrincipal();
    }

    public void invalidateSession() {
        HttpSession session = (HttpSession)this.getSession(false);
        if (session != null) {
            session.invalidate();
        }
    }

    public boolean isResponseCommitted() {
        return this._httpServletResponse.isCommitted();
    }

    public void redirect(String url) throws IOException {
        FacesContext facesContext = this.getCurrentFacesContext();
        PartialViewContext partialViewContext = facesContext.getPartialViewContext();
        if (partialViewContext.isPartialRequest()) {
            if (this._servletResponse instanceof HttpServletResponse && facesContext.getResponseComplete()) {
                throw new IllegalStateException();
            }
            PartialResponseWriter writer = partialViewContext.getPartialResponseWriter();
            this.setResponseContentType("text/xml");
            this.setResponseCharacterEncoding("UTF-8");
            this.addResponseHeader("Cache-control", "no-cache");
            writer.startDocument();
            writer.redirect(url);
            writer.endDocument();
            facesContext.responseComplete();
        } else if (this._servletResponse instanceof HttpServletResponse) {
            ((HttpServletResponse)this._servletResponse).sendRedirect(url);
            facesContext.responseComplete();
        } else {
            throw new IllegalArgumentException("Only HttpServletResponse supported");
        }
    }

    public void responseFlushBuffer() throws IOException {
        this.checkHttpServletResponse();
        this._httpServletResponse.flushBuffer();
    }

    public void responseReset() {
        this.checkHttpServletResponse();
        this._httpServletResponse.reset();
    }

    public void responseSendError(int statusCode, String message) throws IOException {
        this.checkHttpServletResponse();
        if (message == null) {
            this._httpServletResponse.sendError(statusCode);
        } else {
            this._httpServletResponse.sendError(statusCode, message);
        }
    }

    public Iterator<Locale> getRequestLocales() {
        this.checkHttpServletRequest();
        return new EnumerationIterator<Locale>(this._httpServletRequest.getLocales());
    }

    public void setRequest(Object request) {
        this._servletRequest = (ServletRequest)request;
        this._httpServletRequest = this.isHttpServletRequest(this._servletRequest) ? (HttpServletRequest)this._servletRequest : null;
        this._httpServletRequest = this.isHttpServletRequest(this._servletRequest) ? (HttpServletRequest)this._servletRequest : null;
        this._requestHeaderMap = null;
        this._requestHeaderValuesMap = null;
        this._requestMap = null;
        this._requestParameterMap = null;
        this._requestParameterValuesMap = null;
        this._requestCookieMap = null;
        this._sessionMap = null;
    }

    public void setRequestCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        this._servletRequest.setCharacterEncoding(encoding);
    }

    public String getRequestCharacterEncoding() {
        return this._servletRequest.getCharacterEncoding();
    }

    public String getResponseCharacterEncoding() {
        return this._servletResponse.getCharacterEncoding();
    }

    public void setResponse(Object response) {
        this._servletResponse = (ServletResponse)response;
    }

    public void setResponseBufferSize(int size) {
        this.checkHttpServletResponse();
        this._httpServletResponse.setBufferSize(size);
    }

    public void setResponseCharacterEncoding(String encoding) {
        this._servletResponse.setCharacterEncoding(encoding);
    }

    public void setResponseContentLength(int length) {
        this.checkHttpServletResponse();
        this._httpServletResponse.setContentLength(length);
    }

    public void setResponseContentType(String contentType) {
        if (!this._servletResponse.isCommitted()) {
            this._servletResponse.setContentType(contentType);
        } else {
            log.severe("Cannot set content type. Response already committed");
        }
    }

    public void setResponseHeader(String name, String value) {
        this.checkHttpServletResponse();
        this._httpServletResponse.setHeader(name, value);
    }

    public void setResponseStatus(int statusCode) {
        this.checkHttpServletResponse();
        this._httpServletResponse.setStatus(statusCode);
    }

    private void checkHttpServletRequest() {
        if (this._httpServletRequest == null) {
            throw new UnsupportedOperationException("Only HttpServletRequest supported");
        }
    }

    private boolean isHttpServletRequest(ServletRequest servletRequest) {
        return servletRequest instanceof HttpServletRequest;
    }

    private void checkHttpServletResponse() {
        if (this._httpServletRequest == null) {
            throw new UnsupportedOperationException("Only HttpServletResponse supported");
        }
    }

    private boolean isHttpServletResponse(ServletResponse servletResponse) {
        return servletResponse instanceof HttpServletResponse;
    }

    public void addResponseCookie(String name, String value, Map<String, Object> properties) {
        this.checkHttpServletResponse();
        Cookie cookie = new Cookie(name, value);
        if (properties != null) {
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                String propertyKey = entry.getKey();
                Object propertyValue = entry.getValue();
                if ("comment".equals(propertyKey)) {
                    cookie.setComment((String)propertyValue);
                    continue;
                }
                if ("domain".equals(propertyKey)) {
                    cookie.setDomain((String)propertyValue);
                    continue;
                }
                if ("maxAge".equals(propertyKey)) {
                    cookie.setMaxAge(((Integer)propertyValue).intValue());
                    continue;
                }
                if ("secure".equals(propertyKey)) {
                    cookie.setSecure(((Boolean)propertyValue).booleanValue());
                    continue;
                }
                if ("path".equals(propertyKey)) {
                    cookie.setPath((String)propertyValue);
                    continue;
                }
                if ("httpOnly".equals(propertyKey)) {
                    cookie.setHttpOnly(((Boolean)propertyValue).booleanValue());
                    continue;
                }
                cookie.setAttribute(propertyKey, propertyValue == null ? null : propertyValue.toString());
            }
        }
        this._httpServletResponse.addCookie(cookie);
    }

    public void addResponseHeader(String name, String value) {
        this._httpServletResponse.addHeader(name, value);
    }

    /*
     * WARNING - void declaration
     */
    private String encodeURL(String baseUrl, Map<String, List<String>> parameters) {
        boolean hasParams;
        FacesContext facesContext;
        ClientWindow window;
        Assert.notNull(baseUrl, "url");
        this.checkHttpServletRequest();
        String fragment = null;
        String queryString = null;
        HashMap<String, List<String>> paramMap = null;
        int index = baseUrl.indexOf(35);
        if (index != -1) {
            fragment = baseUrl.substring(index + 1);
            baseUrl = baseUrl.substring(0, index);
        }
        if ((index = baseUrl.indexOf(63)) != -1) {
            queryString = baseUrl.substring(index + 1);
            baseUrl = baseUrl.substring(0, index);
            String[] nameValuePairs = queryString.split(URL_PARAM_SEPERATOR);
            for (int i = 0; i < nameValuePairs.length; ++i) {
                List list;
                String[] currentPair = nameValuePairs[i].split(URL_NAME_VALUE_PAIR_SEPERATOR);
                String currentName = currentPair[0];
                if (paramMap == null) {
                    paramMap = new HashMap(5, 1.0f);
                }
                if ((list = (List)paramMap.get(currentName)) == null) {
                    ArrayList arrayList = new ArrayList(1);
                    paramMap.put(currentName, arrayList);
                }
                try {
                    void var11_14;
                    var11_14.add(currentPair.length > 1 ? URLDecoder.decode(currentPair[1], this.getResponseCharacterEncoding()) : "");
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new UnsupportedOperationException("Encoding type=" + this.getResponseCharacterEncoding() + " not supported", e);
                }
            }
        }
        if (parameters != null && !parameters.isEmpty()) {
            for (Map.Entry<String, List<String>> pair : parameters.entrySet()) {
                String key = pair.getKey();
                if (!StringUtils.isNotBlank(key)) continue;
                if (paramMap == null) {
                    paramMap = new HashMap(5, 1.0f);
                }
                paramMap.put(key, pair.getValue());
            }
        }
        if ((window = (facesContext = this.getCurrentFacesContext()).getExternalContext().getClientWindow()) != null && window.isClientWindowRenderModeEnabled(facesContext)) {
            Map additionalQueryURLParameters;
            if (paramMap == null) {
                paramMap = new HashMap<String, List<String>>(5, 1.0f);
            }
            if (!paramMap.containsKey("jfwid")) {
                paramMap.put("jfwid", Arrays.asList(window.getId()));
            }
            if ((additionalQueryURLParameters = window.getQueryURLParameters(facesContext)) != null) {
                for (Map.Entry entry : additionalQueryURLParameters.entrySet()) {
                    paramMap.put((String)entry.getKey(), Arrays.asList((String)entry.getValue()));
                }
            }
        }
        boolean bl = hasParams = paramMap != null && !paramMap.isEmpty();
        if (!hasParams && fragment == null) {
            return baseUrl;
        }
        StringBuilder newUrl = SharedStringBuilder.get(facesContext, SB_ENCODE_URL, baseUrl.length() + 10);
        newUrl.append(baseUrl);
        if (hasParams) {
            boolean bl2 = true;
            for (Map.Entry pair : paramMap.entrySet()) {
                for (int i = 0; i < ((List)pair.getValue()).size(); ++i) {
                    boolean bl3;
                    String value = (String)((List)pair.getValue()).get(i);
                    if (!bl3) {
                        newUrl.append(URL_PARAM_SEPERATOR);
                    } else {
                        newUrl.append('?');
                        bl3 = false;
                    }
                    newUrl.append((String)pair.getKey());
                    newUrl.append(URL_NAME_VALUE_PAIR_SEPERATOR);
                    if (value == null) continue;
                    try {
                        newUrl.append(URLEncoder.encode(value, this.getResponseCharacterEncoding()));
                        continue;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new UnsupportedOperationException("Encoding type=" + this.getResponseCharacterEncoding() + " not supported", e);
                    }
                }
            }
        }
        if (fragment != null) {
            newUrl.append('#');
            newUrl.append(fragment);
        }
        return newUrl.toString();
    }

    public Flash getFlash() {
        if (this._flash == null) {
            if (this._flashFactory == null) {
                this._flashFactory = (FlashFactory)FactoryFinder.getFactory((String)"jakarta.faces.context.FlashFactory");
                this._flash = this._flashFactory == null ? FlashImpl.getCurrentInstance(this) : this._flashFactory.getFlash(true);
            } else {
                this._flash = this._flashFactory.getFlash(true);
            }
        }
        return this._flash;
    }

    public boolean isSecure() {
        return this._servletRequest.isSecure();
    }

    public int getSessionMaxInactiveInterval() {
        HttpSession session = this._httpServletRequest.getSession();
        return session.getMaxInactiveInterval();
    }

    public void setSessionMaxInactiveInterval(int interval) {
        HttpSession session = this._httpServletRequest.getSession();
        session.setMaxInactiveInterval(interval);
    }

    protected FacesContext getCurrentFacesContext() {
        if (this._currentFacesContext == null) {
            this._currentFacesContext = FacesContext.getCurrentInstance();
        }
        return this._currentFacesContext;
    }
}

