/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.push.cdi;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.faces.context.FacesContext;
import org.apache.myfaces.config.webparameters.MyfacesConfig;
import org.apache.myfaces.util.token.CsrfSessionTokenFactory;
import org.apache.myfaces.util.token.CsrfSessionTokenFactoryRandom;
import org.apache.myfaces.util.token.CsrfSessionTokenFactorySecureRandom;

@ApplicationScoped
public class WebsocketChannelTokenBuilder {
    private CsrfSessionTokenFactory csrfSessionTokenFactory;
    private boolean initialized;

    @PostConstruct
    public void init() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null) {
            this.internalInit(facesContext);
        }
    }

    private synchronized void internalInit(FacesContext facesContext) {
        String csrfRandomMode = MyfacesConfig.getCurrentInstance((FacesContext)facesContext).getRandomKeyInViewStateSessionToken();
        this.csrfSessionTokenFactory = "random".equals(csrfRandomMode) ? new CsrfSessionTokenFactoryRandom(facesContext) : new CsrfSessionTokenFactorySecureRandom(facesContext);
        this.initialized = true;
    }

    public String createChannelToken(FacesContext facesContext, String channel) {
        if (!this.initialized) {
            this.internalInit(facesContext);
        }
        return this.csrfSessionTokenFactory.createToken(facesContext);
    }
}

