/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.impl;

import jakarta.faces.FactoryFinder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.component.UniqueIdVendor;
import jakarta.faces.component.visit.VisitContextFactory;
import jakarta.faces.context.FacesContext;
import jakarta.faces.view.AttachedObjectHandler;
import jakarta.faces.view.EditableValueHolderAttachedObjectHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.config.webparameters.MyfacesConfig;
import org.apache.myfaces.util.lang.Lazy;
import org.apache.myfaces.view.facelets.ELExpressionCacheMode;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.FaceletFactory;
import org.apache.myfaces.view.facelets.FaceletViewDeclarationLanguage;
import org.apache.myfaces.view.facelets.impl.SectionUniqueIdCounter;

public class FaceletCompositionContextImpl
extends FaceletCompositionContext {
    public static final String JAKARTA_FACES_LOCATION_PREFIX = "jakarta_faces_location_";
    private static final String VISIT_CONTEXT_FACTORY = "oam.vf.VisitContextFactory";
    private FacesContext _facesContext;
    private FaceletFactory _factory;
    private LinkedList<UIComponent> _compositeComponentStack;
    private LinkedList<UniqueIdVendor> _uniqueIdVendorStack;
    private LinkedList<Map.Entry<String, EditableValueHolderAttachedObjectHandler>> _enclosingValidatorIdsStack;
    private Boolean _isRefreshingTransientBuild;
    private Boolean _isMarkInitialState;
    private Boolean _isBuildingViewMetadata;
    private Boolean _refreshTransientBuildOnPSS;
    private Boolean _usingPSSOnThisView;
    private List<Map<String, UIComponent>> _componentsMarkedForDeletion;
    private Map<String, UIComponent> _relocatableResourceForDeletion;
    private int _deletionLevel;
    private Map<UIComponent, List<AttachedObjectHandler>> _attachedObjectHandlers;
    private Map<UIComponent, Map<String, Object>> _methodExpressionsTargeted;
    private Map<UIComponent, Map<String, Boolean>> _compositeComponentAttributesMarked;
    private static final String VIEWROOT_FACELET_ID = "oam.VIEW_ROOT";
    private Lazy<SectionUniqueIdCounter> _sectionUniqueIdCounter;
    private Lazy<SectionUniqueIdCounter> _sectionUniqueComponentIdCounter;
    private List<String> _uniqueIdsList;
    private Iterator<String> _uniqueIdsIterator;
    private int _level;
    private int _isInMetadataSection;
    private Lazy<SectionUniqueIdCounter> _sectionUniqueMetadataIdCounter;
    private Lazy<SectionUniqueIdCounter> _sectionUniqueNormalIdCounter;
    private Lazy<SectionUniqueIdCounter> _sectionUniqueComponentMetadataIdCounter;
    private Lazy<SectionUniqueIdCounter> _sectionUniqueComponentNormalIdCounter;
    private List<SectionUniqueIdCounter> _sectionUniqueIdCounterStack;
    private List<SectionUniqueIdCounter> _sectionUniqueComponentIdCounterStack;
    private StringBuilder _sharedStringBuilder;
    private int _ccLevel;
    private boolean _dynamicComponentHandler;
    private boolean _oldRefreshingTransientBuild;
    private boolean _dynamicComponentTopLevel;
    private int _dynamicComponentSection = 0;
    private List<Integer> _dynamicOldDeletionLevel;
    private VisitContextFactory _visitContextFactory = null;
    private UIViewRoot _viewRoot = null;
    private MyfacesConfig myfacesConfig;

    public FaceletCompositionContextImpl(FaceletFactory factory, FacesContext facesContext) {
        String[] componentIdsCache;
        this._factory = factory;
        this._facesContext = facesContext;
        this._componentsMarkedForDeletion = new ArrayList<Map<String, UIComponent>>();
        this._relocatableResourceForDeletion = new HashMap<String, UIComponent>();
        this._deletionLevel = -1;
        this._sectionUniqueIdCounter = new Lazy<Object>(() -> new SectionUniqueIdCounter());
        this.myfacesConfig = MyfacesConfig.getCurrentInstance((FacesContext)facesContext);
        this._sectionUniqueComponentIdCounter = this.myfacesConfig.getComponentUniqueIdsCacheSize() > 0 ? ((componentIdsCache = (String[])facesContext.getExternalContext().getApplicationMap().get("oam.CACHED_COMPONENT_IDS")) != null ? new Lazy<Object>(() -> new SectionUniqueIdCounter("_", componentIdsCache)) : new Lazy<Object>(() -> new SectionUniqueIdCounter("_"))) : new Lazy<Object>(() -> new SectionUniqueIdCounter("_"));
        this._sectionUniqueNormalIdCounter = this._sectionUniqueIdCounter;
        this._sectionUniqueComponentNormalIdCounter = this._sectionUniqueComponentIdCounter;
        this._uniqueIdsList = null;
        this._uniqueIdsIterator = null;
        this._level = 0;
        this._isInMetadataSection = 0;
        this._sharedStringBuilder = null;
        this._ccLevel = 0;
        this._viewRoot = null;
    }

    public FaceletCompositionContextImpl(FaceletFactory factory, FacesContext facesContext, String base) {
        this(factory, facesContext);
        this._sectionUniqueIdCounter = new Lazy<Object>(() -> new SectionUniqueIdCounter(base + "_"));
        this._sectionUniqueComponentIdCounter = new Lazy<Object>(() -> new SectionUniqueIdCounter("_" + base + "_"));
        this._sectionUniqueNormalIdCounter = this._sectionUniqueIdCounter;
        this._sectionUniqueComponentNormalIdCounter = this._sectionUniqueComponentIdCounter;
        this._dynamicComponentTopLevel = true;
        this._dynamicComponentSection = 1;
    }

    @Override
    public void setUniqueIdsIterator(Iterator<String> uniqueIdsIterator) {
        this._uniqueIdsList = null;
        this._uniqueIdsIterator = uniqueIdsIterator;
    }

    @Override
    public void initUniqueIdRecording() {
        this._uniqueIdsList = new LinkedList<String>();
        this._uniqueIdsIterator = null;
    }

    @Override
    public void addUniqueId(String uniqueId) {
        if (this._uniqueIdsList != null && this._level == 0 && this._isInMetadataSection <= 0 && this._dynamicComponentSection <= 0) {
            this._uniqueIdsList.add(uniqueId);
        }
    }

    @Override
    public String getUniqueIdFromIterator() {
        if (this._uniqueIdsIterator != null && this._uniqueIdsIterator.hasNext() && this._level == 0 && this._isInMetadataSection <= 0 && this._dynamicComponentSection <= 0) {
            return this._uniqueIdsIterator.next();
        }
        return null;
    }

    @Override
    public List<String> getUniqueIdList() {
        return this._uniqueIdsList;
    }

    @Override
    public FaceletFactory getFaceletFactory() {
        return this._factory;
    }

    @Override
    public void release(FacesContext facesContext) {
        super.release(facesContext);
        this._factory = null;
        this._facesContext = null;
        this._compositeComponentStack = null;
        this._enclosingValidatorIdsStack = null;
        this._uniqueIdVendorStack = null;
        this._componentsMarkedForDeletion = null;
        this._relocatableResourceForDeletion = null;
        this._sectionUniqueIdCounter = null;
        this._sectionUniqueNormalIdCounter = null;
        this._sectionUniqueMetadataIdCounter = null;
        this._sectionUniqueComponentIdCounter = null;
        this._sectionUniqueComponentNormalIdCounter = null;
        this._sectionUniqueComponentMetadataIdCounter = null;
        this._sharedStringBuilder = null;
        this._visitContextFactory = null;
        this._dynamicOldDeletionLevel = null;
        this._viewRoot = null;
    }

    @Override
    public UIComponent getCompositeComponentFromStack() {
        if (this._compositeComponentStack != null && !this._compositeComponentStack.isEmpty()) {
            return this._compositeComponentStack.peek();
        }
        return null;
    }

    @Override
    public void pushCompositeComponentToStack(UIComponent parent) {
        if (this._compositeComponentStack == null) {
            this._compositeComponentStack = new LinkedList();
        }
        this._compositeComponentStack.addFirst(parent);
        ++this._ccLevel;
    }

    @Override
    public void popCompositeComponentToStack() {
        if (this._compositeComponentStack != null && !this._compositeComponentStack.isEmpty()) {
            this._compositeComponentStack.removeFirst();
        }
        --this._ccLevel;
    }

    @Override
    public int getCompositeComponentLevel() {
        return this._ccLevel;
    }

    @Override
    public UniqueIdVendor getUniqueIdVendorFromStack() {
        if (this._uniqueIdVendorStack != null && !this._uniqueIdVendorStack.isEmpty()) {
            return this._uniqueIdVendorStack.peek();
        }
        return null;
    }

    @Override
    public void popUniqueIdVendorToStack() {
        if (this._uniqueIdVendorStack != null && !this._uniqueIdVendorStack.isEmpty()) {
            this._uniqueIdVendorStack.removeFirst();
        }
    }

    @Override
    public void pushUniqueIdVendorToStack(UniqueIdVendor parent) {
        if (this._uniqueIdVendorStack == null) {
            this._uniqueIdVendorStack = new LinkedList();
        }
        this._uniqueIdVendorStack.addFirst(parent);
    }

    @Override
    public void popEnclosingValidatorIdToStack() {
        if (this._enclosingValidatorIdsStack != null && !this._enclosingValidatorIdsStack.isEmpty()) {
            this._enclosingValidatorIdsStack.removeFirst();
        }
    }

    @Override
    public void pushEnclosingValidatorIdToStack(String validatorId, EditableValueHolderAttachedObjectHandler attachedObjectHandler) {
        if (this._enclosingValidatorIdsStack == null) {
            this._enclosingValidatorIdsStack = new LinkedList();
        }
        this._enclosingValidatorIdsStack.addFirst(new SimpleEntry<String, EditableValueHolderAttachedObjectHandler>(validatorId, attachedObjectHandler));
    }

    @Override
    public Iterator<Map.Entry<String, EditableValueHolderAttachedObjectHandler>> getEnclosingValidatorIdsAndHandlers() {
        if (this._enclosingValidatorIdsStack != null && !this._enclosingValidatorIdsStack.isEmpty()) {
            return this._enclosingValidatorIdsStack.iterator();
        }
        return null;
    }

    @Override
    public boolean containsEnclosingValidatorId(String id) {
        if (this._enclosingValidatorIdsStack != null && !this._enclosingValidatorIdsStack.isEmpty()) {
            for (Map.Entry entry : this._enclosingValidatorIdsStack) {
                if (!((String)entry.getKey()).equals(id)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isRefreshingTransientBuild() {
        if (this._isRefreshingTransientBuild == null) {
            this._isRefreshingTransientBuild = FaceletViewDeclarationLanguage.isRefreshingTransientBuild(this._facesContext);
        }
        return this._isRefreshingTransientBuild;
    }

    @Override
    public boolean isMarkInitialState() {
        if (this._isMarkInitialState == null) {
            this._isMarkInitialState = FaceletViewDeclarationLanguage.isMarkInitialState(this._facesContext);
        }
        return this._isMarkInitialState;
    }

    @Override
    public void setMarkInitialState(boolean value) {
        this._isMarkInitialState = value;
    }

    @Override
    public boolean isRefreshTransientBuildOnPSS() {
        if (this._refreshTransientBuildOnPSS == null) {
            this._refreshTransientBuildOnPSS = FaceletViewDeclarationLanguage.isRefreshTransientBuildOnPSS(this._facesContext);
        }
        return this._refreshTransientBuildOnPSS;
    }

    @Override
    public boolean isRefreshTransientBuildOnPSSPreserveState() {
        return this.myfacesConfig.isRefreshTransientBuildOnPSSPreserveState();
    }

    @Override
    public boolean isBuildingViewMetadata() {
        if (this._isBuildingViewMetadata == null) {
            this._isBuildingViewMetadata = FaceletViewDeclarationLanguage.isBuildingViewMetadata(this._facesContext);
        }
        return this._isBuildingViewMetadata;
    }

    @Override
    public boolean isUsingPSSOnThisView() {
        if (this._usingPSSOnThisView == null) {
            this._usingPSSOnThisView = FaceletViewDeclarationLanguage.isUsingPSSOnThisView(this._facesContext);
        }
        return this._usingPSSOnThisView;
    }

    @Override
    public boolean isMarkInitialStateAndIsRefreshTransientBuildOnPSS() {
        return this.isMarkInitialState() && this.isRefreshTransientBuildOnPSS();
    }

    @Override
    public ELExpressionCacheMode getELExpressionCacheMode() {
        return this.myfacesConfig.getELExpressionCacheMode();
    }

    @Override
    public boolean isWrapTagExceptionsAsContextAware() {
        return this.myfacesConfig.isWrapTagExceptionsAsContextAware();
    }

    @Override
    public void addAttachedObjectHandler(UIComponent compositeComponentParent, AttachedObjectHandler handler) {
        List<AttachedObjectHandler> list = null;
        if (this._attachedObjectHandlers == null) {
            this._attachedObjectHandlers = new HashMap<UIComponent, List<AttachedObjectHandler>>();
        } else {
            list = this._attachedObjectHandlers.get(compositeComponentParent);
        }
        if (list == null) {
            list = new ArrayList<AttachedObjectHandler>();
            this._attachedObjectHandlers.put(compositeComponentParent, list);
        }
        list.add(handler);
    }

    @Override
    public void removeAttachedObjectHandlers(UIComponent compositeComponentParent) {
        if (this._attachedObjectHandlers == null) {
            return;
        }
        this._attachedObjectHandlers.remove(compositeComponentParent);
    }

    @Override
    public List<AttachedObjectHandler> getAttachedObjectHandlers(UIComponent compositeComponentParent) {
        if (this._attachedObjectHandlers == null) {
            return null;
        }
        return this._attachedObjectHandlers.get(compositeComponentParent);
    }

    @Override
    public void addMethodExpressionTargeted(UIComponent targetedComponent, String attributeName, Object backingValue) {
        Map<String, Object> map = null;
        if (this._methodExpressionsTargeted == null) {
            this._methodExpressionsTargeted = new HashMap<UIComponent, Map<String, Object>>();
        } else {
            map = this._methodExpressionsTargeted.get(targetedComponent);
        }
        if (map == null) {
            map = new HashMap<String, Object>(8);
            this._methodExpressionsTargeted.put(targetedComponent, map);
        }
        map.put(attributeName, backingValue);
    }

    @Override
    public boolean isMethodExpressionAttributeApplied(UIComponent compositeComponentParent, String attributeName) {
        if (this._compositeComponentAttributesMarked == null) {
            return false;
        }
        Map<String, Boolean> map = this._compositeComponentAttributesMarked.get(compositeComponentParent);
        if (map == null) {
            return false;
        }
        Boolean v = map.get(attributeName);
        return v == null ? false : v;
    }

    @Override
    public void markMethodExpressionAttribute(UIComponent compositeComponentParent, String attributeName) {
        Map<String, Boolean> map = null;
        if (this._compositeComponentAttributesMarked == null) {
            this._compositeComponentAttributesMarked = new HashMap<UIComponent, Map<String, Boolean>>();
        } else {
            map = this._compositeComponentAttributesMarked.get(compositeComponentParent);
        }
        if (map == null) {
            map = new HashMap<String, Boolean>(8);
            this._compositeComponentAttributesMarked.put(compositeComponentParent, map);
        }
        map.put(attributeName, Boolean.TRUE);
    }

    @Override
    public void clearMethodExpressionAttribute(UIComponent compositeComponentParent, String attributeName) {
        if (this._compositeComponentAttributesMarked == null) {
            return;
        }
        Map<String, Boolean> map = this._compositeComponentAttributesMarked.get(compositeComponentParent);
        if (map == null) {
            return;
        }
        map.put(attributeName, Boolean.FALSE);
    }

    @Override
    public Object removeMethodExpressionTargeted(UIComponent targetedComponent, String attributeName) {
        if (this._methodExpressionsTargeted == null) {
            return null;
        }
        Map<String, Object> map = this._methodExpressionsTargeted.get(targetedComponent);
        if (map != null) {
            return map.remove(attributeName);
        }
        return null;
    }

    private void increaseComponentLevelMarkedForDeletion() {
        ++this._deletionLevel;
        if (this._componentsMarkedForDeletion.size() <= this._deletionLevel) {
            this._componentsMarkedForDeletion.add(new HashMap());
        }
    }

    private void decreaseComponentLevelMarkedForDeletion() {
        if (!this._componentsMarkedForDeletion.get(this._deletionLevel).isEmpty()) {
            this._componentsMarkedForDeletion.get(this._deletionLevel).clear();
        }
        --this._deletionLevel;
    }

    private void markComponentForDeletion(String id, UIComponent component) {
        this._componentsMarkedForDeletion.get(this._deletionLevel).put(id, component);
    }

    private UIComponent removeComponentForDeletion(String id) {
        UIComponent removedComponent = this._componentsMarkedForDeletion.get(this._deletionLevel).remove(id);
        if (removedComponent != null && this._deletionLevel > 0) {
            this._componentsMarkedForDeletion.get(this._deletionLevel - 1).remove(id);
        }
        return removedComponent;
    }

    @Override
    public void markForDeletion(UIComponent component) {
        int childCount;
        this.increaseComponentLevelMarkedForDeletion();
        String id = (String)component.getAttributes().get("oam.vf.MARK_ID");
        id = id == null ? VIEWROOT_FACELET_ID : id;
        this.markComponentForDeletion(id, component);
        if (component.getFacetCount() > 0) {
            for (UIComponent fc : component.getFacets().values()) {
                int childCount2;
                id = (String)fc.getAttributes().get("oam.vf.MARK_ID");
                if (id != null) {
                    this.markComponentForDeletion(id, fc);
                    continue;
                }
                if (!Boolean.TRUE.equals(fc.getAttributes().get("oam.vf.createdUIPanel")) || (childCount2 = fc.getChildCount()) <= 0) continue;
                for (int i = 0; i < childCount2; ++i) {
                    UIComponent child = (UIComponent)fc.getChildren().get(i);
                    id = (String)child.getAttributes().get("oam.vf.MARK_ID");
                    if (id == null) continue;
                    this.markComponentForDeletion(id, child);
                }
            }
        }
        if ((childCount = component.getChildCount()) > 0) {
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)component.getChildren().get(i);
                id = (String)child.getAttributes().get("oam.vf.MARK_ID");
                if (id == null) continue;
                this.markComponentForDeletion(id, child);
            }
        }
    }

    @Override
    public void removeComponentForDeletion(UIComponent component) {
        int childCount;
        String id = (String)component.getAttributes().get("oam.vf.MARK_ID");
        if (id != null) {
            this.removeComponentForDeletion(id);
        } else if (id == null && Boolean.TRUE.equals(component.getAttributes().get("oam.vf.createdUIPanel")) && (childCount = component.getChildCount()) > 0) {
            int size = childCount;
            for (int i = 0; i < size; ++i) {
                UIComponent child = (UIComponent)component.getChildren().get(i);
                id = (String)child.getAttributes().get("oam.vf.MARK_ID");
                if (id == null) continue;
                this.removeComponentForDeletion(id);
            }
        }
    }

    @Override
    public void finalizeForDeletion(UIComponent component) {
        String id = (String)component.getAttributes().get("oam.vf.MARK_ID");
        id = id == null ? VIEWROOT_FACELET_ID : id;
        this.removeComponentForDeletion(id);
        int childCount = component.getChildCount();
        if (childCount > 0) {
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)component.getChildren().get(i);
                id = (String)child.getAttributes().get("oam.vf.MARK_ID");
                if (id == null || this.removeComponentForDeletion(id) == null) continue;
                component.getChildren().remove(i);
                --i;
                --childCount;
            }
        }
        if (component.getFacetCount() > 0) {
            Map facets = component.getFacets();
            Iterator itr = facets.values().iterator();
            while (itr.hasNext()) {
                UIComponent fc = (UIComponent)itr.next();
                id = (String)fc.getAttributes().get("oam.vf.MARK_ID");
                if (id != null && this.removeComponentForDeletion(id) != null) {
                    itr.remove();
                    continue;
                }
                if (id != null || !Boolean.TRUE.equals(fc.getAttributes().get("oam.vf.createdUIPanel"))) continue;
                if (fc.getChildCount() > 0) {
                    int size = fc.getChildCount();
                    for (int i = 0; i < size; ++i) {
                        UIComponent child = (UIComponent)fc.getChildren().get(i);
                        id = (String)child.getAttributes().get("oam.vf.MARK_ID");
                        if (id == null || this.removeComponentForDeletion(id) == null) continue;
                        fc.getChildren().remove(i);
                        --i;
                        --size;
                    }
                }
                if (fc.getChildCount() != 0) continue;
                itr.remove();
            }
        }
        this.decreaseComponentLevelMarkedForDeletion();
    }

    @Override
    public void markRelocatableResourceForDeletion(UIComponent component) {
        String id = (String)component.getAttributes().get("oam.vf.MARK_ID");
        if (id != null) {
            this._relocatableResourceForDeletion.put(id, component);
        }
    }

    @Override
    public void finalizeRelocatableResourcesForDeletion(UIViewRoot root) {
        String id = null;
        if (root.getFacetCount() > 0) {
            Map facets = root.getFacets();
            for (UIComponent fc : facets.values()) {
                int childCount;
                if (fc.getId() == null || !fc.getId().startsWith(JAKARTA_FACES_LOCATION_PREFIX) || (childCount = fc.getChildCount()) <= 0) continue;
                for (int i = 0; i < childCount; ++i) {
                    UIComponent child = (UIComponent)fc.getChildren().get(i);
                    id = (String)child.getAttributes().get("oam.vf.MARK_ID");
                    if (id == null || this.finalizeRelocatableResourcesForDeletion(id) != null) continue;
                    fc.getChildren().remove(i);
                    --i;
                    --childCount;
                }
            }
        }
    }

    private UIComponent finalizeRelocatableResourcesForDeletion(String id) {
        return this._relocatableResourceForDeletion.remove(id);
    }

    @Override
    public String startComponentUniqueIdSection() {
        ++this._level;
        this._sectionUniqueComponentIdCounter.get().startUniqueIdSection();
        return this._sectionUniqueIdCounter.get().startUniqueIdSection();
    }

    @Override
    public String startComponentUniqueIdSection(String base) {
        ++this._level;
        this._sectionUniqueComponentIdCounter.get().startUniqueIdSection(base);
        return this._sectionUniqueIdCounter.get().startUniqueIdSection(base);
    }

    @Override
    public void incrementUniqueId() {
        this._sectionUniqueIdCounter.get().incrementUniqueId();
    }

    @Override
    public String generateUniqueId() {
        return this._sectionUniqueIdCounter.get().generateUniqueId();
    }

    @Override
    public void generateUniqueId(StringBuilder builderToAdd) {
        this._sectionUniqueIdCounter.get().generateUniqueId(builderToAdd);
    }

    @Override
    public String generateUniqueComponentId() {
        return this._sectionUniqueComponentIdCounter.get().generateUniqueId();
    }

    @Override
    public void incrementUniqueComponentId() {
        this._sectionUniqueComponentIdCounter.get().incrementUniqueId();
    }

    @Override
    public void endComponentUniqueIdSection() {
        --this._level;
        this._sectionUniqueIdCounter.get().endUniqueIdSection();
        this._sectionUniqueComponentIdCounter.get().endUniqueIdSection();
    }

    @Override
    public void endComponentUniqueIdSection(String base) {
        --this._level;
        this._sectionUniqueIdCounter.get().endUniqueIdSection(base);
        this._sectionUniqueComponentIdCounter.get().endUniqueIdSection(base);
    }

    @Override
    public void startMetadataSection() {
        if (this._isInMetadataSection == 0) {
            if (this._sectionUniqueMetadataIdCounter == null) {
                this._sectionUniqueMetadataIdCounter = new Lazy<Object>(() -> new SectionUniqueIdCounter("__md_"));
            }
            if (this._sectionUniqueComponentMetadataIdCounter == null) {
                this._sectionUniqueComponentMetadataIdCounter = new Lazy<Object>(() -> new SectionUniqueIdCounter("__md_"));
            }
            this._sectionUniqueIdCounter = this._sectionUniqueMetadataIdCounter;
            this._sectionUniqueComponentIdCounter = this._sectionUniqueComponentMetadataIdCounter;
        }
        ++this._isInMetadataSection;
    }

    @Override
    public void endMetadataSection() {
        --this._isInMetadataSection;
        if (this._isInMetadataSection == 0) {
            this._sectionUniqueIdCounter = this._sectionUniqueNormalIdCounter;
            this._sectionUniqueComponentIdCounter = this._sectionUniqueComponentNormalIdCounter;
        }
    }

    @Override
    public boolean isInMetadataSection() {
        return this._isInMetadataSection > 0;
    }

    @Override
    public boolean isRefreshingSection() {
        return this.isRefreshingTransientBuild() || !this.isBuildingViewMetadata() && this.isInMetadataSection();
    }

    @Override
    public StringBuilder getSharedStringBuilder() {
        if (this._sharedStringBuilder == null) {
            this._sharedStringBuilder = new StringBuilder();
        } else {
            this._sharedStringBuilder.setLength(0);
        }
        return this._sharedStringBuilder;
    }

    @Override
    public boolean isDynamicCompositeComponentHandler() {
        return this._dynamicComponentHandler;
    }

    @Override
    public void setDynamicCompositeComponentHandler(boolean value) {
        this._dynamicComponentHandler = value;
    }

    @Override
    public void pushDynamicComponentSection(String base) {
        if (this._sectionUniqueIdCounterStack == null) {
            this._sectionUniqueIdCounterStack = new ArrayList<SectionUniqueIdCounter>();
        }
        if (this._sectionUniqueComponentIdCounterStack == null) {
            this._sectionUniqueComponentIdCounterStack = new ArrayList<SectionUniqueIdCounter>();
        }
        if (this._sectionUniqueComponentIdCounterStack.isEmpty()) {
            this._oldRefreshingTransientBuild = this._isRefreshingTransientBuild;
        }
        this._isRefreshingTransientBuild = true;
        this._sectionUniqueIdCounterStack.add(this._sectionUniqueIdCounter.get());
        this._sectionUniqueComponentIdCounterStack.add(this._sectionUniqueComponentIdCounter.get());
        this._sectionUniqueIdCounter = new Lazy<Object>(() -> new SectionUniqueIdCounter(base + "_"));
        this._sectionUniqueComponentIdCounter = new Lazy<Object>(() -> new SectionUniqueIdCounter("_" + base + "_"));
        this._sectionUniqueNormalIdCounter = this._sectionUniqueIdCounter;
        this._sectionUniqueComponentNormalIdCounter = this._sectionUniqueComponentIdCounter;
        this._dynamicComponentTopLevel = true;
        ++this._dynamicComponentSection;
        if (this._dynamicOldDeletionLevel == null) {
            this._dynamicOldDeletionLevel = new ArrayList<Integer>(4);
        }
        this._dynamicOldDeletionLevel.add(this._deletionLevel);
        this.increaseComponentLevelMarkedForDeletion();
    }

    @Override
    public void popDynamicComponentSection() {
        this.decreaseComponentLevelMarkedForDeletion();
        int oldDeletionLevel = this._dynamicOldDeletionLevel.remove(this._dynamicOldDeletionLevel.size() - 1);
        if (this._deletionLevel != oldDeletionLevel) {
            this.decreaseComponentLevelMarkedForDeletion();
        }
        this._sectionUniqueIdCounter.reset(this._sectionUniqueIdCounterStack.remove(this._sectionUniqueIdCounterStack.size() - 1));
        this._sectionUniqueComponentIdCounter.reset(this._sectionUniqueComponentIdCounterStack.remove(this._sectionUniqueComponentIdCounterStack.size() - 1));
        if (this._sectionUniqueComponentIdCounterStack.isEmpty()) {
            this._isRefreshingTransientBuild = this._oldRefreshingTransientBuild;
        }
        this._sectionUniqueNormalIdCounter = this._sectionUniqueIdCounter;
        this._sectionUniqueComponentNormalIdCounter = this._sectionUniqueComponentIdCounter;
        this._dynamicComponentTopLevel = false;
        --this._dynamicComponentSection;
    }

    @Override
    public boolean isDynamicComponentTopLevel() {
        return this._dynamicComponentTopLevel;
    }

    @Override
    public void setDynamicComponentTopLevel(boolean value) {
        this._dynamicComponentTopLevel = value;
    }

    @Override
    public boolean isDynamicComponentSection() {
        return this._dynamicComponentSection > 0;
    }

    @Override
    public void setViewRoot(UIViewRoot root) {
        this._viewRoot = root;
    }

    @Override
    public UIViewRoot getViewRoot(FacesContext facesContext) {
        if (this._viewRoot == null) {
            return facesContext.getViewRoot();
        }
        return this._viewRoot;
    }

    @Override
    public VisitContextFactory getVisitContextFactory() {
        if (this._visitContextFactory == null) {
            this._visitContextFactory = (VisitContextFactory)this._facesContext.getExternalContext().getApplicationMap().computeIfAbsent(VISIT_CONTEXT_FACTORY, k -> FactoryFinder.getFactory((String)"jakarta.faces.component.visit.VisitContextFactory"));
        }
        return this._visitContextFactory;
    }

    private static class SimpleEntry<K, V>
    implements Map.Entry<K, V> {
        private final K _key;
        private final V _value;

        public SimpleEntry(K key, V value) {
            this._key = key;
            this._value = value;
        }

        @Override
        public K getKey() {
            return this._key;
        }

        @Override
        public V getValue() {
            return this._value;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this._value == null ? 0 : this._value.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SimpleEntry other = (SimpleEntry)obj;
            if (this._key == null ? other._key != null : !this._key.equals(other._key)) {
                return false;
            }
            return !(this._value == null ? other._value != null : !this._value.equals(other._value));
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }
}

