/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.oidcclientcore.userinfo;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.security.common.jwt.JwtParsingUtils;
import io.openliberty.security.common.jwt.jws.JwsSignatureVerifier;
import io.openliberty.security.oidcclientcore.client.OidcClientConfig;
import io.openliberty.security.oidcclientcore.config.MetadataUtils;
import io.openliberty.security.oidcclientcore.config.OidcMetadataService;
import io.openliberty.security.oidcclientcore.exceptions.OidcClientConfigurationException;
import io.openliberty.security.oidcclientcore.exceptions.OidcDiscoveryException;
import io.openliberty.security.oidcclientcore.exceptions.UserInfoEndpointNotHttpsException;
import io.openliberty.security.oidcclientcore.exceptions.UserInfoResponseException;
import io.openliberty.security.oidcclientcore.exceptions.UserInfoResponseNot200Exception;
import io.openliberty.security.oidcclientcore.http.OidcClientHttpUtil;
import io.openliberty.security.oidcclientcore.jwt.JwtUtils;
import io.openliberty.security.oidcclientcore.userinfo.UserInfoResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.util.EntityUtils;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.JwtContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class UserInfoRequestor {
    public static final TraceComponent tc = Tr.register(UserInfoRequestor.class, (String)"OpenIdConnect", (String)"io.openliberty.security.oidcclientcore.internal.resources.OidcClientCoreMessages");
    private final OidcClientConfig oidcClientConfig;
    private final String userInfoEndpoint;
    private final String accessToken;
    private final List<NameValuePair> params;
    private final boolean hostnameVerification;
    private final boolean useSystemPropertiesForHttpClientConnections;
    OidcClientHttpUtil oidcClientHttpUtil = OidcClientHttpUtil.getInstance();
    static final long serialVersionUID = 6208484011495571784L;

    private UserInfoRequestor(Builder builder) {
        this.oidcClientConfig = builder.oidcClientConfig;
        this.userInfoEndpoint = builder.userInfoEndpoint;
        this.accessToken = builder.accessToken;
        this.hostnameVerification = builder.hostnameVerification;
        this.useSystemPropertiesForHttpClientConnections = builder.useSystemPropertiesForHttpClientConnections;
        this.params = new ArrayList<NameValuePair>();
    }

    @FFDCIgnore(value={Exception.class})
    public UserInfoResponse requestUserInfo() throws UserInfoResponseException {
        if (!this.userInfoEndpoint.toLowerCase().startsWith("https:")) {
            throw new UserInfoEndpointNotHttpsException(this.userInfoEndpoint, this.oidcClientConfig.getClientId());
        }
        int statusCode = 0;
        JSONObject claims = null;
        try {
            Map<String, Object> resultMap = this.getFromUserInfoEndpoint();
            HttpResponse response = (HttpResponse)resultMap.get("RESPONSEMAP_CODE");
            if (response == null) {
                throw new Exception("HttpResponse from getUserinfo is null");
            }
            claims = this.extractClaimsFromResponse(response);
            statusCode = this.getStatusCodeFromResponse(response);
        }
        catch (Exception e) {
            throw new UserInfoResponseException(this.userInfoEndpoint, e);
        }
        if (statusCode != 200) {
            throw new UserInfoResponseNot200Exception(this.userInfoEndpoint, Integer.toString(statusCode), claims.toString());
        }
        return new UserInfoResponse(claims);
    }

    private int getStatusCodeFromResponse(HttpResponse response) {
        return response.getStatusLine().getStatusCode();
    }

    private JSONObject extractClaimsFromResponse(HttpResponse response) throws Exception {
        HttpEntity entity = response.getEntity();
        String jresponse = null;
        if (entity != null) {
            jresponse = EntityUtils.toString((HttpEntity)entity);
        }
        if (jresponse == null || jresponse.isEmpty()) {
            return null;
        }
        String contentType = this.getContentType(entity);
        if (contentType == null) {
            return null;
        }
        JSONObject claims = null;
        if (contentType.contains("application/json")) {
            claims = this.extractClaimsFromJsonResponse(jresponse);
        } else if (contentType.contains("application/jwt")) {
            claims = this.extractClaimsFromJwtResponse(jresponse);
        }
        return claims;
    }

    private JSONObject extractClaimsFromJsonResponse(String jresponse) throws IOException {
        return JSONObject.parse((String)jresponse);
    }

    private String getContentType(HttpEntity entity) {
        Header contentTypeHeader = entity.getContentType();
        if (contentTypeHeader != null) {
            return contentTypeHeader.getValue();
        }
        return null;
    }

    public JSONObject extractClaimsFromJwtResponse(String responseString) throws Exception {
        JwtClaims claims;
        JwtContext jwtContext = JwtParsingUtils.parseJwtWithoutValidation((String)responseString);
        if (jwtContext != null && (claims = this.validateJwsSignatureAndGetClaims(jwtContext)) != null) {
            return JSONObject.parse((String)claims.toJson());
        }
        return null;
    }

    JwtClaims validateJwsSignatureAndGetClaims(JwtContext jwtContext) throws Exception {
        JwsSignatureVerifier.Builder verifierBuilder = JwtUtils.verifyJwsAlgHeaderAndCreateJwsSignatureVerifierBuilder(jwtContext, this.oidcClientConfig, this.getSigningAlgorithmsAllowed());
        JwsSignatureVerifier signatureVerifier = verifierBuilder.build();
        return signatureVerifier.validateJwsSignature(jwtContext);
    }

    @FFDCIgnore(value={OidcClientConfigurationException.class})
    String[] getSigningAlgorithmsAllowed() {
        String[] signingAlgsAllowed = null;
        try {
            signingAlgsAllowed = MetadataUtils.getUserInfoSigningAlgorithmsSupported(this.oidcClientConfig);
        }
        catch (OidcClientConfigurationException | OidcDiscoveryException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught exception getting user info signing algorithm supported. Defaulting to RS256. Exception was: " + e.getMessage()), (Object[])new Object[0]);
            }
            signingAlgsAllowed = new String[]{"RS256"};
        }
        return signingAlgsAllowed;
    }

    private Map<String, Object> getFromUserInfoEndpoint() throws HttpException, IOException {
        return this.oidcClientHttpUtil.getFromEndpoint(this.userInfoEndpoint, this.params, null, null, this.accessToken, OidcMetadataService.getSSLSocketFactory(), this.hostnameVerification, this.useSystemPropertiesForHttpClientConnections);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class Builder {
        private final OidcClientConfig oidcClientConfig;
        private final String userInfoEndpoint;
        private final String accessToken;
        private boolean hostnameVerification = false;
        private boolean useSystemPropertiesForHttpClientConnections = false;
        static final long serialVersionUID = -8019156304595351864L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public Builder(OidcClientConfig oidcClientConfig, String userInfoEndpoint, String accessToken) {
            this.oidcClientConfig = oidcClientConfig;
            this.userInfoEndpoint = userInfoEndpoint;
            this.accessToken = accessToken;
        }

        public Builder hostnameVerification(boolean hostnameVerification) {
            this.hostnameVerification = hostnameVerification;
            return this;
        }

        public Builder useSystemPropertiesForHttpClientConnections(boolean useSystemPropertiesForHttpClientConnections) {
            this.useSystemPropertiesForHttpClientConnections = useSystemPropertiesForHttpClientConnections;
            return this;
        }

        public UserInfoRequestor build() {
            return new UserInfoRequestor(this);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.security.oidcclientcore.userinfo.UserInfoRequestor$Builder", Builder.class, (String)"OpenIdConnect", (String)"io.openliberty.security.oidcclientcore.internal.resources.OidcClientCoreMessages");
        }
    }
}

