/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal;

import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.genericbnf.internal.GenericUtils;
import com.ibm.ws.http.channel.h2internal.Constants;
import com.ibm.ws.http.channel.internal.HttpConfigConstants;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.ws.http.internal.HttpEndpointImpl;
import com.ibm.ws.http.logging.internal.DisabledLogger;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.wsspi.http.channel.values.VersionValues;
import com.ibm.wsspi.http.logging.AccessLog;
import com.ibm.wsspi.http.logging.DebugLog;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpChannelConfig {
    private static final TraceComponent tc = Tr.register(HttpChannelConfig.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private static final int TIMEOUT_MODIFIER = 1000;
    private int maxPersistRequest = -1;
    private VersionValues outgoingHttpVersion = VersionValues.V11;
    private boolean bDirectBuffers = true;
    private boolean bKeepAliveEnabled = true;
    private int outgoingHdrBuffSize = 1024;
    private int incomingHdrBuffSize = 8192;
    private int incomingBodyBuffSize = 32768;
    private int persistTimeout = 30000;
    private int readTimeout = 60000;
    private int writeTimeout = 60000;
    private int byteCacheSize = 512;
    private boolean bExtractValue = true;
    private boolean bBinaryTransport = false;
    private AtomicReference<AccessLog> accessLogger = new AtomicReference<DisabledLogger>(DisabledLogger.getRef());
    private final DebugLog debugLogger = DisabledLogger.getRef();
    private int limitFieldSize = 32768;
    private int limitNumHeaders = 500;
    private int limitNumResponses = 10;
    private long limitMessageSize = -1L;
    private boolean bAllowRetries = true;
    private final boolean bServantRegion = false;
    private final boolean bRunningOnZOS = false;
    private final boolean bControlRegion = false;
    private boolean bHeaderValidation = true;
    private boolean bJITOnlyReads = false;
    private boolean bStrictURLFormat = false;
    private boolean bRemoveServerHeader = false;
    private byte[] baServerHeaderValue = null;
    private long lDateHeaderRange = 1000L;
    private boolean bCookiesConfigureNoCache = true;
    private int headerChangeLimit = -1;
    private boolean bAutoDecompression = true;
    private boolean bEnableSmugglingProtection = true;
    private boolean v0CookieDateRFC1123compat = true;
    private boolean doNotAllowDuplicateSetCookies = false;
    private boolean waitForEndOfMessage = false;
    private boolean removeCLHeaderInTempStatusRespRFC7230compat = false;
    private boolean preventResponseSplit = true;
    private boolean attemptPurgeData = false;
    private Boolean throwIOEForInboundConnections = null;
    private boolean skipCookiePathQuotes = false;
    private boolean purgeRemainingResponseBody = true;
    private Boolean useH2ProtocolAttribute = null;
    private long http2ConnectionCloseTimeout = 30L;
    private int http2SettingsInitialWindowSize = Constants.SPEC_INITIAL_WINDOW_SIZE;
    private int http2ConnectionWindowSize = Constants.SPEC_INITIAL_WINDOW_SIZE;
    private int http2ConnectionIdleTimeout = 0;
    private int http2MaxConcurrentStreams = 100;
    private int http2MaxFrameSize = 57344;
    private boolean http2LimitWindowUpdateFrames = false;
    private int http2MaxResetFrames = 100;
    private int http2ResetFramesWindow = 30000;
    private int http2MaxStreamsRefused = 100;
    private boolean useForwardingHeaders = false;
    private String proxiesRegex = "10\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|192\\.168\\.\\d{1,3}\\.\\d{1,3}|169\\.254\\.\\d{1,3}\\.\\d{1,3}|127\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|172\\.1[6-9]{1}\\.\\d{1,3}\\.\\d{1,3}|172\\.2[0-9]{1}\\.\\d{1,3}\\.\\d{1,3}|172\\.3[0-1]{1}\\.\\d{1,3}\\.\\d{1,3}|0:0:0:0:0:0:0:1|::1";
    private Pattern proxiesPattern = null;
    private int decompressionRatioLimit = 200;
    private int decompressionTolerance = 3;
    private boolean useForwardingHeadersInAccessLog = false;
    private boolean useCompression = false;
    private String preferredCompressionAlgorithm = "none";
    private Set<String> includedCompressionContentTypes = null;
    private Set<String> excludedCompressionContentTypes = null;
    private final String compressionQValueRegex = "^((0(\\.\\d{0,3})?)|1(\\.0{0,3})?)$";
    private Pattern compressionQValuePattern = null;
    private boolean useSameSiteConfig = false;
    private Map<String, String> sameSiteCookies = null;
    private Set<String> sameSiteErrorCookies = null;
    private Map<String, String> sameSiteStringPatterns = null;
    private Map<Pattern, String> sameSitePatterns = null;
    private boolean onlySameSiteStar = false;
    private boolean isPartitioned = false;
    private boolean isHeadersConfigEnabled = false;
    private Map<Integer, List<Map.Entry<String, String>>> configuredHeadersToAdd = null;
    private Map<Integer, Map.Entry<String, String>> configuredHeadersToSet = null;
    private Map<Integer, Map.Entry<String, String>> configuredHeadersToSetIfMissing = null;
    private Map<Integer, String> configuredHeadersToRemove = null;
    private HashSet<String> configuredHeadersErrorSet = null;

    public HttpChannelConfig(ChannelData cc) {
        this.parseConfig(cc);
    }

    public void updateConfig(ChannelData cc) {
        this.parseConfig(cc);
    }

    private void parseConfig(ChannelData cc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("parseConfig: " + cc.getName()), (Object[])new Object[0]);
        }
        Map propsIn = cc.getPropertyBag();
        HashMap<Object, Object> props = new HashMap<Object, Object>();
        for (Map.Entry entry : propsIn.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (key.equalsIgnoreCase("KeepAliveEnabled")) {
                props.put("KeepAliveEnabled", value);
                continue;
            }
            if (key.equalsIgnoreCase("MaxKeepAliveRequests")) {
                props.put("MaxKeepAliveRequests", value);
                continue;
            }
            if (key.equalsIgnoreCase("persistTimeout")) {
                props.put("persistTimeout", value);
                continue;
            }
            if (key.equalsIgnoreCase("readTimeout")) {
                props.put("readTimeout", value);
                continue;
            }
            if (key.equalsIgnoreCase("writeTimeout")) {
                props.put("writeTimeout", value);
                continue;
            }
            if (key.equalsIgnoreCase("JITOnlyReads")) {
                props.put("JITOnlyReads", value);
                continue;
            }
            if (key.equalsIgnoreCase("outgoingVersion")) {
                props.put("outgoingVersion", value);
                continue;
            }
            if (key.equalsIgnoreCase("useDirectBuffers")) {
                props.put("useDirectBuffers", value);
                continue;
            }
            if (key.equalsIgnoreCase("outgoingHdrBufferSize")) {
                props.put("outgoingHdrBufferSize", value);
                continue;
            }
            if (key.equalsIgnoreCase("incomingHdrBufferSize")) {
                props.put("incomingHdrBufferSize", value);
                continue;
            }
            if (key.equalsIgnoreCase("incomingBodyBufferSize")) {
                props.put("incomingBodyBufferSize", value);
                continue;
            }
            if (key.equalsIgnoreCase("byteCacheSize")) {
                props.put("byteCacheSize", value);
                continue;
            }
            if (key.equalsIgnoreCase("extractValue")) {
                props.put("extractValue", value);
                continue;
            }
            if (key.equalsIgnoreCase("enableBinaryTransport")) {
                props.put("enableBinaryTransport", value);
                continue;
            }
            if (key.equalsIgnoreCase("limitFieldSize")) {
                props.put("limitFieldSize", value);
                continue;
            }
            if (key.equalsIgnoreCase("limitNumHeaders")) {
                props.put("limitNumHeaders", value);
                continue;
            }
            if (key.equalsIgnoreCase("LimitNumberResponses")) {
                props.put("LimitNumberResponses", value);
                continue;
            }
            if (key.equalsIgnoreCase("MessageSizeLimit")) {
                props.put("MessageSizeLimit", value);
                continue;
            }
            if (key.equalsIgnoreCase("allowRetries")) {
                props.put("allowRetries", value);
                continue;
            }
            if (key.equalsIgnoreCase("splitResponseProtection")) {
                props.put("splitResponseProtection", value);
                continue;
            }
            if (key.equalsIgnoreCase("StrictURLFormat")) {
                props.put("StrictURLFormat", value);
                continue;
            }
            if (key.equalsIgnoreCase("ServerHeaderValue")) {
                props.put("ServerHeaderValue", value);
                continue;
            }
            if (key.equalsIgnoreCase("RemoveServerHeader")) {
                props.put("RemoveServerHeader", value);
                continue;
            }
            if (key.equalsIgnoreCase("DateHeaderRange")) {
                props.put("DateHeaderRange", value);
                continue;
            }
            if (key.equalsIgnoreCase("CookiesConfigureNoCache")) {
                props.put("CookiesConfigureNoCache", value);
                continue;
            }
            if (key.equalsIgnoreCase("HeaderChangeLimit")) {
                props.put("HeaderChangeLimit", value);
                continue;
            }
            if (key.equalsIgnoreCase("AutoDecompression")) {
                props.put("AutoDecompression", value);
                continue;
            }
            if (key.equalsIgnoreCase("EnableSmugglingProtection")) {
                props.put("EnableSmugglingProtection", value);
                continue;
            }
            if (key.equalsIgnoreCase("RunningOnZOS")) {
                props.put("RunningOnZOS", value);
                continue;
            }
            if (key.equalsIgnoreCase("ServantRegion")) {
                props.put("ServantRegion", value);
                continue;
            }
            if (key.equalsIgnoreCase("ControlRegion")) {
                props.put("ControlRegion", value);
                continue;
            }
            if (key.equalsIgnoreCase("v0CookieDateRFC1123compat")) {
                props.put("v0CookieDateRFC1123compat", value);
                continue;
            }
            if (key.equalsIgnoreCase("DoNotAllowDuplicateSetCookies")) {
                props.put("DoNotAllowDuplicateSetCookies", value);
                continue;
            }
            if (key.equalsIgnoreCase("WaitForEndOfMessage")) {
                props.put("WaitForEndOfMessage", value);
                continue;
            }
            if (key.equalsIgnoreCase("RemoveCLHeaderInTempStatusRespRFC7230compat")) {
                props.put("RemoveCLHeaderInTempStatusRespRFC7230compat", value);
                continue;
            }
            if (key.equalsIgnoreCase("PreventReponseSplit")) {
                props.put("PreventReponseSplit", value);
                continue;
            }
            if (key.equalsIgnoreCase("PurgeDataDuringClose")) {
                props.put("PurgeDataDuringClose", value);
                continue;
            }
            if (key.equalsIgnoreCase("ThrowIOEForInboundConnections")) {
                props.put("ThrowIOEForInboundConnections", value);
                continue;
            }
            if (key.equalsIgnoreCase("SkipCookiePathQuotes")) {
                props.put("SkipCookiePathQuotes", value);
                continue;
            }
            if (key.equalsIgnoreCase("H2ConnCloseTimeout")) {
                props.put("H2ConnCloseTimeout", value);
                continue;
            }
            if (key.equalsIgnoreCase("settingsInitialWindowSize")) {
                props.put("settingsInitialWindowSize", value);
                continue;
            }
            if (key.equalsIgnoreCase("http2ConnectionIdleTimeout")) {
                props.put("http2ConnectionIdleTimeout", value);
                continue;
            }
            if (key.equalsIgnoreCase("maxConcurrentStreams")) {
                props.put("maxConcurrentStreams", value);
            }
            if (key.equalsIgnoreCase("maxFrameSize")) {
                props.put("maxFrameSize", value);
            }
            if (key.equalsIgnoreCase("limitWindowUpdateFrames")) {
                props.put("limitWindowUpdateFrames", value);
                continue;
            }
            if (key.equalsIgnoreCase("maxResetFrames")) {
                props.put("maxResetFrames", value);
            }
            if (key.equalsIgnoreCase("resetFramesWindow")) {
                props.put("resetFramesWindow", value);
            }
            if (key.equalsIgnoreCase("maxStreamsRefused")) {
                props.put("maxStreamsRefused", value);
            }
            if (key.equalsIgnoreCase("PurgeRemainingResponseBody")) {
                props.put("PurgeRemainingResponseBody", value);
                continue;
            }
            if (key.equalsIgnoreCase("protocolVersionInternal")) {
                props.put("protocolVersionInternal", value);
                continue;
            }
            if (key.equalsIgnoreCase("proxiesInternal")) {
                props.put("proxiesInternal", value);
            }
            if (key.equalsIgnoreCase("useRemoteIpInternal")) {
                props.put("useRemoteIpInternal", value);
            }
            if (key.equalsIgnoreCase("useRemoteIpInAccessLogInternal")) {
                props.put("useRemoteIpInAccessLogInternal", value);
            }
            if (key.equalsIgnoreCase("useAutoCompressionInternal")) {
                props.put("useAutoCompressionInternal", value);
            }
            if (key.equalsIgnoreCase("compressionListByTypesInternal")) {
                props.put("compressionListByTypesInternal", value);
            }
            if (key.equalsIgnoreCase("serverPreferredAlgorithmInternal")) {
                props.put("serverPreferredAlgorithmInternal", value);
            }
            if (key.equalsIgnoreCase("decompressionRatioLimit")) {
                props.put("decompressionRatioLimit", value);
            }
            if (key.equalsIgnoreCase("decompressionTolerance")) {
                props.put("decompressionTolerance", value);
            }
            if (key.equalsIgnoreCase("sameSiteInternal")) {
                props.put("sameSiteInternal", value);
            }
            if (key.equalsIgnoreCase("sameSiteLaxInternal")) {
                props.put("sameSiteLaxInternal", value);
            }
            if (key.equalsIgnoreCase("sameSiteNoneInternal")) {
                props.put("sameSiteNoneInternal", value);
            }
            if (key.equalsIgnoreCase("sameSiteStrictInternal")) {
                props.put("sameSiteStrictInternal", value);
            }
            if (ProductInfo.getBetaEdition() && key.equalsIgnoreCase("sameSitePartitionedInternal")) {
                props.put("sameSitePartitionedInternal", value);
            }
            if (key.equalsIgnoreCase("headersInternal")) {
                props.put("headersInternal", value);
            }
            if (key.equalsIgnoreCase("headersAddInternal")) {
                props.put("headersAddInternal", value);
            }
            if (key.equalsIgnoreCase("headersSetInternal")) {
                props.put("headersSetInternal", value);
            }
            if (key.equalsIgnoreCase("headersSetIfMissingInternal")) {
                props.put("headersSetIfMissingInternal", value);
            }
            if (key.equalsIgnoreCase("headersRemoveInternal")) {
                props.put("headersRemoveInternal", value);
            }
            props.put(key, value);
        }
        this.parseProtocolVersion(props);
        this.parsePersistence(props);
        this.parseOutgoingVersion(props);
        this.parseBufferType(props);
        this.parseOutgoingBufferSize(props);
        this.parseIncomingHdrBufferSize(props);
        this.parseIncomingBodyBufferSize(props);
        this.parsePersistTimeout(props);
        this.parseReadTimeout(props);
        this.parseWriteTimeout(props);
        this.parseByteCacheSize(props);
        this.parseDelayedExtract(props);
        this.parseBinaryTransport(props);
        this.parseLimitFieldSize(props);
        this.parseLimitNumberHeaders(props);
        this.parseLimitNumberResponses(props);
        this.parseLimitMessageSize(props);
        this.parseAllowRetries(props);
        this.parseLoggingInfo(props);
        this.parseHeaderValidation(props);
        this.parseStrictURLFormat(props);
        this.parseServerHeader(props);
        this.parseDateHeaderRange(props);
        this.parseCookieUpdate(props);
        this.parseHeaderChangeLimit(props);
        this.parseAutoDecompression(props);
        this.parseRequestSmugglingProtection(props);
        this.parsev0CookieDateRFC1123compat(props);
        this.parseDoNotAllowDuplicateSetCookies(props);
        this.parseWaitForEndOfMessage(props);
        this.parseRemoveCLHeaderInTempStatusRespRFC7230compat(props);
        this.parsePreventResponseSplit(props);
        this.parseAttemptPurgeData(props);
        this.parseThrowIOEForInboundConnections(props);
        this.parseSkipCookiePathQuotes(props);
        this.parseH2ConnCloseTimeout(props);
        this.parseH2ConnectionIdleTimeout(props);
        this.parseH2MaxConcurrentStreams(props);
        this.parseH2MaxFrameSize(props);
        this.parseH2SettingsInitialWindowSize(props);
        this.parseH2ConnectionWindowSize(props);
        this.parseH2LimitWindowUpdateFrames(props);
        this.parseH2MaxResetFrames(props);
        this.parseH2ResetFramesWindow(props);
        this.parseH2MaxStreamsRefused(props);
        this.parsePurgeRemainingResponseBody(props);
        this.parseRemoteIp(props);
        this.parseRemoteIpProxies(props);
        this.parseRemoteIpAccessLog(props);
        this.parseCompression(props);
        this.parseCompressionTypes(props);
        this.parseCompressionPreferredAlgorithm(props);
        this.parseDecompressionRatioLimit(props);
        this.parseDecompressionTolerance(props);
        this.parseSameSiteConfig(props);
        this.parseCookiesSameSiteLax(props);
        this.parseCookiesSameSiteNone(props);
        this.parseCookiesSameSiteStrict(props);
        if (ProductInfo.getBetaEdition()) {
            this.parseCookiesSameSitePartitioned(props);
        }
        this.initSameSiteCookiesPatterns();
        this.parseHeaders(props);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"parseConfig");
        }
    }

    private String getProp(Map<Object, Object> props, String key) {
        String value = (String)props.get(key);
        if (null == value) {
            value = (String)props.get(key.toLowerCase());
        }
        return null != value ? value.trim() : null;
    }

    private void parsePersistence(Map<Object, Object> props) {
        this.parseKeepAliveEnabled(props);
        if (this.isKeepAliveEnabled()) {
            this.parseMaxPersist(props);
        }
    }

    private void parseKeepAliveEnabled(Map<Object, Object> props) {
        boolean flag = this.bKeepAliveEnabled;
        Object value = props.get("KeepAliveEnabled");
        if (null != value) {
            flag = this.convertBoolean(value);
        }
        this.bKeepAliveEnabled = flag;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Config: KeepAliveEnabled is " + this.isKeepAliveEnabled()), (Object[])new Object[0]);
        }
    }

    private void parseMaxPersist(Map<Object, Object> props) {
        block4: {
            Object value = props.get("MaxKeepAliveRequests");
            if (null != value) {
                try {
                    this.maxPersistRequest = this.minLimit(this.convertInteger(value), -1);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Config: Max persistent requests is " + this.getMaximumPersistentRequests()), (Object[])new Object[0]);
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, (String)(this.getClass().getName() + ".parseMaxPersist"), (String)"1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event((TraceComponent)tc, (String)("Config: Invalid max persistent requests; " + value), (Object[])new Object[0]);
                }
            }
        }
    }

    private void parseOutgoingVersion(Map<Object, Object> props) {
        String value = this.getProp(props, "outgoingVersion");
        if ("1.0".equals(value)) {
            this.outgoingHttpVersion = VersionValues.V10;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: Outgoing version is " + this.getOutgoingVersion().getName()), (Object[])new Object[0]);
            }
        }
    }

    private void parseBufferType(Map<Object, Object> props) {
        Object value = props.get("useDirectBuffers");
        if (null != value) {
            this.bDirectBuffers = this.convertBoolean(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: use direct buffers is " + this.isDirectBufferType()), (Object[])new Object[0]);
            }
        }
    }

    private void parseOutgoingBufferSize(Map<Object, Object> props) {
        block4: {
            Object value = props.get("outgoingHdrBufferSize");
            if (null != value) {
                try {
                    this.outgoingHdrBuffSize = this.rangeLimit(this.convertInteger(value), 1024, 0x100000);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Config: Outgoing hdr buffer size is " + this.getOutgoingHdrBufferSize()), (Object[])new Object[0]);
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, (String)(this.getClass().getName() + ".parseOutgoingBufferSize"), (String)"1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event((TraceComponent)tc, (String)("Config: Invalid outgoing header buffer size; " + value), (Object[])new Object[0]);
                }
            }
        }
    }

    private void parseIncomingHdrBufferSize(Map<Object, Object> props) {
        block4: {
            Object value = props.get("incomingHdrBufferSize");
            if (null != value) {
                try {
                    this.incomingHdrBuffSize = this.rangeLimit(this.convertInteger(value), 1024, 0x100000);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Config: Incoming hdr buffer size is " + this.getIncomingHdrBufferSize()), (Object[])new Object[0]);
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, (String)(this.getClass().getName() + ".parseIncomingHdrBufferSize"), (String)"1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event((TraceComponent)tc, (String)("Config: Invalid incoming hdr buffer size of " + value), (Object[])new Object[0]);
                }
            }
        }
    }

    private void parseIncomingBodyBufferSize(Map<Object, Object> props) {
        block4: {
            Object value = props.get("incomingBodyBufferSize");
            if (null != value) {
                try {
                    this.incomingBodyBuffSize = this.rangeLimit(this.convertInteger(value), 1024, 0x100000);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Config: Incoming body buffer size is " + this.getIncomingBodyBufferSize()), (Object[])new Object[0]);
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, (String)(this.getClass().getName() + ".parseIncomingBodyBufferSize"), (String)"1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event((TraceComponent)tc, (String)("Config: Invalid incoming body buffer size; " + value), (Object[])new Object[0]);
                }
            }
        }
    }

    private void parsePersistTimeout(Map<Object, Object> props) {
        block4: {
            Object value = props.get("persistTimeout");
            if (null != value) {
                try {
                    this.persistTimeout = 1000 * this.minLimit(this.convertInteger(value), 0);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Config: Persist timeout is " + this.getPersistTimeout()), (Object[])new Object[0]);
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, (String)(this.getClass().getName() + ".parsePersistTimeout"), (String)"1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event((TraceComponent)tc, (String)("Config: Invalid persist timeout; " + value), (Object[])new Object[0]);
                }
            }
        }
    }

    private void parseReadTimeout(Map<Object, Object> props) {
        block4: {
            Object value = props.get("readTimeout");
            if (null != value) {
                try {
                    this.readTimeout = 1000 * this.minLimit(this.convertInteger(value), 0);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Config: Read timeout is " + this.getReadTimeout()), (Object[])new Object[0]);
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, (String)(this.getClass().getName() + ".parseReadTimeout"), (String)"1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event((TraceComponent)tc, (String)("Config: Invalid read timeout; " + value), (Object[])new Object[0]);
                }
            }
        }
    }

    private void parseWriteTimeout(Map<Object, Object> props) {
        block4: {
            Object value = props.get("writeTimeout");
            if (null != value) {
                try {
                    this.writeTimeout = 1000 * this.minLimit(this.convertInteger(value), 0);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Config: Write timeout is " + this.getWriteTimeout()), (Object[])new Object[0]);
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, (String)(this.getClass().getName() + ".parseWriteTimeout"), (String)"1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event((TraceComponent)tc, (String)("Config: Invalid write timeout; " + value), (Object[])new Object[0]);
                }
            }
        }
    }

    private void parseH2ConnectionIdleTimeout(Map<Object, Object> props) {
        block4: {
            Object value = props.get("http2ConnectionIdleTimeout");
            if (null != value) {
                try {
                    this.http2ConnectionIdleTimeout = 1000 * this.minLimit(this.convertInteger(value), 0);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Config: HTTP/2 Connection idle timeout is " + this.getH2ConnectionIdleTimeout()), (Object[])new Object[0]);
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, (String)(this.getClass().getName() + ".parseH2ConnectionIdleTimeout"), (String)"1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event((TraceComponent)tc, (String)("Config: Invalid HTTP/2 connection idle timeout; " + value), (Object[])new Object[0]);
                }
            }
        }
    }

    private void parseH2MaxConcurrentStreams(Map<Object, Object> props) {
        block4: {
            Object value = props.get("maxConcurrentStreams");
            if (null != value) {
                try {
                    this.http2MaxConcurrentStreams = this.convertInteger(value);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Config: HTTP/2 Max Concurrent Streams is " + this.getH2MaxConcurrentStreams()), (Object[])new Object[0]);
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, (String)(this.getClass().getName() + ".parseH2MaxConcurrentStreams"), (String)"1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event((TraceComponent)tc, (String)("Config: Invalid HTTP/2 Max Concurrent Streams; " + value), (Object[])new Object[0]);
                }
            }
        }
    }

    private void parseH2MaxResetFrames(Map<Object, Object> props) {
        block4: {
            Object value = props.get("maxResetFrames");
            if (null != value) {
                try {
                    this.http2MaxResetFrames = this.convertInteger(value);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Config: HTTP/2 Max Reset Frames " + this.getH2MaxResetFrames()), (Object[])new Object[0]);
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, (String)(this.getClass().getName() + ".parseH2MaxResetFrames"), (String)"1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event((TraceComponent)tc, (String)("Config: Invalid HTTP/2 Max Reset Frames; " + value), (Object[])new Object[0]);
                }
            }
        }
    }

    private void parseH2ResetFramesWindow(Map<Object, Object> props) {
        block4: {
            Object value = props.get("resetFramesWindow");
            if (null != value) {
                try {
                    this.http2ResetFramesWindow = this.convertInteger(value);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Config: HTTP/2 Reset Frames Window " + this.getH2ResetFramesWindow()), (Object[])new Object[0]);
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, (String)(this.getClass().getName() + ".parseH2ResetFramesWindow"), (String)"1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event((TraceComponent)tc, (String)("Config: Invalid HTTP/2 Reset Frames Window; " + value), (Object[])new Object[0]);
                }
            }
        }
    }

    private void parseH2MaxStreamsRefused(Map<Object, Object> props) {
        block4: {
            Object value = props.get("maxStreamsRefused");
            if (null != value) {
                try {
                    this.http2MaxStreamsRefused = this.convertInteger(value);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Config: HTTP/2 Max Streams Refused " + this.getH2MaxStreamsRefused()), (Object[])new Object[0]);
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, (String)(this.getClass().getName() + ".parseH2MaxStreamsRefused"), (String)"1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event((TraceComponent)tc, (String)("Config: Invalid HTTP/2 Max Streams Refused; " + value), (Object[])new Object[0]);
                }
            }
        }
    }

    private void parseH2MaxFrameSize(Map<Object, Object> props) {
        block4: {
            Object value = props.get("maxFrameSize");
            if (null != value) {
                try {
                    this.http2MaxFrameSize = this.rangeLimit(this.convertInteger(value), 16384, 0xFFFFFF);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Config: HTTP/2 Max Frame Size is " + this.getH2MaxFrameSize()), (Object[])new Object[0]);
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, (String)(this.getClass().getName() + ".parseH2MaxFrameSize"), (String)"1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event((TraceComponent)tc, (String)("Config: Invalid HTTP/2 Frame Size; " + value), (Object[])new Object[0]);
                }
            }
        }
    }

    private void parseH2SettingsInitialWindowSize(Map<Object, Object> props) {
        Object value = props.get("settingsInitialWindowSize");
        if (null != value) {
            this.http2SettingsInitialWindowSize = this.convertInteger(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: HTTP/2 Settings Initial Window Size is " + this.getH2SettingsInitialWindowSize()), (Object[])new Object[0]);
            }
        }
    }

    private void parseH2ConnectionWindowSize(Map<Object, Object> props) {
        Object value = props.get("connectionWindowSize");
        if (null != value) {
            this.http2ConnectionWindowSize = this.convertInteger(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: HTTP/2 Connection Window Size is " + this.getH2ConnectionWindowSize()), (Object[])new Object[0]);
            }
        }
    }

    private void parseH2LimitWindowUpdateFrames(Map<Object, Object> props) {
        Object value = props.get("limitWindowUpdateFrames");
        if (null != value) {
            this.http2LimitWindowUpdateFrames = this.convertBoolean(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: HTTP/2 Limit Window Update Frames is " + this.getH2LimitWindowUpdateFrames()), (Object[])new Object[0]);
            }
        }
    }

    private void parseH2ConnCloseTimeout(Map<?, ?> props) {
        block4: {
            Object value = props.get("H2ConnCloseTimeout");
            if (null != value) {
                try {
                    this.http2ConnectionCloseTimeout = this.convertLong(value);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Config: H2 Connection Close timeout is " + this.getH2ConnCloseTimeout()), (Object[])new Object[0]);
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, (String)(this.getClass().getName() + ".parseH2ConnCloseTimeout"), (String)"1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event((TraceComponent)tc, (String)("Config: Invalid H2 Connection Close Timeout of " + value), (Object[])new Object[0]);
                }
            }
        }
    }

    private void parseByteCacheSize(Map<Object, Object> props) {
        block4: {
            Object value = props.get("byteCacheSize");
            if (null != value) {
                try {
                    this.byteCacheSize = this.rangeLimit(this.convertInteger(value), 256, 2048);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Config: byte cache size is " + this.getByteCacheSize()), (Object[])new Object[0]);
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, (String)(this.getClass().getName() + ".parseByteCacheSize"), (String)"1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event((TraceComponent)tc, (String)("Config: Invalid bytecache setting of " + value), (Object[])new Object[0]);
                }
            }
        }
    }

    private void parseDelayedExtract(Map<Object, Object> props) {
        Object value = props.get("extractValue");
        if (null != value) {
            this.bExtractValue = this.convertBoolean(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: header value extraction is " + this.shouldExtractValue()), (Object[])new Object[0]);
            }
        }
    }

    private void parseBinaryTransport(Map<Object, Object> props) {
        Object value = props.get("enableBinaryTransport");
        if (null != value) {
            this.bBinaryTransport = this.convertBoolean(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: binary transport is " + this.isBinaryTransportEnabled()), (Object[])new Object[0]);
            }
        }
    }

    private void parseLimitFieldSize(Map<Object, Object> props) {
        block4: {
            Object value = props.get("limitFieldSize");
            if (null != value) {
                try {
                    this.limitFieldSize = this.rangeLimit(this.convertInteger(value), 50, 32768);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Config: field size limit is " + this.getLimitOfFieldSize()), (Object[])new Object[0]);
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, (String)(this.getClass().getName() + ".parseLimitFieldSize"), (String)"1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event((TraceComponent)tc, (String)("Config: Invaild max field size setting of " + value), (Object[])new Object[0]);
                }
            }
        }
    }

    private void parseLimitNumberHeaders(Map<Object, Object> props) {
        block4: {
            Object value = props.get("limitNumHeaders");
            if (null != value) {
                try {
                    this.limitNumHeaders = this.rangeLimit(this.convertInteger(value), 50, 500);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Config: Num hdrs limit is " + this.getLimitOnNumberOfHeaders()), (Object[])new Object[0]);
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, (String)(this.getClass().getName() + ".parseLimitNumberHeaders"), (String)"1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event((TraceComponent)tc, (String)("Config: Invalid number of headers limit; " + value), (Object[])new Object[0]);
                }
            }
        }
    }

    private void parseLimitNumberResponses(Map<Object, Object> props) {
        block4: {
            Object value = props.get("LimitNumberResponses");
            if (null != value) {
                try {
                    int size = this.convertInteger(value);
                    this.limitNumResponses = -1 == size ? 50 : this.rangeLimit(size, 1, 50);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Config: Num responses limit is " + this.getLimitOnNumberOfResponses()), (Object[])new Object[0]);
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, (String)(this.getClass().getName() + ".parseLimitNumberResponses"), (String)"1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event((TraceComponent)tc, (String)("Config: Invalid max number of responses; " + value), (Object[])new Object[0]);
                }
            }
        }
    }

    private void parseLimitMessageSize(Map<Object, Object> props) {
        block4: {
            Object value = props.get("MessageSizeLimit");
            if (null != value) {
                try {
                    this.limitMessageSize = this.convertLong(value);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Config: Message size limit is " + this.getMessageSizeLimit()), (Object[])new Object[0]);
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, (String)(this.getClass().getName() + ".parseLimitMessageSize"), (String)"1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event((TraceComponent)tc, (String)("Config: Invalid message size limit; " + value), (Object[])new Object[0]);
                }
            }
        }
    }

    public long getMessageSizeLimit() {
        return this.limitMessageSize;
    }

    private void parseAccessLog(Map<Object, Object> props) {
        String id = (String)props.get("accessLogID");
        if (id != null) {
            AtomicReference<AccessLog> aLog = HttpEndpointImpl.getAccessLogger(id);
            if (aLog != null) {
                this.accessLogger = aLog;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Config: using logging service", (Object[])new Object[]{this.accessLogger});
            }
        }
    }

    private void parseSameSiteConfig(Map<Object, Object> props) {
        Object value = props.get("sameSiteInternal");
        if (null != value) {
            this.useSameSiteConfig = this.convertBoolean(value);
            if (this.useSameSiteConfig) {
                this.sameSiteCookies = new HashMap<String, String>();
                this.sameSiteErrorCookies = new HashSet<String>();
                this.sameSiteStringPatterns = new HashMap<String, String>();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Http Channel Config: SameSite configuration has been enabled", (Object[])new Object[0]);
                }
            }
        }
    }

    private void parseCookiesSameSiteLax(Map<Object, Object> props) {
        Object value = props.get("sameSiteLaxInternal");
        if (null != value && this.useSameSiteConfig) {
            if (value instanceof String[]) {
                String[] cookies;
                for (String s : cookies = (String[])value) {
                    this.addSameSiteAttribute(s, HttpConfigConstants.SameSite.LAX);
                }
            }
            if (this.useSameSiteConfig && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Http Channel Config: SameSite Lax configuration parsed.", (Object[])new Object[0]);
            }
        }
    }

    private void parseCookiesSameSiteNone(Map<Object, Object> props) {
        Object value = props.get("sameSiteNoneInternal");
        if (null != value && this.useSameSiteConfig) {
            if (value instanceof String[]) {
                String[] cookies;
                for (String s : cookies = (String[])value) {
                    this.addSameSiteAttribute(s, HttpConfigConstants.SameSite.NONE);
                }
            }
            if (this.useSameSiteConfig && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Http Channel Config: SameSite None configuration parsed.", (Object[])new Object[0]);
            }
        }
    }

    private void parseCookiesSameSiteStrict(Map<Object, Object> props) {
        Object value = props.get("sameSiteStrictInternal");
        if (null != value && this.useSameSiteConfig) {
            if (value instanceof String[]) {
                String[] cookies;
                for (String s : cookies = (String[])value) {
                    this.addSameSiteAttribute(s, HttpConfigConstants.SameSite.STRICT);
                }
            }
            if (this.useSameSiteConfig && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Http Channel Config: SameSite Strict configuration parsed.", (Object[])new Object[0]);
            }
        }
    }

    private void parseCookiesSameSitePartitioned(Map<Object, Object> props) {
        Object value = props.get("sameSitePartitionedInternal");
        if (null != value && this.useSameSiteConfig) {
            Boolean partitionedValue;
            if (value instanceof Boolean && (partitionedValue = (Boolean)value).booleanValue()) {
                this.isPartitioned = true;
            }
            if (this.useSameSiteConfig && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Http Channel Config: SameSite Partitioned configuration parsed.", (Object[])new Object[0]);
            }
        }
    }

    private void addSameSiteAttribute(String name, HttpConfigConstants.SameSite sameSiteAttribute) {
        if (this.sameSiteErrorCookies.contains(name)) {
            Tr.warning((TraceComponent)tc, (String)"cookies.samesite.knownDuplicateName", (Object[])new Object[]{name, sameSiteAttribute.getName().toLowerCase()});
        }
        if (!this.sameSiteErrorCookies.contains(name)) {
            if (name.endsWith("*") && name.indexOf("*") == name.lastIndexOf("*")) {
                if (this.sameSiteStringPatterns.containsKey(name) && !this.sameSiteStringPatterns.get(name).equals(sameSiteAttribute.getName())) {
                    this.sameSiteStringPatterns.remove(name);
                    Tr.warning((TraceComponent)tc, (String)"cookies.samesite.duplicateName", (Object[])new Object[]{name, sameSiteAttribute.getName().toLowerCase()});
                    this.sameSiteErrorCookies.add(name);
                } else if (!this.sameSiteStringPatterns.containsKey(name)) {
                    this.sameSiteStringPatterns.put(name, sameSiteAttribute.getName());
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("The duplicate pattern: " + name + " was not added again to the: " + sameSiteAttribute.getName() + " list."), (Object[])new Object[0]);
                }
            } else if (name.contains("*")) {
                Tr.warning((TraceComponent)tc, (String)"cookies.samesite.unsupportedWildcard", (Object[])new Object[]{name});
                this.sameSiteErrorCookies.add(name);
            } else if (this.sameSiteCookies.containsKey(name) && !this.sameSiteCookies.get(name).equals(sameSiteAttribute.getName())) {
                this.sameSiteCookies.remove(name);
                Tr.warning((TraceComponent)tc, (String)"cookies.samesite.duplicateName", (Object[])new Object[]{name, sameSiteAttribute.getName().toLowerCase()});
                this.sameSiteErrorCookies.add(name);
            } else if (!this.sameSiteCookies.containsKey(name)) {
                this.sameSiteCookies.put(name, sameSiteAttribute.getName());
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("The duplicate cookieName: " + name + " was not added again to the: " + sameSiteAttribute.getName() + " list."), (Object[])new Object[0]);
            }
        }
    }

    private void initSameSiteCookiesPatterns() {
        if (this.useSameSiteConfig()) {
            HashMap<Pattern, String> patterns = new HashMap<Pattern, String>();
            Pattern p = null;
            String sameSiteValue = null;
            if (this.sameSiteStringPatterns.size() == 1 && this.sameSiteStringPatterns.containsKey("*")) {
                this.onlySameSiteStar = true;
                this.sameSiteCookies.put("*", this.sameSiteStringPatterns.get("*"));
            }
            if (!this.onlySameSiteStar) {
                for (String string : this.sameSiteStringPatterns.keySet()) {
                    sameSiteValue = this.sameSiteStringPatterns.get(string);
                    String string2 = string.replace("*", ".*");
                    p = Pattern.compile(string2);
                    patterns.put(p, sameSiteValue);
                }
                LinkedList list = new LinkedList(patterns.entrySet());
                Collections.sort(list, new Comparator<Map.Entry<Pattern, String>>(){

                    @Override
                    public int compare(Map.Entry<Pattern, String> pattern1, Map.Entry<Pattern, String> pattern2) {
                        return pattern1.getKey().toString().compareTo(pattern2.toString());
                    }
                });
                Collections.sort(list, new Comparator<Map.Entry<Pattern, String>>(){
                    Pattern pat = null;
                    Matcher mat = null;

                    @Override
                    public int compare(Map.Entry<Pattern, String> pattern1, Map.Entry<Pattern, String> pattern2) {
                        this.pat = pattern1.getKey();
                        this.mat = this.pat.matcher(pattern2.getKey().toString());
                        return this.mat.matches() ? 1 : -1;
                    }
                });
                this.sameSitePatterns = new LinkedHashMap<Pattern, String>();
                for (Map.Entry entry : list) {
                    this.sameSitePatterns.put((Pattern)entry.getKey(), (String)entry.getValue());
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                HashSet<String> laxCookies = new HashSet<String>();
                HashSet<String> hashSet = new HashSet<String>();
                HashSet<String> hashSet2 = new HashSet<String>();
                StringBuilder sb = new StringBuilder();
                sb.append("Http Channel Config: SameSite configuration complete. The following values are set:\n");
                for (String string : this.sameSiteCookies.keySet()) {
                    if (HttpConfigConstants.SameSite.LAX.getName().equalsIgnoreCase(this.sameSiteCookies.get(string))) {
                        laxCookies.add(string);
                    }
                    if (HttpConfigConstants.SameSite.NONE.getName().equalsIgnoreCase(this.sameSiteCookies.get(string))) {
                        hashSet.add(string);
                    }
                    if (!HttpConfigConstants.SameSite.STRICT.getName().equalsIgnoreCase(this.sameSiteCookies.get(string))) continue;
                    hashSet2.add(string);
                }
                if (this.sameSitePatterns != null) {
                    for (Pattern pattern : this.sameSitePatterns.keySet()) {
                        if (HttpConfigConstants.SameSite.LAX.getName().equalsIgnoreCase(this.sameSitePatterns.get(pattern))) {
                            laxCookies.add(pattern.toString());
                        }
                        if (HttpConfigConstants.SameSite.NONE.getName().equalsIgnoreCase(this.sameSitePatterns.get(pattern))) {
                            hashSet.add(pattern.toString());
                        }
                        if (!HttpConfigConstants.SameSite.STRICT.getName().equalsIgnoreCase(this.sameSitePatterns.get(pattern))) continue;
                        hashSet2.add(pattern.toString());
                    }
                }
                sb.append("SameSite Lax Cookies ").append(laxCookies).append("\n");
                sb.append("SameSite None Cookies ").append(hashSet).append("\n");
                sb.append("SameSite Strict Cookies ").append(hashSet2);
                if (!this.sameSiteErrorCookies.isEmpty()) {
                    sb.append("\n").append("Misconfigured SameSite cookies ").append(this.sameSiteErrorCookies);
                }
                Tr.event((TraceComponent)tc, (String)sb.toString(), (Object[])new Object[0]);
            }
        }
    }

    private void parseCompression(Map<Object, Object> props) {
        Object value = props.get("useAutoCompressionInternal");
        if (null != value) {
            this.useCompression = this.convertBoolean(value);
            if (this.useCompression) {
                this.includedCompressionContentTypes = new HashSet<String>();
                this.includedCompressionContentTypes.add("text/*");
                this.includedCompressionContentTypes.add("application/javascript");
                this.excludedCompressionContentTypes = new HashSet<String>();
            }
            if (this.useCompression && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Http Channel Config: compression has been enabled", (Object[])new Object[0]);
            }
        }
    }

    private void parseCompressionTypes(Map<Object, Object> props) {
        Object value = props.get("compressionListByTypesInternal");
        if (value != null && this.useCompression) {
            HashSet<String> configuredCompressionTypes = new HashSet<String>();
            HashSet<String> addCompressionConfig = new HashSet<String>();
            HashSet<String> removeCompressionConfig = new HashSet<String>();
            StringBuilder sb = new StringBuilder();
            boolean hasConfigError = false;
            for (String s : this.includedCompressionContentTypes) {
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append(s);
            }
            String defaultConfiguration = sb.toString();
            if (value instanceof String[]) {
                String[] filterTypes;
                for (String s : filterTypes = (String[])value) {
                    if ((s = s.trim().toLowerCase(Locale.ENGLISH)).indexOf("+") == 0) {
                        if (addCompressionConfig.add(s = s.replaceFirst("\\+", ""))) continue;
                        Tr.warning((TraceComponent)tc, (String)"compression.duplicateType", (Object[])new Object[]{s, defaultConfiguration});
                        hasConfigError = true;
                        break;
                    }
                    if (s.indexOf("-") == 0) {
                        if (removeCompressionConfig.add(s = s.replaceFirst("-", ""))) continue;
                        Tr.warning((TraceComponent)tc, (String)"compression.duplicateTypeRemoval", (Object[])new Object[]{s, defaultConfiguration});
                        hasConfigError = true;
                        break;
                    }
                    if (configuredCompressionTypes.add(s)) continue;
                    Tr.warning((TraceComponent)tc, (String)"compression.duplicateType", (Object[])new Object[]{s, defaultConfiguration});
                    hasConfigError = true;
                    break;
                }
            }
            if (!addCompressionConfig.isEmpty() && !hasConfigError) {
                if (!configuredCompressionTypes.isEmpty()) {
                    Tr.warning((TraceComponent)tc, (String)"compression.duplicateOverwriteAndAdd", (Object[])new Object[]{defaultConfiguration});
                    hasConfigError = true;
                }
                if (!hasConfigError) {
                    for (String s : addCompressionConfig) {
                        if (this.includedCompressionContentTypes.contains(s)) {
                            Tr.warning((TraceComponent)tc, (String)"compression.duplicateType", (Object[])new Object[]{s, defaultConfiguration});
                            hasConfigError = true;
                            break;
                        }
                        if (!removeCompressionConfig.contains(s)) continue;
                        Tr.warning((TraceComponent)tc, (String)"compression.duplicateTypeAddRemove", (Object[])new Object[]{s, defaultConfiguration});
                        hasConfigError = true;
                        break;
                    }
                }
            }
            if (!hasConfigError) {
                if (!configuredCompressionTypes.isEmpty()) {
                    this.includedCompressionContentTypes = configuredCompressionTypes;
                }
                if (!addCompressionConfig.isEmpty()) {
                    for (String s : addCompressionConfig) {
                        this.includedCompressionContentTypes.add(s);
                    }
                }
                if (!removeCompressionConfig.isEmpty()) {
                    this.excludedCompressionContentTypes = removeCompressionConfig;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Compression Config", (Object[])new Object[]{"compressionContentTypes updated: " + !hasConfigError});
                if (!hasConfigError) {
                    for (String s : this.includedCompressionContentTypes) {
                        Tr.event((TraceComponent)tc, (String)("Include list of content-types: " + s), (Object[])new Object[0]);
                    }
                    for (String s : this.excludedCompressionContentTypes) {
                        Tr.event((TraceComponent)tc, (String)("Exclude list of content-types: " + s), (Object[])new Object[0]);
                    }
                }
            }
        }
    }

    private void parseCompressionPreferredAlgorithm(Map<Object, Object> props) {
        String value = (String)props.get("serverPreferredAlgorithmInternal");
        if (null != value && this.useCompression) {
            boolean isSupportedConfiguration = true;
            switch (value.toLowerCase(Locale.ENGLISH)) {
                case "gzip": {
                    break;
                }
                case "deflate": {
                    break;
                }
                case "x-gzip": {
                    break;
                }
                case "identity": {
                    break;
                }
                case "zlib": {
                    break;
                }
                case "none": {
                    break;
                }
                default: {
                    Tr.warning((TraceComponent)tc, (String)"compression.unsupportedAlgorithm", (Object[])new Object[]{value, this.preferredCompressionAlgorithm});
                    isSupportedConfiguration = false;
                }
            }
            if (isSupportedConfiguration) {
                this.preferredCompressionAlgorithm = value.toLowerCase();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Compression Config", (Object[])new Object[]{"preferred compression algorithm set to: " + this.preferredCompressionAlgorithm});
            }
        }
    }

    private void parseRemoteIp(Map<Object, Object> props) {
        Object value = props.get("useRemoteIpInternal");
        if (null != value) {
            this.useForwardingHeaders = this.convertBoolean(value);
            if (this.useForwardingHeaders && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"HTTP Channel Config: remoteIp has been enabled", (Object[])new Object[0]);
            }
        }
    }

    private void parseRemoteIpProxies(Map<Object, Object> props) {
        String value = (String)props.get("proxiesInternal");
        if (null != value) {
            this.proxiesRegex = value;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("RemoteIp Config: proxies regex set to: " + value), (Object[])new Object[0]);
            }
        }
        if (this.useForwardingHeaders) {
            this.proxiesPattern = Pattern.compile(this.proxiesRegex);
        }
    }

    private void parseRemoteIpAccessLog(Map<Object, Object> props) {
        Object value = props.get("useRemoteIpInAccessLogInternal");
        if (null != value) {
            this.useForwardingHeadersInAccessLog = this.convertBoolean(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("RemoteIp Config: useRemoteIpInAccessLog set to: " + this.useForwardingHeadersInAccessLog), (Object[])new Object[0]);
            }
        }
    }

    private void parseHeaders(Map<Object, Object> props) {
        Object value = props.get("headersInternal");
        if (null != value) {
            this.isHeadersConfigEnabled = this.convertBoolean(value);
            if (this.isHeadersConfigEnabled) {
                this.configuredHeadersToAdd = new HashMap<Integer, List<Map.Entry<String, String>>>();
                this.configuredHeadersToSet = new HashMap<Integer, Map.Entry<String, String>>();
                this.configuredHeadersToSetIfMissing = new HashMap<Integer, Map.Entry<String, String>>();
                this.configuredHeadersToRemove = new HashMap<Integer, String>();
                this.configuredHeadersErrorSet = new HashSet();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Http Channel Config: <headers> config has been enabled", (Object[])new Object[0]);
                }
                this.parseHeadersToRemove(props);
                this.parseHeadersToAdd(props);
                this.parseHeadersToSet(props);
                this.parseHeadersToSetIfMissing(props);
                this.logHeadersConfig();
            }
        }
    }

    private void parseHeadersToRemove(Map<Object, Object> props) {
        Object value = props.get("headersRemoveInternal");
        if (null != value && this.isHeadersConfigEnabled) {
            if (value instanceof String[]) {
                String[] headers;
                for (String headerName : headers = (String[])value) {
                    if (headerName.isEmpty()) {
                        Tr.warning((TraceComponent)tc, (String)"headers.emptyName", (Object[])new Object[]{"remove"});
                        continue;
                    }
                    int hashcode = headerName.trim().toLowerCase().hashCode();
                    if (this.configuredHeadersToRemove.containsKey(hashcode)) continue;
                    this.configuredHeadersToRemove.put(hashcode, headerName);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                    Tr.event((TraceComponent)tc, (String)("Headers remove configuration: parsed name [" + headerName + "]"), (Object[])new Object[0]);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Http Headers Config: <headers> remove configuration finished parsing.", (Object[])new Object[0]);
            }
        }
    }

    private void parseHeadersToAdd(Map<Object, Object> props) {
        Object value = props.get("headersAddInternal");
        if (null != value && this.isHeadersConfigEnabled) {
            if (value instanceof String[]) {
                String[] headers;
                for (String headerEntry : headers = (String[])value) {
                    this.setHeaderToCollection(headerEntry, HttpConfigConstants.Headers.ADD);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Http Headers Config: <headers> add configuration finished parsing.", (Object[])new Object[0]);
            }
        }
    }

    private void parseHeadersToSet(Map<Object, Object> props) {
        Object value = props.get("headersSetInternal");
        if (null != value && this.isHeadersConfigEnabled && value instanceof String[]) {
            String[] headers;
            for (String headerEntry : headers = (String[])value) {
                this.setHeaderToCollection(headerEntry, HttpConfigConstants.Headers.SET);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Http Headers Config: <headers> set configuration finished parsing.", (Object[])new Object[0]);
            }
        }
    }

    private void parseHeadersToSetIfMissing(Map<Object, Object> props) {
        Object value = props.get("headersSetIfMissingInternal");
        if (null != value && this.isHeadersConfigEnabled && value instanceof String[]) {
            String[] headers;
            for (String headerEntry : headers = (String[])value) {
                this.setHeaderToCollection(headerEntry, HttpConfigConstants.Headers.SET_IF_MISSING);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Http Headers Config: <headers> setIfMissing configuration finished parsing.", (Object[])new Object[0]);
            }
        }
    }

    private void logHeadersConfig() {
        if (this.isHeadersConfigEnabled && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            LinkedList<String> addHeaders = new LinkedList<String>();
            StringBuilder sb = new StringBuilder();
            sb.append("Http Channel Config: Headers configuration complete. The following values are set:\n");
            for (List<Map.Entry<String, String>> headerList : this.configuredHeadersToAdd.values()) {
                for (Map.Entry<String, String> header : headerList) {
                    addHeaders.add(header.getKey() + ":" + header.getValue());
                }
            }
            sb.append("Headers Remove ").append(this.configuredHeadersToRemove.values()).append("\n");
            sb.append("Headers Add ").append(addHeaders).append("\n");
            sb.append("Headers Set ").append(this.configuredHeadersToSet.values()).append("\n");
            sb.append("Headers SetIfMissing ").append(this.configuredHeadersToSetIfMissing.values());
            if (!this.configuredHeadersErrorSet.isEmpty()) {
                sb.append("\n").append("Misconfigured headers ").append(this.configuredHeadersErrorSet);
            }
            Tr.event((TraceComponent)tc, (String)sb.toString(), (Object[])new Object[0]);
        }
    }

    private void setHeaderToCollection(String header, HttpConfigConstants.Headers collectionType) {
        String headerName;
        int delimiterIndex = -1;
        String headerValue = null;
        delimiterIndex = header.indexOf(":");
        if (delimiterIndex == -1) {
            headerName = header.trim();
            headerValue = "";
        } else {
            headerName = header.substring(0, delimiterIndex).trim();
            headerValue = header.substring(delimiterIndex + 1).trim();
        }
        if (headerName.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"headers.emptyName", (Object[])new Object[]{collectionType.getName()});
        } else {
            String normalizedHeaderName = headerName.trim().toLowerCase();
            int headerNameHashCode = normalizedHeaderName.hashCode();
            if (this.configuredHeadersErrorSet.contains(normalizedHeaderName)) {
                Tr.warning((TraceComponent)tc, (String)"headers.knownDuplicateHeader", (Object[])new Object[]{header, collectionType.getName()});
            } else if (this.configuredHeadersToRemove.containsKey(headerNameHashCode) || this.configuredHeadersToAdd.containsKey(headerNameHashCode) && collectionType != HttpConfigConstants.Headers.ADD || this.configuredHeadersToSet.containsKey(headerNameHashCode) || this.configuredHeadersToSetIfMissing.containsKey(headerNameHashCode)) {
                this.configuredHeadersToRemove.remove(headerNameHashCode);
                this.configuredHeadersToAdd.remove(headerNameHashCode);
                this.configuredHeadersToSet.remove(headerNameHashCode);
                this.configuredHeadersToSetIfMissing.remove(headerNameHashCode);
                this.configuredHeadersErrorSet.add(normalizedHeaderName);
                Tr.warning((TraceComponent)tc, (String)"headers.duplicateHeaderName", (Object[])new Object[]{header, collectionType.getName()});
            } else {
                if (collectionType == HttpConfigConstants.Headers.ADD) {
                    if (!this.configuredHeadersToAdd.containsKey(headerNameHashCode)) {
                        this.configuredHeadersToAdd.put(headerNameHashCode, new LinkedList());
                    }
                    this.configuredHeadersToAdd.get(headerNameHashCode).add(new AbstractMap.SimpleEntry<String, String>(headerName, headerValue));
                } else if (collectionType == HttpConfigConstants.Headers.SET) {
                    this.configuredHeadersToSet.put(headerNameHashCode, new AbstractMap.SimpleEntry<String, String>(headerName, headerValue));
                } else if (collectionType == HttpConfigConstants.Headers.SET_IF_MISSING) {
                    this.configuredHeadersToSetIfMissing.put(headerNameHashCode, new AbstractMap.SimpleEntry<String, String>(headerName, headerValue));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Header " + collectionType.getName() + " configuration: parsed name [" + headerName + "] and value [" + headerValue + "]"), (Object[])new Object[0]);
                }
            }
        }
    }

    private void parseLoggingInfo(Map<Object, Object> props) {
        this.parseAccessLog(props);
    }

    private void parseAllowRetries(Map<Object, Object> props) {
        Object value = props.get("allowRetries");
        if (null != value) {
            this.bAllowRetries = this.convertBoolean(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: allow retries is " + this.allowsRetries()), (Object[])new Object[0]);
            }
        }
    }

    private void parseHeaderValidation(Map<Object, Object> props) {
        Object value = props.get("splitResponseProtection");
        if (null != value) {
            this.bHeaderValidation = this.convertBoolean(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: header validation is " + this.isHeaderValidationEnabled()), (Object[])new Object[0]);
            }
        }
    }

    private void parseJITOnlyReads(Map<Object, Object> props) {
        Object value = props.get("JITOnlyReads");
        if (null != value) {
            this.bJITOnlyReads = this.convertBoolean(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: JIT only reads is " + this.isJITOnlyReads()), (Object[])new Object[0]);
            }
        }
    }

    private void parseStrictURLFormat(Map<Object, Object> props) {
        Object value = props.get("StrictURLFormat");
        if (null != value) {
            this.bStrictURLFormat = this.convertBoolean(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: Strict URL formatting is " + this.isStrictURLFormat()), (Object[])new Object[0]);
            }
        }
    }

    private void parseServerHeader(Map<Object, Object> props) {
        Object ov;
        String value = this.getProp(props, "ServerHeaderValue");
        if (null != value && !"".equals(value)) {
            if ("DefaultServerVersion".equalsIgnoreCase(value)) {
                value = "WebSphere Application Server";
            }
            this.baServerHeaderValue = GenericUtils.getEnglishBytes(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: server header value [" + value + "]"), (Object[])new Object[0]);
            }
        }
        if (null != (ov = props.get("RemoveServerHeader"))) {
            this.bRemoveServerHeader = this.convertBoolean(ov);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: remove server header is " + this.removeServerHeader()), (Object[])new Object[0]);
            }
        }
    }

    private void parseDateHeaderRange(Map<Object, Object> props) {
        block4: {
            Object value = props.get("DateHeaderRange");
            if (null != value) {
                try {
                    this.lDateHeaderRange = this.minLimit(this.convertLong(value), 0L);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Config: date header range is " + value), (Object[])new Object[0]);
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, (String)(this.getClass().getName() + ".parseDateHeaderRange"), (String)"1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event((TraceComponent)tc, (String)("Config: Invalid date header range; " + value), (Object[])new Object[0]);
                }
            }
        }
    }

    private void parseCookieUpdate(Map<Object, Object> props) {
        Object value = props.get("NoCacheCookiesControl");
        Object value2 = props.get("CookiesConfigureNoCache");
        boolean documentedProperty = true;
        boolean originalProperty = true;
        if (null != value) {
            documentedProperty = this.convertBoolean(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: set no-cache cookie control is " + documentedProperty), (Object[])new Object[0]);
            }
        }
        if (null != value2) {
            originalProperty = this.convertBoolean(value2);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: set-cookie configures no-cache is " + originalProperty), (Object[])new Object[0]);
            }
        }
        this.bCookiesConfigureNoCache = originalProperty && documentedProperty;
    }

    private void parseHeaderChangeLimit(Map<Object, Object> props) {
        block4: {
            Object value = props.get("HeaderChangeLimit");
            if (null != value) {
                try {
                    this.headerChangeLimit = this.convertInteger(value);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Config: header change limit is " + this.getHeaderChangeLimit()), (Object[])new Object[0]);
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, (String)(this.getClass().getName() + ".parseHeaderChangeLimit"), (String)"1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event((TraceComponent)tc, (String)("Config: Invalid header change count of " + value), (Object[])new Object[0]);
                }
            }
        }
    }

    private void parseRequestSmugglingProtection(Map<Object, Object> props) {
        Object value = props.get("EnableSmugglingProtection");
        if (null != value) {
            this.bEnableSmugglingProtection = this.convertBoolean(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Config: request smuggling protection is " + this.bEnableSmugglingProtection), (Object[])new Object[0]);
            }
        }
    }

    public boolean isRequestSmugglingProtectionEnabled() {
        return this.bEnableSmugglingProtection;
    }

    private void parseAutoDecompression(Map<Object, Object> props) {
        Object value = props.get("AutoDecompression");
        if (null != value) {
            this.bAutoDecompression = this.convertBoolean(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: autodecompression is " + this.isAutoDecompressionEnabled()), (Object[])new Object[0]);
            }
        }
    }

    private void parsev0CookieDateRFC1123compat(Map<?, ?> props) {
        Object value = props.get("v0CookieDateRFC1123compat");
        if (null != value) {
            this.v0CookieDateRFC1123compat = this.convertBoolean(value);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Config: v0CookieDateRFC1123compat is " + this.isv0CookieDateRFC1123compat() + " this = " + this), (Object[])new Object[0]);
        }
    }

    private void parseSkipCookiePathQuotes(Map<?, ?> props) {
        String value = (String)props.get("SkipCookiePathQuotes");
        if (null != value) {
            this.skipCookiePathQuotes = this.convertBoolean(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: SkipCookiePathQuotes is " + this.shouldSkipCookiePathQuotes()), (Object[])new Object[0]);
            }
        }
    }

    private void parseDoNotAllowDuplicateSetCookies(Map<?, ?> props) {
        String value = (String)props.get("DoNotAllowDuplicateSetCookies");
        if (null != value) {
            this.doNotAllowDuplicateSetCookies = this.convertBoolean(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: DoNotAllowDuplicateSetCookies is " + this.doNotAllowDuplicateSetCookies()), (Object[])new Object[0]);
            }
        }
    }

    private void parseWaitForEndOfMessage(Map<Object, Object> props) {
        String value = (String)props.get("WaitForEndOfMessage");
        if (null != value) {
            this.waitForEndOfMessage = this.convertBoolean(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: PI33453:WaitForEndOfMessage is " + this.shouldWaitForEndOfMessage()), (Object[])new Object[0]);
            }
        }
    }

    private void parseRemoveCLHeaderInTempStatusRespRFC7230compat(Map<Object, Object> props) {
        String value = (String)props.get("RemoveCLHeaderInTempStatusRespRFC7230compat");
        if (null != value) {
            this.removeCLHeaderInTempStatusRespRFC7230compat = this.convertBoolean(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Config: RemoveCLHeaderInTempStatusRespRFC7230compat " + this.shouldRemoveCLHeaderInTempStatusRespRFC7230compat()), (Object[])new Object[0]);
            }
        }
    }

    private void parsePreventResponseSplit(Map<?, ?> props) {
        String value = (String)props.get("PreventReponseSplit");
        if (null != value) {
            this.preventResponseSplit = this.convertBoolean(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: PreventResponseSplit is " + this.shouldPreventResponseSplit()), (Object[])new Object[0]);
            }
        }
    }

    private void parseAttemptPurgeData(Map<Object, Object> props) {
        String value = (String)props.get("PurgeDataDuringClose");
        if (null != value) {
            this.attemptPurgeData = this.convertBoolean(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: PI11176:PurgeDataDuringClose is " + this.shouldAttemptPurgeData()), (Object[])new Object[0]);
            }
        }
    }

    private void parseThrowIOEForInboundConnections(Map<?, ?> props) {
        Object value = props.get("ThrowIOEForInboundConnections");
        if (null != value) {
            this.throwIOEForInboundConnections = this.convertBoolean(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: ThrowIOEForInboundConnections is " + this.throwIOEForInboundConnections()), (Object[])new Object[0]);
            }
        }
    }

    private void parsePurgeRemainingResponseBody(Map<?, ?> props) {
        String purgeRemainingResponseProperty = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("PurgeRemainingResponseBody");
            }
        });
        if (purgeRemainingResponseProperty != null) {
            this.purgeRemainingResponseBody = this.convertBoolean(purgeRemainingResponseProperty);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: PurgeRemainingResponseBody is " + this.shouldPurgeRemainingResponseBody()), (Object[])new Object[0]);
            }
        }
    }

    private void parseProtocolVersion(Map<?, ?> props) {
        Object protocolVersionProperty = props.get("protocolVersionInternal");
        if (null != protocolVersionProperty) {
            String protocolVersion = ((String)protocolVersionProperty).toLowerCase();
            if ("http/1.1".equals(protocolVersion)) {
                this.useH2ProtocolAttribute = Boolean.FALSE;
            } else if ("http/2".equals(protocolVersion)) {
                this.useH2ProtocolAttribute = Boolean.TRUE;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled() && this.useH2ProtocolAttribute != null) {
                Tr.event((TraceComponent)tc, (String)("HTTP Channel Config: versionProtocol has been set to " + protocolVersion), (Object[])new Object[0]);
            }
        }
    }

    private void parseDecompressionRatioLimit(Map<?, ?> props) {
        block4: {
            Object value = props.get("decompressionRatioLimit");
            if (null != value) {
                try {
                    this.decompressionRatioLimit = this.convertInteger(value);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Config: Decompression ratio limit is set to: " + this.getDecompressionRatioLimit()), (Object[])new Object[0]);
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, (String)(this.getClass().getName() + ".parseDecompressionRatioLimit"), (String)"1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event((TraceComponent)tc, (String)("Config: Invalid decompression ratio limit; " + value), (Object[])new Object[0]);
                }
            }
        }
    }

    private void parseDecompressionTolerance(Map<?, ?> props) {
        block4: {
            Object value = props.get("decompressionTolerance");
            if (null != value) {
                try {
                    this.decompressionTolerance = this.convertInteger(value);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Config: Decompression tolerance is set to: " + this.getDecompressionTolerance()), (Object[])new Object[0]);
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, (String)(this.getClass().getName() + ".parseDecompressionTolerance"), (String)"1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event((TraceComponent)tc, (String)("Config: Invalid decompression tolerance; " + value), (Object[])new Object[0]);
                }
            }
        }
    }

    public Boolean getUseH2ProtocolAttribute() {
        return this.useH2ProtocolAttribute;
    }

    public int getH2ConnectionIdleTimeout() {
        return this.http2ConnectionIdleTimeout;
    }

    public int getH2MaxFrameSize() {
        return this.http2MaxFrameSize;
    }

    public int getH2MaxConcurrentStreams() {
        return this.http2MaxConcurrentStreams;
    }

    public boolean getH2LimitWindowUpdateFrames() {
        return this.http2LimitWindowUpdateFrames;
    }

    public long getH2ConnCloseTimeout() {
        return this.http2ConnectionCloseTimeout;
    }

    public int getH2SettingsInitialWindowSize() {
        return this.http2SettingsInitialWindowSize;
    }

    public int getH2ConnectionWindowSize() {
        return this.http2ConnectionWindowSize;
    }

    public int getH2MaxResetFrames() {
        return this.http2MaxResetFrames;
    }

    public int getH2ResetFramesWindow() {
        return this.http2ResetFramesWindow;
    }

    public int getH2MaxStreamsRefused() {
        return this.http2MaxStreamsRefused;
    }

    private boolean convertBoolean(Object o) {
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return "true".equalsIgnoreCase(o.toString().trim());
    }

    private int convertInteger(Object o) {
        if (o instanceof Integer) {
            return (Integer)o;
        }
        return Integer.parseInt(o.toString().trim());
    }

    private long convertLong(Object o) {
        if (o instanceof Long) {
            return (Long)o;
        }
        return Long.parseLong(o.toString().trim());
    }

    private int rangeLimit(int size, int min, int max) {
        if (size < min) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Config: " + size + " too small"), (Object[])new Object[0]);
            }
            return min;
        }
        if (size > max) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Config: " + size + " too large"), (Object[])new Object[0]);
            }
            return max;
        }
        return size;
    }

    private int minLimit(int input, int min) {
        if (input < min) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Config: " + input + " too small."), (Object[])new Object[0]);
            }
            return min;
        }
        return input;
    }

    private long minLimit(long input, long min) {
        if (input < min) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Config: " + input + " too small."), (Object[])new Object[0]);
            }
            return min;
        }
        return input;
    }

    public int getMaximumPersistentRequests() {
        return this.maxPersistRequest;
    }

    public VersionValues getOutgoingVersion() {
        return this.outgoingHttpVersion;
    }

    public boolean isDirectBufferType() {
        return this.bDirectBuffers;
    }

    public boolean isKeepAliveEnabled() {
        return this.bKeepAliveEnabled;
    }

    public int getOutgoingHdrBufferSize() {
        return this.outgoingHdrBuffSize;
    }

    public int getIncomingHdrBufferSize() {
        return this.incomingHdrBuffSize;
    }

    public int getIncomingBodyBufferSize() {
        return this.incomingBodyBuffSize;
    }

    public int getPersistTimeout() {
        return this.persistTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public int getByteCacheSize() {
        return this.byteCacheSize;
    }

    public boolean shouldExtractValue() {
        return this.bExtractValue;
    }

    public boolean isBinaryTransportEnabled() {
        return this.bBinaryTransport;
    }

    public AccessLog getAccessLog() {
        return this.accessLogger.get();
    }

    public DebugLog getDebugLog() {
        return this.debugLogger;
    }

    public int getLimitOfFieldSize() {
        return this.limitFieldSize;
    }

    public int getLimitOnNumberOfHeaders() {
        return this.limitNumHeaders;
    }

    public int getLimitOnNumberOfResponses() {
        return this.limitNumResponses;
    }

    public boolean allowsRetries() {
        return this.bAllowRetries;
    }

    public boolean isServantRegion() {
        Objects.requireNonNull(this);
        return false;
    }

    public boolean isControlRegion() {
        Objects.requireNonNull(this);
        return false;
    }

    public boolean runningOnZOS() {
        Objects.requireNonNull(this);
        return false;
    }

    public boolean isHeaderValidationEnabled() {
        return this.bHeaderValidation;
    }

    public boolean isJITOnlyReads() {
        return this.bJITOnlyReads;
    }

    public boolean isStrictURLFormat() {
        return this.bStrictURLFormat;
    }

    public byte[] getServerHeaderValue() {
        return this.baServerHeaderValue;
    }

    public boolean removeServerHeader() {
        return this.bRemoveServerHeader;
    }

    public long getDateHeaderRange() {
        return this.lDateHeaderRange;
    }

    public boolean shouldCookiesConfigureNoCache() {
        return this.bCookiesConfigureNoCache;
    }

    public int getHeaderChangeLimit() {
        return this.headerChangeLimit;
    }

    public boolean isAutoDecompressionEnabled() {
        return this.bAutoDecompression;
    }

    public boolean isAccessLoggingEnabled() {
        return this.accessLogger.get().isStarted();
    }

    public boolean isv0CookieDateRFC1123compat() {
        return this.v0CookieDateRFC1123compat;
    }

    public boolean shouldSkipCookiePathQuotes() {
        return this.skipCookiePathQuotes;
    }

    public boolean doNotAllowDuplicateSetCookies() {
        return this.doNotAllowDuplicateSetCookies;
    }

    public boolean shouldWaitForEndOfMessage() {
        return this.waitForEndOfMessage;
    }

    public boolean shouldRemoveCLHeaderInTempStatusRespRFC7230compat() {
        return this.removeCLHeaderInTempStatusRespRFC7230compat;
    }

    public boolean shouldPreventResponseSplit() {
        return this.preventResponseSplit;
    }

    public boolean shouldAttemptPurgeData() {
        return this.attemptPurgeData;
    }

    public boolean throwIOEForInboundConnections() {
        if (this.throwIOEForInboundConnections != null) {
            return this.throwIOEForInboundConnections;
        }
        Boolean IOEForInboundConnectionsBehavior = HttpDispatcher.useIOEForInboundConnectionsBehavior();
        return IOEForInboundConnectionsBehavior != null ? IOEForInboundConnectionsBehavior : Boolean.FALSE;
    }

    public boolean shouldPurgeRemainingResponseBody() {
        return this.purgeRemainingResponseBody;
    }

    public boolean useForwardingHeaders() {
        return this.useForwardingHeaders;
    }

    public Pattern getForwardedProxiesRegex() {
        if (this.proxiesPattern == null) {
            this.proxiesPattern = Pattern.compile(this.proxiesRegex);
        }
        return this.proxiesPattern;
    }

    public boolean useForwardingHeadersInAccessLog() {
        return this.useForwardingHeadersInAccessLog && this.useForwardingHeaders;
    }

    public boolean useAutoCompression() {
        return this.useCompression;
    }

    public Pattern getCompressionQValueRegex() {
        if (this.compressionQValuePattern == null) {
            this.compressionQValuePattern = Pattern.compile("^((0(\\.\\d{0,3})?)|1(\\.0{0,3})?)$");
        }
        return this.compressionQValuePattern;
    }

    public Set<String> getCompressionContentTypes() {
        return this.includedCompressionContentTypes;
    }

    public Set<String> getExcludedCompressionContentTypes() {
        return this.excludedCompressionContentTypes;
    }

    public String getPreferredCompressionAlgorithm() {
        return this.preferredCompressionAlgorithm;
    }

    public boolean useSameSiteConfig() {
        return this.useSameSiteConfig;
    }

    public Map<String, String> getSameSiteCookies() {
        return this.sameSiteCookies == null ? new HashMap() : this.sameSiteCookies;
    }

    public Map<Pattern, String> getSameSitePatterns() {
        return this.sameSitePatterns == null ? new HashMap() : this.sameSitePatterns;
    }

    public boolean onlySameSiteStar() {
        return this.onlySameSiteStar;
    }

    public boolean getPartitioned() {
        return this.isPartitioned;
    }

    public int getDecompressionRatioLimit() {
        return this.decompressionRatioLimit;
    }

    public int getDecompressionTolerance() {
        return this.decompressionTolerance;
    }

    public boolean useHeadersConfiguration() {
        return this.isHeadersConfigEnabled;
    }

    public Map<Integer, List<Map.Entry<String, String>>> getConfiguredHeadersToAdd() {
        return this.configuredHeadersToAdd;
    }

    public Map<Integer, Map.Entry<String, String>> getConfiguredHeadersToSet() {
        return this.configuredHeadersToSet;
    }

    public Map<Integer, Map.Entry<String, String>> getConfiguredHeadersToSetIfMissing() {
        return this.configuredHeadersToSetIfMissing;
    }

    public Map<Integer, String> getConfiguredHeadersToRemove() {
        return this.configuredHeadersToRemove;
    }
}

