/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal;

import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.internal.ArtifactDownloaderUtils;
import com.ibm.ws.install.internal.ExceptionUtils;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.install.internal.MavenRepository;
import com.ibm.ws.install.internal.ProgressBar;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ArtifactDownloader
implements AutoCloseable {
    private final int PROGRESS_CHUNK = 500000;
    private final int BUFFER_SIZE = 10000;
    private final String appName = "artifactDownloader";
    private final String appVersion = "1.0.0";
    private final List<File> downloadedFiles = new ArrayList<File>();
    private static final Logger logger = InstallLogUtils.getInstallLogger();
    private final ProgressBar progressBar = ProgressBar.getInstance();
    private static Map<String, Object> envMap = null;
    private final ExecutorService executor = Executors.newFixedThreadPool(ArtifactDownloaderUtils.getNumThreads());

    ArtifactDownloader() {
    }

    private Future<String> submitDownloadRequest(String coords, String fileType, String dLocation, MavenRepository repository) {
        return this.executor.submit(() -> {
            this.synthesizeAndDownload(coords, fileType, dLocation, repository, false);
            return coords + "." + fileType;
        });
    }

    public Set<String> getMissingFeaturesFromRepo(List<String> mavenCoords, MavenRepository repository) throws InstallException {
        List<String> missingFeaturesURLs;
        this.info(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_CONTACTING_MAVEN_REPO", new Object[0]));
        String repo = this.FormatUrlSuffix(repository.getRepositoryUrl());
        HashMap<String, String> URLtoMavenCoordMap = new HashMap<String, String>();
        ArtifactDownloaderUtils.acquireFeatureURLs(mavenCoords, repo, URLtoMavenCoordMap);
        HashSet<String> missingCoords = new HashSet<String>();
        if (!this.testConnection(repository)) {
            throw ExceptionUtils.createByKey("ERROR_FAILED_TO_CONNECT_MAVEN", new Object[0]);
        }
        this.updateProgress(this.progressBar.getMethodIncrement("establishConnection"));
        this.info(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_MAVEN_REPO_CONNECTION_SUCCESSFUL", new Object[0]));
        try {
            missingFeaturesURLs = ArtifactDownloaderUtils.getMissingFiles(URLtoMavenCoordMap.keySet(), envMap);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new InstallException(e.getMessage());
        }
        if (!missingFeaturesURLs.isEmpty()) {
            ArrayList<String> missingFeatureList = new ArrayList<String>();
            for (String f : missingFeaturesURLs) {
                String featureName = ArtifactDownloaderUtils.getFileNameFromURL(f);
                String featureCoord = (String)URLtoMavenCoordMap.get(f);
                missingFeatureList.add(featureName);
                missingCoords.add(featureCoord);
            }
            this.fine("The remote repository \"" + repo.toString() + "\" is missing the following artifacts: " + ((Object)missingFeatureList).toString());
        }
        return missingCoords;
    }

    public void synthesizeAndDownloadFeatures(List<String> mavenCoords, String dLocation, MavenRepository repository) throws InstallException {
        ArrayList<Future<String>> futures = new ArrayList<Future<String>>();
        double individualSize = this.progressBar.getMethodIncrement("downloadArtifacts") / (double)(2 * mavenCoords.size());
        this.progressBar.updateMethodMap("downloadArtifacts", individualSize);
        this.info(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getMessage("MSG_BEGINNING_DOWNLOAD_FEATURES", new Object[0]));
        for (String coords : mavenCoords) {
            Future<String> future1 = this.submitDownloadRequest(coords, "esa", dLocation, repository);
            futures.add(future1);
            Future<String> future2 = this.submitDownloadRequest(coords, "pom", dLocation, repository);
            futures.add(future2);
        }
        while (!futures.isEmpty()) {
            Iterator iter = futures.iterator();
            try {
                while (iter.hasNext()) {
                    Future future = (Future)iter.next();
                    if (!future.isDone()) continue;
                    String downloadedCoords = (String)future.get();
                    this.updateProgress(individualSize);
                    this.progressBar.updateMethodMap("downloadArtifacts", this.progressBar.getMethodIncrement("downloadArtifacts") - individualSize);
                    this.fine("Finished downloading artifact: " + downloadedCoords);
                    iter.remove();
                }
                this.fine("Remaining artifacts: " + futures.size());
                Thread.sleep(300L);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new InstallException(e.getMessage());
            }
        }
        this.progressBar.manuallyUpdate();
    }

    private String FormatPathSuffix(String path) {
        String result = path;
        if (!path.endsWith(File.separator)) {
            result = result + File.separator;
        }
        return result;
    }

    private String FormatUrlSuffix(String url) {
        String result = url;
        if (!url.endsWith("/")) {
            result = result + "/";
        }
        return result;
    }

    public void synthesizeAndDownload(String mavenCoords, String filetype, String dLocation, MavenRepository repository, boolean individualDownload) throws InstallException {
        String[] checksumFormats = new String[]{"MD5", "SHA1", "SHA256"};
        dLocation = this.FormatPathSuffix(dLocation);
        String repo = this.FormatUrlSuffix(repository.getRepositoryUrl());
        String urlLocation = ArtifactDownloaderUtils.getUrlLocation(repo, mavenCoords) + "." + filetype;
        try {
            if (individualDownload) {
                if (!this.testConnection(repository)) {
                    throw ExceptionUtils.createByKey("ERROR_FAILED_TO_CONNECT_MAVEN", new Object[0]);
                }
                if (ArtifactDownloaderUtils.fileIsMissing(urlLocation, envMap)) {
                    throw ExceptionUtils.createByKey("ERROR_FAILED_TO_DOWNLOAD_ASSETS_FROM_REPO", ArtifactDownloaderUtils.getfilename(mavenCoords), filetype + " file", repository.toString());
                }
            }
            this.download(urlLocation, dLocation, checksumFormats, repository);
        }
        catch (IOException e) {
            throw new InstallException(e.getMessage());
        }
    }

    private void download(String urlLocation, String dLocation, String[] checksumFormats, MavenRepository mavenRepository) throws IOException, InstallException {
        try {
            URI uriLoc = new URI(urlLocation);
            File fileLoc = new File(urlLocation.replace(mavenRepository.toString(), dLocation));
            String filename = ArtifactDownloaderUtils.getFileNameFromURL(urlLocation);
            this.downloadInternal(uriLoc, fileLoc, mavenRepository);
            this.downloadedFiles.add(fileLoc);
            boolean someChecksumExists = false;
            boolean checksumFail = false;
            boolean checksumSuccess = false;
            HashMap<String, String> checkSumCache = new HashMap<String, String>();
            for (String checksumFormat : checksumFormats) {
                if (checksumSuccess) continue;
                if (this.checksumIsAvailable(urlLocation, checksumFormat, checkSumCache)) {
                    someChecksumExists = true;
                    if (this.isIncorrectChecksum(fileLoc.getAbsolutePath(), urlLocation, checksumFormat, checkSumCache)) {
                        this.fine("Failed to validate " + checksumFormat + " checksum for file: " + filename);
                        checksumFail = true;
                        continue;
                    }
                    checksumSuccess = true;
                    this.fine("Successfully validated " + checksumFormat + " checksum for file: " + filename);
                    continue;
                }
                this.fine("Failed to find " + checksumFormat + " checksum for file: " + filename);
            }
            if (someChecksumExists) {
                if (checksumFail) {
                    ArtifactDownloaderUtils.deleteFiles(this.downloadedFiles, dLocation, fileLoc);
                    this.downloadedFiles.clear();
                    throw ExceptionUtils.createByKey("ERROR_CHECKSUM_FAILED_MAVEN", filename);
                }
            } else {
                this.fine("No checksums found for file in remote repository");
            }
        }
        catch (URISyntaxException e) {
            throw new InstallException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new InstallException(e.getMessage());
        }
    }

    private boolean checksumIsAvailable(String urlLocation, String checksumFormat, HashMap<String, String> checkSumCache) {
        boolean result = true;
        try {
            if (checkSumCache.containsKey(checksumFormat)) {
                return true;
            }
            String checkSum = ArtifactDownloaderUtils.getPrimaryChecksum(urlLocation, checksumFormat);
            checkSumCache.put(checksumFormat, checkSum);
        }
        catch (IOException e) {
            result = false;
        }
        return result;
    }

    private boolean isIncorrectChecksum(String localFile, String urlLocation, String checksumFormat, HashMap<String, String> checkSumCache) throws NoSuchAlgorithmException {
        String checksumLocal;
        boolean result = false;
        try {
            checksumLocal = ArtifactDownloaderUtils.getChecksum(localFile, checksumFormat);
        }
        catch (IOException e) {
            return true;
        }
        String checksumOrigin = checkSumCache.get(checksumFormat);
        if (checksumOrigin == null || !checksumLocal.equals(checksumOrigin)) {
            result = true;
        }
        return result;
    }

    private void configureProxyAuthentication() {
        System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
        if (envMap.get("https.proxyUser") != null) {
            Authenticator.setDefault(new SystemPropertiesProxyAuthenticator());
        } else if (envMap.get("http.proxyUser") != null) {
            Authenticator.setDefault(new SystemPropertiesProxyHttpAuthenticator());
        }
    }

    private void configureAuthentication(final MavenRepository repository) throws InstallException {
        if (repository.getUserId() != null && repository.getPassword() != null && envMap.get("https.proxyUser") == null && envMap.get("http.proxyUser") == null) {
            final String encodedPassword = this.formatAndCheckRepositoryPassword(repository.getPassword());
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(repository.getUserId(), PasswordUtil.passwordDecode((String)encodedPassword).toCharArray());
                }
            });
        }
    }

    private String formatAndCheckRepositoryPassword(String pwd) throws InstallException {
        String crypto_algorithm = PasswordUtil.getCryptoAlgorithm((String)pwd);
        if (!pwd.startsWith("{")) {
            pwd = "{}" + pwd;
            logger.log(Level.FINE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_PWD_NOT_ENCRYPTED", new Object[0]) + InstallUtils.NEWLINE);
            return pwd;
        }
        if (PasswordUtil.passwordDecode((String)pwd) == null) {
            if (!PasswordUtil.isValidCryptoAlgorithm((String)crypto_algorithm)) {
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_PWD_CRYPTO_UNSUPPORTED", new Object[0]));
            }
            throw new InstallException(InstallLogUtils.Messages.PASSWORD_UTIL_MESSAGES.getLogMessage("PASSWORDUTIL_CYPHER_EXCEPTION", new Object[0]));
        }
        return pwd;
    }

    protected boolean testConnection(MavenRepository repository) {
        try {
            this.checkValidProxy();
            this.configureProxyAuthentication();
            this.configureAuthentication(repository);
            int responseCode = ArtifactDownloaderUtils.exists(repository.getRepositoryUrl(), envMap);
            logger.fine("Response code - " + repository.getRepositoryUrl() + ":" + responseCode);
            if (responseCode != 404) {
                return true;
            }
        }
        catch (InstallException | IOException e) {
            logger.warning(repository.getRepositoryUrl() + " cannot be connected");
            logger.fine(e.getMessage());
        }
        return false;
    }

    private void downloadInternal(URI address, File destination, MavenRepository repository) throws IOException, InstallException {
        Proxy proxy = envMap.get("https.proxyHost") != null ? new Proxy(Proxy.Type.HTTP, new InetSocketAddress((String)envMap.get("https.proxyHost"), Integer.parseInt((String)envMap.get("https.proxyPort")))) : (envMap.get("http.proxyUser") != null ? new Proxy(Proxy.Type.HTTP, new InetSocketAddress((String)envMap.get("http.proxyHost"), Integer.parseInt((String)envMap.get("http.proxyPort")))) : Proxy.NO_PROXY);
        URL url = address.toURL();
        URLConnection conn = url.openConnection(proxy);
        this.addBasicAuthentication(address, conn, repository);
        String userAgentValue = this.calculateUserAgent();
        conn.setRequestProperty("User-Agent", userAgentValue);
        conn.connect();
        destination.getParentFile().mkdirs();
        File tempFile = File.createTempFile(destination.getName(), null, destination.getParentFile());
        try (InputStream in = conn.getInputStream();
             BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tempFile));){
            int numRead;
            byte[] buffer = new byte[10000];
            long progressCounter = 0L;
            while ((numRead = in.read(buffer)) != -1) {
                if ((progressCounter += (long)numRead) / 500000L > 0L) {
                    progressCounter -= 500000L;
                }
                ((OutputStream)out).write(buffer, 0, numRead);
            }
        }
        catch (FileNotFoundException e) {
            throw ExceptionUtils.createByKey("ERROR_FAILED_TO_DOWNLOAD_FEATURE", ArtifactDownloaderUtils.getFileNameFromURL(address.toString()), destination.toString());
        }
        if (destination.exists() || !tempFile.renameTo(destination)) {
            logger.fine("Could not rename " + tempFile.getName() + " to: " + destination.getName());
            tempFile.delete();
        }
    }

    private String calculateUserAgent() {
        String javaVendor = System.getProperty("java.vendor");
        String javaVersion = System.getProperty("java.version");
        String javaVendorVersion = System.getProperty("java.vm.version");
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        String osArch = System.getProperty("os.arch");
        return String.format("%s/%s (%s;%s;%s) (%s;%s;%s)", "artifactDownloader", "1.0.0", osName, osVersion, osArch, javaVendor, javaVersion, javaVendorVersion);
    }

    private void addBasicAuthentication(URI address, URLConnection conn, MavenRepository repository) throws IOException {
        String userInfo = this.calculateUserInfo(address, repository);
        if (userInfo == null) {
            return;
        }
        conn.setRequestProperty("Authorization", "Basic " + this.base64Encode(userInfo));
    }

    private String base64Encode(String userInfo) {
        try {
            return Base64.getEncoder().encodeToString(userInfo.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException encodingException) {
            throw new RuntimeException("Failed to get bytes for user info using UTF-8.", encodingException);
        }
    }

    private String calculateUserInfo(URI uri, MavenRepository repository) {
        if (repository.getUserId() != null && repository.getPassword() != null) {
            return repository.getUserId() + ":" + repository.getPassword();
        }
        return uri.getUserInfo();
    }

    public List<File> getDownloadedEsas() {
        ArrayList<File> esaFiles = new ArrayList<File>();
        for (File f : this.downloadedFiles) {
            if (!f.getName().endsWith(".esa")) continue;
            esaFiles.add(f);
        }
        return esaFiles;
    }

    public List<File> getDownloadedPoms() {
        ArrayList<File> pomFiles = new ArrayList<File>();
        for (File f : this.downloadedFiles) {
            if (!f.getName().endsWith(".pom")) continue;
            pomFiles.add(f);
        }
        return pomFiles;
    }

    public List<File> getDownloadedFiles() {
        return this.downloadedFiles;
    }

    public void checkValidProxy() throws InstallException {
        String protocol = null;
        if (envMap.get("https.proxyUser") != null) {
            protocol = "https";
        } else if (envMap.get("http.proxyUser") != null) {
            protocol = "http";
        }
        String proxyPort = (String)envMap.get(protocol + ".proxyPort");
        if (protocol != null) {
            int proxyPortnum = Integer.parseInt(proxyPort);
            if (((String)envMap.get(protocol + ".proxyHost")).isEmpty()) {
                throw ExceptionUtils.createByKey("ERROR_TOOL_PROXY_HOST_MISSING", new Object[0]);
            }
            if (proxyPortnum < 0 || proxyPortnum > 65535) {
                throw ExceptionUtils.createByKey("ERROR_TOOL_INVALID_PROXY_PORT", proxyPort);
            }
            if (((String)envMap.get(protocol + ".proxyPassword")).isEmpty() || envMap.get(protocol + ".proxyPassword") == null) {
                throw ExceptionUtils.createByKey("ERROR_TOOL_PROXY_PWD_MISSING", new Object[0]);
            }
        }
    }

    private void updateProgress(double increment) {
        this.progressBar.updateProgress(increment);
    }

    public void setEnvMap(Map<String, Object> envMap) {
        ArtifactDownloader.envMap = envMap;
    }

    public Map<String, Object> getEnvMap() {
        return envMap;
    }

    private void info(String msg) {
        logger.info(msg);
    }

    private void fine(String msg) {
        logger.fine(msg);
    }

    private void severe(String msg) {
        logger.severe(msg);
    }

    @Override
    public void close() {
        this.executor.shutdown();
    }

    private static class SystemPropertiesProxyHttpAuthenticator
    extends Authenticator {
        private SystemPropertiesProxyHttpAuthenticator() {
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication((String)envMap.get("http.proxyUser"), ((String)envMap.get("http.proxyPassword")).toCharArray());
        }
    }

    private static class SystemPropertiesProxyAuthenticator
    extends Authenticator {
        private SystemPropertiesProxyAuthenticator() {
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication((String)envMap.get("https.proxyUser"), ((String)envMap.get("https.proxyPassword")).toCharArray());
        }
    }
}

