/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.osgi;

import com.ibm.websphere.ras.TrConfigurator;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.TraceComponentChangeListener;
import com.ibm.ws.logging.internal.osgi.CollectorManagerPipelineConfigurator;
import com.ibm.ws.logging.internal.osgi.LoggingConfigurationService;
import com.ibm.ws.logging.internal.osgi.MessageRouterConfigurator;
import com.ibm.ws.logging.internal.osgi.TrOSGiLogForwarder;
import com.ibm.ws.logging.internal.osgi.TraceComponentChangeListenerTracker;
import com.ibm.ws.logging.internal.osgi.TraceRouterConfigurator;
import com.ibm.ws.ras.instrument.internal.main.LibertyJava8WorkaroundRuntimeTransformer;
import com.ibm.ws.ras.instrument.internal.main.LibertyRuntimeTransformer;
import java.lang.instrument.Instrumentation;
import org.eclipse.equinox.log.ExtendedLogReaderService;
import org.eclipse.equinox.log.LogFilter;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogListener;

public class Activator
implements BundleActivator {
    private MessageRouterConfigurator msgRouter;
    private TraceRouterConfigurator traceRouter;
    private CollectorManagerPipelineConfigurator collectorMgrPipeConfigurator;
    private LoggingConfigurationService logCfgService;
    private static Instrumentation instrumentation;
    private static BundleContext bundleContext;
    private RuntimeTransformerComponentListener runtimeTransformer = null;
    private static TraceComponentChangeListenerTracker listenerTracker;

    public void start(BundleContext context) throws Exception {
        ServiceReference instReference = context.getServiceReference(Instrumentation.class);
        if (instReference != null) {
            instrumentation = (Instrumentation)context.getService(instReference);
            LibertyRuntimeTransformer.setInstrumentation(instrumentation);
            LibertyJava8WorkaroundRuntimeTransformer.setInstrumentation(instrumentation);
            bundleContext = context;
        } else {
            LibertyRuntimeTransformer.setInstrumentation(null);
            LibertyJava8WorkaroundRuntimeTransformer.setInstrumentation(null);
        }
        this.runtimeTransformer = new RuntimeTransformerComponentListener();
        TrConfigurator.addTraceComponentListener((TraceComponentChangeListener)this.runtimeTransformer);
        listenerTracker = new TraceComponentChangeListenerTracker(context);
        listenerTracker.open(true);
        this.logCfgService = new LoggingConfigurationService(context, instrumentation != null);
        this.msgRouter = new MessageRouterConfigurator(context);
        this.traceRouter = new TraceRouterConfigurator(context);
        this.collectorMgrPipeConfigurator = new CollectorManagerPipelineConfigurator(context);
        ExtendedLogReaderService logReader = (ExtendedLogReaderService)context.getService(context.getServiceReference(ExtendedLogReaderService.class));
        TrOSGiLogForwarder logForwarder = new TrOSGiLogForwarder();
        logReader.addLogListener((LogListener)logForwarder, (LogFilter)logForwarder);
    }

    public void stop(BundleContext context) throws Exception {
        this.msgRouter.stop();
        this.traceRouter.stop();
        if (this.logCfgService != null) {
            this.logCfgService.stop();
            this.logCfgService = null;
        }
        TrConfigurator.removeTraceComponentListener((TraceComponentChangeListener)this.runtimeTransformer);
        listenerTracker.close();
    }

    public static Instrumentation getInstrumentation() {
        return instrumentation;
    }

    public static BundleContext getBundleContex() {
        return bundleContext;
    }

    static {
        listenerTracker = null;
    }

    public static class RuntimeTransformerComponentListener
    implements TraceComponentChangeListener {
        public void traceComponentRegistered(TraceComponent tc) {
        }

        public void traceComponentUpdated(TraceComponent tc) {
            LibertyRuntimeTransformer.traceStateChanged(tc);
        }
    }
}

