/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jwt.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jwt.config.JwtConsumerConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MpConfigProperties
extends HashMap<String, String> {
    private static final TraceComponent tc = Tr.register(MpConfigProperties.class, null, null);
    private static final long serialVersionUID = 3205984119272840498L;
    public static final String ISSUER = "mp.jwt.verify.issuer";
    public static final String PUBLIC_KEY = "mp.jwt.verify.publickey";
    public static final String KEY_LOCATION = "mp.jwt.verify.publickey.location";
    public static final String PUBLIC_KEY_ALG = "mp.jwt.verify.publickey.algorithm";
    public static final String DECRYPT_KEY_LOCATION = "mp.jwt.decrypt.key.location";
    public static final String VERIFY_AUDIENCES = "mp.jwt.verify.audiences";
    public static final String TOKEN_HEADER = "mp.jwt.token.header";
    public static final String TOKEN_COOKIE = "mp.jwt.token.cookie";
    public static final String TOKEN_AGE = "mp.jwt.verify.token.age";
    public static final String CLOCK_SKEW = "mp.jwt.verify.clock.skew";
    public static final String DECRYPT_KEY_ALGORITHM = "mp.jwt.decrypt.key.algorithm";

    public MpConfigProperties() {
    }

    public MpConfigProperties(MpConfigProperties mpConfigProps) {
        super(mpConfigProps);
    }

    @Trivial
    public static Set<String> getSensitivePropertyNames() {
        HashSet<String> sensitiveProps = new HashSet<String>();
        sensitiveProps.add(DECRYPT_KEY_LOCATION);
        return sensitiveProps;
    }

    @Trivial
    public static boolean isSensitivePropertyName(String propertyName) {
        Set<String> sensitiveProps = MpConfigProperties.getSensitivePropertyNames();
        return sensitiveProps.contains(propertyName);
    }

    public String getConfiguredSignatureAlgorithm(JwtConsumerConfig config) {
        String signatureAlgorithm = config.getSignatureAlgorithm();
        if (signatureAlgorithm != null) {
            return signatureAlgorithm;
        }
        return this.getSignatureAlgorithmFromMpConfigProps();
    }

    String getSignatureAlgorithmFromMpConfigProps() {
        String defaultAlg = "RS256";
        String publicKeyAlgMpConfigProp = (String)this.get(PUBLIC_KEY_ALG);
        if (publicKeyAlgMpConfigProp == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Didn't find mp.jwt.verify.publickey.algorithm property in MP Config props; defaulting to " + defaultAlg), (Object[])new Object[0]);
            }
            return defaultAlg;
        }
        if (!this.isSupportedSignatureAlgorithm(publicKeyAlgMpConfigProp)) {
            Tr.warning((TraceComponent)tc, (String)"MP_CONFIG_PUBLIC_KEY_ALG_NOT_SUPPORTED", (Object[])new Object[]{publicKeyAlgMpConfigProp, defaultAlg, this.getSupportedSignatureAlgorithms()});
            return defaultAlg;
        }
        return publicKeyAlgMpConfigProp;
    }

    private boolean isSupportedSignatureAlgorithm(String sigAlg) {
        if (sigAlg == null) {
            return false;
        }
        return this.getSupportedSignatureAlgorithms().contains(sigAlg);
    }

    private List<String> getSupportedSignatureAlgorithms() {
        return Arrays.asList("RS256", "RS384", "RS512", "HS256", "HS384", "HS512", "ES256", "ES384", "ES512");
    }

    public List<String> getConfiguredAudiences(JwtConsumerConfig config) {
        List<String> audiences = config.getAudiences();
        if (audiences != null) {
            return audiences;
        }
        return this.getAudiencesFromMpConfigProps();
    }

    List<String> getAudiencesFromMpConfigProps() {
        String[] splitAudiences;
        ArrayList<String> audiences = null;
        String audiencesMpConfigProp = (String)this.get(VERIFY_AUDIENCES);
        if (audiencesMpConfigProp == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Didn't find mp.jwt.verify.audiences property in MP Config props; defaulting to " + audiences), (Object[])new Object[0]);
            }
            return audiences;
        }
        audiences = new ArrayList<String>();
        for (String rawAudience : splitAudiences = audiencesMpConfigProp.split(",")) {
            if (rawAudience.isEmpty()) continue;
            audiences.add(rawAudience);
        }
        return audiences;
    }

    @Override
    public String toString() {
        String string = "{";
        Set<String> sensitiveProps = MpConfigProperties.getSensitivePropertyNames();
        Iterator iter = this.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            string = string + key + "=";
            string = sensitiveProps.contains(key) ? string + "****" : string + (String)entry.getValue();
            if (!iter.hasNext()) continue;
            string = string + ", ";
        }
        string = string + "}";
        return string;
    }
}

