/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc.outbound;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.wsoc.AnnotatedEndpoint;
import com.ibm.ws.wsoc.ClientEndpointConfigCopyPerSession;
import com.ibm.ws.wsoc.EndpointHelper;
import com.ibm.ws.wsoc.ParametersOfInterest;
import com.ibm.ws.wsoc.SessionImpl;
import com.ibm.ws.wsoc.WebSocketVersionServiceManager;
import com.ibm.ws.wsoc.external.SessionExt;
import com.ibm.ws.wsoc.external.WebSocketContainerExt;
import com.ibm.ws.wsoc.external.WebSocketFactory;
import com.ibm.ws.wsoc.outbound.HttpRequestor;
import com.ibm.ws.wsoc.outbound.WsocAddress;
import com.ibm.ws.wsoc.util.Utils;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.exception.InvalidChainNameException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import javax.websocket.ClientEndpoint;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.Decoder;
import javax.websocket.DeploymentException;
import javax.websocket.Encoder;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ClientConnector {
    private static final TraceComponent tc = Tr.register(ClientConnector.class, (String)"websockets", (String)"com.ibm.ws.wsoc.internal.resources.WebSockets");
    static final long serialVersionUID = -9102252972738122641L;

    public Session connectAnnotatedClass(Object annotatedClass, URI path, WebSocketContainer wsc) throws DeploymentException, IOException {
        EndpointHelper eph = this.getAnnotatedClientEndpointClass(annotatedClass.getClass(), path.toString());
        ClientEndpointConfig endpointConfig = this.getEndpointConfig(eph);
        AnnotatedEndpoint aep = new AnnotatedEndpoint();
        aep.initialize(annotatedClass.getClass(), (EndpointConfig)endpointConfig, false);
        aep.setAppInstance(annotatedClass);
        return this.connectClass(aep, path, endpointConfig, wsc);
    }

    /*
     * WARNING - void declaration
     */
    public Session connectClass(Object clazz, URI path, ClientEndpointConfig config, WebSocketContainer wsc) throws DeploymentException, IOException {
        WsocAddress endpointAddress = new WsocAddress(path);
        endpointAddress.validateURI();
        ParametersOfInterest things = new ParametersOfInterest();
        if (WebSocketVersionServiceManager.isWsoc21rHigher()) {
            config = new ClientEndpointConfigCopyPerSession(config);
            things.setUserProperties(config.getUserProperties());
        }
        HttpRequestor requestor = new HttpRequestor(endpointAddress, config, things);
        WsByteBuffer remainingBuf = null;
        try {
            requestor.connect();
            requestor.sendRequest(things);
        }
        catch (InvalidChainNameException invalidChainNameException) {
            void ice;
            FFDCFilter.processException((Throwable)invalidChainNameException, (String)"com.ibm.ws.wsoc.outbound.ClientConnector", (String)"87", (Object)this, (Object[])new Object[]{clazz, path, config, wsc});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"client.connection.nossl", (Object[])new Object[]{endpointAddress.toString(), ice});
            throw new IOException(msg, (Throwable)ice);
        }
        catch (IOException ice) {
            void e;
            FFDCFilter.processException((Throwable)ice, (String)"com.ibm.ws.wsoc.outbound.ClientConnector", (String)"90", (Object)this, (Object[])new Object[]{clazz, path, config, wsc});
            Tr.error((TraceComponent)tc, (String)"client.connection.error", (Object[])new Object[]{endpointAddress.toString(), e.getMessage()});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"client.connection.error", (Object[])new Object[]{endpointAddress.toString(), e.getMessage()});
            IOException up = new IOException(msg, (Throwable)e);
            requestor.closeConnection(up);
            throw up;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.wsoc.outbound.ClientConnector", (String)"96", (Object)this, (Object[])new Object[]{clazz, path, config, wsc});
            Tr.error((TraceComponent)tc, (String)"client.connection.error", (Object[])new Object[]{endpointAddress.toString(), e.getMessage()});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"client.connection.error", (Object[])new Object[]{endpointAddress.toString(), e.getMessage()});
            throw new IOException(msg, e);
        }
        try {
            remainingBuf = requestor.completeResponse();
        }
        catch (IOException e) {
            void up;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.wsoc.outbound.ClientConnector", (String)"104", (Object)this, (Object[])new Object[]{clazz, path, config, wsc});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("requestor.completeResponse threw IOException of: " + up), (Object[])new Object[0]);
            }
            requestor.closeConnection((IOException)up);
            throw up;
        }
        SessionImpl sessionImpl = new SessionImpl();
        WebSocketFactory webSocketFactory = WebSocketVersionServiceManager.getWebSocketFactory();
        SessionExt sessionExt = webSocketFactory.getWebSocketSession();
        sessionExt.initialize(sessionImpl);
        sessionImpl.initialize((Endpoint)clazz, (EndpointConfig)config, requestor.getClientTransportAccess(), sessionExt, (WebSocketContainerExt)wsc, true);
        sessionImpl.setParametersOfInterest(things);
        ClassLoader cl = Utils.getContextClassloaderPrivileged();
        things.setTccl(cl);
        things.setCmd(ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData());
        sessionImpl.signalAppOnOpen(remainingBuf, true);
        return sessionExt;
    }

    /*
     * WARNING - void declaration
     */
    private ClientEndpointConfig getEndpointConfig(EndpointHelper helper) throws DeploymentException {
        ClientEndpointConfig.Builder builder = ClientEndpointConfig.Builder.create();
        if (helper.getDecoders() != null) {
            builder.decoders(helper.getDecoders());
        }
        if (helper.getEncoders() != null) {
            builder.encoders(helper.getEncoders());
        }
        if (helper.getClientEndpointConfigurator() != null) {
            try {
                builder.configurator(helper.getClientEndpointConfigurator().newInstance());
            }
            catch (Exception exception) {
                void in;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.wsoc.outbound.ClientConnector", (String)"145", (Object)this, (Object[])new Object[]{helper});
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"client.invalid.configurator", (Object[])new Object[]{helper.getClientEndpointConfigurator().getClass(), in.getMessage()});
                Tr.error((TraceComponent)tc, (String)"client.invalid.configurator", (Object[])new Object[]{helper.getClientEndpointConfigurator().getClass(), in.getMessage()});
                throw new DeploymentException(msg, (Throwable)in);
            }
        }
        if (helper.getSubprotocols() != null) {
            builder.preferredSubprotocols(Arrays.asList(helper.getSubprotocols()));
        }
        return builder.build();
    }

    private EndpointHelper getAnnotatedClientEndpointClass(Class<?> c, String contextPath) throws DeploymentException {
        String[] subprotocols;
        Class configurator;
        Class[] encoders;
        ClientEndpoint ce = c.getAnnotation(ClientEndpoint.class);
        if (ce == null) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"client.invalid.endpoint", (Object[])new Object[]{c});
            Tr.error((TraceComponent)tc, (String)"client.invalid.endpoint", (Object[])new Object[]{c});
            throw new DeploymentException(msg);
        }
        EndpointHelper helper = new EndpointHelper();
        helper.setEndpointClass(c);
        Class[] decoders = ce.decoders();
        if (decoders != null && decoders.length > 0) {
            ArrayList<Class<? extends Decoder>> list = new ArrayList<Class<? extends Decoder>>();
            for (int i = 0; i < decoders.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("found decoder of: " + decoders[i]), (Object[])new Object[0]);
                }
                list.add(decoders[i]);
            }
            helper.setDecoders(list);
        }
        if ((encoders = ce.encoders()) != null && encoders.length > 0) {
            ArrayList<Class<? extends Encoder>> list = new ArrayList<Class<? extends Encoder>>();
            for (int i = 0; i < encoders.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("found encoder of: " + encoders[i]), (Object[])new Object[0]);
                }
                list.add(encoders[i]);
            }
            helper.setEncoders(list);
        }
        if ((configurator = ce.configurator()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("found configurator of: " + configurator), (Object[])new Object[0]);
            }
            helper.setClientEndpointConfigurator(configurator);
        }
        if ((subprotocols = ce.subprotocols()) != null) {
            if (tc.isDebugEnabled()) {
                for (String protocol : subprotocols) {
                    Tr.debug((TraceComponent)tc, (String)("found a subprotocol " + protocol), (Object[])new Object[0]);
                }
            }
            helper.setSubprotocols(subprotocols);
        }
        return helper;
    }
}

