/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token.internal;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.auth.TokenExpiredException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.token.TokenService;
import com.ibm.ws.security.token.internal.AbstractTokenImpl;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.token.SingleSignonToken;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import javax.security.auth.login.LoginException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SingleSignonTokenImpl
extends AbstractTokenImpl
implements Serializable,
SingleSignonToken {
    private static final TraceComponent tc = Tr.register(SingleSignonTokenImpl.class, (String)"Token", (String)"com.ibm.ws.security.token.internal.resources.TokenMessages");
    private static final long serialVersionUID = -7144674627439090488L;
    private Token token = null;
    private final short version = (short)2;
    private transient TokenService tokenService;
    private String tokenType = null;
    private transient boolean wasDeserialized = false;

    public SingleSignonTokenImpl(TokenService tokenService, String tokenType) {
        this.tokenService = tokenService;
        this.tokenType = tokenType;
    }

    public void initializeToken(byte[] ssoToken) throws LoginException {
        this.initializeToken(ssoToken, false);
    }

    /*
     * WARNING - void declaration
     */
    public void initializeToken(byte[] ssoToken, boolean refreshIfExpired) throws LoginException {
        try {
            this.token = null;
            try {
                this.token = this.getTokenService().recreateTokenFromBytes(ssoToken);
            }
            catch (TokenExpiredException tokenExpiredException) {
                FFDCFilter.processException((Throwable)tokenExpiredException, (String)"com.ibm.ws.security.token.internal.SingleSignonTokenImpl", (String)"62", (Object)this, (Object[])new Object[]{ssoToken, refreshIfExpired});
            }
            final Token tokenPriv = this.token;
            AccessController.doPrivileged(new PrivilegedAction<Void>(){
                static final long serialVersionUID = -2996336814213237394L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Void run() {
                    SingleSignonTokenImpl.this.setToken(tokenPriv);
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.token.internal.SingleSignonTokenImpl$1", 1.class, (String)"Token", (String)"com.ibm.ws.security.token.internal.resources.TokenMessages");
                }
            });
        }
        catch (Exception tokenPriv) {
            void e;
            FFDCFilter.processException((Throwable)tokenPriv, (String)"com.ibm.ws.security.token.internal.SingleSignonTokenImpl", (String)"74", (Object)this, (Object[])new Object[]{ssoToken, refreshIfExpired});
            throw new LoginException(e.getMessage());
        }
    }

    public void initializeToken(final Token token) {
        this.token = token;
        AccessController.doPrivileged(new PrivilegedAction<Void>(){
            static final long serialVersionUID = 5763996997514101355L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Void run() {
                SingleSignonTokenImpl.this.setToken(token);
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.token.internal.SingleSignonTokenImpl$2", 2.class, (String)"Token", (String)"com.ibm.ws.security.token.internal.resources.TokenMessages");
            }
        });
    }

    @Override
    public String getName() {
        return "LtpaToken";
    }

    @Override
    public short getVersion() {
        return 2;
    }

    @Override
    public Object clone() {
        SingleSignonTokenImpl newToken = new SingleSignonTokenImpl(this.getTokenService(), this.tokenType);
        this.token = AccessController.doPrivileged(new PrivilegedAction<Token>(){
            static final long serialVersionUID = 3127249151285156770L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Token run() {
                return SingleSignonTokenImpl.this.getToken();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.token.internal.SingleSignonTokenImpl$3", 3.class, (String)"Token", (String)"com.ibm.ws.security.token.internal.resources.TokenMessages");
            }
        });
        newToken.initializeToken((Token)this.token.clone());
        return newToken;
    }

    /*
     * WARNING - void declaration
     */
    private TokenService getTokenService() {
        if (!this.wasDeserialized || this.tokenService != null) {
            return this.tokenService;
        }
        Bundle b = FrameworkUtil.getBundle(SingleSignonTokenImpl.class);
        BundleContext bc = b.getBundleContext();
        if (bc == null) {
            Tr.error((TraceComponent)tc, (String)"BUNDLE_CONTEXT_MISSING", (Object[])new Object[]{b.getSymbolicName()});
            String formattedMessage = TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.token.internal.resources.TokenMessages", (String)"BUNDLE_CONTEXT_MISSING", (Object[])new Object[]{b.getSymbolicName()}, (String)"CWWKS4004E: Could not retrieve the BundleContext for the {0} bundle. The bundle may still be loading. Try again later.");
            throw new IllegalStateException(formattedMessage);
        }
        String filter = "(tokenType=" + this.tokenType + ")";
        try {
            Collection serviceRefs = bc.getServiceReferences(TokenService.class, filter);
            if (serviceRefs.isEmpty()) {
                Tr.error((TraceComponent)tc, (String)"TOKEN_SERVICE_CONFIG_ERROR_NO_SUCH_SERVICE_TYPE", (Object[])new Object[]{this.tokenType});
                String formattedMessage = TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.token.internal.resources.TokenMessages", (String)"TOKEN_SERVICE_CONFIG_ERROR_NO_SUCH_SERVICE_TYPE", (Object[])new Object[]{this.tokenType}, (String)"CWWKS4000E: A configuration error has occurred. The requested TokenService instance of type {0} could not be found.");
                throw new IllegalArgumentException(formattedMessage);
            }
            ServiceReference serviceRef = serviceRefs.stream().reduce((first, second) -> first).orElse(null);
            this.tokenService = (TokenService)bc.getService(serviceRef);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("In readObject, set the TokenService for " + this + " to " + this.tokenService), (Object[])new Object[0]);
            }
            return this.tokenService;
        }
        catch (InvalidSyntaxException serviceRefs) {
            void e;
            FFDCFilter.processException((Throwable)serviceRefs, (String)"com.ibm.ws.security.token.internal.SingleSignonTokenImpl", (String)"165", (Object)this, (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)"OSGI_INVALID_FILTER", (Object[])new Object[]{filter, e.getMessage()});
            String formattedMessage = TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.token.internal.resources.TokenMessages", (String)"OSGI_INVALID_FILTER", (Object[])new Object[]{filter, e.getMessage()}, (String)"CWWKS4005E: There was a syntax error encountered while retrieving the TokenService using the {0} service filter: {1}");
            throw new IllegalArgumentException(formattedMessage, (Throwable)e);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.wasDeserialized = true;
    }
}

