/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jndi.startup;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.ObjectFactoryBuilder;
import org.apache.aries.jndi.AugmenterInvokerImpl;
import org.apache.aries.jndi.ContextManagerServiceFactory;
import org.apache.aries.jndi.JREInitialContextFactoryBuilder;
import org.apache.aries.jndi.OSGiInitialContextFactoryBuilder;
import org.apache.aries.jndi.OSGiObjectFactoryBuilder;
import org.apache.aries.jndi.ProviderAdminServiceFactory;
import org.apache.aries.jndi.Utils;
import org.apache.aries.jndi.spi.AugmenterInvoker;
import org.apache.aries.jndi.tracker.CachingServiceTracker;
import org.apache.aries.jndi.urls.URLObjectFactoryFinder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.service.jndi.JNDIContextManager;
import org.osgi.service.jndi.JNDIProviderAdmin;
import org.osgi.util.tracker.BundleTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Activator.class.getName());
    private static final String DISABLE_BUILDER = "org.apache.aries.jndi.disable.builder";
    private static final String FORCE_BUILDER = "org.apache.aries.jndi.force.builder";
    private static volatile Activator instance;
    private BundleTracker<ServiceCache> bundleServiceCaches;
    private CachingServiceTracker<InitialContextFactoryBuilder> icfBuilders;
    private CachingServiceTracker<URLObjectFactoryFinder> urlObjectFactoryFinders;
    private CachingServiceTracker<InitialContextFactory> initialContextFactories;
    private CachingServiceTracker<ObjectFactory> objectFactories;
    private AugmenterInvoker augmenterInvoker;
    private InitialContextFactoryBuilder originalICFBuilder;
    private OSGiInitialContextFactoryBuilder icfBuilder;
    private ObjectFactoryBuilder originalOFBuilder;
    private OSGiObjectFactoryBuilder ofBuilder;

    public static Collection<ServiceReference<InitialContextFactoryBuilder>> getInitialContextFactoryBuilderServices() {
        return Activator.instance.icfBuilders.getReferences();
    }

    public static Collection<ServiceReference<InitialContextFactory>> getInitialContextFactoryServices() {
        return Activator.instance.initialContextFactories.getReferences();
    }

    public static Collection<ServiceReference<URLObjectFactoryFinder>> getURLObjectFactoryFinderServices() {
        return Activator.instance.urlObjectFactoryFinders.getReferences();
    }

    public static ServiceReference<ObjectFactory> getUrlFactory(String scheme) {
        return Activator.instance.objectFactories.find(scheme);
    }

    public static ServiceReference<InitialContextFactory> getInitialContextFactory(String interfaceName) {
        return Activator.instance.initialContextFactories.find(interfaceName);
    }

    public static AugmenterInvoker getAugmenterInvoker() {
        return Activator.instance.augmenterInvoker;
    }

    public static <T> T getService(BundleContext context, ServiceReference<T> ref) {
        ServiceCache cache = Activator.getServiceCache(context);
        return cache.getService(ref);
    }

    public static <T> Collection<ServiceReference<T>> getReferences(BundleContext context, Class<T> clazz) {
        ServiceCache cache = Activator.getServiceCache(context);
        return cache.getReferences(clazz);
    }

    public static <T> Iterable<T> getServices(BundleContext context, Class<T> clazz) {
        ServiceCache cache = Activator.getServiceCache(context);
        if (cache == null) {
            cache = new ServiceCache(context);
        }
        Collection refs = cache.getReferences(clazz);
        return () -> Utils.map(refs.iterator(), ref -> Activator.getService(context, ref));
    }

    private static ServiceCache getServiceCache(BundleContext context) {
        ServiceCache cache = (ServiceCache)Activator.instance.bundleServiceCaches.getObject(context.getBundle());
        if (cache == null) {
            cache = new ServiceCache(context);
        }
        return cache;
    }

    public void start(BundleContext context) {
        BundleContext trackerBundleContext;
        instance = this;
        if (!Boolean.getBoolean("org.apache.aries.jndi.trackersUseLocalContext")) {
            trackerBundleContext = context.getBundle("System Bundle").getBundleContext();
            if (trackerBundleContext == null) {
                throw new IllegalStateException("Bundle could not aquire system bundle context.");
            }
        } else {
            trackerBundleContext = context;
        }
        this.bundleServiceCaches = new BundleTracker<ServiceCache>(trackerBundleContext, 56, null){

            public ServiceCache addingBundle(Bundle bundle, BundleEvent event) {
                return new ServiceCache(bundle.getBundleContext());
            }

            public void modifiedBundle(Bundle bundle, BundleEvent event, ServiceCache object) {
            }
        };
        this.bundleServiceCaches.open();
        this.initialContextFactories = new CachingServiceTracker<InitialContextFactory>(trackerBundleContext, InitialContextFactory.class, Activator::getInitialContextFactoryInterfaces);
        this.objectFactories = new CachingServiceTracker<ObjectFactory>(trackerBundleContext, ObjectFactory.class, Activator::getObjectFactorySchemes);
        this.icfBuilders = new CachingServiceTracker<InitialContextFactoryBuilder>(trackerBundleContext, InitialContextFactoryBuilder.class);
        this.urlObjectFactoryFinders = new CachingServiceTracker<URLObjectFactoryFinder>(trackerBundleContext, URLObjectFactoryFinder.class);
        if (!this.isPropertyEnabled(context, DISABLE_BUILDER)) {
            String msg;
            Object builder;
            try {
                block14: {
                    builder = new OSGiInitialContextFactoryBuilder();
                    try {
                        NamingManager.setInitialContextFactoryBuilder((InitialContextFactoryBuilder)builder);
                    }
                    catch (IllegalStateException e) {
                        if (!this.isPropertyEnabled(context, FORCE_BUILDER)) break block14;
                        this.originalICFBuilder = Activator.swapStaticField(InitialContextFactoryBuilder.class, builder);
                    }
                }
                this.icfBuilder = builder;
            }
            catch (NamingException e) {
                LOGGER.debug("A failure occurred when attempting to register an InitialContextFactoryBuilder with the NamingManager. Support for calling new InitialContext() will not be enabled.", (Throwable)e);
            }
            catch (IllegalStateException e) {
                msg = "It was not possible to register an InitialContextFactoryBuilder with the NamingManager because another builder called " + this.getClassName(InitialContextFactoryBuilder.class) + " was already registered. Support for calling new InitialContext() will not be enabled.";
                LOGGER.info(msg);
                LOGGER.debug(msg, (Throwable)e);
            }
            try {
                block15: {
                    builder = new OSGiObjectFactoryBuilder(context);
                    try {
                        NamingManager.setObjectFactoryBuilder((ObjectFactoryBuilder)builder);
                    }
                    catch (IllegalStateException e) {
                        if (!this.isPropertyEnabled(context, FORCE_BUILDER)) break block15;
                        this.originalOFBuilder = Activator.swapStaticField(ObjectFactoryBuilder.class, builder);
                    }
                }
                this.ofBuilder = builder;
            }
            catch (NamingException e) {
                LOGGER.info("A failure occurred when attempting to register an ObjectFactoryBuilder with the NamingManager. Looking up certain objects may not work correctly.", (Throwable)e);
            }
            catch (IllegalStateException e) {
                msg = "It was not possible to register an ObjectFactoryBuilder with the NamingManager because another builder called " + this.getClassName(ObjectFactoryBuilder.class) + " was already registered. Looking up certain objects may not work correctly.";
                LOGGER.info(msg);
                LOGGER.debug(msg, (Throwable)e);
            }
        }
        context.registerService(JNDIProviderAdmin.class.getName(), (Object)new ProviderAdminServiceFactory(context), null);
        context.registerService(InitialContextFactoryBuilder.class.getName(), (Object)new JREInitialContextFactoryBuilder(), null);
        context.registerService(JNDIContextManager.class.getName(), (Object)new ContextManagerServiceFactory(), null);
        this.augmenterInvoker = new AugmenterInvokerImpl(context);
        context.registerService(AugmenterInvoker.class.getName(), (Object)this.augmenterInvoker, null);
    }

    public void stop(BundleContext context) {
        this.bundleServiceCaches.close();
        if (this.icfBuilder != null) {
            Activator.swapStaticField(InitialContextFactoryBuilder.class, this.originalICFBuilder);
        }
        if (this.ofBuilder != null) {
            Activator.swapStaticField(ObjectFactoryBuilder.class, this.originalOFBuilder);
        }
        this.icfBuilders.close();
        this.urlObjectFactoryFinders.close();
        this.objectFactories.close();
        this.initialContextFactories.close();
        instance = null;
    }

    private boolean isPropertyEnabled(BundleContext context, String key) {
        String value = context.getProperty(key);
        if ("false".equals(value)) {
            return false;
        }
        if ("no".equals(value)) {
            return false;
        }
        if (null != value) {
            return true;
        }
        Object revision = context.getBundle().adapt(BundleRevision.class);
        if (!(revision instanceof BundleRevision)) {
            return false;
        }
        BundleRevision bundleRevision = (BundleRevision)revision;
        return bundleRevision.getDeclaredCapabilities(key).size() > 0;
    }

    private String getClassName(Class<?> expectedType) {
        try {
            for (Field field : NamingManager.class.getDeclaredFields()) {
                if (!expectedType.equals(field.getType())) continue;
                field.setAccessible(true);
                Object icf = field.get(null);
                return icf.getClass().getName();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "";
    }

    private static <T> T swapStaticField(Class<T> expectedType, Object value) throws IllegalStateException {
        try {
            for (Field field : NamingManager.class.getDeclaredFields()) {
                if (!expectedType.equals(field.getType())) continue;
                field.setAccessible(true);
                T original = expectedType.cast(field.get(null));
                field.set(null, value);
                return original;
            }
        }
        catch (Throwable t) {
            LOGGER.debug("Error setting field.", t);
            throw new IllegalStateException(t);
        }
        throw new IllegalStateException("Error setting field: no field found for type " + expectedType);
    }

    private static List<String> getInitialContextFactoryInterfaces(ServiceReference<InitialContextFactory> ref) {
        String[] interfaces = (String[])ref.getProperty("objectClass");
        ArrayList<String> resultList = new ArrayList<String>();
        for (String interfaceName : interfaces) {
            if (InitialContextFactory.class.getName().equals(interfaceName)) continue;
            resultList.add(interfaceName);
        }
        return resultList;
    }

    private static List<String> getObjectFactorySchemes(ServiceReference<ObjectFactory> reference) {
        List<String> result;
        Object scheme = reference.getProperty("osgi.jndi.url.scheme");
        if (scheme instanceof String) {
            result = new ArrayList<String>();
            result.add((String)scheme);
        } else {
            result = scheme instanceof String[] ? Arrays.asList((String[])scheme) : Collections.emptyList();
        }
        return result;
    }

    private static class ServiceCache {
        private final BundleContext context;
        private final Map<ServiceReference<?>, Object> cache = new ConcurrentHashMap();
        private final Map<Class<?>, CachingServiceTracker<?>> trackers = new ConcurrentHashMap();

        ServiceCache(BundleContext context) {
            this.context = context;
        }

        <T> T getService(ServiceReference<T> ref) {
            return (T)this.cache.computeIfAbsent(ref, this::doGetService);
        }

        <T> Collection<ServiceReference<T>> getReferences(Class<T> clazz) {
            return this.trackers.computeIfAbsent(clazz, c -> new CachingServiceTracker(this.context, c)).getReferences();
        }

        Object doGetService(ServiceReference<?> ref) {
            return Utils.doPrivileged(() -> this.context.getService(ref));
        }
    }
}

