/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session.store.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.session.SessionManagerConfig;
import com.ibm.ws.session.SessionStatistics;
import com.ibm.ws.session.store.cache.BuiltinSerializationInfo;
import com.ibm.ws.session.store.cache.CacheSession;
import com.ibm.ws.session.store.cache.CacheStore;
import com.ibm.ws.session.store.cache.CacheStoreService;
import com.ibm.ws.session.store.cache.SerializationInfoCache;
import com.ibm.ws.session.store.cache.SessionInfo;
import com.ibm.ws.session.store.cache.TypeConversion;
import com.ibm.ws.session.store.common.BackedHashMap;
import com.ibm.ws.session.store.common.BackedSession;
import com.ibm.wsspi.session.ISession;
import com.ibm.wsspi.session.IStore;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.EternalExpiryPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CacheHashMap
extends BackedHashMap {
    private static final long serialVersionUID = 1L;
    private static final TraceComponent tc = Tr.register(CacheHashMap.class, null, (String)"com.ibm.ws.session.store.cache.resources.WASSessionCache");
    private static final Pattern COLON = Pattern.compile(":");
    private static final Pattern PERCENT = Pattern.compile("%");
    private static final Pattern SLASH = Pattern.compile("/");
    private static final String EOLN = String.format("%n", new Object[0]);
    private static final String INVAL_KEY = ".inval";
    static final byte[] OBJECT_OUTPUT_STREAM_HEADER = new byte[]{-84, -19};
    private final boolean appDataTablesPerThread;
    final CacheStoreService cacheStoreService;
    private final IStore _iStore;
    private final SessionManagerConfig _smc;
    private Cache<String, byte[]> sessionAttributeCache;
    private Cache<String, ArrayList> sessionMetaCache;
    private String tcSessionAttrCache;
    private String tcSessionMetaCache;

    CacheHashMap(IStore store, SessionManagerConfig smc, CacheStoreService cacheStoreService) {
        super(store, smc);
        this.cacheStoreService = cacheStoreService;
        this._iStore = store;
        this._smc = smc;
        this.appDataTablesPerThread = !this._smc.writeAllProperties() && !this._smc.getEnableTimeBasedWrite();
        AccessController.doPrivileged(() -> {
            this.cacheInit();
            return null;
        });
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={CacheException.class})
    private void cacheInit() {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        try {
            String attrCacheName;
            boolean create;
            block24: {
                String metaCacheName;
                String a;
                block23: {
                    if (this.cacheStoreService.cacheManager == null) {
                        this.cacheStoreService.activateLazily();
                    }
                    a = this._iStore.getId();
                    CacheHashMap cacheHashMap = this;
                    if (Character.compare(cacheHashMap._smc.getCacheSeparator(), '%') == 0) {
                        a = PERCENT.matcher(a).replaceAll("%25");
                        a = SLASH.matcher(a).replaceAll("%2F");
                        a = COLON.matcher(a).replaceAll("%3A");
                    } else {
                        CacheHashMap cacheHashMap2 = this;
                        a = SLASH.matcher(a).replaceAll(Character.toString(cacheHashMap2._smc.getCacheSeparator()));
                        CacheHashMap cacheHashMap3 = this;
                        a = COLON.matcher(a).replaceAll(Character.toString(cacheHashMap3._smc.getCacheSeparator()));
                    }
                    metaCacheName = new StringBuilder(24 + a.length()).append("com.ibm.ws.session.meta.").append(a).toString();
                    if (trace && tc.isDebugEnabled()) {
                        CacheHashMap.tcInvoke(this.cacheStoreService.tcCacheManager, "getCache", metaCacheName, "String", "ArrayList");
                    }
                    this.sessionMetaCache = this.cacheStoreService.cacheManager.getCache(metaCacheName, String.class, ArrayList.class);
                    create = this.sessionMetaCache == null;
                    if (create) {
                        if (trace && tc.isDebugEnabled()) {
                            CacheHashMap.tcReturn(this.cacheStoreService.tcCacheManager, "getCache", "null");
                        }
                        MutableConfiguration config = new MutableConfiguration().setTypes(String.class, ArrayList.class).setExpiryPolicyFactory(EternalExpiryPolicy.factoryOf());
                        if (this.cacheStoreService.supportsStoreByReference) {
                            config = config.setStoreByValue(false);
                        }
                        try {
                            if (trace && tc.isDebugEnabled()) {
                                CacheHashMap.tcInvoke(this.cacheStoreService.tcCacheManager, "createCache", metaCacheName, config);
                            }
                            this.sessionMetaCache = this.cacheStoreService.cacheManager.createCache(metaCacheName, (Configuration)config);
                        }
                        catch (CacheException x) {
                            create = false;
                            if (trace && tc.isDebugEnabled()) {
                                CacheHashMap.tcReturn(this.cacheStoreService.tcCacheManager, "createCache", new Object[]{x});
                                CacheHashMap.tcInvoke(this.cacheStoreService.tcCacheManager, "getCache", metaCacheName, "String", "ArrayList");
                            }
                            this.sessionMetaCache = this.cacheStoreService.cacheManager.getCache(metaCacheName, String.class, ArrayList.class);
                            if (this.sessionMetaCache != null) break block23;
                            throw x;
                        }
                    }
                }
                this.tcSessionMetaCache = "MetaCache" + Integer.toHexString(System.identityHashCode(this.sessionMetaCache));
                if (trace && tc.isDebugEnabled()) {
                    CacheHashMap.tcReturn(this.cacheStoreService.tcCacheManager, create ? "createCache" : "getCache", this.tcSessionMetaCache, this.sessionMetaCache);
                }
                this.cacheStoreService.configureMonitoring(metaCacheName);
                attrCacheName = new StringBuilder(24 + a.length()).append("com.ibm.ws.session.attr.").append(a).toString();
                if (trace && tc.isDebugEnabled()) {
                    CacheHashMap.tcInvoke(this.cacheStoreService.tcCacheManager, "getCache", attrCacheName, "String", "byte[]");
                }
                this.sessionAttributeCache = this.cacheStoreService.cacheManager.getCache(attrCacheName, String.class, byte[].class);
                create = this.sessionAttributeCache == null;
                if (create) {
                    if (trace && tc.isDebugEnabled()) {
                        CacheHashMap.tcReturn(this.cacheStoreService.tcCacheManager, "getCache", "null");
                    }
                    MutableConfiguration config = new MutableConfiguration().setTypes(String.class, byte[].class).setExpiryPolicyFactory(EternalExpiryPolicy.factoryOf());
                    if (this.cacheStoreService.supportsStoreByReference) {
                        config = config.setStoreByValue(false);
                    }
                    try {
                        if (trace && tc.isDebugEnabled()) {
                            CacheHashMap.tcInvoke(this.cacheStoreService.tcCacheManager, "createCache", attrCacheName, config);
                        }
                        this.sessionAttributeCache = this.cacheStoreService.cacheManager.createCache(attrCacheName, (Configuration)config);
                    }
                    catch (CacheException x) {
                        create = false;
                        if (trace && tc.isDebugEnabled()) {
                            CacheHashMap.tcReturn(this.cacheStoreService.tcCacheManager, "createCache", new Object[]{x});
                            CacheHashMap.tcInvoke(this.cacheStoreService.tcCacheManager, "getCache", attrCacheName, "String", "byte[]");
                        }
                        this.sessionAttributeCache = this.cacheStoreService.cacheManager.getCache(attrCacheName, String.class, byte[].class);
                        if (this.sessionAttributeCache != null) break block24;
                        throw x;
                    }
                }
            }
            this.tcSessionAttrCache = "AttrCache" + Integer.toHexString(System.identityHashCode(this.sessionAttributeCache));
            if (trace && tc.isDebugEnabled()) {
                CacheHashMap.tcReturn(this.cacheStoreService.tcCacheManager, create ? "createCache" : "getCache", this.tcSessionAttrCache, this.sessionAttributeCache);
            }
            this.cacheStoreService.configureMonitoring(attrCacheName);
        }
        catch (Exception a) {
            void ex;
            FFDCFilter.processException((Throwable)a, (String)"com.ibm.ws.session.store.cache.CacheHashMap", (String)"247", (Object)((Object)this), (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)"ERROR_SESSION_INIT", (Object[])new Object[]{ex});
            throw new RuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"INTERNAL_SERVER_ERROR", (Object[])new Object[0]));
        }
    }

    @Trivial
    private static final String createSessionAttributeKey(String sessionId, String attributeId) {
        return new StringBuilder(sessionId.length() + 1 + attributeId.length()).append(sessionId).append('.').append(attributeId).toString();
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={NoSuchElementException.class})
    private void doInvalidations() {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (this.isCacheClosed(trace)) {
            return;
        }
        try {
            long now = System.currentTimeMillis();
            CacheSession pmiStatSession = null;
            SessionStatistics pmiStats = null;
            if (trace && tc.isDebugEnabled()) {
                CacheHashMap.tcInvoke(this.tcSessionMetaCache, "iterator", new Object[0]);
            }
            Iterator it = this.sessionMetaCache.iterator();
            if (trace && tc.isDebugEnabled()) {
                CacheHashMap.tcReturn(this.tcSessionMetaCache, "iterator", it);
            }
            while (it.hasNext()) {
                ArrayList value;
                Cache.Entry entry;
                if (trace && tc.isDebugEnabled()) {
                    CacheHashMap.tcInvoke(this.tcSessionMetaCache, "_iterator.next", new Object[0]);
                }
                try {
                    entry = (Cache.Entry)it.next();
                }
                catch (NoSuchElementException x) {
                    entry = null;
                }
                String id = entry == null ? null : (String)entry.getKey();
                ArrayList arrayList = value = id == null ? null : (ArrayList)entry.getValue();
                if (trace && tc.isDebugEnabled()) {
                    CacheHashMap.tcReturn(this.tcSessionMetaCache, "_iterator.next", id, value);
                }
                if (id == null || INVAL_KEY.equals(id) || value == null) continue;
                SessionInfo sessionInfo = new SessionInfo(value);
                long lastAccessTime = sessionInfo.getLastAccess();
                short listenerTypes = sessionInfo.getListenerTypes();
                int maxInactiveTime = sessionInfo.getMaxInactiveTime();
                if ((listenerTypes & 1) != 0 || maxInactiveTime < 0 || (long)maxInactiveTime >= (now - lastAccessTime) / 1000L) continue;
                if (now + this._smc.getInvalidationCheckInterval() * 1000L > System.currentTimeMillis()) {
                    Set<String> propIds;
                    if (trace && tc.isDebugEnabled()) {
                        CacheHashMap.tcInvoke(this.tcSessionMetaCache, "remove", id, value);
                    }
                    boolean removed = this.sessionMetaCache.remove((Object)id, (Object)value);
                    if (trace && tc.isDebugEnabled()) {
                        CacheHashMap.tcReturn(this.tcSessionMetaCache, "remove", removed);
                    }
                    if (removed && (propIds = sessionInfo.getSessionPropertyIds()) != null && !propIds.isEmpty()) {
                        HashSet<String> propKeys = new HashSet<String>();
                        for (String propId : propIds) {
                            propKeys.add(CacheHashMap.createSessionAttributeKey(id, propId));
                        }
                        if (trace && tc.isDebugEnabled()) {
                            CacheHashMap.tcInvoke(this.tcSessionAttrCache, "removeAll", propKeys);
                        }
                        this.sessionAttributeCache.removeAll(propKeys);
                        if (trace && tc.isDebugEnabled()) {
                            CacheHashMap.tcReturn(this.tcSessionAttrCache, "removeAll", new Object[0]);
                        }
                    }
                    this.superRemove(id);
                    long createTime = sessionInfo.getCreationTime();
                    if (pmiStatSession == null) {
                        pmiStatSession = new CacheSession();
                    }
                    if (pmiStats == null) {
                        pmiStats = this._iStore.getSessionStatistics();
                    }
                    pmiStatSession.setId(id);
                    pmiStatSession.setCreationTime(createTime);
                    if (pmiStats == null) continue;
                    pmiStats.sessionDestroyed((ISession)pmiStatSession);
                    pmiStats.sessionDestroyedByTimeout((ISession)pmiStatSession);
                    continue;
                }
                break;
            }
        }
        catch (Exception now) {
            void x;
            FFDCFilter.processException((Throwable)now, (String)"com.ibm.ws.session.store.cache.CacheHashMap", (String)"376", (Object)((Object)this), (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)"ERROR_SESSION_INVAL", (Object[])new Object[]{x});
        }
    }

    @Trivial
    @ManualTrace
    @FFDCIgnore(value={Exception.class})
    Object getAllValues(BackedSession sess) {
        CacheHashMap cacheHashMap = this;
        boolean hideValues = cacheHashMap._smc.isHideSessionValues();
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"getAllValues", (Object[])new Object[]{sess});
        }
        String id = sess.getId();
        long startTime = System.nanoTime();
        long readSize = 0L;
        Hashtable<String, Object> h = new Hashtable<String, Object>();
        try {
            SessionStatistics pmiStats;
            Set<String> propIds;
            if (trace && tc.isDebugEnabled()) {
                CacheHashMap.tcInvoke(this.tcSessionMetaCache, "get", id);
            }
            ArrayList list = (ArrayList)this.sessionMetaCache.get((Object)id);
            if (trace && tc.isDebugEnabled()) {
                CacheHashMap.tcReturn(this.tcSessionMetaCache, "get", list);
            }
            Set<String> set = propIds = list == null ? null : new SessionInfo(list).getSessionPropertyIds();
            if (propIds != null) {
                for (String propId : propIds) {
                    Object value;
                    byte[] b;
                    if (sess.appDataRemovals != null && sess.appDataRemovals.containsKey(propId)) {
                        if (!trace || !tc.isDebugEnabled()) continue;
                        Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Found property " + propId + " in appDataRemovals, skipping query for this prop"), (Object[])new Object[0]);
                        continue;
                    }
                    if (sess.appDataChanges != null && sess.appDataChanges.containsKey(propId)) {
                        if (!trace || !tc.isDebugEnabled()) continue;
                        Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Found property " + propId + " in appDataChanges, skipping query for this prop"), (Object[])new Object[0]);
                        continue;
                    }
                    String attributeKey = CacheHashMap.createSessionAttributeKey(id, propId);
                    if (trace && tc.isDebugEnabled()) {
                        CacheHashMap.tcInvoke(this.tcSessionAttrCache, "get", attributeKey);
                    }
                    if ((b = (byte[])this.sessionAttributeCache.get((Object)attributeKey)) == null) {
                        if (!trace || !tc.isDebugEnabled()) continue;
                        CacheHashMap.tcReturn(this.tcSessionAttrCache, "get", "null");
                        continue;
                    }
                    try {
                        value = this.deserialize(b);
                        readSize += (long)b.length;
                        if (trace && tc.isDebugEnabled()) {
                            if (hideValues) {
                                CacheHashMap.tcReturn(this.tcSessionAttrCache, "get", "byte[" + b.length + "]");
                            } else {
                                CacheHashMap.tcReturn(this.tcSessionAttrCache, "get", b, value);
                            }
                        }
                    }
                    catch (Exception x) {
                        if (trace && tc.isDebugEnabled()) {
                            CacheHashMap.tcReturn(this.tcSessionAttrCache, "get", hideValues ? (Object)("byte[" + b.length + "]") : b);
                        }
                        FFDCFilter.processException((Throwable)x, (String)((Object)((Object)this)).getClass().getName(), (String)"91", (Object)sess, (Object[])new Object[]{hideValues ? "byte[" + b.length + "]" : TypeConversion.limitedBytesToString(b)});
                        throw x;
                    }
                    if (value == null) continue;
                    h.put(propId, value);
                }
            }
            if ((pmiStats = this._iStore.getSessionStatistics()) != null) {
                pmiStats.readTimes(readSize, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime));
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.session.store.cache.CacheHashMap.getAllValues", (String)"448", (Object)((Object)this), (Object[])new Object[]{sess});
            Tr.error((TraceComponent)tc, (String)"LOAD_VALUE_ERROR", (Object[])new Object[]{ex});
            throw new RuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"INTERNAL_SERVER_ERROR", (Object[])new Object[0]));
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"getAllValues", (Object)(hideValues ? h.keySet() : h));
        }
        return h;
    }

    public boolean getAppDataTablesPerThread() {
        return this.appDataTablesPerThread;
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={Exception.class})
    private boolean handlePropertyHits(BackedSession session) {
        block52: {
            boolean trace = TraceComponent.isAnyTracingEnabled();
            Thread t = Thread.currentThread();
            String id = session.getId();
            try {
                Set<String> propsToWrite = null;
                Hashtable tht = null;
                if (this._smc.writeAllProperties()) {
                    Map ht = session.getSwappableData();
                    propsToWrite = ht.keySet();
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"doing app changes for ALL mSwappable Data", (Object[])new Object[]{ht});
                    }
                } else if (session.appDataChanges != null) {
                    if (this.appDataTablesPerThread) {
                        tht = (Hashtable)session.appDataChanges.get(t);
                        if (tht != null) {
                            if (trace && tc.isDebugEnabled()) {
                                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("doing app changes for " + id + " on thread " + t), (Object[])new Object[0]);
                            }
                            propsToWrite = tht.keySet();
                        }
                    } else {
                        propsToWrite = session.appDataChanges.keySet();
                        if (trace && tc.isDebugEnabled()) {
                            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"doing app changes for TimeBasedWrite", (Object[])new Object[0]);
                        }
                    }
                }
                if (propsToWrite != null) {
                    for (String string : propsToWrite) {
                        SessionStatistics pmiStats;
                        long startTime = System.nanoTime();
                        if (id.equals(string)) {
                            throw new IllegalArgumentException(string);
                        }
                        String key = CacheHashMap.createSessionAttributeKey(id, string);
                        Object value = session.getSwappableData().get(string);
                        if (value == null) {
                            if (!trace || !tc.isDebugEnabled()) continue;
                            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("ignoring " + string + " because it is no longer found"), (Object[])new Object[0]);
                            continue;
                        }
                        byte[] objbuf = this.serialize(value);
                        if (trace && tc.isDebugEnabled()) {
                            CacheHashMap cacheHashMap = this;
                            boolean hideValues = cacheHashMap._smc.isHideSessionValues();
                            if (hideValues) {
                                CacheHashMap.tcInvoke(this.tcSessionAttrCache, "put", key, "byte[" + objbuf.length + "]");
                            } else {
                                CacheHashMap.tcInvoke(this.tcSessionAttrCache, "put", key, objbuf, value);
                            }
                        }
                        this.sessionAttributeCache.put((Object)key, (Object)objbuf);
                        if (trace && tc.isDebugEnabled()) {
                            CacheHashMap.tcReturn(this.tcSessionAttrCache, "put", new Object[0]);
                        }
                        if ((pmiStats = this._iStore.getSessionStatistics()) == null) continue;
                        pmiStats.writeTimes((long)objbuf.length, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime));
                    }
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)(propsToWrite.size() + " property writes are done"), (Object[])new Object[0]);
                    }
                    if (this.appDataTablesPerThread) {
                        if (session.appDataChanges != null) {
                            session.appDataChanges.remove(t);
                        }
                        if (trace && tc.isDebugEnabled()) {
                            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"remove thread from appDataChanges for thread", (Object[])new Object[]{t});
                        }
                    } else {
                        if (session.appDataChanges != null) {
                            session.appDataChanges.clear();
                        }
                        if (trace && tc.isDebugEnabled()) {
                            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"clearing appDataChanges", (Object[])new Object[0]);
                        }
                    }
                }
                Set<String> propsToRemove = null;
                if (session.appDataRemovals != null) {
                    if (!this.appDataTablesPerThread) {
                        propsToRemove = session.appDataRemovals.keySet();
                        if (trace && tc.isDebugEnabled()) {
                            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("doing app removals for " + id + " on ALL threads"), (Object[])new Object[0]);
                        }
                    } else {
                        tht = (Hashtable)session.appDataRemovals.get(t);
                        if (tht != null) {
                            if (trace && tc.isDebugEnabled()) {
                                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("doing app removals for " + id + " on thread "), (Object[])new Object[]{t});
                            }
                            propsToRemove = tht.keySet();
                        }
                    }
                    if (propsToRemove != null && !propsToRemove.isEmpty()) {
                        for (String propid : propsToRemove) {
                            if (trace && tc.isDebugEnabled()) {
                                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("deleting prop " + propid + " for session " + id), (Object[])new Object[0]);
                            }
                            String key = CacheHashMap.createSessionAttributeKey(id, propid);
                            if (trace && tc.isDebugEnabled()) {
                                CacheHashMap.tcInvoke(this.tcSessionAttrCache, "remove", key);
                            }
                            boolean removed = this.sessionAttributeCache.remove((Object)key);
                            if (!trace || !tc.isDebugEnabled()) continue;
                            CacheHashMap.tcReturn(this.tcSessionAttrCache, "remove", removed);
                        }
                    }
                    if (!this.appDataTablesPerThread) {
                        if (session.appDataRemovals != null) {
                            session.appDataRemovals.clear();
                        }
                        if (trace && tc.isDebugEnabled()) {
                            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"clearing appDataRemovals", (Object[])new Object[0]);
                        }
                    } else {
                        if (session.appDataRemovals != null) {
                            session.appDataRemovals.remove(t);
                        }
                        if (trace && tc.isDebugEnabled()) {
                            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"remove thread from appDataRemovals", (Object[])new Object[]{t});
                        }
                    }
                }
                if (propsToWrite == null && propsToRemove == null) break block52;
                long backoff = 20L;
                boolean replaced = false;
                while (!replaced) {
                    if (backoff > 500L || (backoff *= 2L) > 100L) {
                        try {
                            TimeUnit.MILLISECONDS.sleep(backoff + (long)Math.random() * backoff);
                        }
                        catch (InterruptedException objbuf) {
                            void x;
                            FFDCFilter.processException((Throwable)objbuf, (String)"com.ibm.ws.session.store.cache.CacheHashMap", (String)"643", (Object)((Object)this), (Object[])new Object[]{session});
                            FFDCFilter.processException((Throwable)x, (String)((Object)((Object)this)).getClass().getName(), (String)"324", (Object[])new Object[]{id, backoff, propsToWrite, propsToRemove});
                            throw x;
                        }
                    }
                    if (trace && tc.isDebugEnabled()) {
                        CacheHashMap.tcInvoke(this.tcSessionMetaCache, "get", id);
                    }
                    ArrayList arrayList = (ArrayList)this.sessionMetaCache.get((Object)id);
                    if (trace && tc.isDebugEnabled()) {
                        CacheHashMap.tcReturn(this.tcSessionMetaCache, "get", arrayList);
                    }
                    if (arrayList != null) {
                        SessionInfo sessionInfo = new SessionInfo(arrayList).clone();
                        if (propsToWrite != null) {
                            sessionInfo.addSessionPropertyIds(propsToWrite);
                        }
                        if (propsToRemove != null) {
                            sessionInfo.removeSessionPropertyIds(propsToRemove);
                        }
                        ArrayList<Object> newValue = sessionInfo.getArrayList();
                        if (trace && tc.isDebugEnabled()) {
                            CacheHashMap.tcInvoke(this.tcSessionMetaCache, "replace", id, arrayList, newValue);
                        }
                        replaced = this.sessionMetaCache.replace((Object)id, (Object)arrayList, newValue);
                        if (!trace || !tc.isDebugEnabled()) continue;
                        CacheHashMap.tcReturn(this.tcSessionMetaCache, "replace", replaced);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.session.store.cache.CacheHashMap.handlePropertyHits", (String)"656", (Object)((Object)this), (Object[])new Object[]{session});
                Tr.error((TraceComponent)tc, (String)"PROP_HIT_ERROR", (Object[])new Object[]{ex});
                throw new RuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"INTERNAL_SERVER_ERROR", (Object[])new Object[0]));
            }
        }
        return true;
    }

    @FFDCIgnore(value={Exception.class})
    protected void insertSession(BackedSession session) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        String id = session.getId();
        this.listenerFlagUpdate(session);
        long tmpCreationTime = session.getCreationTime();
        session.setLastWriteLastAccessTime(tmpCreationTime);
        SessionInfo sessionInfo = new SessionInfo(tmpCreationTime, session.getMaxInactiveInterval(), session.listenerFlag, session.getUserName());
        ArrayList<Object> list = sessionInfo.getArrayList();
        boolean added = false;
        try {
            if (trace && tc.isDebugEnabled()) {
                CacheHashMap.tcInvoke(this.tcSessionMetaCache, "putIfAbsent", id, list);
            }
            added = this.sessionMetaCache.putIfAbsent((Object)id, list);
            if (trace && tc.isDebugEnabled()) {
                CacheHashMap.tcReturn(this.tcSessionMetaCache, "putIfAbsent", added);
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.session.store.cache.CacheHashMap.insertSession", (String)"690", (Object)((Object)this), (Object[])new Object[]{session});
            Tr.error((TraceComponent)tc, (String)"STORE_SESS_ERROR", (Object[])new Object[]{ex});
            throw new RuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"INTERNAL_SERVER_ERROR", (Object[])new Object[0]));
        }
        if (!added) {
            throw new IllegalStateException("Cache already contains " + id);
        }
        session.needToInsert = false;
        this.removeFromRecentlyInvalidatedList(id);
        session.update = null;
        session.userWriteHit = false;
        session.maxInactWriteHit = false;
        session.listenCntHit = false;
    }

    @FFDCIgnore(value={Exception.class})
    protected boolean isPresent(String id) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        boolean contains = false;
        try {
            if (trace && tc.isDebugEnabled()) {
                CacheHashMap.tcInvoke(this.tcSessionMetaCache, "isClosed", new Object[0]);
            }
            boolean isClosed = this.sessionMetaCache.isClosed();
            if (trace && tc.isDebugEnabled()) {
                CacheHashMap.tcReturn(this.tcSessionMetaCache, "isClosed", isClosed);
            }
            if (!isClosed) {
                if (trace && tc.isDebugEnabled()) {
                    CacheHashMap.tcInvoke(this.tcSessionMetaCache, "containsKey", id);
                }
                contains = this.sessionMetaCache.containsKey((Object)id);
                if (trace && tc.isDebugEnabled()) {
                    CacheHashMap.tcReturn(this.tcSessionMetaCache, "containsKey", contains);
                }
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.session.store.cache.CacheHashMap.isPresent", (String)"709", (Object)((Object)this), (Object[])new Object[]{id});
            Tr.error((TraceComponent)tc, (String)"ERROR_CACHE_ACCESS", (Object[])new Object[]{ex});
            throw new RuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"INTERNAL_SERVER_ERROR", (Object[])new Object[0]));
        }
        return contains;
    }

    @Trivial
    @ManualTrace
    @FFDCIgnore(value={Exception.class})
    protected Object loadOneValue(String attrName, BackedSession sess) {
        Object value;
        boolean trace;
        boolean hideValues;
        block18: {
            CacheHashMap cacheHashMap = this;
            hideValues = cacheHashMap._smc.isHideSessionValues();
            trace = TraceComponent.isAnyTracingEnabled();
            if (trace && tc.isEntryEnabled()) {
                Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"loadOneValue", (Object[])new Object[]{attrName, sess});
            }
            value = null;
            try {
                byte[] bytes;
                if (((CacheSession)sess).getPopulatedAppData()) break block18;
                String id = sess.getId();
                String key = CacheHashMap.createSessionAttributeKey(id, attrName);
                if (trace && tc.isDebugEnabled()) {
                    CacheHashMap.tcInvoke(this.tcSessionAttrCache, "get", key);
                }
                if ((bytes = (byte[])this.sessionAttributeCache.get((Object)key)) == null || bytes.length == 0) {
                    if (trace && tc.isDebugEnabled()) {
                        CacheHashMap.tcReturn(this.tcSessionAttrCache, "get", new Object[]{bytes});
                    }
                } else {
                    long startTime = System.nanoTime();
                    try {
                        value = this.deserialize(bytes);
                        if (trace && tc.isDebugEnabled()) {
                            if (hideValues) {
                                CacheHashMap.tcReturn(this.tcSessionAttrCache, "get", "byte[" + bytes.length + "]");
                            } else {
                                CacheHashMap.tcReturn(this.tcSessionAttrCache, "get", bytes, value);
                            }
                        }
                    }
                    catch (Exception x) {
                        if (trace && tc.isDebugEnabled()) {
                            CacheHashMap.tcReturn(this.tcSessionAttrCache, "get", hideValues ? (Object)("byte[" + bytes.length + "]") : bytes);
                        }
                        FFDCFilter.processException((Throwable)x, (String)((Object)((Object)this)).getClass().getName(), (String)"197", (Object)sess, (Object[])new Object[]{hideValues ? Integer.valueOf(bytes.length) : TypeConversion.limitedBytesToString(bytes)});
                        throw x;
                    }
                    SessionStatistics pmiStats = this.getIStore().getSessionStatistics();
                    if (pmiStats != null) {
                        pmiStats.readTimes(bytes == null ? 0L : (long)bytes.length, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime));
                    }
                }
                if (trace && tc.isDebugEnabled()) {
                    CacheHashMap.tcInvoke(this.tcSessionMetaCache, "containsKey", id);
                }
                boolean contains = this.sessionMetaCache.containsKey((Object)id);
                if (trace && tc.isDebugEnabled()) {
                    CacheHashMap.tcReturn(this.tcSessionMetaCache, "containsKey", contains);
                }
                if (!contains) {
                    value = null;
                }
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.session.store.cache.CacheHashMap.loadOneValue", (String)"778", (Object)((Object)this), (Object[])new Object[]{sess});
                Tr.error((TraceComponent)tc, (String)"LOAD_VALUE_ERROR", (Object[])new Object[]{ex});
                throw new RuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"INTERNAL_SERVER_ERROR", (Object[])new Object[0]));
            }
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"loadOneValue", hideValues ? (value == null ? null : "not null") : value);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={Exception.class})
    protected int overQualLastAccessTimeUpdate(BackedSession sess, long nowTime) {
        int updateCount;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        String id = sess.getId();
        try {
            if (trace && tc.isDebugEnabled()) {
                CacheHashMap.tcInvoke(this.tcSessionMetaCache, "get", id);
            }
            BackedSession backedSession = sess;
            synchronized (backedSession) {
                ArrayList oldValue = (ArrayList)this.sessionMetaCache.get((Object)id);
                if (trace && tc.isDebugEnabled()) {
                    CacheHashMap.tcReturn(this.tcSessionMetaCache, "get", oldValue);
                }
                SessionInfo sessionInfo = oldValue == null ? null : new SessionInfo(oldValue).clone();
                long curAccessTime = sess.getCurrentAccessTime();
                if (sessionInfo == null || sessionInfo.getLastAccess() != curAccessTime) {
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("session current access time: " + curAccessTime), (Object[])new Object[0]);
                    }
                    updateCount = 0;
                } else if (sessionInfo.getLastAccess() >= nowTime) {
                    updateCount = 1;
                } else {
                    sessionInfo.setLastAccess(nowTime);
                    ArrayList<Object> newValue = sessionInfo.getArrayList();
                    if (trace && tc.isDebugEnabled()) {
                        CacheHashMap.tcInvoke(this.tcSessionMetaCache, "replace", id, oldValue, newValue);
                    }
                    boolean replaced = this.sessionMetaCache.replace((Object)id, (Object)oldValue, newValue);
                    if (trace && tc.isDebugEnabled()) {
                        CacheHashMap.tcReturn(this.tcSessionMetaCache, "replace", replaced);
                    }
                    if (replaced) {
                        sess.updateLastAccessTime(nowTime);
                        updateCount = 1;
                    } else {
                        updateCount = 0;
                    }
                }
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.session.store.cache.CacheHashMap.overQualLastAccessTimeUpdate", (String)"859", (Object)((Object)this), (Object[])new Object[]{sess});
            Tr.error((TraceComponent)tc, (String)"ERROR_CACHE_ACCESS", (Object[])new Object[]{ex});
            throw new RuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"INTERNAL_SERVER_ERROR", (Object[])new Object[0]));
        }
        return updateCount;
    }

    protected boolean isCacheClosed(boolean trace) {
        if (trace && tc.isDebugEnabled()) {
            CacheHashMap.tcInvoke(this.tcSessionMetaCache, "isClosed", new Object[0]);
        }
        boolean isClosed = this.sessionMetaCache.isClosed();
        if (trace && tc.isDebugEnabled()) {
            CacheHashMap.tcReturn(this.tcSessionMetaCache, "isClosed", isClosed);
        }
        return isClosed;
    }

    /*
     * WARNING - void declaration
     */
    protected void performInvalidation() {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (this.isCacheClosed(trace)) {
            return;
        }
        long now = System.currentTimeMillis();
        boolean doInvals = false;
        boolean doCacheInval = this.doScheduledInvalidation();
        try {
            if (!this._smc.getEnableEOSWrite()) {
                this.writeCachedLastAccessedTimes();
            }
            if (doCacheInval) {
                if (trace && tc.isDebugEnabled()) {
                    CacheHashMap.tcInvoke(this.tcSessionMetaCache, "get", INVAL_KEY);
                }
                ArrayList oldValue = (ArrayList)this.sessionMetaCache.get((Object)INVAL_KEY);
                if (trace && tc.isDebugEnabled()) {
                    CacheHashMap.tcReturn(this.tcSessionMetaCache, "get", oldValue);
                }
                if (oldValue == null) {
                    SessionInfo sessionInfo = new SessionInfo(now, -1, 0, null);
                    ArrayList<Object> newValue = sessionInfo.getArrayList();
                    if (trace && tc.isDebugEnabled()) {
                        CacheHashMap.tcInvoke(this.tcSessionMetaCache, "put", INVAL_KEY, newValue);
                    }
                    this.sessionMetaCache.put((Object)INVAL_KEY, newValue);
                    if (trace && tc.isDebugEnabled()) {
                        CacheHashMap.tcReturn(this.tcSessionMetaCache, "put", new Object[0]);
                    }
                    doInvals = true;
                } else {
                    SessionInfo sessionInfo = new SessionInfo(oldValue);
                    long lastTime = sessionInfo.getLastAccess();
                    long lastCheck = now - this._smc.getInvalidationCheckInterval() * 1000L;
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"lastCheck/lastTime/now", (Object[])new Object[]{lastCheck, lastTime, now});
                    }
                    if (lastCheck >= lastTime || lastTime > now) {
                        sessionInfo = sessionInfo.clone();
                        sessionInfo.setLastAccess(now);
                        ArrayList<Object> newValue = sessionInfo.getArrayList();
                        if (trace && tc.isDebugEnabled()) {
                            CacheHashMap.tcInvoke(this.tcSessionMetaCache, "replace", INVAL_KEY, oldValue, newValue);
                        }
                        doInvals = this.sessionMetaCache.replace((Object)INVAL_KEY, (Object)oldValue, newValue);
                        if (trace && tc.isDebugEnabled()) {
                            CacheHashMap.tcReturn(this.tcSessionMetaCache, "replace", doInvals);
                        }
                    }
                }
                if (doInvals) {
                    this.doInvalidations();
                    this.processInvalidListeners();
                }
            }
        }
        catch (Throwable oldValue) {
            void t;
            FFDCFilter.processException((Throwable)oldValue, (String)"com.ibm.ws.session.store.cache.CacheHashMap", (String)"1009", (Object)((Object)this), (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)"ERROR_SESSION_INVAL", (Object[])new Object[]{t});
        }
    }

    @FFDCIgnore(value={Exception.class})
    protected boolean persistSession(BackedSession session, boolean propHit) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        String id = session.getId();
        try {
            if (!(session.userWriteHit || session.maxInactWriteHit || session.listenCntHit || !this._smc.getEnableEOSWrite() || this._smc.getScheduledInvalidation() || propHit)) {
                session.update = null;
                session.userWriteHit = false;
                session.maxInactWriteHit = false;
                session.listenCntHit = false;
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"no changes", (Object[])new Object[0]);
                }
                return true;
            }
            if (propHit && !this.handlePropertyHits(session)) {
                return false;
            }
            boolean updated = false;
            while (!updated) {
                if (trace && tc.isDebugEnabled()) {
                    CacheHashMap.tcInvoke(this.tcSessionMetaCache, "get", id);
                }
                ArrayList oldValue = (ArrayList)this.sessionMetaCache.get((Object)id);
                if (trace && tc.isDebugEnabled()) {
                    CacheHashMap.tcReturn(this.tcSessionMetaCache, "get", oldValue);
                }
                if (oldValue == null) {
                    return false;
                }
                SessionInfo sessionInfo = new SessionInfo(oldValue).clone();
                if (session.userWriteHit) {
                    session.userWriteHit = false;
                    sessionInfo.setUser(session.getUserName());
                }
                if (session.maxInactWriteHit) {
                    session.maxInactWriteHit = false;
                    sessionInfo.setMaxInactiveTime(session.getMaxInactiveInterval());
                }
                if (session.listenCntHit) {
                    session.listenCntHit = false;
                    sessionInfo.setListenerTypes(session.listenerFlag);
                }
                long time = session.getCurrentAccessTime();
                if (!this._smc.getEnableEOSWrite() || this._smc.getScheduledInvalidation()) {
                    session.setLastWriteLastAccessTime(time);
                    sessionInfo.setLastAccess(time);
                }
                if (trace & tc.isDebugEnabled()) {
                    Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)id, (Object[])new Object[]{sessionInfo});
                }
                ArrayList<Object> newValue = sessionInfo.getArrayList();
                if (trace && tc.isDebugEnabled()) {
                    CacheHashMap.tcInvoke(this.tcSessionMetaCache, "replace", id, oldValue, newValue);
                }
                updated = this.sessionMetaCache.replace((Object)id, (Object)oldValue, newValue);
                if (!trace || !tc.isDebugEnabled()) continue;
                CacheHashMap.tcReturn(this.tcSessionMetaCache, "replace", updated);
            }
        }
        catch (Exception ee) {
            FFDCFilter.processException((Throwable)ee, (String)((Object)((Object)this)).getClass().getName(), (String)"272", (Object)((Object)this), (Object[])new Object[]{session});
            Tr.error((TraceComponent)tc, (String)"STORE_SESS_ERROR", (Object[])new Object[]{ee});
            return false;
        }
        return true;
    }

    @FFDCIgnore(value={Exception.class})
    private void processInvalidListeners() {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (this.isCacheClosed(trace)) {
            return;
        }
        String appName = this.getIStore().getId();
        long start = System.currentTimeMillis();
        if (trace && tc.isDebugEnabled()) {
            CacheHashMap.tcInvoke(this.tcSessionMetaCache, "iterator", new Object[0]);
        }
        Iterator it = this.sessionMetaCache.iterator();
        if (trace && tc.isDebugEnabled()) {
            CacheHashMap.tcReturn(this.tcSessionMetaCache, "iterator", it);
        }
        while (it.hasNext()) {
            ArrayList value;
            Cache.Entry entry;
            if (trace && tc.isDebugEnabled()) {
                CacheHashMap.tcInvoke(this.tcSessionMetaCache, "_iterator.next", new Object[0]);
            }
            try {
                entry = (Cache.Entry)it.next();
            }
            catch (NoSuchElementException noSuchElementException) {
                FFDCFilter.processException((Throwable)noSuchElementException, (String)"com.ibm.ws.session.store.cache.CacheHashMap", (String)"1130", (Object)((Object)this), (Object[])new Object[0]);
                entry = null;
            }
            String id = entry == null ? null : (String)entry.getKey();
            ArrayList arrayList = value = id == null ? null : (ArrayList)entry.getValue();
            if (trace && tc.isDebugEnabled()) {
                CacheHashMap.tcReturn(this.tcSessionMetaCache, "_iterator.next", id, value);
            }
            if (id == null || INVAL_KEY.equals(id) || value == null) continue;
            SessionInfo sessionInfo = new SessionInfo(value);
            long lastAccess = sessionInfo.getLastAccess();
            short listenerTypes = sessionInfo.getListenerTypes();
            int maxInactive = sessionInfo.getMaxInactiveTime();
            if ((listenerTypes & 1) == 0 || maxInactive < 0 || (long)maxInactive >= (start - lastAccess) / 1000L) continue;
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("processInvalidListeners for sessionID=" + id), (Object[])new Object[0]);
            }
            CacheSession session = new CacheSession(this, id, this._iStore.getStoreCallback());
            session.initSession(this._iStore);
            session.setIsValid(true);
            session.setIsNew(false);
            session.updateLastAccessTime(lastAccess);
            session.setCreationTime(sessionInfo.getCreationTime());
            session.internalSetMaxInactive(maxInactive);
            session.internalSetUser(sessionInfo.getUser());
            session.setListenerFlag(listenerTypes);
            long now = System.currentTimeMillis();
            lastAccess = session.getCurrentAccessTime();
            try {
                session.setIsNew(false);
                session.getSwappableListeners((short)1);
                sessionInfo = sessionInfo.clone();
                sessionInfo.setLastAccess(lastAccess);
                ArrayList<Object> list = sessionInfo.getArrayList();
                if (trace && tc.isDebugEnabled()) {
                    CacheHashMap.tcInvoke(this.tcSessionMetaCache, "remove", id, list);
                }
                boolean removed = this.sessionMetaCache.remove((Object)id, list);
                if (trace && tc.isDebugEnabled()) {
                    CacheHashMap.tcReturn(this.tcSessionMetaCache, "remove", removed);
                }
                if (removed) {
                    session.internalInvalidate(true);
                    Set<String> propIds = sessionInfo.getSessionPropertyIds();
                    if (propIds != null && !propIds.isEmpty()) {
                        HashSet<String> propKeys = new HashSet<String>();
                        for (String propId : propIds) {
                            propKeys.add(CacheHashMap.createSessionAttributeKey(id, propId));
                        }
                        if (trace && tc.isDebugEnabled()) {
                            CacheHashMap.tcInvoke(this.tcSessionAttrCache, "removeAll", propKeys);
                        }
                        this.sessionAttributeCache.removeAll(propKeys);
                        if (trace && tc.isDebugEnabled()) {
                            CacheHashMap.tcReturn(this.tcSessionAttrCache, "removeAll", new Object[0]);
                        }
                    }
                }
                if (now + this._smc.getInvalidationCheckInterval() * 500L >= System.currentTimeMillis()) continue;
                this.updateNukerTimeStamp(appName);
                now = System.currentTimeMillis();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)((Object)((Object)this)).getClass().getName(), (String)"652", (Object)((Object)this), (Object[])new Object[]{session});
                throw e;
            }
        }
    }

    @FFDCIgnore(value={Exception.class})
    protected BackedSession readFromExternal(String id) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        CacheSession sess = null;
        ArrayList value = null;
        try {
            if (trace && tc.isDebugEnabled()) {
                CacheHashMap.tcInvoke(this.tcSessionMetaCache, "get", id);
            }
            value = (ArrayList)this.sessionMetaCache.get((Object)id);
            if (trace && tc.isDebugEnabled()) {
                CacheHashMap.tcReturn(this.tcSessionMetaCache, "get", value);
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.session.store.cache.CacheHashMap.removePersistedSession", (String)"1156", (Object)((Object)this), (Object[])new Object[]{id});
            Tr.error((TraceComponent)tc, (String)"ERROR_CACHE_ACCESS", (Object[])new Object[]{ex});
            throw new RuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"INTERNAL_SERVER_ERROR", (Object[])new Object[0]));
        }
        if (value != null) {
            SessionInfo sessionInfo = new SessionInfo(value);
            sess = new CacheSession(this, id, this.getIStore().getStoreCallback());
            sess.updateLastAccessTime(sessionInfo.getLastAccess());
            sess.setCreationTime(sessionInfo.getCreationTime());
            sess.internalSetMaxInactive(sessionInfo.getMaxInactiveTime());
            sess.internalSetUser(sessionInfo.getUser());
            sess.setIsValid(true);
            sess.setListenerFlag(sessionInfo.getListenerTypes());
        }
        return sess;
    }

    @FFDCIgnore(value={Exception.class})
    protected void removePersistedSession(String id) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        this.superRemove(id);
        try {
            Set<String> propIds;
            if (trace && tc.isDebugEnabled()) {
                CacheHashMap.tcInvoke(this.tcSessionMetaCache, "getAndRemove", id);
            }
            ArrayList removed = (ArrayList)this.sessionMetaCache.getAndRemove((Object)id);
            if (trace && tc.isDebugEnabled()) {
                CacheHashMap.tcReturn(this.tcSessionMetaCache, "getAndRemove", removed);
            }
            this.addToRecentlyInvalidatedList(id);
            Set<String> set = propIds = removed == null ? null : new SessionInfo(removed).getSessionPropertyIds();
            if (propIds != null) {
                for (String propId : propIds) {
                    String attributeKey = CacheHashMap.createSessionAttributeKey(id, propId);
                    if (trace && tc.isDebugEnabled()) {
                        CacheHashMap.tcInvoke(this.tcSessionAttrCache, "remove", attributeKey);
                    }
                    this.sessionAttributeCache.remove((Object)attributeKey);
                    if (!trace || !tc.isDebugEnabled()) continue;
                    CacheHashMap.tcReturn(this.tcSessionAttrCache, "remove", new Object[0]);
                }
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.session.store.cache.CacheHashMap.removePersistedSession", (String)"1204", (Object)((Object)this), (Object[])new Object[]{id});
            Tr.error((TraceComponent)tc, (String)"ERROR_REMOVING_SESSION", (Object[])new Object[]{ex});
            throw new RuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"INTERNAL_SERVER_ERROR", (Object[])new Object[0]));
        }
    }

    int setMaxInactToZero(String sessId, String appName) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        int rc = -1;
        while (rc == -1) {
            SessionInfo sessionInfo;
            if (trace && tc.isDebugEnabled()) {
                CacheHashMap.tcInvoke(this.tcSessionMetaCache, "get", sessId);
            }
            ArrayList oldValue = (ArrayList)this.sessionMetaCache.get((Object)sessId);
            if (trace && tc.isDebugEnabled()) {
                CacheHashMap.tcReturn(this.tcSessionMetaCache, "get", oldValue);
            }
            SessionInfo sessionInfo2 = sessionInfo = oldValue == null ? null : new SessionInfo(oldValue).clone();
            if (sessionInfo == null || sessionInfo.getMaxInactiveTime() == 0) {
                rc = 0;
                continue;
            }
            sessionInfo.setMaxInactiveTime(0);
            ArrayList<Object> newValue = sessionInfo.getArrayList();
            if (trace && tc.isDebugEnabled()) {
                CacheHashMap.tcInvoke(this.tcSessionMetaCache, "replace", sessId, oldValue, newValue);
            }
            if (this.sessionMetaCache.replace((Object)sessId, (Object)oldValue, newValue)) {
                rc = 1;
            }
            if (!trace || !tc.isDebugEnabled()) continue;
            CacheHashMap.tcReturn(this.tcSessionMetaCache, "replace", rc == 1);
        }
        return rc;
    }

    @Trivial
    static final void tcInvoke(String instance, String methName, Object ... args) {
        StringBuilder b = new StringBuilder("==> ").append(instance);
        if (methName.charAt(0) != '_') {
            b.append('.');
        }
        b.append(methName).append(' ');
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                b.append(", ");
            }
            if (args[i] instanceof byte[]) {
                byte[] bytes = (byte[])args[i];
                b.append("byte[").append(bytes.length).append("]");
                if (++i >= args.length || bytes.length >= 1000) continue;
                b.append(": ").append(args[i]);
                continue;
            }
            if (args[i] instanceof Collection) {
                b.append(EOLN).append(' ');
            }
            b.append(args[i]);
        }
        Tr.debug((TraceComponent)tc, (String)b.toString(), (Object[])new Object[0]);
    }

    @Trivial
    static final void tcReturn(String instance, String methName, Object ... result) {
        StringBuilder b = new StringBuilder("<== ").append(instance);
        if (methName.charAt(0) != '_') {
            b.append('.');
        }
        b.append(methName).append(' ');
        if (result == null) {
            b.append("null");
        } else if (result.length > 0) {
            byte[] bytes;
            if (result[0] instanceof byte[]) {
                bytes = (byte[])result[0];
                b.append("byte[").append(bytes.length).append("]");
            } else {
                bytes = null;
                if (result[0] instanceof Collection) {
                    b.append(EOLN).append(' ');
                }
                b.append(result[0]);
            }
            if (result.length > 1 && (bytes == null || bytes.length < 1000)) {
                b.append(bytes == null ? (char)' ' : ':');
                if (result[1] instanceof Collection) {
                    b.append(EOLN);
                }
                b.append(' ');
                b.append(result[1]);
            }
        }
        Tr.debug((TraceComponent)tc, (String)b.toString(), (Object[])new Object[0]);
    }

    @Trivial
    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + '@' + Integer.toHexString(System.identityHashCode((Object)this)) + " for " + this._iStore.getId();
    }

    @FFDCIgnore(value={Exception.class})
    protected int updateLastAccessTime(BackedSession sess, long nowTime) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        String id = sess.getId();
        int updateCount = -1;
        try {
            while (updateCount == -1) {
                SessionInfo sessionInfo;
                if (trace && tc.isDebugEnabled()) {
                    CacheHashMap.tcInvoke(this.tcSessionMetaCache, "get", id);
                }
                ArrayList oldValue = (ArrayList)this.sessionMetaCache.get((Object)id);
                if (trace && tc.isDebugEnabled()) {
                    CacheHashMap.tcReturn(this.tcSessionMetaCache, "get", oldValue);
                }
                SessionInfo sessionInfo2 = sessionInfo = oldValue == null ? null : new SessionInfo(oldValue).clone();
                if (sessionInfo == null || sessionInfo.getLastAccess() == nowTime) {
                    updateCount = 0;
                    continue;
                }
                sessionInfo.setLastAccess(nowTime);
                ArrayList<Object> newValue = sessionInfo.getArrayList();
                if (trace && tc.isDebugEnabled()) {
                    CacheHashMap.tcInvoke(this.tcSessionMetaCache, "replace", id, oldValue, newValue);
                }
                if (this.sessionMetaCache.replace((Object)id, (Object)oldValue, newValue)) {
                    updateCount = 1;
                }
                if (!trace || !tc.isDebugEnabled()) continue;
                CacheHashMap.tcReturn(this.tcSessionMetaCache, "replace", updateCount == 1);
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.session.store.cache.CacheHashMap.updateLastAccessTime", (String)"1326", (Object)((Object)this), (Object[])new Object[]{sess});
            Tr.error((TraceComponent)tc, (String)"ERROR_CACHE_ACCESS", (Object[])new Object[]{ex});
            throw new RuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"INTERNAL_SERVER_ERROR", (Object[])new Object[0]));
        }
        return updateCount;
    }

    private void updateNukerTimeStamp(String appName) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        long now = System.currentTimeMillis();
        SessionInfo sessionInfo = new SessionInfo(now, -1, 0, null);
        ArrayList<Object> newValue = sessionInfo.getArrayList();
        if (trace && tc.isDebugEnabled()) {
            CacheHashMap.tcInvoke(this.tcSessionMetaCache, "put", INVAL_KEY, newValue);
        }
        this.sessionMetaCache.put((Object)INVAL_KEY, newValue);
        if (trace && tc.isDebugEnabled()) {
            CacheHashMap.tcReturn(this.tcSessionMetaCache, "put", new Object[0]);
        }
    }

    @FFDCIgnore(value={Exception.class})
    private void writeCachedLastAccessedTimes() throws Exception {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        Hashtable updTab = (Hashtable)this.cachedLastAccessedTimes.clone();
        this.cachedLastAccessedTimes.clear();
        Enumeration updEnum = updTab.keys();
        while (updEnum.hasMoreElements()) {
            String id = (String)updEnum.nextElement();
            Long timeObj = (Long)updTab.get(id);
            long time = timeObj;
            try {
                int updateCount = -1;
                while (updateCount == -1) {
                    SessionInfo sessionInfo;
                    if (trace && tc.isDebugEnabled()) {
                        CacheHashMap.tcInvoke(this.tcSessionMetaCache, "get", id);
                    }
                    ArrayList oldValue = (ArrayList)this.sessionMetaCache.get((Object)id);
                    if (trace && tc.isDebugEnabled()) {
                        CacheHashMap.tcReturn(this.tcSessionMetaCache, "get", oldValue);
                    }
                    SessionInfo sessionInfo2 = sessionInfo = oldValue == null ? null : new SessionInfo(oldValue).clone();
                    if (sessionInfo == null || sessionInfo.getLastAccess() >= time) {
                        updateCount = 0;
                        continue;
                    }
                    sessionInfo.setLastAccess(time);
                    ArrayList<Object> newValue = sessionInfo.getArrayList();
                    if (trace && tc.isDebugEnabled()) {
                        CacheHashMap.tcInvoke(this.tcSessionMetaCache, "replace", id, oldValue, newValue);
                    }
                    if (this.sessionMetaCache.replace((Object)id, (Object)oldValue, newValue)) {
                        updateCount = 1;
                    }
                    if (!trace || !tc.isDebugEnabled()) continue;
                    CacheHashMap.tcReturn(this.tcSessionMetaCache, "replace", updateCount == 1);
                }
            }
            catch (Exception x) {
                FFDCFilter.processException((Throwable)x, (String)((Object)((Object)this)).getClass().getName(), (String)"649", (Object)((Object)this), (Object[])new Object[]{id});
                throw x;
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    public byte[] serialize(Object value) throws IOException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        BuiltinSerializationInfo<?> info = SerializationInfoCache.lookupByClass(value.getClass());
        byte[] objbuf = null;
        if (info != null) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"serializing with custom objectToBytes", (Object[])new Object[0]);
            }
            objbuf = info.objectToBytes(value);
        } else {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"serializing with standard writeObject", (Object[])new Object[0]);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = this.cacheStoreService.serializationService.createObjectOutputStream((OutputStream)baos);
            try {
                oos.writeObject(value);
                oos.flush();
                objbuf = baos.toByteArray();
            }
            finally {
                oos.close();
                baos.close();
            }
        }
        return objbuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    public Object deserialize(byte[] bytes) throws IOException, ClassNotFoundException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        Object obj = null;
        if (bytes.length >= 4 && bytes[0] == OBJECT_OUTPUT_STREAM_HEADER[0] && bytes[1] == OBJECT_OUTPUT_STREAM_HEADER[1]) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"deserializing with standard readObject", (Object[])new Object[0]);
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            BufferedInputStream in = new BufferedInputStream(bais);
            try {
                obj = ((CacheStore)this.getIStore()).getLoader().loadObject((InputStream)in);
            }
            finally {
                in.close();
                bais.close();
            }
        } else if (bytes[0] == 0) {
            BuiltinSerializationInfo<?> info;
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"deserializing with custom bytesToObject", (Object[])new Object[0]);
            }
            if ((info = SerializationInfoCache.lookupByIndex(bytes[1])) == null) {
                throw new StreamCorruptedException("invalid stream header: " + bytes[0] + " " + bytes[1]);
            }
            obj = info.bytesToObject(bytes);
        } else {
            throw new StreamCorruptedException("invalid stream header: " + bytes[0] + " " + bytes[1]);
        }
        return obj;
    }
}

