/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication.internal.jaas.modules;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.AuthenticationService;
import com.ibm.ws.security.authentication.collective.CollectiveAuthenticationPlugin;
import com.ibm.ws.security.authentication.internal.SSOTokenHelper;
import com.ibm.ws.security.authentication.jaas.modules.LoginModuleHelper;
import com.ibm.ws.security.authentication.principals.WSPrincipal;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.security.credentials.CredentialsService;
import com.ibm.ws.security.credentials.ExpirableCredential;
import com.ibm.ws.security.jaas.common.modules.CommonLoginModule;
import com.ibm.ws.security.jwtsso.token.proxy.JwtSSOTokenHelper;
import com.ibm.ws.security.mp.jwt.proxy.MpJwtHelper;
import com.ibm.ws.security.registry.EntryNotFoundException;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.registry.UserRegistry;
import com.ibm.ws.security.token.TokenManager;
import com.ibm.wsspi.security.token.SingleSignonToken;
import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class ServerCommonLoginModule
extends CommonLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(ServerCommonLoginModule.class, (String)"Authentication", (String)"com.ibm.ws.security.authentication.internal.resources.AuthenticationMessages");
    private static final String[] jsonWebTokenProperties = new String[]{"com.ibm.ws.authentication.internal.json.web.token"};
    protected SubjectHelper subjectHelper = new SubjectHelper();
    protected final String[] userIdOnlyProperties = new String[]{"com.ibm.wsspi.security.cred.userId", "com.ibm.ws.authentication.internal.assertion"};
    protected boolean customPropertiesFromSubject = false;
    static final long serialVersionUID = -878775644266839608L;

    protected CollectiveAuthenticationPlugin getCollectiveAuthenticationPlugin() throws RegistryException {
        return LoginModuleHelper.getJAASService().getCollectiveAuthenticationPlugin();
    }

    protected UserRegistry getUserRegistry() throws RegistryException {
        return LoginModuleHelper.getJAASService().getUserRegistry();
    }

    protected TokenManager getTokenManager() {
        return LoginModuleHelper.getJAASService().getTokenManager();
    }

    CredentialsService getCredentialsService() {
        return LoginModuleHelper.getJAASService().getCredentialsService();
    }

    protected AuthenticationService getAuthenticationService() {
        return LoginModuleHelper.getJAASService().getAuthenticationService();
    }

    public abstract Callback[] getRequiredCallbacks(CallbackHandler var1) throws IOException, UnsupportedCallbackException;

    protected String getSecurityName(String loginName, String urAuthenticatedId) throws EntryNotFoundException, RegistryException {
        String securityName;
        UserRegistry ur = this.getUserRegistry();
        if (ur != null && ur.getType() != "CUSTOM" && (securityName = ur.getUserSecurityName(urAuthenticatedId)) != null) {
            return securityName;
        }
        if (loginName != null) {
            return loginName;
        }
        if (ur != null) {
            return ur.getUserSecurityName(urAuthenticatedId);
        }
        throw new NullPointerException("No user registry");
    }

    protected void setCredentials(Subject subject, String securityName, String urAuthenticatedId) throws Exception {
        if (urAuthenticatedId != null && !urAuthenticatedId.equals(securityName)) {
            Hashtable<String, String> subjectHash = new Hashtable<String, String>();
            subjectHash.put("user.registry.authenticated.userid", urAuthenticatedId);
            subject.getPrivateCredentials().add(subjectHash);
        }
        CredentialsService credentialsService = this.getCredentialsService();
        credentialsService.setCredentials(subject);
    }

    protected void setWSPrincipal(Subject subject, String securityName, String accessId, String authMethod) throws Exception {
        WSPrincipal principal = new WSPrincipal(securityName, accessId, authMethod);
        subject.getPrincipals().add((Principal)principal);
    }

    protected void setOtherPrincipals(Subject subject, String securityName, String accessId, String authMethod, Hashtable<String, ?> customProperties) throws Exception {
        SubjectHelper subjectHelper = new SubjectHelper();
        if (subjectHelper.isUnauthenticated(subject)) {
            return;
        }
        if (customProperties != null) {
            this.addJaspicPrincipal(subject, customProperties);
        }
        this.addJsonWebToken(subject, customProperties, authMethod);
    }

    protected SingleSignonToken getSSOToken(Subject subject) {
        return SSOTokenHelper.getSSOToken(subject);
    }

    protected void updateSharedState() {
        this.updateSharedStateWithWSPrincipal();
        this.updateSharedStateWithWSCredential();
        this.updateSharedStateWithSSOToken();
    }

    private void updateSharedStateWithWSPrincipal() {
        Set<WSPrincipal> principals = this.temporarySubject.getPrincipals(WSPrincipal.class);
        Iterator<WSPrincipal> principalsIterator = principals.iterator();
        if (principalsIterator.hasNext()) {
            WSPrincipal principal = principalsIterator.next();
            this.sharedState.put("WSPrincipal", principal);
        }
    }

    private void updateSharedStateWithWSCredential() {
        SubjectHelper subjectHelper = new SubjectHelper();
        WSCredential wsCredential = subjectHelper.getWSCredential(this.temporarySubject);
        if (wsCredential != null) {
            this.sharedState.put("WSCredential", wsCredential);
        }
    }

    private void updateSharedStateWithSSOToken() {
        SingleSignonToken ssoToken = this.getSSOToken(this.temporarySubject);
        if (ssoToken != null) {
            this.sharedState.put("com.ibm.wsspi.security.token.wsSingleSignonToken", ssoToken);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void setUpSubject() throws LoginException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                static final long serialVersionUID = 3767048587206963547L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() throws Exception {
                    ServerCommonLoginModule.this.updateSubjectWithSharedStateContents();
                    ServerCommonLoginModule.this.updateSubjectWithTemporarySubjectContents();
                    ServerCommonLoginModule.this.optionallySetWSCredentialExpiration();
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.authentication.internal.jaas.modules.ServerCommonLoginModule$1", 1.class, (String)"Authentication", (String)"com.ibm.ws.security.authentication.internal.resources.AuthenticationMessages");
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.authentication.internal.jaas.modules.ServerCommonLoginModule", (String)"234", (Object)this, (Object[])new Object[0]);
            throw new LoginException("Unable to setup the Subject: " + e.getLocalizedMessage());
        }
    }

    protected void updateSubjectWithSharedStateContents() {
        this.subject.getPrincipals().add((Principal)((WSPrincipal)this.sharedState.get("WSPrincipal")));
        this.subject.getPublicCredentials().add(this.sharedState.get("WSCredential"));
        if (this.sharedState.get("com.ibm.wsspi.security.token.wsSingleSignonToken") != null) {
            this.subject.getPrivateCredentials().add(this.sharedState.get("com.ibm.wsspi.security.token.wsSingleSignonToken"));
        }
    }

    protected void updateSubjectWithTemporarySubjectContents() {
        this.updateSubjectWithPrincipalsOtherThanWSPrincipal();
        this.updateSubjectWithPublicCredentialsOtherThanWSCredential();
        this.updateSubjectWithPrivateCredentialsOtherThanSSOToken();
    }

    private void updateSubjectWithPrincipalsOtherThanWSPrincipal() {
        Set<WSPrincipal> temporaryWSPrincipals = this.temporarySubject.getPrincipals(WSPrincipal.class);
        Set<Principal> temporaryPrincipals = this.temporarySubject.getPrincipals();
        temporaryPrincipals.removeAll(temporaryWSPrincipals);
        this.subject.getPrincipals().addAll(temporaryPrincipals);
    }

    private void updateSubjectWithPublicCredentialsOtherThanWSCredential() {
        Set<WSCredential> temporaryWSCredentials = this.temporarySubject.getPublicCredentials(WSCredential.class);
        Set<Object> temporaryPublicCredentials = this.temporarySubject.getPublicCredentials();
        temporaryPublicCredentials.removeAll(temporaryWSCredentials);
        this.subject.getPublicCredentials().addAll(temporaryPublicCredentials);
    }

    private void updateSubjectWithPrivateCredentialsOtherThanSSOToken() {
        SingleSignonToken ssoToken = this.getSSOToken(this.temporarySubject);
        Set<Object> privateCredentials = this.temporarySubject.getPrivateCredentials();
        if (ssoToken != null) {
            privateCredentials.remove(ssoToken);
        }
        this.subject.getPrivateCredentials().addAll(privateCredentials);
    }

    private void optionallySetWSCredentialExpiration() {
        WSCredential wsCredential = this.subjectHelper.getWSCredential(this.subject);
        SingleSignonToken ssoToken = this.getSSOToken(this.subject);
        if (ssoToken != null && wsCredential instanceof ExpirableCredential) {
            ((ExpirableCredential)wsCredential).setExpiration(ssoToken.getExpiration());
        }
    }

    /*
     * WARNING - void declaration
     */
    void setUpSubject(final String securityName, final String accessId, final String authMethod) throws LoginException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                static final long serialVersionUID = -6116513221642715968L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() throws Exception {
                    ServerCommonLoginModule.this.temporarySubject = new Subject();
                    ServerCommonLoginModule.this.setWSPrincipal(ServerCommonLoginModule.this.temporarySubject, securityName, accessId, authMethod);
                    ServerCommonLoginModule.this.setCredentials(ServerCommonLoginModule.this.temporarySubject, securityName, null);
                    ServerCommonLoginModule.this.setOtherPrincipals(ServerCommonLoginModule.this.temporarySubject, securityName, accessId, authMethod, null);
                    ServerCommonLoginModule.this.subject.getPrincipals().addAll(ServerCommonLoginModule.this.temporarySubject.getPrincipals());
                    ServerCommonLoginModule.this.subject.getPublicCredentials().addAll(ServerCommonLoginModule.this.temporarySubject.getPublicCredentials());
                    ServerCommonLoginModule.this.subject.getPrivateCredentials().addAll(ServerCommonLoginModule.this.temporarySubject.getPrivateCredentials());
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.authentication.internal.jaas.modules.ServerCommonLoginModule$2", 2.class, (String)"Authentication", (String)"com.ibm.ws.security.authentication.internal.resources.AuthenticationMessages");
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.authentication.internal.jaas.modules.ServerCommonLoginModule", (String)"317", (Object)this, (Object[])new Object[]{securityName, accessId, authMethod});
            throw new LoginException(e.getLocalizedMessage());
        }
    }

    protected boolean isAlreadyProcessed() {
        return this.sharedState != null && "true".equalsIgnoreCase((String)this.sharedState.get("AlreadyProcessed "));
    }

    protected void removeInternalAssertionHashtable(Hashtable<String, ?> props, String[] propNames) {
        Set<Object> publicCredentials = this.subject.getPublicCredentials();
        publicCredentials.remove(props);
        for (String propName : propNames) {
            props.remove(propName);
        }
        if (!props.isEmpty()) {
            publicCredentials.add(props);
        }
    }

    private void addJaspicPrincipal(Subject subject, Hashtable<String, ?> customProperties) throws Exception {
        Principal jaspiPrincipal = (Principal)customProperties.get("com.ibm.wsspi.security.cred.jaspi.principal");
        if (jaspiPrincipal != null) {
            WSCredential wsCredential = null;
            Set<WSCredential> wsCredentials = subject.getPublicCredentials(WSCredential.class);
            Iterator<WSCredential> wsCredentialsIterator = wsCredentials.iterator();
            if (wsCredentialsIterator.hasNext() && (wsCredential = wsCredentialsIterator.next()) != null) {
                wsCredential.set("com.ibm.wsspi.security.cred.jaspi.principal", (Object)jaspiPrincipal);
            }
            subject.getPrincipals().add(jaspiPrincipal);
        }
    }

    private void addJsonWebToken(Subject subject, Hashtable<String, ?> customProperties, String authMethod) throws Exception {
        if (customProperties != null && customProperties.get("com.ibm.ws.authentication.internal.json.web.token") != null && "hashtable".equals(authMethod)) {
            MpJwtHelper.addJsonWebToken((Subject)subject, customProperties, (String)"com.ibm.ws.authentication.internal.json.web.token");
            this.removeInternalAssertionHashtable(customProperties, jsonWebTokenProperties);
        } else {
            JwtSSOTokenHelper.createJwtSSOToken((Subject)subject);
        }
    }

    protected boolean allowLoginWithIdOnly(Hashtable<String, ?> customProperties) {
        AuthenticationService authService = this.getAuthenticationService();
        if (authService != null && authService.isAllowHashTableLoginWithIdOnly().booleanValue()) {
            return true;
        }
        Boolean assertion = Boolean.FALSE;
        if (this.customPropertiesFromSubject) {
            Object value = customProperties.get("com.ibm.ws.authentication.internal.assertion");
            assertion = (Boolean)(value != null ? value : Boolean.FALSE);
            this.removeInternalAssertionHashtable(customProperties, this.userIdOnlyProperties);
        } else {
            String[] hashtableInternalProperty = new String[]{"com.ibm.ws.authentication.internal.assertion"};
            Hashtable internalProperties = this.subjectHelper.getHashtableFromSubject(this.subject, hashtableInternalProperty);
            if (internalProperties != null && !internalProperties.isEmpty()) {
                assertion = Boolean.TRUE;
                this.removeInternalAssertionHashtable(internalProperties, this.userIdOnlyProperties);
            }
        }
        return assertion != false;
    }
}

