/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs21.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.UnauthenticatedSubjectService;
import com.ibm.ws.security.authorization.util.RoleMethodAuthUtil;
import com.ibm.ws.security.authorization.util.UnauthenticatedException;
import com.ibm.ws.security.context.SubjectManager;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.Principal;
import javax.annotation.Priority;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.cxf.interceptor.security.AccessDeniedException;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.invoker.MethodDispatcher;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

@Priority(value=2001)
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LibertyAuthFilter
implements ContainerRequestFilter {
    private static final TraceComponent tc = Tr.register(LibertyAuthFilter.class, (String)"JAXRS", null);
    private UnauthenticatedSubjectService unauthenticatedSubjectService;
    static final long serialVersionUID = 7585454365622569792L;

    @FFDCIgnore(value={UnauthenticatedException.class, UnauthenticatedException.class, AccessDeniedException.class})
    public void filter(ContainerRequestContext context) {
        Message m = JAXRSUtils.getCurrentMessage();
        try {
            try {
                this.handleMessage(m);
            }
            catch (UnauthenticatedException ex) {
                try {
                    if (this.authenticate(m)) {
                        this.handleMessage(m);
                        return;
                    }
                }
                catch (UnauthenticatedException unauthenticatedException) {
                    // empty catch block
                }
                context.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            }
        }
        catch (AccessDeniedException ex) {
            context.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
        }
    }

    private boolean authenticate(Message m) {
        HttpServletRequest req = (HttpServletRequest)m.get((Object)"HTTP.REQUEST");
        HttpServletResponse res = (HttpServletResponse)m.get((Object)"HTTP.RESPONSE");
        try {
            return req.authenticate(res);
        }
        catch (IOException | ServletException throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.jaxrs21.security.LibertyAuthFilter", (String)"84", (Object)this, (Object[])new Object[]{m});
            return false;
        }
    }

    private void handleMessage(Message message) throws UnauthenticatedException {
        SecurityContext jaxrsSecurityContext = (SecurityContext)message.get(SecurityContext.class);
        if (jaxrsSecurityContext != null && jaxrsSecurityContext instanceof SecurityContext) {
            Method method = this.getTargetMethod(message);
            if (RoleMethodAuthUtil.parseMethodSecurity((Method)method, (Principal)jaxrsSecurityContext.getUserPrincipal(), s -> jaxrsSecurityContext.isUserInRole(s))) {
                return;
            }
        } else {
            HttpServletRequest req = (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
            Method method = (Method)MessageUtils.getTargetMethod((Message)message).orElseThrow(() -> new AccessDeniedException("Method is not available : Unauthorized"));
            this.setUnauthenticatedSubjectIfNeeded();
            if (RoleMethodAuthUtil.parseMethodSecurity((Method)method, (Principal)req.getUserPrincipal(), s -> req.isUserInRole(s))) {
                return;
            }
        }
        throw new AccessDeniedException("Unauthorized");
    }

    protected Method getTargetMethod(Message m) {
        BindingOperationInfo bop = m.getExchange().getBindingOperationInfo();
        if (bop != null) {
            MethodDispatcher md = (MethodDispatcher)m.getExchange().getService().get((Object)MethodDispatcher.class.getName());
            return md.getMethod(bop);
        }
        Method method = (Method)m.get((Object)"org.apache.cxf.resource.method");
        if (method != null) {
            return method;
        }
        throw new AccessDeniedException("Method is not available : Unauthorized");
    }

    private void setUnauthenticatedSubjectIfNeeded() {
        this.getUnauthenticatedSubjectService();
        SubjectManager subjectManager = new SubjectManager();
        if (subjectManager.getInvocationSubject() == null) {
            subjectManager.setInvocationSubject(this.unauthenticatedSubjectService.getUnauthenticatedSubject());
        }
        if (subjectManager.getCallerSubject() == null) {
            subjectManager.setCallerSubject(this.unauthenticatedSubjectService.getUnauthenticatedSubject());
        }
    }

    private void getUnauthenticatedSubjectService() {
        if (this.unauthenticatedSubjectService == null) {
            BundleContext context = FrameworkUtil.getBundle(UnauthenticatedSubjectService.class).getBundleContext();
            ServiceReference serviceRef = context.getServiceReference(UnauthenticatedSubjectService.class);
            this.unauthenticatedSubjectService = (UnauthenticatedSubjectService)context.getService(serviceRef);
        }
    }
}

