/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.wab.internal;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.servlet.filter.IFilterConfig;
import com.ibm.ws.app.manager.ApplicationStateCoordinator;
import com.ibm.ws.app.manager.module.DeployedAppInfo;
import com.ibm.ws.app.manager.module.DeployedAppServices;
import com.ibm.ws.app.manager.module.DeployedModuleInfo;
import com.ibm.ws.app.manager.module.internal.ModuleClassLoaderFactory;
import com.ibm.ws.app.manager.module.internal.ModuleHandler;
import com.ibm.ws.app.manager.module.internal.ModuleInfoUtils;
import com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase;
import com.ibm.ws.app.manager.wab.helper.WABClassInfoHelper;
import com.ibm.ws.app.manager.wab.internal.OsgiDirectoryProtectionFilter;
import com.ibm.ws.app.manager.wab.internal.WAB;
import com.ibm.ws.app.manager.wab.internal.WABExtensionFactory;
import com.ibm.ws.app.manager.wab.internal.WABGroup;
import com.ibm.ws.app.manager.wab.internal.WABTracker;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.container.service.app.deploy.WebModuleClassesInfo;
import com.ibm.ws.container.service.app.deploy.extended.ApplicationInfoFactory;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedApplicationInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ModuleContainerInfo;
import com.ibm.ws.container.service.metadata.MetaDataException;
import com.ibm.ws.eba.wab.integrator.EbaProvider;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javaee.dd.common.ModuleDeploymentDescriptor;
import com.ibm.ws.javaee.dd.web.WebApp;
import com.ibm.ws.kernel.feature.ServerReadyStatus;
import com.ibm.ws.kernel.feature.ServerStarted;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.update.RuntimeUpdateListener;
import com.ibm.ws.runtime.update.RuntimeUpdateManager;
import com.ibm.ws.runtime.update.RuntimeUpdateNotification;
import com.ibm.ws.threading.FutureMonitor;
import com.ibm.ws.threading.listeners.CompletionListener;
import com.ibm.ws.webcontainer.osgi.webapp.WebAppConfiguration;
import com.ibm.wsspi.adaptable.module.AdaptableModuleFactory;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.factory.ArtifactContainerFactory;
import com.ibm.wsspi.kernel.service.location.VariableRegistry;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.kernel.service.utils.ServerQuiesceListener;
import com.ibm.wsspi.wab.configure.WABConfiguration;
import com.ibm.wsspi.webcontainer.extension.ExtensionFactory;
import com.ibm.wsspi.webcontainer.extension.ExtensionProcessor;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.ServletContext;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, service={EventHandler.class, RuntimeUpdateListener.class, ServerQuiesceListener.class, ServerReadyStatus.class}, property={"service.vendor=IBM", "event.topics=org/osgi/service/web/UNDEPLOYED"})
public class WABInstaller
implements EventHandler,
ExtensionFactory,
RuntimeUpdateListener,
ServerQuiesceListener,
ServerReadyStatus {
    private static final TraceComponent tc = Tr.register(WABInstaller.class, (String[])new String[]{"webcontainer", "applications", "app.manager"}, (String)"com.ibm.ws.app.manager.wab.internal.resources.Messages", (String)"com.ibm.ws.app.manager.wab.internal.WABInstaller");
    private static final String CONFIGURABLE_FILTER = "(&(objectClass=" + WABConfiguration.class.getName() + ")(" + "contextName" + "=*)(" + "contextPath" + "=*))";
    private static final TraceComponent tcWabLifeCycleDebug = Tr.register(WABLifeCycle.class, (String[])new String[]{"webcontainer", "applications", "app.manager"}, (String)"com.ibm.ws.app.manager.wab.internal.resources.Messages", (String)"com.ibm.ws.app.manager.wab.internal.WABInstaller");
    private RegionDigraph digraph;
    private WABTracker<ConfigurableWAB> tracker;
    private ServiceTracker<WABConfiguration, AtomicReference<ConfigurableWAB>> configurableTracker;
    private final AtomicServiceReference<ExecutorService> executorService = new AtomicServiceReference("ExecutorService");
    private final AtomicServiceReference<FutureMonitor> futureMonitor = new AtomicServiceReference("FutureMonitor");
    private final AtomicServiceReference<EventAdmin> eventAdminService = new AtomicServiceReference("EventAdmin");
    private final AtomicServiceReference<ArtifactContainerFactory> containerFactorySRRef = new AtomicServiceReference("ContainerFactory");
    private final AtomicServiceReference<AdaptableModuleFactory> adaptableModuleFactorySRRef = new AtomicServiceReference("AdaptableModuleFactory");
    private final AtomicServiceReference<ApplicationInfoFactory> applicationInfoFactorySRRef = new AtomicServiceReference("ApplicationInfoFactory");
    private final AtomicServiceReference<DeployedAppServices> deployedAppServicesSRRef = new AtomicServiceReference("DeployedAppServices");
    private final AtomicServiceReference<ModuleHandler> webModuleHandlerSRRef = new AtomicServiceReference("WebModuleHandler");
    private final AtomicServiceReference<VariableRegistry> variableRegistrySRRef = new AtomicServiceReference("VariableRegistry");
    private final AtomicBoolean deactivated = new AtomicBoolean(false);
    private final ReentrantReadWriteLock deactivationLock = new ReentrantReadWriteLock();
    private final AtomicBoolean quiesceStarted = new AtomicBoolean(false);
    private final ReentrantLock wabGroupsLock = new ReentrantLock();
    private final Map<String, WABGroup> wabGroups = new HashMap<String, WABGroup>();
    private BundleContext ctx = null;
    private ServiceTracker<EbaProvider, EbaProvider> ebaProviderTracker;
    private final Map<String, WABPathSpecificItemHolder> knownPaths = new HashMap<String, WABPathSpecificItemHolder>();
    private final Hashtable<String, WABPathSpecificItemHolder> wabsEligibleForCollisionResolution = new Hashtable();
    @Reference
    private volatile List<WABClassInfoHelper> classInfoHelpers;
    private final Map<WAB, Future<?>> systemWABsDeploying = new ConcurrentHashMap();
    @Reference(policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL)
    private volatile ServerStarted serverStarted;
    static final long serialVersionUID = 3988957054633030124L;

    @Trivial
    void wabLifecycleDebug(String message, Object ... args) {
        if (TraceComponent.isAnyTracingEnabled() && tcWabLifeCycleDebug.isDebugEnabled()) {
            Tr.debug((TraceComponent)tcWabLifeCycleDebug, (String)message, (Object[])args);
        }
    }

    <T> WABTracker<T> getTracker(BundleTrackerCustomizer<T> wabTrackerCustomizer) {
        try {
            int mask = 40;
            return new WABTracker<T>(this.ctx, mask, wabTrackerCustomizer);
        }
        catch (Exception mask) {
            FFDCFilter.processException((Throwable)mask, (String)"com.ibm.ws.app.manager.wab.internal.WABInstaller", (String)"254", (Object)this, (Object[])new Object[]{wabTrackerCustomizer});
            Tr.error((TraceComponent)tc, (String)"bundle.tracker.init.fail", (Object[])new Object[0]);
            return null;
        }
    }

    protected void activate(ComponentContext context) {
        this.ctx = context.getBundleContext();
        this.ebaProviderTracker = new ServiceTracker(this.ctx, EbaProvider.class, null);
        this.ebaProviderTracker.open();
        this.executorService.activate(context);
        this.futureMonitor.activate(context);
        this.eventAdminService.activate(context);
        this.containerFactorySRRef.activate(context);
        this.adaptableModuleFactorySRRef.activate(context);
        this.applicationInfoFactorySRRef.activate(context);
        this.deployedAppServicesSRRef.activate(context);
        this.webModuleHandlerSRRef.activate(context);
        this.variableRegistrySRRef.activate(context);
        WABTrackerCustomizer customizer = new WABTrackerCustomizer(this.digraph);
        try {
            this.configurableTracker = new ServiceTracker(this.ctx, this.ctx.createFilter(CONFIGURABLE_FILTER), (ServiceTrackerCustomizer)customizer);
            this.configurableTracker.open();
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.app.manager.wab.internal.WABInstaller", (String)"285", (Object)this, (Object[])new Object[]{context});
        }
        this.tracker = this.getTracker(customizer);
        this.tracker.open();
        this.wabLifecycleDebug("Primary WAB Tracker has opened.", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivate(ComponentContext context) {
        ArrayList<WABGroup> toRemoveGroups;
        this.deactivationLock.writeLock().lock();
        try {
            this.deactivated.set(true);
        }
        finally {
            this.deactivationLock.writeLock().unlock();
        }
        if (this.tracker != null) {
            this.tracker.close();
            this.wabLifecycleDebug("Primary WAB Tracker has closed.", new Object[0]);
        }
        if (this.configurableTracker != null) {
            this.configurableTracker.close();
        }
        Hashtable<String, WABPathSpecificItemHolder> hashtable = this.wabsEligibleForCollisionResolution;
        synchronized (hashtable) {
            this.wabsEligibleForCollisionResolution.clear();
        }
        this.wabGroupsLock.lock();
        try {
            toRemoveGroups = new ArrayList<WABGroup>(this.wabGroups.values());
        }
        finally {
            this.wabGroupsLock.unlock();
        }
        for (WABGroup wabGroup : toRemoveGroups) {
            this.wabLifecycleDebug("Primary WAB Tracker uninstalling WABGroup during deactivate", wabGroup);
            wabGroup.uninstallGroup(this);
        }
        this.wabGroupsLock.lock();
        try {
            this.wabGroups.clear();
        }
        finally {
            this.wabGroupsLock.unlock();
        }
        Map<String, WABPathSpecificItemHolder> map = this.knownPaths;
        synchronized (map) {
            this.knownPaths.clear();
        }
        this.wabLifecycleDebug("Primary WAB Tracker no longer tracking wabs", new Object[0]);
        if (this.ebaProviderTracker != null) {
            this.ebaProviderTracker.close();
        }
        this.executorService.deactivate(context);
        this.futureMonitor.deactivate(context);
        this.eventAdminService.deactivate(context);
        this.containerFactorySRRef.deactivate(context);
        this.adaptableModuleFactorySRRef.deactivate(context);
        this.applicationInfoFactorySRRef.deactivate(context);
        this.deployedAppServicesSRRef.deactivate(context);
        this.webModuleHandlerSRRef.deactivate(context);
        this.variableRegistrySRRef.deactivate(context);
        this.ctx = null;
    }

    public void notificationCreated(RuntimeUpdateManager updateManager, RuntimeUpdateNotification notification) {
        if ("ConfigUpdatesDelivered".equals(notification.getName())) {
            notification.onCompletion((CompletionListener)new CompletionListener<Boolean>(){
                static final long serialVersionUID = 5657557363634311256L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void successfulCompletion(Future<Boolean> future, Boolean result) {
                    if (result.booleanValue()) {
                        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
                        WABInstaller.this.wabGroupsLock.lock();
                        try {
                            for (WABGroup group : WABInstaller.this.wabGroups.values()) {
                                for (WAB wab : group.getWABs()) {
                                    if (wab.isResolvedVirtualHostValid()) continue;
                                    bundles.add(wab.getBundle());
                                }
                            }
                        }
                        finally {
                            WABInstaller.this.wabGroupsLock.unlock();
                        }
                        for (Bundle b : bundles) {
                            WABInstaller.restart(b);
                        }
                    }
                }

                public void failedCompletion(Future<Boolean> future, Throwable t) {
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class, (String[])new String[]{"webcontainer", "applications", "app.manager"}, (String)"com.ibm.ws.app.manager.wab.internal.resources.Messages", (String)"com.ibm.ws.app.manager.wab.internal.WABInstaller$1");
                }
            });
        }
    }

    protected String resolveVariable(String stringToResolve) {
        return ((VariableRegistry)this.variableRegistrySRRef.getService()).resolveString(stringToResolve);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected boolean installIntoWebContainer(WAB wab) {
        Bundle bundle = wab.getBundle();
        String contextRoot = wab.getContextRoot();
        this.deactivationLock.readLock().lock();
        try {
            if (this.deactivated.get()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"installIntoWebContainer(WAB) entered by thread after component deactivation", (Object[])new Object[]{wab});
                }
                boolean bl = false;
                return bl;
            }
            ModuleHandler webModuleHandler = (ModuleHandler)this.webModuleHandlerSRRef.getService();
            if (webModuleHandler != null) {
                ModuleContainerInfo mci;
                WABDeployedAppInfo deployedApp;
                boolean groupsLocked;
                ExtendedApplicationInfo appInfo;
                Container wabContainer;
                block33: {
                    block32: {
                        if (FrameworkState.isStopping()) {
                            boolean bl = false;
                            return bl;
                        }
                        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
                        if (wiring == null) {
                            this.postFailureEvent(wab, "wab.install.fail.wiring", bundle, contextRoot);
                            Tr.error((TraceComponent)tc, (String)"wab.install.fail.wiring", (Object[])new Object[]{bundle, contextRoot});
                            boolean bl = false;
                            return bl;
                        }
                        wabContainer = this.getContainerForBundle(wab, bundle, contextRoot);
                        Entry manifestEntry = wabContainer.getEntry("/META-INF/MANIFEST.MF");
                        if (manifestEntry != null) {
                            NonPersistentCache cache = (NonPersistentCache)manifestEntry.adapt(NonPersistentCache.class);
                            cache.addToCache(Dictionary.class, (Object)bundle.getHeaders(""));
                        }
                        ClassLoader loader = wiring.getClassLoader();
                        WebModuleClassesInfo classesInfo = this.getClassesInfo(wab, wabContainer, bundle, contextRoot, wiring);
                        NonPersistentCache npc = (NonPersistentCache)wabContainer.adapt(NonPersistentCache.class);
                        npc.addToCache(WebModuleClassesInfo.class, (Object)classesInfo);
                        String modPath = bundle.getSymbolicName();
                        if (!contextRoot.startsWith("/")) {
                            contextRoot = "/" + contextRoot;
                        }
                        EbaProvider ebaProviderService = (EbaProvider)this.ebaProviderTracker.getService();
                        appInfo = null;
                        if (ebaProviderService != null) {
                            appInfo = (ExtendedApplicationInfo)ebaProviderService.getApplicationInfo(bundle);
                        }
                        if (appInfo == null) {
                            String moduleURI = ModuleInfoUtils.getModuleURIFromLocation((String)modPath);
                            String moduleName = ModuleInfoUtils.getModuleName((ModuleDeploymentDescriptor)((ModuleDeploymentDescriptor)wabContainer.adapt(WebApp.class)), (String)moduleURI);
                            appInfo = ((ApplicationInfoFactory)this.applicationInfoFactorySRRef.getService()).createApplicationInfo(modPath, moduleName, wabContainer, null, null);
                            wab.setCreatedApplicationInfo();
                        }
                        wab.setApplicationInfo((ApplicationInfo)appInfo);
                        groupsLocked = true;
                        this.wabGroupsLock.lock();
                        WABGroup wabGroup = this.wabGroups.get(appInfo.getName());
                        if (wabGroup == null) {
                            wabGroup = new WABGroup((DeployedAppInfo)new WABDeployedAppInfo((DeployedAppServices)this.deployedAppServicesSRRef.getService(), appInfo));
                            this.wabGroups.put(appInfo.getName(), wabGroup);
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("installIntoWebContainer wabGroups.putIfAbsent(" + appInfo.getName() + " , " + wabGroup + ") ==> " + wabGroup), (Object[])new Object[0]);
                        }
                        WABGroup wABGroup = wabGroup;
                        // MONITORENTER : wABGroup
                        deployedApp = (WABDeployedAppInfo)wabGroup.getDeployedAppInfo();
                        wabGroup.addWab(wab, this);
                        groupsLocked = false;
                        this.wabGroupsLock.unlock();
                        mci = deployedApp.createModuleContainerInfo(webModuleHandler, contextRoot, wabContainer, modPath, loader);
                        wab.setModuleContainerInfo(mci);
                        if (!wab.getCreatedApplicationInfo()) break block32;
                        if (!deployedApp.installApp(wab)) {
                            this.postFailureEvent(wab, "wab.install.fail", bundle, contextRoot);
                            Tr.error((TraceComponent)tc, (String)"wab.install.fail", (Object[])new Object[]{bundle, contextRoot});
                            boolean bl = false;
                            // MONITOREXIT : wABGroup
                            if (!groupsLocked) return bl;
                            this.wabGroupsLock.unlock();
                            return bl;
                        }
                        break block33;
                    }
                    if (!deployedApp.installModule(wab)) {
                        this.postFailureEvent(wab, "wab.install.fail", bundle, contextRoot);
                        Tr.error((TraceComponent)tc, (String)"wab.install.fail", (Object[])new Object[]{bundle, contextRoot});
                        boolean bl = false;
                        // MONITOREXIT : wABGroup
                        if (!groupsLocked) return bl;
                        this.wabGroupsLock.unlock();
                        return bl;
                    }
                }
                try {
                    Hashtable<String, String> bRegProps = new Hashtable<String, String>(1);
                    ((Dictionary)bRegProps).put("web.module.key", appInfo.getName() + "#" + deployedApp.getModuleName(mci));
                    ((Dictionary)bRegProps).put("installed.wab.contextRoot", contextRoot);
                    ((Dictionary)bRegProps).put("installed.wab.container", (String)wabContainer);
                    ServiceRegistration reg = this.ctx.registerService(Bundle.class, (Object)bundle, bRegProps);
                    wab.setRegistration((ServiceRegistration<Bundle>)reg);
                    // MONITOREXIT : wABGroup
                    return true;
                }
                finally {
                    if (groupsLocked) {
                        this.wabGroupsLock.unlock();
                    }
                }
            }
            this.postFailureEvent(wab, "wab.install.fail.container", bundle, contextRoot);
            Tr.error((TraceComponent)tc, (String)"wab.install.fail.container", (Object[])new Object[]{bundle, contextRoot});
            boolean bl = false;
            return bl;
        }
        catch (Throwable webModuleHandler) {
            void e;
            FFDCFilter.processException((Throwable)webModuleHandler, (String)"com.ibm.ws.app.manager.wab.internal.WABInstaller", (String)"552", (Object)this, (Object[])new Object[]{wab});
            this.postEvent(wab.createFailedEvent((Throwable)e));
            Tr.error((TraceComponent)tc, (String)"wab.install.fail", (Object[])new Object[]{bundle, contextRoot});
            boolean bl = false;
            return bl;
        }
        finally {
            this.deactivationLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean uninstallFromWebContainer(final WAB wab) {
        ModuleHandler webModuleHandler = (ModuleHandler)this.webModuleHandlerSRRef.getService();
        if (webModuleHandler != null) {
            block16: {
                ApplicationInfo info = wab.getApplicationInfo();
                String groupKey = info.getName();
                boolean groupsLocked = true;
                this.wabGroupsLock.lock();
                try {
                    WABGroup group = this.wabGroups.get(groupKey);
                    if (group == null) break block16;
                    WABGroup wABGroup = group;
                    synchronized (wABGroup) {
                        final WABDeployedAppInfo deployedApp = (WABDeployedAppInfo)group.getDeployedAppInfo();
                        if (group.removeWAB(wab)) {
                            this.wabGroups.remove(groupKey);
                            groupsLocked = false;
                            this.wabGroupsLock.unlock();
                        }
                        if (wab.getCreatedApplicationInfo()) {
                            deployedApp.uninstallApp(wab);
                        } else if (this.ctx.getBundle("System Bundle").getState() == 16) {
                            final CountDownLatch latch = new CountDownLatch(1);
                            ((ExecutorService)this.executorService.getService()).submit(new Runnable(){
                                static final long serialVersionUID = -6270895344423536397L;
                                private static final /* synthetic */ TraceComponent $$$tc$$$;

                                @Override
                                public void run() {
                                    deployedApp.uninstallModule(wab);
                                    latch.countDown();
                                }

                                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                                static {
                                    $$$tc$$$ = Tr.register(2.class, (String[])new String[]{"webcontainer", "applications", "app.manager"}, (String)"com.ibm.ws.app.manager.wab.internal.resources.Messages", (String)"com.ibm.ws.app.manager.wab.internal.WABInstaller$2");
                                }
                            }, Boolean.TRUE);
                            try {
                                if (this.quiesceStarted.get()) {
                                    latch.await(30L, TimeUnit.SECONDS);
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.app.manager.wab.internal.WABInstaller", (String)"613", (Object)this, (Object[])new Object[]{wab});
                                Thread.currentThread().interrupt();
                            }
                        } else {
                            deployedApp.uninstallModule(wab);
                        }
                    }
                }
                finally {
                    if (groupsLocked) {
                        this.wabGroupsLock.unlock();
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Reference(service=ExecutorService.class)
    protected void setExecutorService(ServiceReference<ExecutorService> reference) {
        this.executorService.setReference(reference);
    }

    protected void unsetExecutorService(ServiceReference<ExecutorService> reference) {
        this.executorService.unsetReference(reference);
    }

    @Reference(service=FutureMonitor.class)
    protected void setFutureMonitor(ServiceReference<FutureMonitor> reference) {
        this.futureMonitor.setReference(reference);
    }

    protected void unsetFutureMonitor(ServiceReference<FutureMonitor> reference) {
        this.futureMonitor.unsetReference(reference);
    }

    @Reference(service=EventAdmin.class)
    protected void setEventAdmin(ServiceReference<EventAdmin> reference) {
        this.eventAdminService.setReference(reference);
    }

    protected void unsetEventAdmin(ServiceReference<EventAdmin> reference) {
        this.eventAdminService.unsetReference(reference);
    }

    @Reference(service=ArtifactContainerFactory.class, target="(&(category=DIR)(category=JAR)(category=BUNDLE))")
    protected void setContainerFactory(ServiceReference<ArtifactContainerFactory> ref) {
        this.containerFactorySRRef.setReference(ref);
    }

    protected void unsetContainerFactory(ServiceReference<ArtifactContainerFactory> ref) {
        this.containerFactorySRRef.unsetReference(ref);
    }

    @Reference(service=AdaptableModuleFactory.class)
    protected void setAdaptableModuleFactory(ServiceReference<AdaptableModuleFactory> ref) {
        this.adaptableModuleFactorySRRef.setReference(ref);
    }

    protected void unsetAdaptableModuleFactory(ServiceReference<AdaptableModuleFactory> ref) {
        this.adaptableModuleFactorySRRef.unsetReference(ref);
    }

    @Reference(service=ApplicationInfoFactory.class)
    protected void setApplicationInfoFactory(ServiceReference<ApplicationInfoFactory> ref) {
        this.applicationInfoFactorySRRef.setReference(ref);
    }

    protected void unsetApplicationInfoFactory(ServiceReference<ApplicationInfoFactory> ref) {
        this.applicationInfoFactorySRRef.unsetReference(ref);
    }

    @Reference
    protected void setDeployedAppServices(ServiceReference<DeployedAppServices> ref) {
        this.deployedAppServicesSRRef.setReference(ref);
    }

    protected void unsetDeployedAppServices(ServiceReference<DeployedAppServices> ref) {
        this.deployedAppServicesSRRef.unsetReference(ref);
    }

    @Reference(service=ModuleHandler.class, target="(type=web)")
    protected void setWebModuleHandler(ServiceReference<ModuleHandler> ref) {
        this.webModuleHandlerSRRef.setReference(ref);
    }

    protected void unsetWebModuleHandler(ServiceReference<ModuleHandler> ref) {
        this.webModuleHandlerSRRef.unsetReference(ref);
    }

    @Reference(service=VariableRegistry.class)
    protected void setVariableRegistry(ServiceReference<VariableRegistry> ref) {
        this.variableRegistrySRRef.setReference(ref);
    }

    protected void unsetVariableRegistry(ServiceReference<VariableRegistry> ref) {
        this.variableRegistrySRRef.unsetReference(ref);
    }

    @Reference
    protected void setWABExtensionFactory(WABExtensionFactory extFactory) {
        extFactory.setDelegate(this);
    }

    protected void unsetWABExtensionFactory(WABExtensionFactory extFactory) {
        extFactory.setDelegate(null);
    }

    @Reference
    protected void setRegionDigraph(RegionDigraph digraph) {
        this.digraph = digraph;
    }

    protected void unsetRegionDigraph(RegionDigraph digraph) {
    }

    static void restart(Bundle bundle) {
        if (bundle.getState() != 16) {
            try {
                bundle.stop();
            }
            catch (BundleException bundleException) {
                FFDCFilter.processException((Throwable)bundleException, (String)"com.ibm.ws.app.manager.wab.internal.WABInstaller", (String)"739", null, (Object[])new Object[]{bundle});
            }
            try {
                bundle.start();
            }
            catch (BundleException bundleException) {
                FFDCFilter.processException((Throwable)bundleException, (String)"com.ibm.ws.app.manager.wab.internal.WABInstaller", (String)"747", null, (Object[])new Object[]{bundle});
            }
        }
    }

    Future<?> executeRunnable(Runnable runnable) {
        ExecutorService executor = (ExecutorService)this.executorService.getService();
        if (executor != null) {
            return executor.submit(runnable);
        }
        return null;
    }

    void postFailureEvent(WAB wab, String throwableKey, Object ... args) {
        this.postEvent(wab.createFailedEvent(new Exception(TraceNLS.getFormattedMessage(this.getClass(), (String)tc.getResourceBundleName(), (String)throwableKey, (Object[])args, null))));
    }

    void postEvent(Event e) {
        EventAdmin eventAdmin;
        if (e != null && (eventAdmin = (EventAdmin)this.eventAdminService.getService()) != null) {
            eventAdmin.postEvent(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attemptRedeployOfPreviouslyCollidedContextPath(String contextPath) {
        WABPathSpecificItemHolder wABPathSpecificItemHolder;
        WABPathSpecificItemHolder holder;
        Object object;
        this.wabLifecycleDebug("Primary WAB Tracker performing collision resolution for ", contextPath);
        Map<String, WABPathSpecificItemHolder> map = this.knownPaths;
        synchronized (map) {
            WABPathSpecificItemHolder knownHolder = this.knownPaths.get(contextPath);
            if (knownHolder != null) {
                object = knownHolder;
                synchronized (object) {
                    if (knownHolder.getWABs().isEmpty()) {
                        this.knownPaths.remove(contextPath);
                    }
                }
            }
        }
        object = this.wabsEligibleForCollisionResolution;
        synchronized (object) {
            holder = this.wabsEligibleForCollisionResolution.get(contextPath);
            if (holder != null) {
                wABPathSpecificItemHolder = holder;
                synchronized (wABPathSpecificItemHolder) {
                    if (holder.getWABs().isEmpty()) {
                        this.wabsEligibleForCollisionResolution.remove(contextPath);
                        holder = null;
                    }
                }
            }
        }
        if (holder != null) {
            WAB collidingWabToDeploy = null;
            wABPathSpecificItemHolder = holder;
            synchronized (wABPathSpecificItemHolder) {
                Collection<WAB> wabs = holder.getWABs();
                long lowestId = Long.MAX_VALUE;
                for (WAB w : wabs) {
                    long id = w.getBundle().getBundleId();
                    if (id >= lowestId) continue;
                    lowestId = id;
                    collidingWabToDeploy = w;
                }
            }
            if (collidingWabToDeploy != null) {
                this.wabLifecycleDebug("Primary WAB Tracker selected WAB to deploy from collision resolution ", collidingWabToDeploy);
                collidingWabToDeploy.attemptDeployOfPreviouslyBlockedWab();
            }
        }
    }

    public void handleEvent(Event event) {
        String contextPath = (String)event.getProperty("context.path");
        this.attemptRedeployOfPreviouslyCollidedContextPath(contextPath);
    }

    private Container getContainerForBundle(WAB wab, Bundle bundle, String contextRoot) {
        File cacheDir = bundle.getDataFile("cache");
        if (!FileUtils.ensureDirExists((File)cacheDir)) {
            this.postFailureEvent(wab, "wab.install.fail.cache", bundle, contextRoot);
            Tr.error((TraceComponent)tc, (String)"wab.install.fail.cache", (Object[])new Object[]{bundle, contextRoot});
            return null;
        }
        File cacheDirAdapt = bundle.getDataFile("cacheAdapt");
        if (!FileUtils.ensureDirExists((File)cacheDirAdapt)) {
            this.postFailureEvent(wab, "wab.install.fail.adapt", bundle, contextRoot);
            Tr.error((TraceComponent)tc, (String)"wab.install.fail.adapt", (Object[])new Object[]{bundle, contextRoot});
            return null;
        }
        File cacheDirOverlay = bundle.getDataFile("cacheOverlay");
        if (!FileUtils.ensureDirExists((File)cacheDirOverlay)) {
            this.postFailureEvent(wab, "wab.install.fail.overlay", bundle, contextRoot);
            Tr.error((TraceComponent)tc, (String)"wab.install.fail.overlay", (Object[])new Object[]{bundle, contextRoot});
            return null;
        }
        ArtifactContainer artifactContainer = ((ArtifactContainerFactory)this.containerFactorySRRef.getService()).getContainer(cacheDir, (Object)bundle);
        Container wabContainer = ((AdaptableModuleFactory)this.adaptableModuleFactorySRRef.getService()).getContainer(cacheDirAdapt, cacheDirOverlay, artifactContainer);
        return wabContainer;
    }

    private List<ContainerInfo> getContainerInfosForBundle(Bundle b, Container rootContainer) throws UnableToAdaptException {
        Dictionary headers = b.getHeaders("");
        String classPath = (String)headers.get("Bundle-ClassPath");
        if (classPath == null || classPath.trim().equals("")) {
            classPath = ".";
        }
        String[] classPathElements = classPath.split(",");
        ArrayList<ContainerInfo> cpContainers = new ArrayList<ContainerInfo>();
        for (String cpElt : classPathElements) {
            Container entryContainer;
            String entryName = cpElt = cpElt.trim();
            if (".".equals(cpElt)) {
                entryContainer = rootContainer;
            } else {
                Container cpContainer;
                Entry e = rootContainer.getEntry(cpElt);
                if (e == null || (cpContainer = (Container)e.adapt(Container.class)) == null) continue;
                entryContainer = cpContainer;
            }
            cpContainers.add(new WABContainerInfo(entryName, entryContainer));
        }
        return cpContainers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeWabFromEligibleForCollisionResolution(WAB wab) {
        Hashtable<String, WABPathSpecificItemHolder> hashtable = this.wabsEligibleForCollisionResolution;
        synchronized (hashtable) {
            String contextPath = wab.getContextRoot();
            WABPathSpecificItemHolder holder = this.wabsEligibleForCollisionResolution.get(contextPath);
            if (holder != null) {
                WABPathSpecificItemHolder wABPathSpecificItemHolder = holder;
                synchronized (wABPathSpecificItemHolder) {
                    holder.getWABs().remove(wab);
                }
            }
        }
    }

    private WebModuleClassesInfo getClassesInfo(WAB wab, Container wabContainer, Bundle bundle, String contextRoot, BundleWiring wiring) throws UnableToAdaptException {
        List<ContainerInfo> containerInfos = this.getContainerInfos(wab, wabContainer, bundle, contextRoot, wiring);
        for (WABClassInfoHelper helper : this.classInfoHelpers) {
            containerInfos.addAll(helper.getContainerInfos(wabContainer, bundle));
        }
        WABClassesInfo classesInfo = new WABClassesInfo(containerInfos);
        return classesInfo;
    }

    private List<ContainerInfo> getContainerInfos(WAB wab, Container wabContainer, Bundle bundle, String contextRoot, BundleWiring wiring) throws UnableToAdaptException {
        List<ContainerInfo> cpContainers = this.getContainerInfosForBundle(bundle, wabContainer);
        List bwl = wiring.getProvidedWires("osgi.wiring.host");
        if (bwl != null) {
            for (BundleWire bw : bwl) {
                Container fragContainer;
                Bundle fragment;
                BundleRevision br;
                BundleWiring rw = bw.getRequirerWiring();
                if (rw == null || (br = rw.getRevision()) == null || (fragment = br.getBundle()) == null || (fragContainer = this.getContainerForBundle(wab, fragment, contextRoot)) == null) continue;
                List<ContainerInfo> fragContainers = this.getContainerInfosForBundle(fragment, fragContainer);
                cpContainers.addAll(fragContainers);
            }
        }
        return cpContainers;
    }

    private String WASContextPathNormalize(String contextPath) {
        if (!contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        if (contextPath.endsWith("/") && !contextPath.equals("/")) {
            contextPath = contextPath.substring(0, contextPath.length() - 1);
        }
        return contextPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtensionProcessor createExtensionProcessor(IServletContext iServletContext) throws Exception {
        Map<String, WABPathSpecificItemHolder> knownPaths;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"WAB createExtensionProcessor", (Object[])new Object[]{iServletContext.getContextPath()});
        }
        if ((knownPaths = this.knownPaths) != null) {
            WABPathSpecificItemHolder holder;
            Map<String, WABPathSpecificItemHolder> map = knownPaths;
            synchronized (map) {
                holder = knownPaths.get(iServletContext.getContextPath());
            }
            if (holder != null) {
                Collection<WAB> wabs = holder.getWABs();
                WAB wab = null;
                WABPathSpecificItemHolder wABPathSpecificItemHolder = holder;
                synchronized (wABPathSpecificItemHolder) {
                    for (WAB w : wabs) {
                        switch (w.getState()) {
                            case DEPLOYING: 
                            case DEPLOYED: {
                                wab = w;
                                break;
                            }
                        }
                    }
                }
                if (wab != null) {
                    BundleContext wabBC;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Found WAB matching context path", (Object[])new Object[]{iServletContext.getContextPath()});
                    }
                    if ((wabBC = wab.getBundle().getBundleContext()) == null) {
                        return null;
                    }
                    iServletContext.setAttribute("osgi-bundlecontext", (Object)wabBC);
                    iServletContext.setAttribute("org.springframework.osgi.web." + BundleContext.class.getName(), (Object)wabBC);
                    IServletContext esc = iServletContext;
                    IFilterConfig fc = esc.getFilterConfig("com.ibm.ws.app.manager.wab.internal.WABInstaller.OSGIDENYCONFIG");
                    fc.setDescription("Filter protecting OSGI-INF and OSGI-OPT resources");
                    fc.setName("com.ibm.ws.app.manager.wab.internal.OsgiDirectoryProtectionFilter");
                    fc.setFilterClassLoader(this.getClass().getClassLoader());
                    fc.setFilterClassName(OsgiDirectoryProtectionFilter.class.getName());
                    fc.setDisplayName("OSGI Directory protection filter");
                    fc.setDispatchMode(new int[]{3, 1, 2, 0});
                    fc.setAsyncSupported(true);
                    esc.addMappingFilter("/*", fc);
                    wab.registerServletContext((ServletContext)iServletContext, wabBC);
                }
                return null;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No WABS matching context path", (Object[])new Object[]{iServletContext.getContextPath()});
                Tr.debug((TraceComponent)tc, (String)"Known WAB context paths", (Object[])new Object[]{knownPaths});
            }
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Not initialized with knownPaths", (Object[])new Object[0]);
        }
        return null;
    }

    public List getPatternList() {
        return Collections.EMPTY_LIST;
    }

    public void serverStopping() {
        this.quiesceStarted.set(true);
    }

    void addSystemWABDeployFuture(WAB wab, Future<?> future) {
        if (this.serverStarted != null) {
            return;
        }
        EbaProvider ebaProvider = (EbaProvider)this.ebaProviderTracker.getService();
        if (ebaProvider != null && ebaProvider.getApplicationInfo(wab.getBundle()) != null) {
            return;
        }
        this.systemWABsDeploying.put(wab, future);
    }

    public void check() {
        AtomicBoolean timeoutOccurred = new AtomicBoolean();
        this.systemWABsDeploying.forEach((w, f) -> {
            try {
                if (timeoutOccurred.get()) {
                    if (!f.isDone()) {
                        this.logSlowWab((WAB)w);
                    }
                } else {
                    f.get(ApplicationStateCoordinator.getApplicationStartTimeout(), TimeUnit.SECONDS);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
            }
            catch (TimeoutException e) {
                timeoutOccurred.set(true);
                this.logSlowWab((WAB)w);
            }
        });
        this.systemWABsDeploying.clear();
    }

    private void logSlowWab(WAB w) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Stopped waiting for the system WAB to start: ", (Object[])new Object[]{w.getBundle().getSymbolicName()});
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static final class WABDeployedAppInfo
    extends SimpleDeployedAppInfoBase {
        WAB currentWAB;
        static final long serialVersionUID = -2685178651374502888L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        WABDeployedAppInfo(DeployedAppServices deployedAppServices, ExtendedApplicationInfo appInfo) throws UnableToAdaptException {
            super(deployedAppServices);
            this.appInfo = appInfo;
        }

        ModuleContainerInfo createModuleContainerInfo(ModuleHandler webModuleHandler, String contextRoot, Container moduleContainer, String moduleLocation, ClassLoader loader) throws UnableToAdaptException {
            final ClassLoader moduleClassLoader = loader;
            ModuleClassLoaderFactory moduleClassLoaderFactory = new ModuleClassLoaderFactory(){
                static final long serialVersionUID = 2452367544854772676L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public ClassLoader createModuleClassLoader(ModuleInfo moduleInfo, List<ContainerInfo> moduleClassesContainers) {
                    return moduleClassLoader;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class, (String[])new String[]{"webcontainer", "applications", "app.manager"}, (String)"com.ibm.ws.app.manager.wab.internal.resources.Messages", (String)"com.ibm.ws.app.manager.wab.internal.WABInstaller$WABDeployedAppInfo$1");
                }
            };
            String moduleURI = ModuleInfoUtils.getModuleURIFromLocation((String)moduleLocation);
            SimpleDeployedAppInfoBase.WebModuleContainerInfo mci = new SimpleDeployedAppInfoBase.WebModuleContainerInfo(webModuleHandler, this.deployedAppServices.getModuleMetaDataExtenders("web"), this.deployedAppServices.getNestedModuleMetaDataFactories("web"), moduleContainer, null, moduleURI, moduleClassLoaderFactory, this.moduleClassesInfo, contextRoot);
            this.moduleContainerInfos.add(mci);
            return mci;
        }

        public DeployedModuleInfo getDeployedModule(ExtendedModuleInfo moduleInfo) {
            String virtualHost;
            DeployedModuleInfo deployedMod = super.getDeployedModule(moduleInfo);
            this.currentWAB.setDeployedModuleInfo(deployedMod);
            WebAppConfiguration appConfig = (WebAppConfiguration)((WebModuleMetaData)moduleInfo.getMetaData()).getConfiguration();
            if (appConfig != null && (virtualHost = this.currentWAB.getVirtualHost()) != null) {
                appConfig.setVirtualHostName(virtualHost);
            }
            return deployedMod;
        }

        public boolean installApp(WAB wab) {
            this.currentWAB = wab;
            Future result = this.futureMonitor.createFuture(Boolean.class);
            return this.installApp(result);
        }

        public boolean installModule(WAB wab) throws MetaDataException, InterruptedException, ExecutionException {
            SimpleDeployedAppInfoBase.WebModuleContainerInfo mci = (SimpleDeployedAppInfoBase.WebModuleContainerInfo)wab.getModuleContainerInfo();
            this.currentWAB = wab;
            mci.createModuleMetaData((ApplicationInfo)this.appInfo, (SimpleDeployedAppInfoBase)this);
            DeployedModuleInfo deployedMod = this.getDeployedModule(mci.moduleInfo);
            Future appFuture = mci.moduleHandler.deployModule(deployedMod, (DeployedAppInfo)this);
            return !appFuture.isDone() || (Boolean)appFuture.get() != false;
        }

        public void uninstallApp(WAB wab) {
            this.uninstallApp();
        }

        public void uninstallModule(WAB wab) {
            SimpleDeployedAppInfoBase.WebModuleContainerInfo mci = (SimpleDeployedAppInfoBase.WebModuleContainerInfo)wab.getModuleContainerInfo();
            DeployedModuleInfo deployedMod = wab.getDeployedModuleInfo();
            mci.moduleHandler.undeployModule(deployedMod);
        }

        public String getModuleName(ModuleContainerInfo mci) {
            return ((SimpleDeployedAppInfoBase.WebModuleContainerInfo)mci).moduleInfo.getName();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(WABDeployedAppInfo.class, (String[])new String[]{"webcontainer", "applications", "app.manager"}, (String)"com.ibm.ws.app.manager.wab.internal.resources.Messages", (String)"com.ibm.ws.app.manager.wab.internal.WABInstaller$WABDeployedAppInfo");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    final class WABPathSpecificItemHolder {
        private final Collection<WAB> wabs = new ArrayList<WAB>();
        static final long serialVersionUID = 1901767489701319896L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        WABPathSpecificItemHolder(WAB wab) {
            this.wabs.add(wab);
        }

        Collection<WAB> getWABs() {
            return this.wabs;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(WABPathSpecificItemHolder.class, (String[])new String[]{"webcontainer", "applications", "app.manager"}, (String)"com.ibm.ws.app.manager.wab.internal.resources.Messages", (String)"com.ibm.ws.app.manager.wab.internal.WABInstaller$WABPathSpecificItemHolder");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class WABClassesInfo
    implements WebModuleClassesInfo {
        private final List<ContainerInfo> containerInfos;
        static final long serialVersionUID = -2951110368179057508L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        WABClassesInfo(List<ContainerInfo> containerInfos) {
            this.containerInfos = containerInfos;
        }

        public List<ContainerInfo> getClassesContainers() {
            return this.containerInfos;
        }

        public String toString() {
            return this.containerInfos.toString();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(WABClassesInfo.class, (String[])new String[]{"webcontainer", "applications", "app.manager"}, (String)"com.ibm.ws.app.manager.wab.internal.resources.Messages", (String)"com.ibm.ws.app.manager.wab.internal.WABInstaller$WABClassesInfo");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class WABContainerInfo
    implements ContainerInfo {
        private final String entryName;
        private final Container entryContainer;
        static final long serialVersionUID = -3397311160469770327L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        WABContainerInfo(String entryName, Container entryContainer) {
            this.entryName = entryName;
            this.entryContainer = entryContainer;
        }

        public ContainerInfo.Type getType() {
            return ContainerInfo.Type.WEB_INF_LIB;
        }

        public String getName() {
            return this.entryName;
        }

        public Container getContainer() {
            return this.entryContainer;
        }

        public String toString() {
            return "[WEB_INF_LIB]" + this.entryName + ":" + this.entryContainer;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(WABContainerInfo.class, (String[])new String[]{"webcontainer", "applications", "app.manager"}, (String)"com.ibm.ws.app.manager.wab.internal.resources.Messages", (String)"com.ibm.ws.app.manager.wab.internal.WABInstaller$WABContainerInfo");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    final class WABTrackerCustomizer
    implements BundleTrackerCustomizer<ConfigurableWAB>,
    ServiceTrackerCustomizer<WABConfiguration, AtomicReference<ConfigurableWAB>> {
        private final RegionDigraph digraph;
        private final Map<String, Map<Region, ConfigurableWAB>> configurableContextPaths = new HashMap<String, Map<Region, ConfigurableWAB>>();
        static final long serialVersionUID = 686959923487013107L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public WABTrackerCustomizer(RegionDigraph digraph) {
            this.digraph = digraph;
        }

        public ConfigurableWAB addingBundle(Bundle bundle, BundleEvent event) {
            String webContextPath = (String)bundle.getHeaders("").get("Web-ContextPath");
            if (webContextPath == null) {
                return null;
            }
            if (webContextPath.startsWith("@")) {
                return this.createConfigurableWAB(bundle, webContextPath.substring(1));
            }
            webContextPath = WABInstaller.this.WASContextPathNormalize(webContextPath);
            return new ConfigurableWAB(bundle, null, null, webContextPath, this.createWAB(bundle, webContextPath));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ConfigurableWAB createConfigurableWAB(Bundle wabBundle, String webContextPathName) {
            Map<String, Map<Region, ConfigurableWAB>> map = this.configurableContextPaths;
            synchronized (map) {
                Region region = this.digraph.getRegion(wabBundle);
                if (region == null) {
                    return null;
                }
                ConfigurableWAB configurableWAB = this.findConfigurableWAB(region, webContextPathName);
                if (configurableWAB == null) {
                    configurableWAB = new ConfigurableWAB(wabBundle, region, webContextPathName, null, null);
                    this.putConfigurableWAB(configurableWAB);
                } else {
                    if (configurableWAB.wabBundle != null) {
                        throw new IllegalStateException("A bundle is already attempting to use the name: " + webContextPathName + " - " + configurableWAB.wabBundle);
                    }
                    configurableWAB.wabBundle = wabBundle;
                    if (configurableWAB.configuredContextPath != null) {
                        configurableWAB.wabRef.set(this.createWAB(configurableWAB.wabBundle, configurableWAB.configuredContextPath));
                    }
                }
                return configurableWAB;
            }
        }

        private void putConfigurableWAB(ConfigurableWAB configurableWAB) {
            Map<Region, ConfigurableWAB> configurableWABs = this.getOrCreateConfigurableWABMap(configurableWAB.webContextPathName);
            configurableWABs.put(configurableWAB.webContextPathRegion, configurableWAB);
        }

        private ConfigurableWAB findConfigurableWAB(Region region, String webContextPathName) {
            return this.getOrCreateConfigurableWABMap(webContextPathName).get(region);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<Region, ConfigurableWAB> getOrCreateConfigurableWABMap(String webContextPathName) {
            Map<String, Map<Region, ConfigurableWAB>> map = this.configurableContextPaths;
            synchronized (map) {
                Map<Region, ConfigurableWAB> configurableWABs = this.configurableContextPaths.get(webContextPathName);
                if (configurableWABs == null) {
                    configurableWABs = new HashMap<Region, ConfigurableWAB>();
                    this.configurableContextPaths.put(webContextPathName, configurableWABs);
                }
                return configurableWABs;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ConfigurableWAB createConfigurableWAB(ServiceReference<WABConfiguration> ref) {
            Map<String, Map<Region, ConfigurableWAB>> map = this.configurableContextPaths;
            synchronized (map) {
                Region region = this.digraph.getRegion(ref.getBundle());
                if (region == null) {
                    return null;
                }
                String webContextPathName = (String)ref.getProperty("contextName");
                String configuredContextPath = (String)ref.getProperty("contextPath");
                ConfigurableWAB configurableWAB = this.findConfigurableWAB(region, webContextPathName);
                if (configurableWAB == null) {
                    configurableWAB = new ConfigurableWAB(null, region, webContextPathName, configuredContextPath, null);
                    this.putConfigurableWAB(configurableWAB);
                } else {
                    if (configurableWAB.configuredContextPath != null) {
                        throw new IllegalStateException("A context path \"" + configurableWAB.configuredContextPath + "\" is already configured for the name: " + webContextPathName);
                    }
                    configurableWAB.configuredContextPath = configuredContextPath;
                    if (configurableWAB.wabBundle != null) {
                        configurableWAB.wabRef.set(this.createWAB(configurableWAB.wabBundle, configurableWAB.configuredContextPath));
                    }
                }
                return configurableWAB;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unconfigureContextPath(ConfigurableWAB configurableWAB) {
            Map<String, Map<Region, ConfigurableWAB>> map = this.configurableContextPaths;
            synchronized (map) {
                configurableWAB.configuredContextPath = null;
                Bundle wabBundle = configurableWAB.wabBundle;
                if (wabBundle != null) {
                    WABInstaller.restart(wabBundle);
                } else {
                    this.getOrCreateConfigurableWABMap(configurableWAB.webContextPathName).remove(configurableWAB.webContextPathRegion);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unconfigureWABBundle(ConfigurableWAB configurableWAB) {
            if (configurableWAB.webContextPathName == null) {
                return;
            }
            Map<String, Map<Region, ConfigurableWAB>> map = this.configurableContextPaths;
            synchronized (map) {
                configurableWAB.wabBundle = null;
                if (configurableWAB.configuredContextPath == null) {
                    this.getOrCreateConfigurableWABMap(configurableWAB.webContextPathName).remove(configurableWAB.webContextPathRegion);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private WAB createWAB(Bundle bundle, String webContextPath) {
            WAB addedWAB = new WAB(bundle, webContextPath, WABInstaller.this);
            WABInstaller.this.wabLifecycleDebug("Primary WAB Tracker processing new WAB", addedWAB);
            if (addedWAB.moveToDeploying()) {
                WABPathSpecificItemHolder wABPathSpecificItemHolder;
                WABPathSpecificItemHolder knownCollisionsHolder;
                WABPathSpecificItemHolder knownHolder;
                WABPathSpecificItemHolder holder = new WABPathSpecificItemHolder(addedWAB);
                WABPathSpecificItemHolder collisionsHolder = new WABPathSpecificItemHolder(addedWAB);
                Object object = WABInstaller.this.knownPaths;
                synchronized (object) {
                    knownHolder = WABInstaller.this.knownPaths.put(webContextPath, holder);
                    if (knownHolder != null) {
                        WABInstaller.this.knownPaths.put(webContextPath, knownHolder);
                    }
                }
                if (knownHolder != null) {
                    object = knownHolder;
                    synchronized (object) {
                        Collection<WAB> collisions = knownHolder.getWABs();
                        ArrayList<WAB> toRemove = new ArrayList<WAB>();
                        for (WAB w : collisions) {
                            Bundle collidingBundle = w.getBundle();
                            if (collidingBundle.getBundleId() != bundle.getBundleId()) continue;
                            WABInstaller.this.wabLifecycleDebug("Primary WAB Tracker cleaning up old known WAB for bundleId ", w, bundle.getBundleId());
                            w.terminateWAB();
                            toRemove.add(w);
                        }
                        knownHolder.getWABs().removeAll(toRemove);
                        knownHolder.getWABs().add(addedWAB);
                    }
                }
                object = WABInstaller.this.wabsEligibleForCollisionResolution;
                synchronized (object) {
                    knownCollisionsHolder = WABInstaller.this.wabsEligibleForCollisionResolution.put(webContextPath, collisionsHolder);
                    if (knownCollisionsHolder != null && !knownCollisionsHolder.getWABs().isEmpty()) {
                        WABInstaller.this.wabsEligibleForCollisionResolution.put(webContextPath, knownCollisionsHolder);
                        wABPathSpecificItemHolder = knownCollisionsHolder;
                        synchronized (wABPathSpecificItemHolder) {
                            WAB selfAlreadyInSet = null;
                            for (WAB w : knownCollisionsHolder.getWABs()) {
                                if (w.getBundle().getBundleId() != bundle.getBundleId()) continue;
                                w.terminateWAB();
                                selfAlreadyInSet = w;
                                knownCollisionsHolder = null;
                                break;
                            }
                            if (selfAlreadyInSet != null) {
                                knownCollisionsHolder.getWABs().remove(selfAlreadyInSet);
                            }
                        }
                    }
                }
                if (knownCollisionsHolder != null && !knownCollisionsHolder.getWABs().isEmpty()) {
                    long[] collisionIds;
                    wABPathSpecificItemHolder = knownCollisionsHolder;
                    synchronized (wABPathSpecificItemHolder) {
                        Collection<WAB> collisions = knownCollisionsHolder.getWABs();
                        ArrayList<WAB> toRemove = new ArrayList<WAB>();
                        collisionIds = new long[collisions.size()];
                        int i = 0;
                        for (WAB w : collisions) {
                            Bundle collidingBundle = w.getBundle();
                            collisionIds[i] = collidingBundle.getBundleId();
                            ++i;
                            if (collidingBundle.getBundleId() != bundle.getBundleId()) continue;
                            WABInstaller.this.wabLifecycleDebug("Primary WAB Tracker cleaning up old colliding WAB for bundleId ", w, bundle.getBundleId());
                            w.terminateWAB();
                            toRemove.add(w);
                        }
                        knownCollisionsHolder.getWABs().removeAll(toRemove);
                        if (!knownCollisionsHolder.getWABs().isEmpty()) {
                            ArrayList<String> collidingWabs = new ArrayList<String>(knownCollisionsHolder.getWABs().size());
                            for (WAB w : knownCollisionsHolder.getWABs()) {
                                collidingWabs.add(w.getBundle().toString());
                            }
                            Tr.error((TraceComponent)tc, (String)"wab.install.fail.clash", (Object[])new Object[]{bundle, webContextPath, collidingWabs});
                        }
                        knownCollisionsHolder.getWABs().add(addedWAB);
                    }
                    WABInstaller.this.wabLifecycleDebug("Primary WAB Tracker adding WAB to collision set.", addedWAB);
                    WABInstaller.this.postEvent(addedWAB.createFailedEvent(webContextPath, collisionIds));
                } else {
                    WABInstaller.this.wabLifecycleDebug("Primary WAB Tracker enabling SubTracker for new WAB", addedWAB);
                    addedWAB.enableTracker();
                }
                return addedWAB;
            }
            return null;
        }

        public void modifiedBundle(Bundle bundle, BundleEvent event, ConfigurableWAB configurable) {
        }

        public void removedBundle(Bundle bundle, BundleEvent event, ConfigurableWAB configurable) {
            this.removeWAB(configurable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeWAB(ConfigurableWAB configurable) {
            try {
                WABPathSpecificItemHolder wABPathSpecificItemHolder;
                WAB wab = configurable.wabRef.get();
                if (wab == null) {
                    return;
                }
                WABInstaller.this.wabLifecycleDebug("Primary WAB Tracker processing shutdown for ", wab);
                Map map = WABInstaller.this.knownPaths;
                synchronized (map) {
                    WABPathSpecificItemHolder holder = (WABPathSpecificItemHolder)WABInstaller.this.knownPaths.get(wab.getContextRoot());
                    if (holder != null) {
                        wABPathSpecificItemHolder = holder;
                        synchronized (wABPathSpecificItemHolder) {
                            holder.getWABs().remove(wab);
                        }
                    }
                }
                map = WABInstaller.this.wabsEligibleForCollisionResolution;
                synchronized (map) {
                    WABPathSpecificItemHolder eligibleWab = (WABPathSpecificItemHolder)WABInstaller.this.wabsEligibleForCollisionResolution.get(wab.getContextRoot());
                    if (eligibleWab != null) {
                        wABPathSpecificItemHolder = eligibleWab;
                        synchronized (wABPathSpecificItemHolder) {
                            eligibleWab.getWABs().remove(wab);
                        }
                    }
                }
            }
            finally {
                this.unconfigureWABBundle(configurable);
            }
        }

        public AtomicReference<ConfigurableWAB> addingService(ServiceReference<WABConfiguration> ref) {
            return this.configurableWAB(new AtomicReference<ConfigurableWAB>(), ref);
        }

        private AtomicReference<ConfigurableWAB> configurableWAB(AtomicReference<ConfigurableWAB> configurableWABref, ServiceReference<WABConfiguration> ref) {
            ConfigurableWAB configurableWAB = this.createConfigurableWAB(ref);
            configurableWABref.set(configurableWAB);
            return configurableWABref;
        }

        public void modifiedService(ServiceReference<WABConfiguration> ref, AtomicReference<ConfigurableWAB> tracked) {
            this.unconfigureContextPath(tracked.get());
            if (ref.getBundle() != null) {
                this.configurableWAB(tracked, ref);
            }
        }

        public void removedService(ServiceReference<WABConfiguration> ref, AtomicReference<ConfigurableWAB> tracked) {
            this.unconfigureContextPath(tracked.get());
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(WABTrackerCustomizer.class, (String[])new String[]{"webcontainer", "applications", "app.manager"}, (String)"com.ibm.ws.app.manager.wab.internal.resources.Messages", (String)"com.ibm.ws.app.manager.wab.internal.WABInstaller$WABTrackerCustomizer");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static final class ConfigurableWAB {
        Bundle wabBundle = null;
        String configuredContextPath;
        final AtomicReference<WAB> wabRef;
        final String webContextPathName;
        final Region webContextPathRegion;
        static final long serialVersionUID = 6011678830634994086L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ConfigurableWAB(Bundle wabBundle, Region region, String webContextPathName, String configuredContextPath, WAB wab) {
            this.wabBundle = wabBundle;
            this.webContextPathName = webContextPathName;
            this.configuredContextPath = configuredContextPath;
            this.wabRef = new AtomicReference<WAB>(wab);
            this.webContextPathRegion = region;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ConfigurableWAB.class, (String[])new String[]{"webcontainer", "applications", "app.manager"}, (String)"com.ibm.ws.app.manager.wab.internal.resources.Messages", (String)"com.ibm.ws.app.manager.wab.internal.WABInstaller$ConfigurableWAB");
        }
    }

    private static interface WABLifeCycle {
    }
}

