/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.tx.config.ConfigurationProviderManager;
import com.ibm.tx.util.alarm.Alarm;
import com.ibm.tx.util.alarm.AlarmListener;
import com.ibm.tx.util.alarm.AlarmManager;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.HeartbeatLog;
import com.ibm.ws.recoverylog.spi.LogClosedException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class HeartbeatLogManager {
    private static final TraceComponent tc = Tr.register(HeartbeatLogManager.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static TimeoutInfo _info;
    static final long serialVersionUID = -2796586930005746084L;

    @ManualTrace
    public static void setTimeout(HeartbeatLog heartbeatLog, int peerLockTimeBetweenHeartbeats) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setTimeout", (Object[])new Object[]{heartbeatLog, peerLockTimeBetweenHeartbeats});
        }
        HeartbeatLogManager.stopTimeout();
        _info = new TimeoutInfo(heartbeatLog, peerLockTimeBetweenHeartbeats);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setTimeout", (Object)_info);
        }
    }

    public static void stopTimeout() {
        if (_info != null) {
            _info.cancelAlarm();
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class TimeoutInfo
    implements AlarmListener {
        protected HeartbeatLog _heartbeatLog;
        protected final int _duration;
        private Alarm _alarm;
        private volatile boolean _isHeartbeating = true;
        private final AlarmManager _alarmManager = ConfigurationProviderManager.getConfigurationProvider().getAlarmManager();
        static final long serialVersionUID = -5864075247134516241L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @ManualTrace
        protected TimeoutInfo(HeartbeatLog heartbeatLog, int duration) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"TimeoutInfo", (Object[])new Object[]{heartbeatLog, duration});
            }
            this._duration = duration;
            this._heartbeatLog = heartbeatLog;
            if (this._heartbeatLog != null) {
                this._alarm = this._alarmManager.scheduleAlarm((long)this._duration * 1000L, (AlarmListener)this, null);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"TimeoutInfo");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ManualTrace
        @FFDCIgnore(value={LogClosedException.class})
        public void alarm(Object alarmContext) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"alarm", (Object[])new Object[0]);
            }
            if (this._heartbeatLog != null && this._isHeartbeating) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Update the HADB timestamp", (Object[])new Object[0]);
                }
                try {
                    this._heartbeatLog.heartBeat();
                }
                catch (LogClosedException e) {
                    this._isHeartbeating = false;
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"NULL heartbeatLog or heartbeating cancelled", (Object[])new Object[0]);
                }
                this._isHeartbeating = false;
            }
            TimeoutInfo timeoutInfo = this;
            synchronized (timeoutInfo) {
                if (this._heartbeatLog != null && this._isHeartbeating) {
                    this._alarm = this._alarmManager.scheduleAlarm((long)this._duration * 1000L, (AlarmListener)this, null);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"alarm");
            }
        }

        @ManualTrace
        public synchronized void cancelAlarm() {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"cancelAlarm", (Object[])new Object[]{this._alarm});
            }
            this._isHeartbeating = false;
            if (this._alarm != null) {
                this._alarm.cancel();
                this._alarm = null;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"cancelAlarm");
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.recoverylog.spi.HeartbeatLogManager$TimeoutInfo", TimeoutInfo.class, null, null);
        }
    }
}

