/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.LogRecord;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import java.nio.ByteBuffer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WriteableLogRecord
extends LogRecord {
    private static final TraceComponent tc = Tr.register(WriteableLogRecord.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    private final long _sequenceNumber;
    static final long serialVersionUID = -1243372223489304644L;

    @ManualTrace
    protected WriteableLogRecord(ByteBuffer buffer, long sequenceNumber, int length, int absolutePosition) {
        super(buffer, absolutePosition);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"WriteableLogRecord", (Object[])new Object[]{buffer, sequenceNumber, length, absolutePosition});
        }
        this._buffer.put(RECORD_MAGIC_NUMBER);
        this._buffer.putLong(sequenceNumber);
        this._buffer.putInt(length);
        this._sequenceNumber = sequenceNumber;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"WriteableLogRecord", (Object)this);
        }
    }

    @ManualTrace
    protected void put(byte[] bytes) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"put", (Object[])new Object[]{RLSUtils.toHexString(bytes, 32), this});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Writing at position " + this._buffer.position()), (Object[])new Object[0]);
        }
        this._buffer.put(bytes);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"put");
        }
    }

    protected void putInt(int data) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Writing at position " + this._buffer.position()), (Object[])new Object[]{data, this});
        }
        this._buffer.putInt(data);
    }

    protected void putLong(long data) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Writing at position " + this._buffer.position()), (Object[])new Object[]{data, this});
        }
        this._buffer.putLong(data);
    }

    protected void putShort(short data) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Writing at position " + this._buffer.position()), (Object[])new Object[]{data, this});
        }
        this._buffer.putShort(data);
    }

    protected void putBoolean(boolean data) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Writing at position " + this._buffer.position()), (Object[])new Object[]{data, this});
        }
        this._buffer.put(data ? (byte)1 : 0);
    }

    @ManualTrace
    protected void close() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"close", (Object[])new Object[]{this});
        }
        this._buffer.putLong(this._sequenceNumber);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"close");
        }
    }
}

