/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.impl.weld;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.cdi.CDIException;
import com.ibm.ws.cdi.impl.weld.ResourceLoaderImpl;
import com.ibm.ws.cdi.internal.interfaces.ArchiveType;
import com.ibm.ws.cdi.internal.interfaces.CDIArchive;
import com.ibm.ws.cdi.internal.interfaces.CDIRuntime;
import com.ibm.ws.cdi.internal.interfaces.CDIUtils;
import com.ibm.ws.cdi.internal.interfaces.EjbEndpointService;
import com.ibm.ws.cdi.internal.interfaces.EndPointsInfo;
import com.ibm.ws.cdi.internal.interfaces.ManagedBeanDescriptor;
import com.ibm.ws.cdi.internal.interfaces.Resource;
import com.ibm.ws.cdi.internal.interfaces.WebSphereBeanDeploymentArchive;
import com.ibm.ws.cdi.internal.interfaces.WebSphereCDIDeployment;
import com.ibm.ws.cdi.internal.interfaces.WebSphereEjbServices;
import com.ibm.ws.cdi.internal.interfaces.WebSphereInjectionServices;
import com.ibm.ws.cdi.utils.WeldCDIUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.injectionengine.ReferenceContext;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.DefinitionException;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.inject.Inject;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedField;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeanDiscoveryMode;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.bootstrap.spi.EEModuleDescriptor;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.injection.FieldInjectionPoint;
import org.jboss.weld.injection.InjectionPointFactory;
import org.jboss.weld.injection.spi.InjectionServices;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.api.WeldInjectionTarget;
import org.jboss.weld.manager.api.WeldInjectionTargetFactory;
import org.jboss.weld.manager.api.WeldManager;
import org.jboss.weld.resources.MemberTransformer;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class BeanDeploymentArchiveImpl
implements WebSphereBeanDeploymentArchive {
    private final Set<String> archiveClassNames = new HashSet<String>();
    private final Set<String> allClasses = new HashSet<String>();
    private final Map<String, Class<?>> beanClasses = new TreeMap();
    private final ClassLoader classloader;
    private final Set<Class<?>> ejbClasses = new HashSet();
    private final Set<Class<?>> managedBeanClasses = new HashSet();
    private final Set<Class<?>> injectionClasses = new HashSet();
    private final Set<Class<?>> jeeComponentClasses = new HashSet();
    private final Set<String> additionalClasses = new HashSet<String>();
    private final Set<String> additionalBeanDefiningAnnotations = new HashSet<String>();
    private final Set<String> extensionClassNames = new HashSet<String>();
    private final Set<Supplier<Object>> spiExtensionSuppliers = new HashSet<Supplier<Object>>();
    private final ServiceRegistry weldServiceRegistry;
    private final String id;
    private final EEModuleDescriptor eeModuleDescriptor;
    private final Set<WebSphereBeanDeploymentArchive> accessibleBDAs = new HashSet<WebSphereBeanDeploymentArchive>();
    private final Set<WebSphereBeanDeploymentArchive> descendantBDAs = new HashSet<WebSphereBeanDeploymentArchive>();
    private final WebSphereCDIDeployment cdiDeployment;
    private final Set<EjbDescriptor<?>> ejbDescriptors = new HashSet();
    private final Map<Class<?>, Set<EjbDescriptor<?>>> ejbDescriptorMap = new HashMap();
    private boolean scanned = false;
    private boolean hasBeans = false;
    private boolean endpointsScanned = false;
    private final Set<Class<?>> nonCDIInterceptors = new HashSet();
    private BeansXml beansXml;
    private BeanDiscoveryMode beanDiscoveryMode = null;
    private Set<String> directBeanDefiningAnnotations;
    private Set<String> accessibleBeanDefiningAnnotations;
    private final CDIRuntime cdiRuntime;
    private Boolean isExtension = null;
    private final boolean extensionCanSeeApplicationBDAs;
    private final ResourceLoader resourceLoader;
    private final Map<Class<?>, InjectionTarget<?>> injectionTargets = new HashMap();
    private final Map<Class<?>, List<InjectionPoint>> staticInjectionPoints = new HashMap();
    private final CDIArchive archive;
    private static final TraceComponent tc = Tr.register(BeanDeploymentArchiveImpl.class, (String)"JCDI", (String)"com.ibm.ws.cdi.internal.resources.CDI");
    static final long serialVersionUID = -4884162476968247746L;

    BeanDeploymentArchiveImpl(WebSphereCDIDeployment cdiDeployment, String archiveID, CDIArchive archive, CDIRuntime cdiRuntime, Set<String> archiveClassNames, Set<String> additionalClasses, Set<String> additionalBeanDefiningAnnotations, boolean extensionCanSeeApplicationBDAs, Set<String> extensionClassNames, EEModuleDescriptor eeModuleDescriptor) throws CDIException {
        this.id = archiveID;
        this.eeModuleDescriptor = eeModuleDescriptor;
        this.archive = archive;
        this.classloader = archive.getClassLoader();
        this.cdiDeployment = cdiDeployment;
        this.extensionCanSeeApplicationBDAs = extensionCanSeeApplicationBDAs;
        this.archiveClassNames.addAll(archiveClassNames);
        this.additionalBeanDefiningAnnotations.addAll(additionalBeanDefiningAnnotations);
        this.additionalClasses.addAll(additionalClasses);
        this.additionalClasses.addAll(additionalBeanDefiningAnnotations);
        this.allClasses.addAll(this.archiveClassNames);
        this.allClasses.addAll(this.additionalClasses);
        this.extensionClassNames.addAll(extensionClassNames);
        this.cdiRuntime = cdiRuntime;
        this.weldServiceRegistry = new SimpleServiceRegistry();
        this.resourceLoader = new ResourceLoaderImpl(archive.getClassLoader());
        EjbEndpointService ejbEndpointService = cdiRuntime.getEjbEndpointService();
        if (ejbEndpointService != null) {
            WebSphereEjbServices ejbServices = ejbEndpointService.getWebSphereEjbServices(cdiDeployment.getDeploymentID());
            this.weldServiceRegistry.add(EjbServices.class, (Service)ejbServices);
        }
        WebSphereInjectionServices injectionServices = cdiDeployment.getInjectionServices();
        this.weldServiceRegistry.add(InjectionServices.class, (Service)injectionServices);
        this.weldServiceRegistry.add(ResourceLoader.class, (Service)this.resourceLoader);
        this.weldServiceRegistry.add(EEModuleDescriptor.class, (Service)eeModuleDescriptor);
    }

    public Set<String> scanForBeanDefiningAnnotations(boolean includeAccessible) throws CDIException {
        HashSet<String> beanDefiningAnnotations = new HashSet<String>(this.additionalBeanDefiningAnnotations);
        if (this.directBeanDefiningAnnotations == null) {
            this.directBeanDefiningAnnotations = new HashSet<String>();
            BeanDiscoveryMode mode = this.getBeanDiscoveryMode();
            if (mode != BeanDiscoveryMode.NONE) {
                this.directBeanDefiningAnnotations.addAll(this.archive.getBeanDefiningAnnotations());
                this.directBeanDefiningAnnotations.retainAll(this.archiveClassNames);
            }
            this.directBeanDefiningAnnotations.addAll(CDIUtils.BEAN_DEFINING_ANNOTATION_NAMES);
        }
        beanDefiningAnnotations.addAll(this.directBeanDefiningAnnotations);
        if (includeAccessible) {
            if (this.accessibleBeanDefiningAnnotations == null) {
                this.accessibleBeanDefiningAnnotations = new HashSet<String>();
                for (WebSphereBeanDeploymentArchive child : this.accessibleBDAs) {
                    this.accessibleBeanDefiningAnnotations.addAll(child.scanForBeanDefiningAnnotations(false));
                }
            }
            beanDefiningAnnotations.addAll(this.accessibleBeanDefiningAnnotations);
        }
        return beanDefiningAnnotations;
    }

    private BeanDiscoveryMode getBeanDiscoveryMode() {
        if (this.beanDiscoveryMode == null) {
            BeansXml beansXml = this.getBeansXml();
            this.beanDiscoveryMode = BeanDiscoveryMode.ANNOTATED;
            if (beansXml != null) {
                this.beanDiscoveryMode = beansXml.getBeanDiscoveryMode();
            } else if (this.cdiRuntime.isImplicitBeanArchivesScanningDisabled(this.archive) || this.isExtension()) {
                this.beanDiscoveryMode = BeanDiscoveryMode.NONE;
            }
        }
        return this.beanDiscoveryMode;
    }

    public void scan() throws CDIException {
        if (!this.scanned) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("scan [ " + this.getHumanReadableName() + " ] BEGIN SCAN"), (Object[])new Object[0]);
            }
            this.scanned = true;
            for (WebSphereBeanDeploymentArchive child : this.accessibleBDAs) {
                if (child.hasBeenScanned()) continue;
                child.scan();
            }
            Set<String> rawBeanclassNames = this.scanForBeanClassNames();
            ClassLoader classLoader = this.getClassLoader();
            Map loadedBeanClasses = CDIUtils.loadClasses((ClassLoader)classLoader, rawBeanclassNames);
            for (Map.Entry classEntry : loadedBeanClasses.entrySet()) {
                String className = (String)classEntry.getKey();
                Class loadedClass = (Class)classEntry.getValue();
                ClassLoader actualClassLoader = loadedClass.getClassLoader();
                if (actualClassLoader != classLoader && this.isAccessibleBean(loadedClass)) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && this.beanClasses.containsKey(className)) {
                    Tr.debug((TraceComponent)tc, (String)("beanClasses key collision for " + className), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("Old class " + this.beanClasses.get(className).getCanonicalName() + this.beanClasses.get(className).getClassLoader().toString()), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("New class " + loadedClass.getCanonicalName() + loadedClass.getClassLoader().toString()), (Object[])new Object[0]);
                }
                this.beanClasses.put(className, loadedClass);
            }
        }
        boolean bl = this.hasBeans = this.beanClasses.size() > 0;
        if (this.archive.getType() != ArchiveType.RUNTIME_EXTENSION) {
            this.scanForEndpoints();
        }
        this.initializeInjectionClasses(this.beanClasses.values());
        this.initializeJEEComponentClasses(this.allClasses);
    }

    private boolean isAccessibleBean(Class<?> beanClass) {
        boolean accessibleBean = false;
        for (WebSphereBeanDeploymentArchive child : this.accessibleBDAs) {
            if (!child.containsBeanClass(beanClass)) continue;
            accessibleBean = true;
            break;
        }
        return accessibleBean;
    }

    @ManualTrace
    private Set<String> scanForBeanClassNames() throws CDIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("scanForBeanClassNames [ " + this.getHumanReadableName() + " ]"), (Object[])new Object[0]);
        }
        HashSet<String> classNames = new HashSet<String>();
        BeanDiscoveryMode mode = this.getBeanDiscoveryMode();
        if (mode == BeanDiscoveryMode.ANNOTATED) {
            Set<String> beanDefiningAnnotations = this.scanForBeanDefiningAnnotations(true);
            Set scannedClassNames = this.archive.getAnnotatedClasses(beanDefiningAnnotations);
            scannedClassNames.retainAll(this.archiveClassNames);
            classNames.addAll(scannedClassNames);
        } else if (mode == BeanDiscoveryMode.ALL) {
            classNames.addAll(this.archiveClassNames);
        }
        if (mode != BeanDiscoveryMode.ALL && this.isExtension()) {
            classNames.addAll(this.extensionClassNames);
        }
        classNames.addAll(this.additionalClasses);
        if (this.archive.getType() == ArchiveType.CLIENT_MODULE) {
            String appMainClassName = this.archive.getClientModuleMainClass();
            classNames.remove(appMainClassName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            String beanNames = String.join((CharSequence)", ", classNames);
            Tr.exit((TraceComponent)tc, (String)("scanForBeanClassNames [ " + this.getHumanReadableName() + " ] { " + classNames + " }"));
        }
        return classNames;
    }

    @ManualTrace
    private void initializeInjectionClasses(Collection<Class<?>> beanClasses) throws CDIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            String beanNames = beanClasses.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(", "));
            Tr.entry((TraceComponent)tc, (String)("initializeInjectionClasses [ " + this.getHumanReadableName() + " ] {" + beanNames + "}"), (Object[])new Object[0]);
        }
        HashSet classes = new HashSet();
        classes.addAll(beanClasses);
        if (this.archive.getType() == ArchiveType.CLIENT_MODULE) {
            Map<String, Class<?>> clientClasses = this.getClientContainerManagedClasses();
            classes.removeAll(clientClasses.values());
        }
        this.removeVetoedClasses(classes);
        classes.removeAll(this.getEJBClasses());
        classes.removeAll(this.getManagedBeanClasses());
        this.injectionClasses.addAll(classes);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            String beanNames = this.injectionClasses.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(", "));
            Tr.exit((TraceComponent)tc, (String)("initializeInjectionClasses [ " + this.getHumanReadableName() + " ] {" + beanNames + "}"));
        }
    }

    @ManualTrace
    private void initializeJEEComponentClasses(Set<String> allClassNames) throws CDIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            String classNames = String.join((CharSequence)", ", allClassNames);
            Tr.entry((TraceComponent)tc, (String)("initializeJEEComponentClasses [ " + this.getHumanReadableName() + " ] {" + classNames + "}"), (Object[])new Object[0]);
        }
        HashSet classes = new HashSet();
        ClassLoader classLoader = this.getClassLoader();
        List jeeComponentClassNames = this.archive.getInjectionClassList();
        if (jeeComponentClassNames != null && jeeComponentClassNames.size() > 0) {
            for (String string : allClassNames) {
                if (!jeeComponentClassNames.contains(string)) continue;
                Class clazz = CDIUtils.loadClass((ClassLoader)classLoader, (String)string);
                if (clazz != null) {
                    classes.add(clazz);
                    continue;
                }
                Tr.debug((TraceComponent)tc, (String)"jee Component Class was null", (Object[])new Object[]{string});
            }
        }
        Collection<EjbDescriptor<?>> ejbs = this.getEjbs();
        for (EjbDescriptor<?> ejb : ejbs) {
            if (!ejb.isMessageDriven()) continue;
            classes.add(ejb.getBeanClass());
            if (ejb.getBeanClass() != null) continue;
            Tr.debug((TraceComponent)tc, (String)"Message Bean's bean class was null", (Object[])new Object[]{ejb});
        }
        Set<Class<?>> set = this.getManagedBeanClasses();
        classes.addAll(set);
        if (this.archive.getType() == ArchiveType.CLIENT_MODULE) {
            Map<String, Class<?>> clientClasses = this.getClientContainerManagedClasses();
            classes.addAll(clientClasses.values());
        }
        classes.addAll(this.nonCDIInterceptors);
        this.jeeComponentClasses.addAll(classes);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            String names = this.jeeComponentClasses.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(", "));
            Tr.exit((TraceComponent)tc, (String)("initializeJEEComponentClasses [ " + this.getHumanReadableName() + " ] {" + names + "}"));
        }
    }

    @ManualTrace
    private void scanForEndpoints() throws CDIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("scanForEndpoints [ " + this.getHumanReadableName() + " ]"), (Object[])new Object[0]);
        }
        if (!this.endpointsScanned) {
            this.endpointsScanned = true;
            EjbEndpointService ejbEndpointService = this.cdiRuntime.getEjbEndpointService();
            if (ejbEndpointService != null) {
                ArchiveType type = this.getType();
                if (type == ArchiveType.EJB_MODULE) {
                    EndPointsInfo endPointsInfo = ejbEndpointService.getEndPointsInfo(this.archive);
                    this.addManagedBeanDescriptors(endPointsInfo.getManagedBeanDescriptors());
                    this.addEjbDescriptors(endPointsInfo.getEJBDescriptors());
                    this.nonCDIInterceptors.addAll(endPointsInfo.getNonCDIInterceptors());
                } else if (type == ArchiveType.WEB_MODULE) {
                    Class clazz;
                    boolean added;
                    EndPointsInfo endPointsInfo = ejbEndpointService.getEndPointsInfo(this.archive);
                    Set ejbDescriptors = endPointsInfo.getEJBDescriptors();
                    Set managedBeanDescriptors = endPointsInfo.getManagedBeanDescriptors();
                    for (ManagedBeanDescriptor managedBeanDescriptor : managedBeanDescriptors) {
                        added = false;
                        for (WebSphereBeanDeploymentArchive child : this.getWebSphereBeanDeploymentArchives()) {
                            if (!child.getAllClazzes().contains(managedBeanDescriptor.getBeanClass().getName()) || (clazz = CDIUtils.loadClass((ClassLoader)this.classloader, (String)managedBeanDescriptor.getBeanClass().getName())) != managedBeanDescriptor.getBeanClass()) continue;
                            child.addManagedBeanDescriptor(managedBeanDescriptor);
                            added = true;
                            break;
                        }
                        if (added) continue;
                        this.addManagedBeanDescriptor(managedBeanDescriptor);
                    }
                    for (EjbDescriptor ejbDescriptor : ejbDescriptors) {
                        added = false;
                        for (WebSphereBeanDeploymentArchive child : this.getWebSphereBeanDeploymentArchives()) {
                            if (!child.getAllClazzes().contains(ejbDescriptor.getBeanClass().getName()) || (clazz = CDIUtils.loadClass((ClassLoader)this.classloader, (String)ejbDescriptor.getBeanClass().getName())) != ejbDescriptor.getBeanClass()) continue;
                            child.addEjbDescriptor(ejbDescriptor);
                            added = true;
                            break;
                        }
                        if (added) continue;
                        this.addEjbDescriptor(ejbDescriptor);
                    }
                    this.nonCDIInterceptors.addAll(endPointsInfo.getNonCDIInterceptors());
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("scanForEndpoints [ " + this.getHumanReadableName() + " ]"));
        }
    }

    private Map<String, Class<?>> getClientContainerManagedClasses() throws CDIException {
        Map clientClasses = null;
        if (this.archive.getType() == ArchiveType.CLIENT_MODULE) {
            HashSet<String> classNames = new HashSet<String>();
            String appMainClassName = null;
            String appCallbackHandlerName = null;
            appMainClassName = this.archive.getClientModuleMainClass();
            appCallbackHandlerName = this.archive.getClientAppCallbackHandlerName();
            if (appMainClassName != null) {
                classNames.add(appMainClassName);
            }
            if (appCallbackHandlerName != null) {
                classNames.add(appCallbackHandlerName);
            }
            clientClasses = CDIUtils.loadClasses((ClassLoader)this.archive.getClassLoader(), classNames);
        }
        return clientClasses;
    }

    public ReferenceContext initializeInjectionServices() throws CDIException {
        Set<Class<?>> injectionClasses = this.getInjectionClasses();
        ReferenceContext referenceContext = this.archive.getReferenceContext(injectionClasses);
        return referenceContext;
    }

    @ManualTrace
    private void removeVetoedClasses(Set<Class<?>> classes) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            String vetoedClassNames = classes.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(", "));
            Tr.entry((TraceComponent)tc, (String)("removeVetoedClasses [ " + this.getHumanReadableName() + " ] {" + vetoedClassNames + "}"), (Object[])new Object[0]);
        }
        HashSet<String> classNames = new HashSet<String>();
        for (Class<?> clazz : classes) {
            classNames.add(clazz.getName());
        }
        Collection includedClasses = WeldCDIUtils.filterClassesBasedOnBeansXML((BeansXml)this.beansXml, (ResourceLoader)this.resourceLoader, classNames);
        Iterator<Class<?>> iterator = classes.iterator();
        while (iterator.hasNext()) {
            Class<?> clazz = iterator.next();
            if (WeldCDIUtils.isClassVetoed(clazz)) {
                iterator.remove();
                continue;
            }
            if (includedClasses.contains(clazz.getName())) continue;
            iterator.remove();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("removeVetoedClasses [ " + this.getHumanReadableName() + " ]"));
        }
    }

    public Set<Class<?>> getInjectionClasses() {
        HashSet classes = new HashSet(this.injectionClasses);
        for (WebSphereBeanDeploymentArchive bda : this.descendantBDAs) {
            classes.addAll(bda.getInjectionClasses());
        }
        return classes;
    }

    public Set<Class<?>> getJEEComponentClasses() {
        HashSet classes = new HashSet(this.jeeComponentClasses);
        for (WebSphereBeanDeploymentArchive bda : this.descendantBDAs) {
            classes.addAll(bda.getJEEComponentClasses());
        }
        return classes;
    }

    public boolean hasBeans() {
        return this.hasBeans;
    }

    @Trivial
    public Set<String> getAllClazzes() {
        return this.allClasses;
    }

    public Collection<String> getBeanClasses() {
        return this.beanClasses.keySet();
    }

    public boolean containsBeanClass(Class<?> beanClass) {
        boolean containsBeanClass = false;
        Class<?> localBeanClass = this.beanClasses.get(beanClass.getName());
        if (localBeanClass != null && beanClass.equals(localBeanClass)) {
            containsBeanClass = true;
        }
        return containsBeanClass;
    }

    public Collection<BeanDeploymentArchive> getBeanDeploymentArchives() {
        return new ArrayList<WebSphereBeanDeploymentArchive>(this.accessibleBDAs);
    }

    public void addBeanDeploymentArchive(WebSphereBeanDeploymentArchive accessibleBDA) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("addBeanDeploymentArchive: [ " + accessibleBDA + " ] will be visible to [ " + this.getHumanReadableName() + " ]"), (Object[])new Object[0]);
        }
        this.accessibleBDAs.add(accessibleBDA);
    }

    public void addDescendantBda(WebSphereBeanDeploymentArchive descendantBda) {
        this.descendantBDAs.add(descendantBda);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeansXml getBeansXml() {
        Resource beansXmlResource;
        if (this.beansXml == null && (beansXmlResource = this.archive.getBeansXml()) != null) {
            URL beansXmlUrl = beansXmlResource.getURL();
            ClassLoader origTCCL = BeanDeploymentArchiveImpl.getContextClassLoader();
            try {
                BeanDeploymentArchiveImpl.setContextClassLoader(BeanDeploymentArchiveImpl.class.getClassLoader());
                this.beansXml = this.getCDIRuntime().getBeanParser().parse(this.getCDIDeployment(), beansXmlUrl);
            }
            finally {
                BeanDeploymentArchiveImpl.setContextClassLoader(origTCCL);
            }
        }
        return this.beansXml;
    }

    public boolean isExtension() {
        if (this.isExtension == null) {
            Set extensionClazz;
            this.isExtension = this.archive.getType() == ArchiveType.ON_DEMAND_LIB ? Boolean.valueOf(false) : Boolean.valueOf(!(extensionClazz = this.archive.getExtensionClasses()).isEmpty());
        }
        return this.isExtension;
    }

    public Collection<EjbDescriptor<?>> getEjbs() {
        return this.ejbDescriptors;
    }

    private Set<Class<?>> getEJBClasses() {
        return this.ejbClasses;
    }

    private Set<Class<?>> getManagedBeanClasses() {
        return this.managedBeanClasses;
    }

    public String getId() {
        return this.id;
    }

    public ServiceRegistry getServices() {
        return this.weldServiceRegistry;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    @Trivial
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BeanDeploymentArchiveImpl other = (BeanDeploymentArchiveImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public CDIArchive getArchive() {
        return this.archive;
    }

    public WeldManager getBeanManager() {
        return this.getCDIDeployment().getBootstrap().getManager((BeanDeploymentArchive)this);
    }

    public String toString() {
        return this.getHumanReadableName();
    }

    @Trivial
    private String getHumanReadableName() {
        return "BDA for " + this.id + "(" + this.archive.getType() + ")";
    }

    public WebSphereCDIDeployment getCDIDeployment() {
        return this.cdiDeployment;
    }

    public boolean extensionCanSeeApplicationBDAs() {
        return this.archive.getType() == ArchiveType.RUNTIME_EXTENSION && this.extensionCanSeeApplicationBDAs;
    }

    public Set<WebSphereBeanDeploymentArchive> getWebSphereBeanDeploymentArchives() {
        return this.accessibleBDAs;
    }

    public Set<WebSphereBeanDeploymentArchive> getDescendantBdas() {
        return this.descendantBDAs;
    }

    public void addEjbDescriptors(Collection<EjbDescriptor<?>> ejbDescriptors) {
        for (EjbDescriptor<?> ejbDescriptor : ejbDescriptors) {
            this.addEjbDescriptor(ejbDescriptor);
        }
    }

    public void addManagedBeanDescriptors(Collection<ManagedBeanDescriptor<?>> managedBeanDescriptors) {
        for (ManagedBeanDescriptor<?> managedBeanDescriptor : managedBeanDescriptors) {
            this.addManagedBeanDescriptor(managedBeanDescriptor);
        }
    }

    @ManualTrace
    public void addEjbDescriptor(EjbDescriptor<?> ejbDescriptor) {
        Tr.entry((TraceComponent)tc, (String)("addEjbDescriptor. Adding EjbDescriptor: " + ejbDescriptor + " with ejbName: " + ejbDescriptor.getEjbName() + " to bda: " + this.getHumanReadableName()), (Object[])new Object[0]);
        if (this.getBeanDiscoveryMode() != BeanDiscoveryMode.NONE) {
            this.ejbDescriptors.add(ejbDescriptor);
            Class beanClass = ejbDescriptor.getBeanClass();
            this.beanClasses.put(beanClass.getName(), beanClass);
            this.ejbClasses.add(beanClass);
            Set<EjbDescriptor<?>> ejbDescriptors = this.ejbDescriptorMap.get(beanClass);
            if (ejbDescriptors == null) {
                ejbDescriptors = new HashSet();
            }
            ejbDescriptors.add(ejbDescriptor);
            this.ejbDescriptorMap.put(beanClass, ejbDescriptors);
            this.hasBeans = true;
        }
    }

    public void addManagedBeanDescriptor(ManagedBeanDescriptor<?> managedBeanDescriptor) {
        if (this.getBeanDiscoveryMode() != BeanDiscoveryMode.NONE) {
            this.managedBeanClasses.add(managedBeanDescriptor.getBeanClass());
            if (managedBeanDescriptor.getBeanClass() == null) {
                Tr.debug((TraceComponent)tc, (String)"Managed bean descriptor's bean class was null", (Object[])new Object[]{managedBeanDescriptor});
            }
        }
    }

    public CDIRuntime getCDIRuntime() {
        return this.cdiRuntime;
    }

    public void addToBeanClazzes(Class<?> clazz) {
        this.beanClasses.put(clazz.getName(), clazz);
        this.allClasses.add(clazz.getName());
    }

    public void createInjectionTargetsForJEEComponentClasses() throws CDIException {
        Set<Class<?>> jeeComponentClasses = this.getJEEComponentClasses();
        block0: for (Class<?> clazz : jeeComponentClasses) {
            if (this.allClasses.contains(clazz.getName())) {
                this.createInjectionTargetsForJEEComponentClass(clazz);
                continue;
            }
            for (WebSphereBeanDeploymentArchive child : this.getDescendantBdas()) {
                if (!child.getAllClazzes().contains(clazz.getName())) continue;
                child.createInjectionTargetsForJEEComponentClass(clazz);
                continue block0;
            }
        }
    }

    public void createInjectionTargetsForJEEComponentClass(Class<?> clazz) throws CDIException {
        this.createJEEComponentInjectionTarget(clazz);
        if (this.archive.getType() == ArchiveType.CLIENT_MODULE) {
            String mainClassName = this.archive.getClientModuleMainClass();
            if (clazz.getName().equals(mainClassName)) {
                this.createStaticFieldInjectionPoints(clazz);
            }
        }
    }

    private <T, X> InjectionPoint fireProcessInjectionPoint(Class<T> clazz, AnnotatedField<X> field) {
        BeanManagerImpl beanManager = (BeanManagerImpl)this.getBeanManager();
        InjectionPointFactory factory = InjectionPointFactory.instance();
        EnhancedAnnotatedField enhancedField = (EnhancedAnnotatedField)((MemberTransformer)beanManager.getServices().get(MemberTransformer.class)).loadEnhancedMember(field, this.getId());
        FieldInjectionPoint injectionPoint = factory.createFieldInjectionPoint(enhancedField, null, clazz, beanManager);
        return injectionPoint;
    }

    private <X> void createStaticFieldInjectionPoints(Class<X> clazz) {
        WeldManager beanManager = this.getBeanManager();
        AnnotatedType annotatedType = beanManager.createAnnotatedType(clazz);
        Set fields = annotatedType.getFields();
        for (AnnotatedField field : fields) {
            if (!field.isAnnotationPresent(Inject.class) || !field.isStatic()) continue;
            InjectionPoint injectionPoint = this.fireProcessInjectionPoint(clazz, field);
            List<InjectionPoint> injectionPoints = this.staticInjectionPoints.get(clazz);
            if (injectionPoints == null) {
                injectionPoints = new ArrayList<InjectionPoint>();
                this.staticInjectionPoints.put(clazz, injectionPoints);
            }
            injectionPoints.add(injectionPoint);
        }
    }

    /*
     * WARNING - void declaration
     */
    private <T> void createJEEComponentInjectionTarget(Class<T> clazz) {
        WeldManager beanManager = this.getBeanManager();
        AnnotatedType annotatedType = null;
        try {
            annotatedType = beanManager.createAnnotatedType(clazz);
        }
        catch (ResourceLoadingException resourceLoadingException) {
            FFDCFilter.processException((Throwable)resourceLoadingException, (String)"com.ibm.ws.cdi.impl.weld.BeanDeploymentArchiveImpl", (String)"938", (Object)this, (Object[])new Object[]{clazz});
        }
        if (annotatedType != null) {
            try {
                InjectionTarget injectionTarget;
                if (this.nonCDIInterceptors.contains(clazz)) {
                    WeldInjectionTargetFactory weldInjectionTargetFactory = this.getBeanManager().getInjectionTargetFactory(annotatedType);
                    WeldInjectionTarget it = weldInjectionTargetFactory.createInterceptorInjectionTarget();
                    injectionTarget = beanManager.fireProcessInjectionTarget(annotatedType, (InjectionTarget)it);
                } else {
                    injectionTarget = beanManager.fireProcessInjectionTarget(annotatedType);
                }
                this.injectionTargets.put(clazz, injectionTarget);
            }
            catch (IllegalArgumentException injectionTarget) {
                void e;
                FFDCFilter.processException((Throwable)injectionTarget, (String)"com.ibm.ws.cdi.impl.weld.BeanDeploymentArchiveImpl", (String)"959", (Object)this, (Object[])new Object[]{clazz});
                throw new DefinitionException((Throwable)e);
            }
        }
    }

    public <T> InjectionTarget<T> getJEEComponentInjectionTarget(Class<T> clazz) {
        return this.injectionTargets.get(clazz);
    }

    public <T> List<InjectionPoint> getJEEComponentInjectionPoints(Class<T> clazz) throws CDIException {
        InjectionTarget<T> injectionTarget = this.getJEEComponentInjectionTarget(clazz);
        ArrayList<InjectionPoint> injectionPoints = null;
        if (injectionTarget != null) {
            List<InjectionPoint> staticInjectionPoints;
            String mainClassName;
            injectionPoints = new ArrayList<InjectionPoint>();
            Set jeeClassInjectionPoints = injectionTarget.getInjectionPoints();
            if (jeeClassInjectionPoints != null && jeeClassInjectionPoints.size() > 0) {
                injectionPoints.addAll(jeeClassInjectionPoints);
            }
            if ((mainClassName = this.archive.getClientModuleMainClass()) != null && clazz.getName().equals(mainClassName) && (staticInjectionPoints = this.staticInjectionPoints.get(clazz)) != null) {
                injectionPoints.addAll(staticInjectionPoints);
            }
        }
        return injectionPoints;
    }

    public <T> void addJEEComponentInjectionTarget(Class<T> clazz, InjectionTarget<T> injectionTarget) {
        this.injectionTargets.put(clazz, injectionTarget);
    }

    public boolean hasBeenScanned() {
        return this.scanned;
    }

    public ArchiveType getType() {
        return this.archive.getType();
    }

    public ClassLoader getClassLoader() {
        return this.archive.getClassLoader();
    }

    public Set<EjbDescriptor<?>> getEjbDescriptor(Class<?> clazz) {
        return this.ejbDescriptorMap.get(clazz);
    }

    public String getEEModuleDescriptorId() {
        return this.eeModuleDescriptor.getId();
    }

    public Collection<Class<?>> getLoadedBeanClasses() {
        return this.beanClasses.values();
    }

    public Collection<String> getKnownClasses() {
        return this.getAllClazzes();
    }

    public Set<Supplier<Object>> getSPIExtensionSuppliers() {
        return this.spiExtensionSuppliers;
    }

    public void setSPIExtensionSuppliers(Set<Supplier<Object>> spiExtensionSuppliers) {
        this.spiExtensionSuppliers.clear();
        this.spiExtensionSuppliers.addAll(spiExtensionSuppliers);
    }

    private static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
            static final long serialVersionUID = 6364790684709848549L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.cdi.impl.weld.BeanDeploymentArchiveImpl$1", 1.class, (String)"JCDI", (String)"com.ibm.ws.cdi.internal.resources.CDI");
            }
        });
    }

    private static void setContextClassLoader(final ClassLoader newLoader) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){
            static final long serialVersionUID = 6314586069502057953L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Void run() {
                Thread.currentThread().setContextClassLoader(newLoader);
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.cdi.impl.weld.BeanDeploymentArchiveImpl$2", 2.class, (String)"JCDI", (String)"com.ibm.ws.cdi.internal.resources.CDI");
            }
        });
    }
}

