/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.health20.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.health.internal.HealthCheckHttpResponseBuilder;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashMap;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.microprofile.health.HealthCheckResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HealthCheck20HttpResponseBuilder
extends HealthCheckHttpResponseBuilder {
    private static final TraceComponent tc = Tr.register(HealthCheck20HttpResponseBuilder.class, (String)"HEALTH", (String)"com.ibm.ws.microprofile.health.resources.Health");
    static final long serialVersionUID = -4205360218818748105L;

    @Override
    public void setHttpResponse(HttpServletResponse httpResponse) {
        httpResponse.setHeader("Content-Type", "application/json; charset=UTF-8");
        HashMap<String, Object> payload = new HashMap<String, Object>();
        httpResponse.setStatus(this.overallState == HealthCheckResponse.State.UP ? 200 : 503);
        payload.put("status", this.overallState);
        payload.put("checks", this.checks.toArray());
        this.setJSONPayload(payload, httpResponse);
    }

    @Override
    protected void setChecks(HealthCheckResponse response) {
        Optional data;
        HashMap<String, String> check = new HashMap<String, String>();
        check.put("name", response.getName());
        HealthCheckResponse.State checkState = response.getState();
        check.put("status", (String)checkState);
        if (checkState != null) {
            if (checkState.equals((Object)HealthCheckResponse.State.DOWN)) {
                this.overallState = HealthCheckResponse.State.DOWN;
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"setChecks(): checkState is null", (Object[])new Object[0]);
            }
            this.overallState = HealthCheckResponse.State.DOWN;
        }
        if ((data = response.getData()) != null && data.isPresent()) {
            check.put("data", (String)data.get());
        }
        this.checks.add(check);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setChecks(): checks = " + this.checks), (Object[])new Object[0]);
        }
    }
}

