/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.file.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.artifact.file.ContainerFactoryHolder;
import com.ibm.ws.artifact.file.FileArtifactNotifier;
import com.ibm.ws.artifact.file.internal.FileEntry;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.ArtifactEntry;
import com.ibm.wsspi.artifact.ArtifactNotifier;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class FileContainer
implements ArtifactContainer {
    private final ContainerFactoryHolder containerFactoryHolder;
    private final ArtifactContainer parent;
    private final ArtifactEntry thisInParent;
    private final File dir;
    private final File cacheDir;
    private final boolean isRoot;
    private final FileContainer root;
    private final ArtifactNotifier artifactNotifier;
    static final long serialVersionUID = 556130772302156267L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    FileContainer(File cacheDir, File f, ContainerFactoryHolder c) {
        this.cacheDir = cacheDir;
        this.dir = f;
        this.isRoot = true;
        this.root = this;
        this.artifactNotifier = new FileArtifactNotifier(this, c, this.dir.getAbsolutePath());
        this.thisInParent = null;
        this.parent = null;
        this.containerFactoryHolder = c;
    }

    FileContainer(File cacheDir, ArtifactContainer parent, ArtifactEntry e, File f, ContainerFactoryHolder c) {
        this.cacheDir = cacheDir;
        this.dir = f;
        this.parent = parent;
        this.thisInParent = e;
        this.isRoot = true;
        this.root = this;
        this.artifactNotifier = new FileArtifactNotifier(this, c, this.dir.getAbsolutePath());
        this.containerFactoryHolder = c;
    }

    FileContainer(File cacheDir, ArtifactContainer parent, ArtifactEntry e, File f, ContainerFactoryHolder c, boolean isRoot, FileContainer root) {
        this.cacheDir = cacheDir;
        this.dir = f;
        this.parent = parent;
        this.thisInParent = e;
        this.isRoot = isRoot;
        if (isRoot) {
            this.root = this;
            this.artifactNotifier = new FileArtifactNotifier(this, c, this.dir.getAbsolutePath());
        } else {
            this.root = root;
            this.artifactNotifier = root.artifactNotifier;
        }
        this.containerFactoryHolder = c;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public Iterator<ArtifactEntry> iterator() {
        return new FileEntryIterator(this, this.dir, this.root, this.containerFactoryHolder);
    }

    public ArtifactContainer getEnclosingContainer() {
        return this.parent;
    }

    public ArtifactEntry getEntryInEnclosingContainer() {
        return this.thisInParent;
    }

    public String getPath() {
        if (!this.isRoot) {
            return this.thisInParent.getPath();
        }
        return "/";
    }

    public String getName() {
        if (!this.isRoot) {
            return this.dir.getName();
        }
        return "/";
    }

    public void stopUsingFastMode() {
    }

    public void useFastMode() {
    }

    public ArtifactEntry getEntry(String pathAndName) {
        boolean exists;
        if ((pathAndName = PathUtils.normalizeUnixStylePath((String)pathAndName)).equals("/") || pathAndName.equals("")) {
            return null;
        }
        if (pathAndName.endsWith("/")) {
            pathAndName = pathAndName.substring(0, pathAndName.length() - 1);
        }
        if (this.isRoot && !PathUtils.isNormalizedPathAbsolute((String)pathAndName)) {
            return null;
        }
        if (pathAndName.startsWith("../")) {
            return this.parent.getEntry(pathAndName.substring(3));
        }
        if ("..".equals(pathAndName)) {
            if (this.parent.isRoot()) {
                return null;
            }
            return new FileEntry(this.parent.getEnclosingContainer(), this.dir.getParentFile(), this.root, this.containerFactoryHolder);
        }
        File target = new File(this.dir, pathAndName);
        Boolean fileExists = null;
        if (!this.isRoot && !pathAndName.startsWith("/") || this.isRoot) {
            exists = FileUtils.fileExists((File)target);
            Boolean bl = fileExists = exists ? Boolean.TRUE : Boolean.FALSE;
            if (!exists || !PathUtils.checkCase((File)target, (String)pathAndName)) {
                return null;
            }
        }
        if (pathAndName.indexOf("/") == -1) {
            boolean bl = exists = fileExists != null ? fileExists : FileUtils.fileExists((File)target);
            if (exists && PathUtils.checkCase((File)target, (String)pathAndName)) {
                return new FileEntry(this, target, this.root, this.containerFactoryHolder);
            }
            return null;
        }
        if (pathAndName.startsWith("/")) {
            FileContainer c;
            for (c = this; c != null && !c.isRoot(); c = c.getEnclosingContainer()) {
            }
            return c == null ? null : c.getEntry(pathAndName.substring(1));
        }
        ArrayDeque<File> ascendants = new ArrayDeque<File>();
        File ascendant = target;
        while (!(ascendant = ascendant.getParentFile()).equals(this.dir)) {
            ascendants.push(ascendant);
        }
        FileContainer descendantAsContainer = this;
        while (!ascendants.isEmpty()) {
            File descendant = (File)ascendants.pop();
            FileEntry descendantEntry = new FileEntry(descendantAsContainer, descendant, this.root, this.containerFactoryHolder);
            descendantAsContainer = new FileContainer(this.cacheDir, descendantAsContainer, descendantEntry, descendant, this.containerFactoryHolder, false, this.root);
        }
        return new FileEntry(descendantAsContainer, target, this.root, this.containerFactoryHolder);
    }

    public ArtifactContainer getRoot() {
        return this.root;
    }

    public Collection<URL> getURLs() {
        try {
            if (System.getSecurityManager() == null) {
                return Collections.singleton(this.dir.toURI().toURL());
            }
            return AccessController.doPrivileged(new PrivilegedAction<Collection<URL>>(){
                static final long serialVersionUID = 8019008681685523838L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Collection<URL> run() {
                    try {
                        return Collections.singleton(FileContainer.this.dir.toURI().toURL());
                    }
                    catch (MalformedURLException malformedURLException) {
                        FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.artifact.file.internal.FileContainer$1", (String)"334", (Object)this, (Object[])new Object[0]);
                        return Collections.emptySet();
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.file.internal.FileContainer$1", 1.class, (String)"archive.artifact.file", null);
                }
            });
        }
        catch (MalformedURLException malformedURLException) {
            FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.artifact.file.internal.FileContainer", (String)"340", (Object)this, (Object[])new Object[0]);
            return Collections.emptySet();
        }
    }

    public String getPhysicalPath() {
        return this.dir.getAbsolutePath();
    }

    File getCacheDir() {
        return this.cacheDir;
    }

    public ArtifactNotifier getArtifactNotifier() {
        return this.artifactNotifier;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.file.internal.FileContainer", FileContainer.class, (String)"archive.artifact.file", null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class FileEntryIterator
    implements Iterator<ArtifactEntry> {
        final Iterator<File> children;
        final ArtifactContainer enclosingContainer;
        final ContainerFactoryHolder containerFactoryHolder;
        final FileContainer root;
        static final long serialVersionUID = 8934759795025182588L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        FileEntryIterator(ArtifactContainer c, File f, FileContainer r, ContainerFactoryHolder cfh) {
            File[] childs = FileUtils.listFiles((File)f);
            this.children = childs != null ? Collections.unmodifiableList(Arrays.asList(childs)).iterator() : Collections.unmodifiableList(new ArrayList()).iterator();
            this.enclosingContainer = c;
            this.containerFactoryHolder = cfh;
            this.root = r;
        }

        @Override
        public boolean hasNext() {
            return this.children.hasNext();
        }

        @Override
        public ArtifactEntry next() {
            return new FileEntry(this.enclosingContainer, this.children.next(), this.root, this.containerFactoryHolder);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.file.internal.FileContainer$FileEntryIterator", FileEntryIterator.class, (String)"archive.artifact.file", null);
        }
    }
}

