/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.utils;

import java.util.concurrent.atomic.AtomicLong;

public class SequenceNumber {
    private final AtomicLong seq = new AtomicLong();
    private static final String ZEROES = "0000000000000";

    public long getRawSequenceNumber() {
        return this.seq.incrementAndGet();
    }

    public static String formatSequenceNumber(long date, long n) {
        return date + "_" + SequenceNumber.toPaddedHex(n);
    }

    public String next(long date) {
        long n = this.seq.incrementAndGet();
        return SequenceNumber.formatSequenceNumber(date, n);
    }

    private static String toPaddedHex(long n) {
        String hexValue = Long.toHexString(n);
        String paddedHexValue = (hexValue = SequenceNumber.upperCaseHex(hexValue)).length() <= 12 ? ZEROES.substring(hexValue.length()) + hexValue : hexValue;
        return paddedHexValue;
    }

    private static String upperCaseHex(String s) {
        char[] chars = s.toCharArray();
        int length = s.length();
        block8: for (int i = 0; i < length; ++i) {
            switch (chars[i]) {
                case 'a': {
                    chars[i] = 65;
                    continue block8;
                }
                case 'b': {
                    chars[i] = 66;
                    continue block8;
                }
                case 'c': {
                    chars[i] = 67;
                    continue block8;
                }
                case 'd': {
                    chars[i] = 68;
                    continue block8;
                }
                case 'e': {
                    chars[i] = 69;
                    continue block8;
                }
                case 'f': {
                    chars[i] = 70;
                }
            }
        }
        return new String(chars);
    }
}

