/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal.merge;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.Constructible;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.info.Contact;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.info.License;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Discriminator;
import org.eclipse.microprofile.openapi.models.media.Encoding;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.media.XML;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.security.OAuthFlow;
import org.eclipse.microprofile.openapi.models.security.OAuthFlows;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.models.servers.ServerVariable;
import org.eclipse.microprofile.openapi.models.tags.Tag;

@Trivial
public enum ModelType {
    OPENAPI(OpenAPI.class),
    INFO(Info.class),
    EXTERNALDOC(ExternalDocumentation.class),
    SERVER(Server.class),
    SECURITY_REQUIREMENT(SecurityRequirement.class),
    TAG(Tag.class),
    PATHS(Paths.class),
    COMPONENTS(Components.class),
    CONTACT(Contact.class),
    LICENSE(License.class),
    OPERATION(Operation.class),
    PATH_ITEM(PathItem.class),
    CALLBACK(Callback.class),
    EXAMPLE(Example.class),
    HEADER(Header.class),
    LINK(Link.class),
    CONTENT(Content.class),
    DISCRIMINATOR(Discriminator.class),
    ENCODING(Encoding.class),
    MEDIA_TYPE(MediaType.class),
    SCHEMA(Schema.class),
    XML(XML.class),
    PARAMETER(Parameter.class),
    REQUEST_BODY(RequestBody.class),
    API_RESPONSE(APIResponse.class),
    API_RESPONSES(APIResponses.class),
    OAUTH_FLOW(OAuthFlow.class),
    OAUTH_FLOWS(OAuthFlows.class),
    SECURITY_SCHEME(SecurityScheme.class),
    SERVER_VARIABLE(ServerVariable.class);

    private List<ModelParameter> parameters;
    private Class<? extends Constructible> clazz;

    public static Optional<ModelType> getModelObject(Class<?> clazz) {
        for (ModelType obj : ModelType.values()) {
            if (!obj.clazz.isAssignableFrom(clazz)) continue;
            return Optional.of(obj);
        }
        return Optional.empty();
    }

    public Object createInstance() {
        return OASFactory.createObject(this.clazz);
    }

    public List<ModelParameter> getParameters() {
        return this.parameters;
    }

    public boolean isInstance(Object object) {
        return this.clazz.isInstance(object);
    }

    private ModelType(Class<? extends Constructible> clazz) {
        this.parameters = ModelType.getParameters(clazz);
        this.clazz = clazz;
    }

    private static List<ModelParameter> getParameters(Class<?> clazz) {
        ArrayList classes = new ArrayList();
        classes.add(clazz);
        classes.addAll(Arrays.asList(clazz.getInterfaces()));
        return classes.stream().flatMap(c -> Arrays.stream(c.getDeclaredMethods())).filter(m -> m.getName().startsWith("get")).filter(m -> m.getParameterCount() == 0).filter(m -> Modifier.isPublic(m.getModifiers())).flatMap(m -> ModelType.getDescriptor(clazz, m)).collect(Collectors.toList());
    }

    private static Stream<ModelParameter> getDescriptor(Class<?> clazz, Method getter) {
        String setterName = getter.getName().replaceFirst("get", "set");
        try {
            Method setter = clazz.getMethod(setterName, getter.getReturnType());
            ModelParameter result = new ModelParameter(getter, setter, getter.getGenericReturnType());
            return Stream.of(result);
        }
        catch (NoSuchMethodException e) {
            return Stream.empty();
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class ModelParameter {
        private final Method getter;
        private final Method setter;
        private final Type type;
        static final long serialVersionUID = -7268321801502580527L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ModelParameter(Method getter, Method setter, Type type) {
            this.getter = getter;
            this.setter = setter;
            this.type = type;
        }

        /*
         * WARNING - void declaration
         */
        public void set(Object instance, Object value) {
            try {
                this.setter.invoke(instance, value);
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.microprofile.openapi20.internal.merge.ModelType$ModelParameter", (String)"163", (Object)this, (Object[])new Object[]{instance, value});
                throw new RuntimeException("Error invoking " + this.setter.getName() + " on " + instance, (Throwable)e);
            }
        }

        /*
         * WARNING - void declaration
         */
        public Object get(Object instance) {
            try {
                return this.getter.invoke(instance, new Object[0]);
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.microprofile.openapi20.internal.merge.ModelType$ModelParameter", (String)"177", (Object)this, (Object[])new Object[]{instance});
                throw new RuntimeException("Error invoking " + this.getter.getName() + " on " + instance, (Throwable)e);
            }
        }

        public Type getType() {
            return this.type;
        }

        public String toString() {
            return this.getter.getName();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.openapi20.internal.merge.ModelType$ModelParameter", ModelParameter.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
        }
    }
}

