/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.utils.OpenAPIModelWalker;
import io.openliberty.microprofile.openapi20.internal.validation.OASValidationResult;
import io.openliberty.microprofile.openapi20.internal.validation.TypeValidator;
import io.openliberty.microprofile.openapi20.internal.validation.ValidationHelper;
import io.openliberty.microprofile.openapi20.internal.validation.ValidatorUtils;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Schema;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HeaderValidator
extends TypeValidator<Header> {
    private static final TraceComponent tc = Tr.register(HeaderValidator.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.validation.ValidationMessages");
    private static final HeaderValidator INSTANCE = new HeaderValidator();
    static final long serialVersionUID = -5297202983492306737L;

    private HeaderValidator() {
    }

    public static HeaderValidator getInstance() {
        return INSTANCE;
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, Header t) {
        if (t != null) {
            Map mediaTypes;
            String message;
            String reference = t.getRef();
            if (reference != null && !reference.isEmpty()) {
                ValidatorUtils.referenceValidatorHelper(reference, t, helper, context, key);
                return;
            }
            if (t.getExample() != null && t.getExamples() != null && !t.getExamples().isEmpty()) {
                String message2 = Tr.formatMessage((TraceComponent)tc, (String)"headerExampleOrExamples", (Object[])new Object[]{key});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, context.getLocation(), message2));
            }
            Schema schema = t.getSchema();
            Content content = t.getContent();
            if (schema == null && content == null) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"headerSchemaOrContent", (Object[])new Object[]{key});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            }
            if (schema != null && content != null) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"headerSchemaAndContent", (Object[])new Object[]{key});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            }
            if (content != null && (mediaTypes = content.getMediaTypes()) != null && mediaTypes.size() > 1) {
                String message3 = Tr.formatMessage((TraceComponent)tc, (String)"headerContentMap", (Object[])new Object[]{key});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message3));
            }
        }
    }
}

