/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.javaee.ddmodel.app;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.javaee.dd.app.Application;
import com.ibm.ws.javaee.ddmodel.DDParser;
import com.ibm.ws.javaee.ddmodel.app.ApplicationDDParser;
import com.ibm.ws.javaee.version.JavaEEVersion;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.adaptable.module.adapters.ContainerAdapter;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.overlay.OverlayContainer;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class ApplicationAdapter
implements ContainerAdapter<Application> {
    private ServiceReference<JavaEEVersion> versionRef;
    private Version platformVersion = JavaEEVersion.DEFAULT_VERSION;
    public static final boolean FAILED = true;
    static final long serialVersionUID = 714784309608369060L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public synchronized void setVersion(ServiceReference<JavaEEVersion> referenceRef) {
        this.versionRef = referenceRef;
        this.platformVersion = Version.parseVersion((String)((String)referenceRef.getProperty("version")));
        if (this.platformVersion == null) {
            this.platformVersion = JavaEEVersion.DEFAULT_VERSION;
        }
    }

    public synchronized void unsetVersion(ServiceReference<JavaEEVersion> versionRef) {
        if (versionRef == this.versionRef) {
            this.versionRef = null;
            this.platformVersion = JavaEEVersion.DEFAULT_VERSION;
        }
    }

    public synchronized Version getVersion() {
        return this.platformVersion;
    }

    public int getVersionInt() {
        Version usePlatformVersion = this.getVersion();
        return usePlatformVersion.getMajor() * 10 + usePlatformVersion.getMinor();
    }

    private <T> T cacheGet(OverlayContainer rootOverlay, String targetPath, Class<T> targetType) {
        return (T)rootOverlay.getFromNonPersistentCache(targetPath, targetType);
    }

    private <T> void cachePut(OverlayContainer rootOverlay, String targetPath, Class<T> targetType, T value) {
        rootOverlay.addToNonPersistentCache(targetPath, targetType, value);
    }

    @FFDCIgnore(value={DDParser.ParseException.class})
    public Application adapt(Container root, OverlayContainer rootOverlay, ArtifactContainer artifactContainer, Container containerToAdapt) throws UnableToAdaptException {
        String containerPath = artifactContainer.getPath();
        Application appDD = this.cacheGet(rootOverlay, containerPath, Application.class);
        if (appDD != null) {
            return appDD;
        }
        ApplicationRef appDDRef = this.cacheGet(rootOverlay, containerPath, ApplicationRef.class);
        if (appDDRef != null) {
            String failure = appDDRef.getFailure();
            if (failure != null) {
                throw new UnableToAdaptException(failure);
            }
            return appDDRef.getApplication();
        }
        DDParser.ParseException pe = null;
        Entry ddEntry = containerToAdapt.getEntry("META-INF/application.xml");
        if (ddEntry != null) {
            try {
                ApplicationDDParser ddParser = new ApplicationDDParser(containerToAdapt, ddEntry, this.getVersionInt());
                appDD = ddParser.parse();
            }
            catch (DDParser.ParseException e) {
                pe = e;
            }
        }
        appDDRef = pe != null ? new ApplicationRef(pe.getMessage()) : new ApplicationRef(appDD);
        if (appDD != null) {
            this.cachePut(rootOverlay, containerPath, Application.class, appDD);
        }
        this.cachePut(rootOverlay, containerPath, ApplicationRef.class, appDDRef);
        if (pe != null) {
            throw new UnableToAdaptException((Throwable)pe);
        }
        return appDD;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.javaee.ddmodel.app.ApplicationAdapter", ApplicationAdapter.class, (String)"ddmodel", (String)"com.ibm.ws.javaee.internal.ddmodel.resources.DDModelMessages");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class ApplicationRef {
        public final Application application;
        public final String failure;
        static final long serialVersionUID = -2362074790676950035L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ApplicationRef(Application application) {
            this.application = application;
            this.failure = null;
        }

        public ApplicationRef(String failure) {
            this.application = null;
            this.failure = failure;
        }

        public Application getApplication() {
            return this.application;
        }

        public String getFailure() {
            return this.failure;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.javaee.ddmodel.app.ApplicationAdapter$ApplicationRef", ApplicationRef.class, (String)"ddmodel", (String)"com.ibm.ws.javaee.internal.ddmodel.resources.DDModelMessages");
        }
    }
}

